/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class JokoCave
extends MIDlet
implements CommandListener {
    static final boolean REAL_DEVICE = false;
    static final boolean DEBUG = true;
    Display display;
    Displayable currentDisplayable;
    Displayable previousDisplayable;
    private Form loadingForm;
    private Form helpForm;
    private Form aboutForm;
    Form resultForm;
    private SplashCanvas splashCanvas;
    MainCanvas mainCanvas;
    private JokoCaveCanvas jokoCaveCanvas;
    private Thread thread;
    static Gauge gauge;
    private boolean firstTime;
    private Command solveCommand;
    private Command exitCommand;
    Command backCommand;
    private byte level = 1;
    public static int highScore;
    final String APP_VERSION = "version " + this.getAppProperty("MIDlet-Version");
    final String APP_NAME = this.getAppProperty("MIDlet-Name");
    String APP_SALE = this.getAppProperty("APP-SALE");
    final String APP_SPLASH;
    final String APP_MENU;
    final String MAIN_STR = this.getAppProperty("MIDlet-Description");
    final String ABOUT_STR = "Joko Cave Junior, version " + this.getAppProperty("MIDlet-Version") + "\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by " + this.getAppProperty("MIDlet-Vendor") + " " + this.getAppProperty("MIDlet-Info-URL") + "\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
    final String HELP_STR;

    public JokoCave() {
        this.APP_SPLASH = "/JokoCaveSplash.png";
        this.APP_MENU = "/JokoCaveMenu.png";
        this.HELP_STR = "You are a gold miner that was spelled by the old crazy witch who transformed you into a very strange creature. You need to find your way out of the cave. When you get out of the cave, the Sun light will cancel the spell and you will get your body back. On your way out of the cave, you will find weapons that were left by former victims of the crazy witch. In addition to the weapons, you will also find treasures. Try to collect many treasures as possible. They grant you with more points. The weapons you can collect and use during the game include the following: Hammer (You can throw it a short distance and collect it again for another usage), Crossbow (You can find a crossbow with 9 arrows. When you shoot the arrows, the crossbow disappears), Sword&Shield (This increases your protection for 5 small battles). You complete a level when you find the map (of that level) that guides you in your way out. Use the navigation keys to move inside the cave and press the fire key to throw a hammer or shoot with your Crossbow. \"Joko Cave Junior\" is a partial version of the game \"Joko Cave\". It includes one level only. If you finish this level then you are prepared for the real game. Please visit at www.jacado.com to buy \"Joko Cave\", the full commercial version. For further assistance, please send us an email at JokoCave@jacado.com.";
        if (this.APP_SALE == null) {
            this.APP_SALE = "www.jacado.com";
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.currentDisplayable = this.mainCanvas;
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void startApp() {
        if (this.display == null) {
            this.thread = new Thread(){

                public void run() {
                    try {
                        JokoCave.this.display = Display.getDisplay((MIDlet)JokoCave.this);
                        JokoCave.this.loadingForm = new Form("Loading...");
                        JokoCave.this.currentDisplayable = JokoCave.this.loadingForm;
                        gauge = new Gauge("Please wait", false, 10, 0);
                        JokoCave.this.loadingForm.append((Item)gauge);
                        gauge.setValue(0);
                        JokoCave.this.display.setCurrent((Displayable)JokoCave.this.loadingForm);
                        JokoCave.this.exitCommand = new Command("Exit", 7, 2);
                        JokoCave.this.backCommand = new Command("Back", 2, 2);
                        JokoCave.this.firstTime = true;
                        JokoCave.this.loadHighScore();
                        gauge.setValue(1);
                        JokoCave.this.jokoCaveCanvas = new JokoCaveCanvas(JokoCave.this);
                        System.out.println("midlet1");
                        gauge.setValue(4);
                        System.out.println("midlet2");
                        gauge.setValue(7);
                        JokoCave.this.mainCanvas = new MainCanvas();
                        System.out.println("midlet3");
                        gauge.setValue(8);
                        JokoCave.this.aboutForm = new Form("About");
                        JokoCave.this.aboutForm.append(JokoCave.this.ABOUT_STR);
                        JokoCave.this.aboutForm.addCommand(JokoCave.this.backCommand);
                        JokoCave.this.aboutForm.setCommandListener((CommandListener)JokoCave.this);
                        System.out.println("midlet4");
                        gauge.setValue(9);
                        JokoCave.this.helpForm = new Form("Help");
                        JokoCave.this.helpForm.append("You are a gold miner that was spelled by the old crazy witch who transformed you into a very strange creature. You need to find your way out of the cave. When you get out of the cave, the Sun light will cancel the spell and you will get your body back. On your way out of the cave, you will find weapons that were left by former victims of the crazy witch. In addition to the weapons, you will also find treasures. Try to collect many treasures as possible. They grant you with more points. The weapons you can collect and use during the game include the following: Hammer (You can throw it a short distance and collect it again for another usage), Crossbow (You can find a crossbow with 9 arrows. When you shoot the arrows, the crossbow disappears), Sword&Shield (This increases your protection for 5 small battles). You complete a level when you find the map (of that level) that guides you in your way out. Use the navigation keys to move inside the cave and press the fire key to throw a hammer or shoot with your Crossbow. \"Joko Cave Junior\" is a partial version of the game \"Joko Cave\". It includes one level only. If you finish this level then you are prepared for the real game. Please visit at www.jacado.com to buy \"Joko Cave\", the full commercial version. For further assistance, please send us an email at JokoCave@jacado.com.");
                        JokoCave.this.helpForm.addCommand(JokoCave.this.backCommand);
                        JokoCave.this.helpForm.setCommandListener((CommandListener)JokoCave.this);
                        System.out.println("midlet5");
                        gauge.setValue(10);
                        JokoCave.this.splashCanvas = new SplashCanvas();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.thread.start();
        } else {
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void pauseApp() {
        if (this.currentDisplayable != this.mainCanvas) {
            this.currentDisplayable = this.display.getCurrent();
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.helpForm = null;
        this.aboutForm = null;
        this.mainCanvas = null;
        this.loadingForm = null;
        gauge = null;
        this.exitCommand = null;
        this.backCommand = null;
        this.jokoCaveCanvas = null;
        this.splashCanvas = null;
        this.thread = null;
    }

    static byte[] calcScore(int n) {
        byte[] byArray = new byte[]{(byte)(n / 10000), (byte)(n % 10000 / 100), (byte)(n % 100)};
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHighScore() {
        System.out.println("loadHighScore");
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"JokoCaveScores", (boolean)true);
            if (recordStore.getNumRecords() == 1) {
                byte[] byArray = recordStore.getRecord(1);
                highScore = byArray[0] * 10000 + byArray[1] * 100 + byArray[2];
            } else {
                if (recordStore.getNumRecords() > 0) {
                    this.deleteScoresDatabase();
                }
                recordStore = RecordStore.openRecordStore((String)"JokoCaveScores", (boolean)true);
                byte[] byArray = JokoCave.calcScore(0);
                recordStore.addRecord(byArray, 0, 3);
                highScore = 0;
            }
        }
        catch (RecordStoreException recordStoreException) {
            this.deleteScoresDatabase();
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    private void deleteScoresDatabase() {
        try {
            RecordStore.deleteRecordStore((String)"JokoCaveScores");
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    static {
        highScore = 0;
    }

    private class MainCanvas
    extends FullCanvas {
        private int height;
        private int width;
        private Font boldFont = Font.getFont((int)0, (int)1, (int)0);
        private Font ulFont = Font.getFont((int)0, (int)5, (int)0);
        private int selected = 1;
        private boolean bug = false;
        private String[] menu = new String[]{"Continue", "New game", "High score", "Turn sound off", "Exit", "Help", "About"};
        private Image menuImg = null;

        private MainCanvas() {
            this.width = this.getWidth();
            this.height = this.getHeight();
            try {
                this.menuImg = Image.createImage((String)"/JokoCaveMenu.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected void keyPressed(int n) {
            if (n == -6 || n == -7) {
                this.bug = true;
            } else if (this.getGameAction(n) == 6) {
                ++this.selected;
                if (this.selected > this.menu.length - 1) {
                    this.selected = this.menu.length - 1;
                }
            } else if (this.getGameAction(n) == 1) {
                --this.selected;
                if (this.selected < 0) {
                    this.selected = 0;
                }
            } else if (this.getGameAction(n) == 8) {
                switch (this.selected) {
                    case 0: {
                        if (((JokoCave)JokoCave.this).jokoCaveCanvas.level == 0) {
                            JokoCave.this.jokoCaveCanvas.init(1);
                        }
                        JokoCave.this.currentDisplayable = JokoCave.this.jokoCaveCanvas;
                        JokoCave.this.display.setCurrent(JokoCave.this.currentDisplayable);
                        break;
                    }
                    case 1: {
                        JokoCave.this.jokoCaveCanvas.init(1);
                        JokoCave.this.currentDisplayable = JokoCave.this.jokoCaveCanvas;
                        JokoCave.this.display.setCurrent(JokoCave.this.currentDisplayable);
                        break;
                    }
                    case 2: {
                        String string = "Best result : " + highScore;
                        Alert alert = new Alert("High Scores:", string, null, AlertType.INFO);
                        alert.setTimeout(4000);
                        JokoCave.this.display.setCurrent(alert, (Displayable)this);
                        break;
                    }
                    case 3: {
                        boolean bl = ((JokoCave)JokoCave.this).jokoCaveCanvas.sound = !((JokoCave)JokoCave.this).jokoCaveCanvas.sound;
                        if (((JokoCave)JokoCave.this).jokoCaveCanvas.sound) {
                            ((JokoCave)JokoCave.this).jokoCaveCanvas.sounds.playSound(0, 50);
                            break;
                        }
                        ((JokoCave)JokoCave.this).jokoCaveCanvas.sounds.stopAll();
                        break;
                    }
                    case 4: {
                        this.bug = true;
                        break;
                    }
                    case 5: {
                        JokoCave.this.currentDisplayable = JokoCave.this.helpForm;
                        JokoCave.this.display.setCurrent(JokoCave.this.currentDisplayable);
                        break;
                    }
                    case 6: {
                        JokoCave.this.currentDisplayable = JokoCave.this.aboutForm;
                        JokoCave.this.display.setCurrent(JokoCave.this.currentDisplayable);
                    }
                }
            }
            if (this.bug) {
                JokoCave.this.exit();
            } else {
                this.repaint();
                this.serviceRepaints();
            }
        }

        protected void paint(Graphics graphics) {
            graphics.drawImage(this.menuImg, 0, 0, 20);
            graphics.setFont(this.boldFont);
            graphics.setColor(0, 0, 0);
            int n = 0;
            while (n < this.menu.length) {
                graphics.drawString(this.menu[n], this.width / 2 + 2, 75 + n * 17 + 2, 17);
                ++n;
            }
            graphics.setColor(255, 204, 0);
            this.menu[3] = ((JokoCave)JokoCave.this).jokoCaveCanvas.sound ? "Turn sound off" : "Turn sound on";
            int n2 = 0;
            while (n2 < this.menu.length) {
                if (n2 == this.selected) {
                    graphics.setColor(255, 204, 0);
                    graphics.setFont(this.ulFont);
                } else {
                    graphics.setColor(255, 154, 0);
                    graphics.setFont(this.boldFont);
                }
                graphics.drawString(this.menu[n2], this.width / 2, 75 + n2 * 17, 17);
                ++n2;
            }
        }

        protected void hideNotify() {
            if (this.bug) {
                return;
            }
            ((JokoCave)JokoCave.this).jokoCaveCanvas.sounds.stopAll();
        }

        protected void showNotify() {
            if (((JokoCave)JokoCave.this).jokoCaveCanvas.sound) {
                ((JokoCave)JokoCave.this).jokoCaveCanvas.sounds.playSound(0, 50);
            }
        }
    }

    private class SplashCanvas
    extends FullCanvas {
        private Timer timer = new Timer();
        private Image splashImg;

        private SplashCanvas() {
            try {
                this.splashImg = Image.createImage((String)"/JokoCaveSplash.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            JokoCave.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 5000L);
        }

        protected void keyPressed(int n) {
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            graphics.drawImage(this.splashImg, 0, 0, 20);
        }

        private void dismiss() {
            this.timer.cancel();
            JokoCave.this.currentDisplayable = JokoCave.this.mainCanvas;
            this.splashImg = null;
            JokoCave.this.display.setCurrent(JokoCave.this.currentDisplayable);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

