#ifndef SDK_UIS_H
#define SDK_UIS_H

#include <apps.h>
#include <typedefs.h>
#include <stdarg.h>
#include <resources.h>

//   Trancient Notice
enum
{
	NOTICE_TYPE_DEFAULT = 0,//  ""
	NOTICE_TYPE_OK,			// ?
	NOTICE_TYPE_FAIL,		// ?
	NOTICE_TYPE_WAIT_NO_KEY,//  , ? ??? ?    ?? 
							//  ??  ?(?  )
	NOTICE_TYPE_WAIT_2,		// ?? ?? ? ? ?EV_DIALOG_DONE
	NOTICE_TYPE_INFO_NO_KEY,//    ?
	NOTICE_TYPE_INFO,
	NOTICE_TYPE_OK_2,
	
	NOTICE_TYPE_DELETED = 12,
	NOTICE_TYPE_NEW_MESSAGE,
	NOTICE_TYPE_SMS,
	NOTICE_TYPE_SEND,
	NOTICE_TYPE_SEND_CENTER,//  ?mpx_ultra ??
	
	NOTICE_TYPE_WAIT_3 = 27,// ??   
	NOTICE_TYPE_WAIT_4,		// ?? ?? ???? EV_DIALOG_DONE
	NOTICE_TYPE_INFO_LONG,
	NOTICE_TYPE_WAIT_FAST,	//  ?  ??
	
	NOTICE_TYPE_WAIT_5 = 32,// ??NOTICE_TYPE_WAIT_2
	
	NOTICE_TYPE_WAIT_6 = 37,// ? ?? ??? ? EV_DIALOG_DONE
	
	NOTICE_TYPE_CHAT = 45,
	NOTICE_TYPE_NEW_CHAT_MESSAGE
	
	//   ??
};


typedef struct  
{
	RESOURCE_ID 	icon1; 
    RESOURCE_ID		icon2; 

    RESOURCE_ID   	animation_icon1;
    RESOURCE_ID   	animation_icon2;

    void *			unk1;
    RESOURCE_ID	  	title; 
    UINT8			unk2[3];

} NOTICE_PARAMETERS_T;







// Action list
enum
{
	ACTION_OP_ADD = 0,  //  
	ACTION_OP_DELETE,   // ?
	ACTION_OP_UPDATE	//  
};

typedef struct
{
	UINT8			 operation;		// ? ???(ACTION_OP_*)
	EVENT_CODE_T	  event;			// ? ? ? ??
	RESOURCE_ID	action_res;	// , ? (. RES_ACTION_LIST_ITEM_T)

} ACTION_ENTRY_T;

typedef struct
{
	UINT8			 count;			// ? ?
	ACTION_ENTRY_T	action[16];	//      ?

} ACTIONS_T;


// Content
typedef struct
{
	char			format[40];
	UINT32			count;
	UINT32			data[40];
} CONTENT_T;

#define UI_CONTENT		CONTENT_T



// List

enum {
	LIST_TYPE_DEFAULT = 0,
	LIST_TYPE_DETAIL,
	LIST_TYPE_DEFAULT_2,
	LIST_TYPE_DETAIL_2,
	LIST_TYPE_DETAIL_3,
	LIST_TYPE_DETAIL_4,
	LIST_TYPE_NO_LIST,
	LIST_TYPE_DEFAULT_SUBTITLE,
	LIST_TYPE_DEFAULT_4
};



typedef struct
{
	RESOURCE_ID		field_res;	//  ?FIELD_DESCR_T
	//UINT32			data;		 // ? (RESOURCE_ID / WCHAR * / CONTENT_T * / UINT32)
	// ? ?FIELD_DESCR_T
	union {								//  ?
		UINT32		val_dword;
		UINT16		val_word;
		UINT8		val_byte;
		void *		val_ptr;
		
		UINT32		u0;		// 0
		UINT32		u1;		// 1
		UINT32		u2;		// 2
		WCHAR *		str;	// 3
		struct {			// 4
			INT16		num;
			UINT8		text_type;	// 0="", 1="?, 2="?(??, 3=""
		} meter;	// ?(? )
	} data;
	BOOL			unk3;	 
	BOOL			unk4;
	BOOL			unk5;		 // = 0
} FIELD_T;


typedef struct
{
	CONTENT_T		text;
	UINT32			unk1;
	RESOURCE_ID		marks[2];
	RESOURCE_ID		unk3[2];
	RESOURCE_ID		unk4[2];
	UINT8			unk5;
	BOOL			can_mark; //  TRUE,  ? ?  ?
							//  ? ? ?0 ?   ? ?
							//  ?SelectionEditor   TRUE,
							//  ?? ?    ?? ? ?
} STATIC_LIST_ENTRY_T;  

typedef union
{
	STATIC_LIST_ENTRY_T		static_entry;	// ?, ?editable == FALSE
	FIELD_T					editable_entry;	// ?, ?editable == TRUE
	UINT8					pad[0xEC];		// pad to real size
} LIST_CONTENT_T;


typedef struct
{
	BOOL					editable;   //   ? 
	UINT32					unk1;	// ??
	LIST_CONTENT_T			content;
	
	UINT8				pad[4];
} LIST_ENTRY_T;




#ifdef __cplusplus
extern "C" {
#endif

	  /* ??*/
	  
	  
/* ??*/
/* ?? format:
	 ?   ??
	? ?.
	? ???????
	?:
	q - ? WCHAR 
	s -  
	i - int
	g - hex int
	p -  
	r - CONTENT_T
	f - ? 
	
	d - ?
	t - ?
	e - ?
	h - ?
	j - ?
	l - ?
	
	??:
	N -  
	S - ?
	C - ? 
	L -  ?"...",   ?
	M - ? ( )
	T - ?
	B - ??
	
	H - 
	F -  ? ?
	E - ?
	I - ?
	
	: "MCq0p1" = "? ?   
	 ?dst ?, ? - ?" */
UINT32 UIS_MakeContentFromString( const char * format,  CONTENT_T * dst,  ... );

/* ? EV_GRANT_TOKEN */
UINT32 APP_HandleUITokenGranted( EVENT_STACK_T * ev_st,  void * app );

/* ? EV_REVOKE_TOKEN */
UINT32 APP_HandleUITokenRevoked( EVENT_STACK_T * ev_st,  void * app );

/*  , ?APP_UtilChangeState,  ? ??(consumed) event */
UINT32 APP_UtilConsumeEvChangeState( UINT8 new_state,  EVENT_STACK_T * ev_st,  void * app );

/*  ?? ?*/
UINT32 UIS_HandleEvent( UIS_DIALOG_T dialog,  EVENT_STACK_T * ev_st );

/* ? ?UI */
UINT32 UIS_Refresh( void );

/* ? ?UI */
UINT32 UIS_ForceRefresh( void );

/*   ?? ??NULL */
UINT32 APP_UtilUISDialogDelete( UIS_DIALOG_T * dialog );




/*    */
UINT32 UIS_SetActionList( UIS_DIALOG_T pdialog, ACTIONS_T * actions );







#define DialogType_Dialling 0x05 //dial-up window
#define DialogType_EnterName 0x08 //input names. . .
#define DialogType_SetDate 0x0B //Set Date
#define DialogType_SetTime 0x0D //set-up time
#define DialogType_Homescreen 0x0E //desktop standby
#define DialogType_DeskTop DialogType_Homescreen
#define DialogType_list 0x10 //Item List
#define DialogType_SelectionList 0x13 //options
#define DialogType_BatteryandMemory 0x15 //power, memory usage information, such as window howed that the grid
#define DialogType_JumpOut 0x17 //pop-up window, such as "keyboard is locked, unlocked by XX", "please wait" category
#define DialogType_MessageBox 0x1B //information inbox
#define DialogType_GameAni 0x1D //games and applications when they enter the animation
#define DialogType_WapMenu 0x1E //Wap browser-related menu
#define DialogType_VideoCamera 0x25 //Camera viewfinder window
#define DialogType_Password 0x26 //Password window
#define DialogType_PB_SC_Other 0x28 //phone book, Shortcuts like, a lot of this state
#define DialogType_Menu 0x2D //Main Menu
#define DialogType_SecondLevelMenu 0x2E //2 of the three menu and the menu
#define DialogType_WriteText 0x32 //input text
#define DialogType_Brightness 0x37 //Settings - brightness - highlighted regulation
#define DialogType_Picture 0x39 //Multimedia - picture

UINT32 UIS_GetActiveDialogType( UINT8 * result );




/* *****************************************
 ??  ?
***************************************** */
#define BATTERY_STRENGTH_STATUS		0  //: ? integer  0  3
#define SIGNAL_STRENGTH_STATUS		3  // : ? integer  0  5

#ifdef FTR_L7E
	#define GPRS_STATUS					0x1E //  ? 
	#define NETWORK_STATUS  			0x28 //  ? ?
#else
	#define GPRS_STATUS					0x1D //  ? 
	#define NETWORK_STATUS  			0x27 //  ? ?
#endif

extern const UINT8 * ITUNES_STATUS;
#define ITUNES_STATE_STATUS		*(ITUNES_STATUS+1) //  integer: 0 - no, 1 - play, 2 - pause

//  L7e ? ? ?
#define AUDIO_STATUS 				0x69 //   ?
#define READY_STATUS 				47
#define PROVIDER_NAME_STATUS 		55

typedef union
{
    INT32		integer;
    BOOL		boolean;
    WCHAR *		quoted_string;
    UINT64		unk;
} STATUS_VALUE_T;

UINT32 UIS_SetStatus ( UINT8 id,  STATUS_VALUE_T status ); 

UINT32 UIS_SetStatusOff( UINT8 id, STATUS_VALUE_T status );

UINT32 UIS_GetCurrentStatusValue( UINT8 id, STATUS_VALUE_T * status ); 

typedef struct {
	WCHAR * 	uri;
	UINT32		unk;
} UIS_SETWALLPAPER_SETTINGS_T;

UINT32 UIS_SetWallpaper( UIS_SETWALLPAPER_SETTINGS_T * ws );


// -----------------------------------------------------------------------------------------
// dialogs
		/* ??  */


			/* ?? */
/* ? ?. type = NOTICE_TYPE_* */
UIS_DIALOG_T
UIS_CreateNotice( SU_PORT_T *	port,
				CONTENT_T *		content,
				UINT32			duration,
				UINT8			type,
				BOOL			no_transient, //  TRUE   ?  ? ? KEY_PRESS
				ACTIONS_T *		action_list );

/* ?? ?. type = NOTICE_TYPE_* */
UIS_DIALOG_T
UIS_CreateTransientNotice( SU_PORT_T * port,  CONTENT_T * content,  UINT8 type );

UIS_DIALOG_T
UIS_CreateExtendedNotice( SU_PORT_T *		port,  
							CONTENT_T *		content,
							UINT32			duration, //  
							UINT8			type, 
							UINT16 			status,
							NOTICE_PARAMETERS_T 	parameters,
							ACTIONS_T *		actions );


			/* ?  */

/* ?   */
UIS_DIALOG_T
UIS_CreateViewer( SU_PORT_T *	port,
				CONTENT_T *		contents,
				ACTIONS_T *		actions );

/* ?  , ??? ?  */
UIS_DIALOG_T
UIS_CreateViewerWithTitle( SU_PORT_T *		port,
							CONTENT_T *		title,
							CONTENT_T *		body,
							ACTIONS_T *		actions,
							RESOURCE_ID		dlgres );


			/* ??*/

/* ? - */
UIS_DIALOG_T
UIS_CreateStaticList( SU_PORT_T *		port,
						UINT32			param1,		  // = 0 ID?
						UINT32			count,
						UINT32			marks,
						LIST_ENTRY_T *	entries, 
						UINT8			param5,		  // = 0
						UINT8			list_type,	  // = 2
						ACTIONS_T *		actions,
						RESOURCE_ID		caption );

/* ?- ?????  */
UIS_DIALOG_T
UIS_CreateList( SU_PORT_T *		port,
				UINT32			param1,			// = 0  ID?
				UINT32			count,			//  ??
				UINT32			marks_num,		//  ? ?? ? .  1,  ???   ??  2,     ?
				UINT32 *		starting_num,	// ??   ?
				UINT8			param5,			// = 0
				UINT8			list_type,		// = 2
				ACTIONS_T *		actions,		//  
				RESOURCE_ID		list_res );		// ?,   RES_TYPE_LIST_DESCR, ?RES_LIST_DESCR_T




/* ?  () ?? ??  */
UIS_DIALOG_T
UIS_CreatePictureAndTextList( SU_PORT_T *	port,
							UINT32			param1,
							UINT32			count, 
							UINT32 *		starting_num, 
							UINT8			list_type, // = 2
							UINT8			param5, // = 0
							UINT8			param6, // = 1, try 0,2,...
							ACTIONS_T *		actions, 
							RESOURCE_ID		dlgres );

// ?-  ?. ?.
UIS_DIALOG_T
UIS_CreateStaticSelectionEditor( SU_PORT_T *	port,
								UINT32			param1,
								UINT32			count,
								LIST_ENTRY_T *	entries,
								UINT32			mark_pos,		//  ?
								ACTIONS_T *		actions,
								RESOURCE_ID		dlgres );

UIS_DIALOG_T
UIS_CreateSelectionEditor( SU_PORT_T *		port,
							UINT32			param1,
							UINT32			count,
							UINT32			mark_pos,		//  ?
							UINT32 *		starting_num,
							UINT32			param5,
							ACTIONS_T *		actions,
							RESOURCE_ID		dlgres );


			/* ? ,  */

/* ?-  ?() */
UIS_DIALOG_T UIS_CreateSplashScreenFs( SU_PORT_T * port, WCHAR * uri, UINT32 unk );	// unk = 0x7D0

/* ?-  ? */
UIS_DIALOG_T UIS_CreateSplashScreen( SU_PORT_T * port, RESOURCE_ID img, UINT32 unk );	// unk = 0xD3 , 0x7D0

/* ? "?"  . ?: GIF, JPG, PNG, BMP, ?. */
UIS_DIALOG_T UIS_CreateScreenSaver( SU_PORT_T * post, WCHAR * uri );


			/*  */

// ?  ?
UIS_DIALOG_T
UIS_CreateProgressBar( SU_PORT_T *		port,
						RESOURCE_ID		res_img,	// 0x12000055
						CONTENT_T *		content,	// 
						const WCHAR *	str,
						UINT8			perc,
						BOOL			show_arrows,
						const WCHAR *	value_str,
						ACTIONS_T *		actions,
						RESOURCE_ID		dlgres );	// can be =0
//   ??

#define EV_PB_SET_PERCENT		0x213F
#define EV_PB_SET_VALUE_STR		0x2140
#define EV_PB_SET_STR			0x2141
//#define EV_PB_SET_PERCENT		0x2141
//#define EV_PB_SET_VALUE_STR		0x2142
//#define EV_PB_SET_STR			0x2143




/* ?- (/? */
UIS_DIALOG_T
UIS_CreateConfirmation( SU_PORT_T * port,  CONTENT_T * content );


/* ? ? */
UIS_DIALOG_T
UIS_CreateCharacterEditor( SU_PORT_T *		port,
							WCHAR *			text,
							UINT8			edit_type,
							UINT32			maxlen,
							BOOL			masked,
							ACTIONS_T *		actions, 
							RESOURCE_ID		dlgres );
/* 
  ? edit_type:
0 -  ????
1 - ??
2 -  ? ???
3 - ,  ???
4 - ?
5 - ???
6 -  ?  ?
7 - ?????
8 - , ??
9 - ?4, ??
10 - , ??
11 - ?0, ? ? 
12 - ?1, ? ? 
23 - url
28 -  ?
29 - ,  ???
32 -  ?
*/


UIS_DIALOG_T
UIS_CreateMixedContentViewer( SU_PORT_T * port, CONTENT_T * content, ACTIONS_T * action_list, RESOURCE_ID dlgres );


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // SDK_UIS_H