#ifndef SDK_STDLIB_H
#define SDK_STDLIB_H

#include <typedefs.h>

/* ***************************************************
 * Minimum and maximum macros
 */
#define __max(a,b)  (((a) > (b)) ? (a) : (b))
#define __min(a,b)  (((a) < (b)) ? (a) : (b))


#define abs(i)		(i<0 ? -i : i)


#ifdef __cplusplus
extern "C" {
#endif

/* ***************************************************
 * ANSI strings routines
 */

/* !
      ? ?????dst ? ?
	  ? ? src  ?n,  ?dst  ??   '\0'
*/

size_t  strlen( const char * str );								// ?
char *  strcat( char * dst, const char * src );					// ? ?
char *  strchr( const char * str, int s );						// ???
int     strcmp( const char * s1, const char * s2 );				// ??
char *  strcpy( char * dst, const char * src );					// ??

char *  strncat( char * dst, const char * src, size_t n );		//  ?
int     strncmp( const char * s1, const char * s2, size_t n );	// ? ?
char *  strncpy( char * dst, const char * src, size_t n );		// ? ?

char *  strstr( const char * str, const char * srch );			// ??
char *  strrchr( const char * str, int s );						// ??? ()
char *  strtok( char *, const char * );

int toupper( int c );		//  ? 
int tolower( int c );		//  ??

size_t strcspn( const char * str1, const char * str2 );		//   ??str1 ????  str2
size_t strspn( const char * str1, const char * str2 );		// ,  ``

/* ***************************************************
 * Unicode strings routines
 */

size_t	u_strlen( const WCHAR * );

WCHAR *	u_strcat( WCHAR * dst, const WCHAR * str );

//  n   src ? dst
WCHAR * u_strncat( WCHAR * dst, const WCHAR * src, UINT32 n );		

WCHAR *	u_strcmp( const WCHAR * s1, const WCHAR * s2 );
WCHAR *	u_strcpy( WCHAR * dst, const WCHAR * src );

WCHAR *	u_strncmp( const WCHAR * s1, const WCHAR * s2, size_t count );
WCHAR *	u_strncpy( WCHAR * dst, const WCHAR * src, size_t count );

//  ?str  ??chr
WCHAR * u_strchr( WCHAR * src, WCHAR chr );
//  ?str ???chr
WCHAR * u_strrchr( WCHAR * src, WCHAR chr );

//  search ?src (? )
WCHAR * u_strstr( WCHAR * src, WCHAR * search );
// ,  ??
WCHAR * u_stristr( WCHAR * src, WCHAR * search );

//  ?  n  ??pos
INT32 u_strcut( WCHAR * str, UINT16 len_str, UINT16 pos, int n ); 

WCHAR *	u_strmakeupper( WCHAR * str );		// Unicode  ? 
WCHAR *	u_strmakelower( WCHAR * str );		// Unicode  ??


/* ***************************************************
 * Convert
 */

// ANSI string to Unicode
WCHAR *	u_atou( const char * src, WCHAR * dst );

// Unicode string to ANSI (valid only for ascii-range symbols)
char *	u_utoa( const WCHAR * src, char * dst );

// Unicode to UTF-8
UINT16 DL_Char_convUCS2toUTF8String( const WCHAR * src,	UINT16 src_len,
									UINT8 * dst,		UINT16 dst_len );		
// UTF-8 to Unicode
UINT16 DL_Char_convUTF8toUCS2String( const UINT8 * src,	UINT16 src_len,
									WCHAR * dst,		UINT16 dst_len );

// CP-1251 to Unicode									
UINT16 DL_Char_convCP1251toUCS2String( const UINT8 * src,	UINT16 src_len,
										WCHAR * dst_ptr,	UINT16 dst_len);
UINT16 DL_Char_convGB2312toUCS2Buf( const UINT8   *src_ptr,
									  UINT16  src_len,
									  WCHAR   *trg_ptr,
									  UINT16  trg_len);
UINT16 DL_Char_convBig5toUCS2Buf ( const UINT8   *src_ptr,
									  UINT16  src_len,
									  WCHAR   *trg_ptr,
									  UINT16  trg_len);

/* ***************************************************
 *       <-> ?
 *  str - ? ?
 *  end -  ?  ?? ??
 *  base, radix - ?.
 *      0,  ?? "? ?- "0x..." = HEX / "0..." = OCT / ?DEC
 */
// ? ??long (INT32)
long strtol( const char * str, char ** end, int base );

//  -> unsigned long (UINT32)
unsigned long strtoul( const char * str, char ** end, int base );

// ?-> 
char * _itoa( int value, char * string, int radix );
#define itoa(v,s,r)		_itoa(v,s,r)

// ?->  Unicode
WCHAR *	u_ltou( long number, WCHAR * str );

// Unicode  -> unsigned long (UINT32)
long u_atol( WCHAR * str );

// ? dec ?HEX
WCHAR * u_itoh( int value, WCHAR * dst );

/* ***************************************************
 * end string funcs
 */

// Quick compare strings
UINT32 namecmp( const char * str1, const char * str2 ); //returns 1 if equal

/* ***************************************************
 * other functions
 */

void * bsearch( const void * key, const void * buf, size_t num, size_t size, int (*compare)(const void *, const void *) );
void qsort( void * buf, size_t num, size_t size, int (*compare)(const void *, const void *) );

int rand( void );
void srand( unsigned int seed );
#define randomize()		srand((UINT32)suPalReadTime())
#define rand_init()		srand((UINT32)suPalReadTime())


int abs_0( int );

int sprintf( char * str, const char * format, ... );


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // SDK_STDLIB_H
