#ifndef SDK_RESOURCES_H
#define SDK_RESOURCES_H

#include <typedefs.h>

typedef UINT32	RESOURCE_ID;    // ID 



#ifdef __cplusplus
extern "C" {
#endif


/* ID             
	, 0x01000496 = " "
	     , ,    DRM */


#define RES_TYPE_STRING			0x01    // 
#define RES_TYPE_BITMAP			0x02    //  ,   
#define RES_TYPE_ACTION			0x06    // 
#define RES_TYPE_LIST_DESCR		0x07    // ,   
#define RES_TYPE_FIELD			0x0d    // Editable field in list
#define RES_TYPE_ENUM			0x10	//   
#define RES_TYPE_GRAPHICS		0x12    //  (GIF)



//  
UINT32 DRM_CreateResource( RESOURCE_ID *	res_id,
							UINT32			type,	//RES_TYPE_*
							const void *	data,
							size_t			size );

//   
UINT32 DRM_GetResource( RESOURCE_ID	res_id,
						void *		buf,
						size_t		size );

//   
UINT32 DRM_GetResourceLength( RESOURCE_ID res_id,  size_t * size );

//  
UINT32 DRM_SetResource( RESOURCE_ID		res_id,
						const void *	data,
						size_t			size );

//  
UINT32 DRM_ClearResource( RESOURCE_ID res_id );

#ifdef __cplusplus
} /* extern "C" */
#endif


/*      Action- */
typedef struct
{
	RESOURCE_ID			softkey_label;		//   -
	RESOURCE_ID			list_label;			//    
	INT8				softkey_priority;	//    ,  - 
											//   ,  -  
	INT8				list_priority;		//     ,  
											//      ,    softkey_priority
	BOOL				isExit;				// ??      
	BOOL				sendDlgDone;		//     EV_DIALOG_DONE
} RES_ACTION_LIST_ITEM_T;

typedef struct
{
	RESOURCE_ID			l_title;			//   
	RESOURCE_ID			m_title;			//   
	UINT32				unk1;
	UINT32				unk2;
	RESOURCE_ID			unk3[2];
	BOOL				unk4;
	UINT32				unk5;
	RESOURCE_ID			img;				// .  
	BOOL				unk6;
} RES_LIST_DESCR_T;




// FIELD_DESCR_T::type
#define EDITED_ENTRY_DATA_PTR_WCHAR		3
#define EDITED_ENTRY_DATA_METER			4
/*	0x12 -  
 *	0x09 - /
 *	0x02 - COMBO, res_type = 0x09	//  +  
 *	0x16 -   .  .
 */


typedef struct
{
	UINT16				type;
	RESOURCE_ID			label;		//  ""
	BOOL				readonly;
	BOOL				show;
	BOOL				unk5;
	UINT32				maxlen;
	RESOURCE_ID			resource;	// res_type = 0x10
	UINT32				unk8;		// 0xB
} FIELD_DESCR_T;



#endif // SDK_RESOURCES_H