#ifndef SDK_MEMORY_H
#define SDK_MEMORY_H

#include <typedefs.h>
#include <trace.h>

#ifdef __cplusplus
extern "C" {
#endif

//  
//     ,   err   
//     NULL     
void * suAllocMem( size_t size, INT32 * err );

//  
void suFreeMem( void * ptr );

void __rt_memclr( void *, size_t );
//    
#define memclr(m,sz)			__rt_memclr((void *)m,(size_t)sz)

void * __rt_memcpy( void *, const void *, size_t );
//   
#define memcpy(dst,src,sz)		__rt_memcpy((void *)dst,(const void *)src,(size_t)sz)

void * __rt_memset( void *, int, size_t );
//     
#define memset(m,byte,sz)			__rt_memset((void *)m,(int)byte,(size_t)sz)


//   
//void * AmMemAlloc( size_t size );
//void AmMemFree( void * ptr );


//   su*Mem ( )
//     su*Mem,   - uis*Mem
//   
//       ,  
//    !
void * device_Alloc_mem( UINT32 count, size_t sz );
void device_Free_mem_fn( void * ptr );



//    
#define malloc1(sz)		suAllocMem(sz, NULL)
#define free1(mb)		suFreeMem(mb);

#ifdef __cplusplus
} /* extern "C" */
#endif


#endif // SDK_MEMORY_H