#ifndef SDK_FILESYSTEM_H
#define SDK_FILESYSTEM_H

#include <typedefs.h>


#define FILEURI_MAX_LEN			258		// please, use FILEURI_MAX_LEN+1
#define FILENAME_MAX_LEN		63		// 

#define FS_PARAM				0

/* ***********************************
 *		type definition
 */
typedef UINT64					FILE_ID;		//  ID 
#define FILE_ID_INVALID			(FILE_ID)(-1)

typedef UINT16					FILE_HANDLE_T;
#define FILE					FILE_HANDLE_T	//

#define FILE_HANDLE_INVALID		0xFFFF
#define FILE_INVALID			FILE_HANDLE_INVALID

//  
typedef UINT8 FS_SEARCH_HANDLE_T;

//  
typedef struct
{
#ifdef	FTR_L7E
	UINT32				flags;	// FS_SEARCH_*
#else
	UINT8				flags;	// FS_SEARCH_*
#endif
	UINT16				attrib; // ,     ,   &mask==attrib
	UINT16				mask;
} FS_SEARCH_PARAMS_T;
#define FS_SEARCH_RECURSIVE				0x01
#define FS_SEARCH_SORT_BY_NAME			0x04
#define FS_SEARCH_START_PATH			0x08
#define FS_SEARCH_FOLDERS				0x10
#define FS_SEARCH_SORT_BY_DATE			0x20

//  
typedef struct
{
	WCHAR			name[FILEURI_MAX_LEN+1]; //    ( )
	UINT16			attrib;
   	UINT16			unk1;
} FS_SEARCH_RESULT_T;

//  
typedef struct {
	WCHAR		volume[2+1];
	WCHAR		descr[12+1];	// "flash" (for phone)
	size_t		free_size;	// in bytes
	size_t		vol_size;	// in bytes
	UINT16		attr;		// ??. For vol /b attr==type
	UINT8		unk1;		// 0x01
	UINT16		type;		// ?? 0x40 - TRANS / 0x01 - flash. FileSystem???
	UINT16		unk3;
	UINT32		unk4;		// pointer to DSP??? only for TRANS

} VOLUME_DESCR_T;


/* ***********************************
 *		define
 */

// File system attributes
#define FS_ATTR_DEFAULT		0x0000
#define FS_ATTR_READONLY   	0x0001
#define FS_ATTR_HIDDEN	 	0x0002
#define FS_ATTR_SYSTEM	 	0x0004
#define FS_ATTR_VOLUME	 	0x0008
#define FS_ATTR_DIRECTORY  	0x0010
#define FS_ATTR_ARCHIVE		0x0020

/* this flags used in function APP_FSS_IsVolumeFormatted */
#define VOL_ATTR_UNK0		8
#define VOL_ATTR_UNK1		0x100


/* ***********************************
 *		enum
 */
/*  mode  DL_FsOpenFile.   - . 
	  C stdio.h  */
enum
{
	FILE_READ_MODE = 0,		 //   
	FILE_MODE_READ	= FILE_READ_MODE,
	FILE_WRITE_MODE,			//  
	FILE_MODE_WRITE	= FILE_WRITE_MODE,
	FILE_WRITE_EXIST_MODE,	  // ,    
	FILE_MODE_WRITE_EXIST	= FILE_WRITE_EXIST_MODE,
	FILE_APPEND_MODE,		   //    
	FILE_MODE_APPEND	= FILE_APPEND_MODE,
	FILE_READ_PLUS_MODE,		//     
	FILE_MODE_READ_PLUS	= FILE_READ_PLUS_MODE,
	FILE_WRITE_PLUS_MODE,	   //     
	FILE_MODE_WRITE_PLUS	= FILE_WRITE_PLUS_MODE,
	FILE_WRITE_EXIST_PLUS_MODE, //     ,   
	FILE_MODE_WRITE_EXIST_PLUS	= FILE_WRITE_EXIST_PLUS_MODE,
	FILE_APPEND_PLUS_MODE,	   //      /  
	FILE_MODE_APPEND_PLUS	= FILE_APPEND_PLUS_MODE
};

/*  whence  DL_FsSeekFile */
enum
{
	SEEK_WHENCE_SET = 0,
	SEEK_WHENCE_CUR,
	SEEK_WHENCE_END
};


// for C++ compiler
#ifdef __cplusplus
extern "C" {
#endif

/* ***********************************
 *		Functions
 *
 *	*     
 */

/*   */
FILE_HANDLE_T DL_FsOpenFile( const WCHAR * uri,  UINT8 mode,  UINT16 param3 );

/*   */
UINT8 DL_FsCloseFile( FILE_HANDLE_T handle );

/*    */
UINT8 DL_FsReadFile( void * buffer,
					 size_t size,
					 size_t count,
					 FILE_HANDLE_T handle,
					 size_t * read );

/*     */
UINT8 DL_FsWriteFile( void * buffer,
					  size_t size,
					  size_t count, 
					  FILE_HANDLE_T handle,
					  size_t * written);

/*    / */
UINT8 DL_FsFSeekFile( FILE_HANDLE_T handle,  INT32 off,  UINT8 whence );

/*   */
size_t DL_FsGetFileSize( FILE_HANDLE_T handle );

/*   */
size_t DL_FsSGetFileSize( const WCHAR * uri,  UINT16 param1 );

BOOL DL_FsDirExist( const WCHAR * uri );	//  
BOOL DL_FsFFileExist( const WCHAR * uri );  //  

/*     / */
UINT32 DL_FsFGetPosition( FILE_HANDLE_T handle );

/*   */
UINT8 DL_FsRenameFile( FILE_HANDLE_T handle,  WCHAR * new_name );

/*   */
UINT8 DL_FsSRenameFile( const WCHAR * old_uri, const WCHAR * new_name,  UINT16 param2 );

/*   */
UINT8 DL_FsDeleteFile( const WCHAR * uri,  UINT16 param1 );

/*   */
UINT8 DL_FsFMoveFile( const WCHAR * src_uri, const WCHAR * dst_uri,  UINT16 param2 );

/*   */
UINT8 DL_FsMkDir( const WCHAR * uri,  UINT16 param1 );

/*   */
UINT8 DL_FsRmDir( const WCHAR * uri,  UINT16 param1,  BOOL b_free ); //param1=0 param2 = 0|1

/*   */
UINT8 DL_FsFSetAttr( FILE_HANDLE_T handle,  UINT16 attrib );

/*   */
UINT8 DL_FsSSetAttr( const WCHAR * uri,  UINT16 param1,  UINT16 attrib );

/*   */
UINT16 DL_FsGetAttr( FILE_HANDLE_T handle );

/*   */
UINT16 DL_FsSGetAttr( const WCHAR * uri,  UINT16 param1 );

/*     */
/* search_string   uri ,   ,   0xFFFE,  .
	: "file://b/Elf/\xFFFE*.elf" */
UINT16 DL_FsSSearch( FS_SEARCH_PARAMS_T		params,
						  const WCHAR *			search_string,
						  FS_SEARCH_HANDLE_T *	handle, 		// out
						  UINT16 *				res_count,		// out
						  UINT16 				param4 );

/*    []    */
UINT16 DL_FsSearchResults( FS_SEARCH_HANDLE_T		handle,
						   		 UINT16 				start_index, // 0 based
								 UINT16 *				count,		 // in and out
								 FS_SEARCH_RESULT_T *	results );
/*    */
UINT16 DL_FsSearchClose( FS_SEARCH_HANDLE_T handle );

/*   */
void DL_FsFlush( void );



/*   
	   L"/a\xFFFE/c\xFFFE/b"
	   - 0xFFFE */
WCHAR * DL_FsVolumeEnum( WCHAR * result );

/*   () */
VOLUME_DESCR_T * DL_FsGetVolumeDescr( WCHAR * volume, VOLUME_DESCR_T * vd );


/*   ID  */
FILE_ID *	DL_FsGetIDFromURI( const WCHAR * file_uri, FILE_ID * fid );

/*       ID */
WCHAR *		DL_FsGetURIFromID( const FILE_ID * fid, WCHAR * file_uri );


UINT32 URINameValid( WCHAR * uri );


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // SDK_FILESYSTEM_H