/* ***********************************
 *	Device Layer
 */
#ifndef SDK_DL_H
#define SDK_DL_H

#include <typedefs.h>

#define KEY_0				0
#define KEY_1				1
#define KEY_2				2
#define KEY_3				3
#define KEY_4				4
#define KEY_5				5
#define KEY_6				6
#define KEY_7				7
#define KEY_8				8
#define KEY_9				9
#define KEY_STAR			10
#define KEY_POUND  			11

#define KEY_SMART 			21
#define KEY_CAM				63

#define KEY_UP				44
#define KEY_DOWN			45
#define KEY_LEFT			46
#define KEY_RIGHT			47
#define KEY_JOY_OK			0x3D

#define KEY_GREEN			0x12
#define KEY_RED				0x11

#define KEY_SOFT_LEFT		0x0E
#define KEY_SOFT_RIGHT		0x0F

#define KEY_MENU			0x14
#define KEY_ITUNES			0x42

#define KEY_VOL_UP			0x17
#define KEY_VOL_DOWN		0x18

typedef struct
{
	UINT32	period;
	UINT32	id;
} DL_TIMER_INIT_T;

#ifdef __cplusplus
extern "C" {
#endif

UINT32 DL_AudPlayTone( UINT32 tone,  UINT8 volume ); //Current volume = 0xFF


///////////////////// Added by om2804 //////////////////////

/* ?  

	E398 ONLY! */
void HAPI_LP393X_disp_backlight_intensity( UINT32 light ); // light = 0..100

/* ? ??
	type: 0-? 1-?
	val: 0xRGB (0x000 - 0xFFF),  0x00E - ?

	E398 ONLY! */
void HAPI_LP393X_set_tri_color_led( UINT32 type,  UINT32 val );

/////////////////// Added by WhiteHotIce /////////////////////

/*   */
void HAPI_WATCHDOG_soft_reset( void );

/*  ? */
void pu_main_powerdown( void );

///////////////////// Added by G-XaD ///////////////////////

/*  ??seem_data count   seem,  record
	???  ?count  ?! */
UINT32 SEEM_FDI_OUTSIDE_SEEM_ACCESS_read( UINT32 seem,  UINT32 record,  void* seem_data,  UINT32 count );

/*    seem_data count  ??seem,  record
	 ?*/
#define SEEM_WRITE_METHOD_ADD				0
#define SEEM_WRITE_METHOD_UPDATE			1
UINT32 SEEM_FDI_OUTSIDE_SEEM_ACCESS_write( UINT32 method,  UINT32 seem,  UINT32 record,  void* seem_data,  UINT32 count );

/*  ?funlight) ??fl_id
	?  ???? ?p2 = 3,
	   ? ?? ( ?...) 

	E398 ONLY! */
UINT32 DL_AudStartFunlight( UINT8 fl_id,  UINT32 p2,  UINT32 p3 ); // p2 = 1, p3 = 0

/* ??funlight) ??fl_id 

	E398 ONLY! */
UINT32 DL_AudStopFunlight( UINT8 fl_id );

/* ? */
void DAL_DisableDisplay( UINT32 p1 ); // p1 = 0

/*   */
void DAL_EnableDisplay( UINT32 p1 ); // p1 = 0


UINT8 DL_PwrGetActiveBatteryPercent( void );	//  ?

enum {
	SIMPIN_STATUS_SECURED = 2,	// ???
	SIMPIN_STATUS_NO_PIN,
	SIMPIN_STATUS_INVALID
};
UINT8 DL_SimMgrGetPinStatus( UINT8 card );

UINT32 DL_ClkStartTimer( IFACE_DATA_T * iface, UINT32 period, UINT32 id );
UINT32 DL_ClkStartCyclicalTimer( IFACE_DATA_T * iface, UINT32 period, UINT32 id );
UINT32 DL_ClkStopTimer( IFACE_DATA_T * iface );
void DL_KeyInjectKeyPress(UINT8 p1,UINT8 p2,UINT8 p3);

/* ***************************
  ?
*************************** */

enum {			// volume_type
	VOLUME_TYPE_RING = 0,	// ?
	VOLUME_TYPE_KEYTONE,	// ?
	VOLUME_TYPE_MME,		// ?  LTE
	VOLUME_TYPE_INCALL,		//   ?
	VOLUME_TYPE_MME_LTE2,	//  ? LTE2 ?V3i
	VOLUME_TYPE_PTT_TONES,
	VOLUME_TYPE_MUTABLE_MAX,
	VOLUME_TYPE_IMMUTABLE_MAX,
	VOLUME_TYPE_MAX = VOLUME_TYPE_IMMUTABLE_MAX
};

//  ?
void DL_AudSetVolumeSetting( UINT8 volume_type, UINT8 volume );
//  ??
void DL_AudGetVolumeSetting( UINT8 volume_type, UINT8 * volume );



#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // SDK_DL_H