#ifndef SDK_CANVAS_H
#define SDK_CANVAS_H

#include <typedefs.h>
#include <stdarg.h>
#include <uis.h>
#include <fs.h>			// FILE_HANDLE_T


#ifdef __cplusplus
extern "C" {
#endif


//     ????
#define CANVAS_EV_KEY_PRESS 		  0x2034
#define CANVAS_EV_KEY_RELEASE		  0x2035


typedef UINT32				UIS_COLOR_T;
//#define COLOR_T				UIS_COLOR_T
#define COLOR_RED			(COLOR_T)(0xFF000000)
#define COLOR_GREEN			(COLOR_T)(0x00FF0000)
#define COLOR_BLUE			(COLOR_T)(0x0000FF00)
#define COLOR_TRANSPARENT	(COLOR_T)(0x000000FF)
#define RGB(r,g,b)			(COLOR_T)((BYTE)(r)<<24 | (BYTE)(g)<<16 | (BYTE)(b)<<8)
#define RGBT(r,g,b,t)		(COLOR_T)((BYTE)(r)<<24 | (BYTE)(g)<<16 | (BYTE)(b)<<8 | (BYTE)(t))

#define RGB_getr(c)			(BYTE)((UINT32)(c) >> 24 & 0xFF)// RED
#define RGB_getg(c)			(BYTE)((UINT32)(c) >> 16 & 0xFF)// GREEN
#define RGB_getb(c)			(BYTE)((UINT32)(c) >>  8 & 0xFF)// BLUE
#define RGB_gett(c)			(BYTE)((UINT32)(c)	   & 0xFF)// TRANSPARENT

typedef struct
{
	UINT8 red;
	UINT8 green;
	UINT8 blue;
	UINT8 transparent; // transparency 
} COLOR_T;
// DRAWING_BUFFER
#define PIXEL			UINT16
typedef struct {
	PIXEL *		p_buf; // can be NULL
	UINT16		w;
	UINT16		h;
} UIS_DRAWING_BUFFER_T;


// POINT_T
typedef struct tag_DAL_GRAPHIC_POINT_T {
	INT16		x;
	INT16		y;
} UIS_GRAPHIC_POINT_T;
#define GRAPHIC_POINT_T			UIS_GRAPHIC_POINT_T
#define POINT_T					UIS_GRAPHIC_POINT_T
// inline point
#define set_point(p,x,y)		p.x = x;\
			p.y = y;

// METRIC_T
typedef struct {
    UINT16 h;
    UINT16 w;
} UIS_GRAPHIC_METRIC_T;
#define GRAPHIC_METRIC_T		UIS_GRAPHIC_METRIC_T
#define METRIC_T				UIS_GRAPHIC_METRIC_T


// REGION_T
typedef struct tag_DAL_GRAPHIC_REGION_T {
	POINT_T		ulc;
	POINT_T		lrc;
} UIS_GRAPHIC_REGION_T;
#define GRAPHIC_REGION_T	UIS_GRAPHIC_REGION_T
#define REGION_T			UIS_GRAPHIC_REGION_T
// inline region
#define set_region(r,x,y,w,h)			set_point(r.ulc,x,y);\
			set_point(r.lrc,x+w,y+h);
#define SOFTKEY_REGION(r)	set_region(r,0,198,175,21)// for display 172x220


// Horisontal justification
// used in UIS_CanvasDrawText
typedef enum {
	DT_H_ALIGN_CENTER = 0,
	DT_H_ALIGN_RIGHT,
	DT_H_ALIGN_LEFT
} CANVAS_DRAW_TEXT_H_ALIGN;



typedef UINT8 CANVAS_IMAGE_HANDLE_T;



// to <uis.h>
UINT32
UIS_Delete( UIS_DIALOG_T dialog );


// use for UIS_DRAWING_BUFFER_T
POINT_T
UIS_CanvasGetDisplaySize( void );

UIS_DIALOG_T
UIS_CreateColorCanvas( SU_PORT_T * port, UIS_DRAWING_BUFFER_T * drb, BOOL use_soft_icons_region );

UIS_DIALOG_T
UIS_CreateColorCanvasWithWallpaper( SU_PORT_T * port, UIS_DRAWING_BUFFER_T * drb, BOOL use_soft_icons_region, BOOL b_wallp );


/* ************************************
 * Simple Canvas Draw API
 * ************************************/
void UIS_CanvasDrawPixel( POINT_T point, UIS_DIALOG_T dialog );						   
void UIS_CanvasDrawLine( POINT_T from, POINT_T to, UIS_DIALOG_T dialog );
// Fill & Foreground
void UIS_CanvasDrawRect( REGION_T region, BOOL b_fill, UIS_DIALOG_T dialog );
void UIS_CanvasFillRect( REGION_T region, UIS_DIALOG_T dialog );
void UIS_CanvasDrawArc( REGION_T region, UINT16 start_angle, UINT16 end_angle, BOOL b_fill, UIS_DIALOG_T dialog );
void UIS_CanvasDrawRoundRect( POINT_T p1, POINT_T p2, 
								UINT16 rpW, UINT16 rpH,		// parameters of a rounding
								BOOL b_fill, UIS_DIALOG_T dialog);
// Draw polyhedron
void UIS_CanvasDrawPoly( UINT16		n,		// number of vertices
						POINT_T	*	array,	// size = sizeof(POINT_T)*n
						BOOL		b_fill, UIS_DIALOG_T dialog );

// ?  
COLOR_T UIS_CanvasGetFillColor( void );
void UIS_CanvasSetFillColor( COLOR_T );
//   ?
COLOR_T UIS_CanvasGetBackgroundColor( void );
void UIS_CanvasSetBackgroundColor( COLOR_T );
// ? ?  Foreground
COLOR_T UIS_CanvasGetForegroundColor( void );
void UIS_CanvasSetForegroundColor( COLOR_T );

// Line Width
void UIS_CanvasSetLineWidth( UINT16 width );
UINT16 UIS_CanvasGetLineWidth( void );

UINT32
UIS_CanvasFillRegion( PIXEL *	p_buf,		// UIS_DRAWING_BUFFER_T::p_buf
					REGION_T	region,
					UINT32		unk_0 );	// =0


/* *********************************
 * other API
 * *********************************/
UINT32
UIS_CanvasDrawText( PIXEL *			p_buf,		// UIS_DRAWING_BUFFER_T::p_buf
					const WCHAR *	text,
					REGION_T		region,
					UINT8			font_id,	// look at MotoLangEditor
					BOOL			b_reverse,
					UINT32			empty_0,	// not used
					UINT8			h_align );	// CANVAS_DRAW_TEXT_H_ALIGN

UINT32
UIS_CanvasDrawBitmap ( PIXEL *			p_buf,
					const BYTE *		p_bitmap,
					REGION_T			region,
					BOOL				b_reverse );


UINT32
UIS_CanvasDrawPicture( PIXEL *			p_buf,		// UIS_DRAWING_BUFFER_T::p_buf
						RESOURCE_ID 	res_id,		// 0x0200yyyy
						REGION_T		region,
						BOOL			b_reverse );


void UIS_CanvasRefreshDisplayBuffer( UIS_DIALOG_T dialog );

void UIS_CanvasRefreshDisplayRegion( UIS_DIALOG_T dialog, REGION_T region );


UINT32
UIS_CanvasGetStringSize( const WCHAR * str,
						METRIC_T * size,
						UINT8 font_id );


BOOL UIS_CanvasGetWallpaperFlag( UIS_DIALOG_T dialog );
void UIS_CanvasSetWallpaperFlag( UIS_DIALOG_T dialog, BOOL b_wallp );



/* ************************************************************
 * UIS_CanvasDrawImage & UIS_CanvasDrawColorText special types
 * ************************************************************/

/* justification flags for image & text
 *
 * used in:	UIS_CanvasDrawImage
 * 			UIS_CanvasDrawColorText
 * */
#define HALIGN_CENTER		1
#define VALIGN_CENTER		2	// image only
#define HALIGN_LEFT			4
#define HALIGN_RIGHT		8
#define VALIGN_TOP			16
#define VALIGN_BOTTOM		32
#define VALIGN_CENTERTEXT	64	// text only


typedef enum { // picture_type
	CANVAS_DI_RESID = 0, 
	CANVAS_DI_URI,
	CANVAS_DI_DATA,
	CANVAS_DI_FHANDLE,
	CANVAS_DI_URI_OFF
} CANVAS_DRAW_IMAGE_TYPE;

typedef struct {
	const void *	data;
	size_t			size;
} IMG_POINTER_T;

typedef struct {
	FILE_HANDLE_T	file;
	UINT32			off;
	size_t			size;
} UIS_FILE_HANDLE_T;

typedef struct {
	WCHAR *				uri;
	UINT32				mime_type; // MMSS_MIME_TYPE_T // look at mme.h
	UINT32				off;
	size_t				size;
} URI_WITH_OFFSET_T;

typedef struct 
{
    const void *resourcePicturePointerValue;  // Location pointer? pa? ty //ڴеָ
    UINT32 imageSize;                     	  // size of the image 
} PICTURE_POINTER_T;
typedef union {
	RESOURCE_ID				img_id; 	// CANVAS_DI_RESID
	WCHAR *					uri;		// CANVAS_DI_URI
	IMG_POINTER_T			img;		// CANVAS_DI_DATA
	UIS_FILE_HANDLE_T		uis_file;	// CANVAS_DI_FHANDLE
	URI_WITH_OFFSET_T		uri_ext;	// CANVAS_DI_URI_OFF:
    	//PICTURE_POINTER_T       	PointerValue;
} PICTURE_TYPE_UNION_T;

enum  // draw_op
{
	DRAW_OP_ALPHA,
	DRAW_OP_DRAW,
	DRAW_OP_FILLALPHA_NOIMAGE,
	DRAW_OP_INVERT,
	DRAW_OP_UNK2,
	DRAW_OP_UNK3,
	DRAW_OP_INVERT2,
		DRAW_OP_UNK4,	// empty
	DRAW_OP_UNK5,
	DRAW_OP_UNK6
}; 

UINT32
UIS_CanvasDrawImage( UINT8						type,	// CANVAS_DRAW_IMAGE_TYPE
					PICTURE_TYPE_UNION_T		img,
					POINT_T						point,
					UINT16						align_attrib,
					UINT8						draw_op,	// DRAW_OP_TYPE
					UIS_DIALOG_T				dialog );

// BG & FG
void
UIS_CanvasDrawColorText( const WCHAR *	str,
						UINT16			start,			// draw from simbol
						UINT16			count,			// count simbols to be written
						POINT_T			point,
						UINT16			align_attrib,
						UIS_DIALOG_T	dialog );


/* ***********************************
 * Canvas+Image Methods & typedefs
 * ***********************************/
typedef UINT8		CANVAS_IMAGE_HANDLE_T;

typedef enum {
	IMAGE_NO_ATTRIBUTES,
	IMAGE_FRAME_COMPLETED_CONFIRMATION,
	IMAGE_CYCLE_COMPLETED_CONFIRMATION,
	IMAGE_ANIMATION_COMPLETED_CONFIRMATION,
	IMAGE_FORCED_STILL_IMAGE,
	IMAGE_BACKGROUND_TRANSPARENT_IMAGE,
	IMAGE_BACKGROUND_TRANSPARENT_COLOR,
	IMAGE_BACKGROUND_TRANSPARENT_GRADIENT,
	
	IMAGE_BACKGROUND_TRANSPARENT_TILED_IMAGE,
	IMAGE_BACKGROUND_WALLPAPER_NEEDED,
 
	IMAGE_START_ANIMATION_AGAIN,
	IMAGE_BACKGROUND_EXCLUDING_IMAGE,
	IMAGE_CHANGE_ONLY_FOR_SUCCESS, 
	IMAGE_NO_PAINT_WHITE,
	IMAGE_NO_PAINT_WHITE_WITH_CROSS,
	IMAGE_PAINT_WHITE_AND_PAINT_WHITE_WITH_CROSS,
	IMAGE_NO_OF_CYCLES_OF_ANIMATION,
	IMAGE_DECODE_WALLPAPER_GRAYSCALE,
	IMAGE_PRESERVE_BACKGROUND_GRAYSCALE,
	IMAGE_RETURN_HANDLE_EVENT,
	IMAGE_GET_WIDTH,
	IMAGE_GET_HEIGHT,
	IMAGE_GET_FRAME_DELAY,
	IMAGE_OBEY_TRANSPARENCY,

	IMAGE_BLEND_VALUE,

	IMAGE_CLOSE_FILE_ON_RETURN,
	IMAGE_DO_NOT_UPDATE_DISPLAY,
	IMAGE_GET_SCALING_FACTOR,
	IMAGE_CHANGE_BUFFER_DIMENSIONS,
	IMAGE_GET_TYPE,
	IMAGE_GET_FRAME_NUMBER,
	IMAGE_GET_NUMBER_OF_FRAMES,
	IMAGE_GET_ID,
	IMAGE_SEND_EVENT,
	IMAGE_DECODE_THUMBNAIL,	
	IMAGE_GET_THUMBNAIL_WIDTH, 
	IMAGE_GET_THUMBNAIL_HEIGHT, 
	IMAGE_MME_DECODE_HIGHEST_SCALE_FACTOR,
	IMAGE_GET_REGION_ULCX,
	IMAGE_GET_REGION_ULCY,
	IMAGE_FORMAT
	//   ?
} IMG_ATTR_T;

CANVAS_IMAGE_HANDLE_T
UIS_CanvasOpenImage( UINT8 type, PICTURE_TYPE_UNION_T img );

//CANVAS_IMAGE_HANDLE_T
//UIS_CanvasOpenImageAndGetSize( UINT8 type, PICTURE_TYPE_UNION_T img, METRIC_T * img_size );
CANVAS_IMAGE_HANDLE_T UIS_CanvasOpenImageAndGetSize(UINT8 picture_type,
													PICTURE_TYPE_UNION_T picture_data,
													GRAPHIC_POINT_T *attributes);

UINT32
UIS_CanvasCloseImage( CANVAS_IMAGE_HANDLE_T h_img );
// ??
UINT32
UIS_CanvasResizeImage( CANVAS_IMAGE_HANDLE_T	h_img,
						UINT16					percent,		// zoom ??
						REGION_T				region_src,		//   
						REGION_T				region_dst,		// ?
						UINT8					draw_op,
						UIS_DIALOG_T			dialog );
//   
METRIC_T
UIS_CanvasGetImageSize( UINT8 type, PICTURE_TYPE_UNION_T img );

UINT32
UIS_CanvasSetImageAttribute( CANVAS_IMAGE_HANDLE_T	h_img,
							IMG_ATTR_T				attrute,
							void *					value );
//  									
UINT32
UIS_CanvasGetImageAttribute( CANVAS_IMAGE_HANDLE_T	h_img,
							IMG_ATTR_T				attrute,
							void *					value);
// ? ??pointer
UINT32
UIS_CanvasDecodeImageToPointer( CANVAS_IMAGE_HANDLE_T h_img, void * p_buf );


UINT32
UIS_CanvasDrawWallpaper( CANVAS_IMAGE_HANDLE_T	h_img,
						GRAPHIC_REGION_T		region_src,
						GRAPHIC_REGION_T		region_dst,
						UINT8					draw_op,
						UINT8					wlp_type,
						UIS_DIALOG_T			dialog );		


/* **********************
 * Font, font style
 * **********************/

UINT32
UIS_CanvasSetFont( UINT8 font_id, UIS_DIALOG_T dialog );

UINT8
UIS_CanvasGetFontId( UIS_DIALOG_T dialog );
// Font style
UINT8 UIS_CanvasGetFontStyle( UIS_DIALOG_T dialog );
UINT32 UIS_CanvasSetFontStyle( UINT8 style, UIS_DIALOG_T dialog );
// Font size
UINT32
UIS_CanvasGetFontSize ( UINT8 font_id, METRIC_T * size );









// ----
//  ?
UINT32
UIS_CanvasInsert( UIS_DIALOG_T dialog, const void * p_buf, POINT_T point );	

//  
UINT32
UIS_CanvasMoveRegion( GRAPHIC_REGION_T src_region,
						GRAPHIC_REGION_T dst_region,
						UIS_DIALOG_T dialog );







//  ?????
UINT32
UIS_CanvasGetColorDepth ( void );



#ifdef __cplusplus
} /* extern "C" */
#endif

#endif // SDK_CANVAS_H