/* ***********************************
 *	    ,
 *		   
 */
#ifndef SDK_BLUETOOTH_SEND_APP_H
#define SDK_BLUETOOTH_SEND_APP_H

#include <typedefs.h>
#include <fs.h>

#define MIME_TYPE_STRING_LEN	50

//    
extern const UINT32 *			EVENT_BT;


#define CNT_LTE_TYPE_PR_REC		3
#define CNT_LTE_TYPE_SC_URL		4
#define CNT_LTE_TYPE_FILE		5

#ifdef FTR_L7E
#define CNT_LTE2_TYPE_FILE		6
#else
#define CNT_LTE2_TYPE_FILE		5
#endif



typedef struct {
	WCHAR		uri[FILEURI_MAX_LEN+6+1];			// strlen("file:/") = 6
	char		mime_type[MIME_TYPE_STRING_LEN+1];	// ="*/*"
	BOOL		remove;
	UINT16		pad;				// =0
	UINT16		num_files;			// =1
} LTE_SEND_BT_FILE;

// R373 BT Attach
typedef struct {
	UINT8		content_type;	// CNT_*
	union {
		LTE_SEND_BT_FILE	file;	// CNT_LTE_TYPE_FILE
		UINT8				pad[592];
		UINT32				pad2[148];	// ,       4 
	} cnt;
} LTE_SEND_BT_ATT;	// size=596



// LTE2 BT Attach
typedef struct {
#ifdef FTR_L7E
	UINT16		unk2;			// 1
	UINT8		pad4[6];		// 0
#endif
	UINT8		content_type;	// CNT_LTE2_TYPE_FILE for file
	UINT8		pad1[584];		// 0
	BOOL		remove;			// delete files after sending
	UINT16		pad2;			// 0
	FILE_ID *	p_ids;
	UINT32		num_files;
	UINT8		pad3[1848];		// 0
#ifndef FTR_L7E
	UINT16		unk2;			// 1
	UINT8		pad4[6];		// 0
#endif
} LTE2_SEND_BT_ATT;	// size = 2447


//       ARM



#endif // SDK_BLUETOOTH_SEND_APP_H
