#include "main.h"
UINT8 pos[5];
UINT8 pos_i;
UINT32 map_id;
WCHAR map_uir[100];
WCHAR bmap_uir[100];
WCHAR pic_uir[100];
char g2bTable[15228];
UINT8 *PIC=NULL;
UINT32 PIC_SIZE;
BOOL r_pic=FALSE;
UINT8			atype;
const char app_name[APP_NAME_LEN] = "HexEditor";  //
//static unsigned short last[]={0x6700,   /**/0x8fd1,   /**/0x9605,   /**/0x8BFB,0};
const WCHAR edit_name[]={'T','X','T','E','D','I','T',0};
const WCHAR open[]={0x6253/**/,0x5F00/**/,0};
const WCHAR menu_[]={0x83DC,0x5355,0};
const WCHAR goto_[]={0x8DF3,0x5230,0};
const WCHAR new_[]={0x6587,0x4EF6,0x540D,0};
const WCHAR set_[]={0x8BBE,0x7F6E,0};
const WCHAR set_y[]={0x884C,0x8DDD,0};
const WCHAR set_t[]={0x65F6,0x95F4,0};
const WCHAR set_h[]={0x884C,0x6570,0};
const WCHAR set_x[]={0x50CF,0x7D20,0};
const WCHAR set_c[]={0x989C,0x8272,0};
const WCHAR set_b[]={0x5907,0x4EFD,0};
const WCHAR set_back[]={0x80CC,0x666F,0};
const WCHAR set_txt[]={0x6587,0x5B57,0};
const WCHAR set_type[]={0x7F16,0x7801,0};
//const WCHAR set_atype[]={0x9ED8,0x8BA4,0};
const WCHAR set_type_n[]={0x9ED8,0x8BA4,0};
const WCHAR set_type_a[]={0x81EA,0x52A8,0};
const WCHAR set_type_g[]={0x7B80,0x4F53,0};
const WCHAR set_type_b[]={0x7E41,0x4F53,0};
const WCHAR set_type_big5[]={'B','I','G','5',0};
const WCHAR set_type_b5[]={0x663E,0x793A,0x7E41,0x4F53,0};
const WCHAR set_type_u[]={0x0055,0x7801,0};
const WCHAR set_type_ul[]={0x0055,0x004C,0x7801,0};
const WCHAR set_type_utf8[]={'U','T','F','-','8',0};
const WCHAR set_type_o[]={0x504F,0x79FB,0};
const WCHAR set_type_m[]={'M','A','P',0};

const WCHAR *	lang_type[TYPE_LANGMAX] = //
{
set_type_n,
set_type_a,
set_type_g,
set_type_b,
set_type_big5,
set_type_b5,
set_type_u,
set_type_ul,
set_type_utf8,
};


WCHAR file_dir[FILEURI_MAX_LEN+1];
WCHAR           file_open[FILEURI_MAX_LEN+1];
BOOL 			cmd_file=FALSE;
UINT8 SET_Y;
UINT16 SET_T;
UINT8 SET_H;
UINT8 SET_X;
BOOL SET_B;
RESOURCE_ID Resources[RES_MAX];
UIS_DIALOG_T            dialog;
GRAPHIC_POINT_T         display_size;
//extern const EVENT_HANDLER_ENTRY_T fb_state_handlers[];
//extern const EVENT_HANDLER_ENTRY_T read_state_handlers[];
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
	{EV_GAIN_FOCUS,                gotoread},
	//{ EV_KEY_PRESS,                mKeypress },
    { STATE_HANDLERS_END,           NULL           },
};
static const EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    { EV_GRANT_TOKEN,               HandleUITokenGranted},
    { STATE_HANDLERS_END,           NULL           },
};
static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_DONE,                     	            mback },
	{ EV_SELECT, 		                       mSelectItem }, 
	{ EV_KEY_PRESS,								mKeypress	},
	//{ EV_KEY_RELEASE,            			mKeyrelease },
	{ EV_LIST_NAVIGATE,							mHandleNavigate },
    //{ EV_DIALOG_DONE,             	            destroyApp },
    { EV_REQUEST_LIST_ITEMS,       	        HandleListReq },
    //{ 0x3222,								mback },

    { STATE_HANDLERS_END,           		      	  NULL },
};
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
	{ HE_STATE_ANY,              
	NULL,                      
	NULL,                       
	any_state_handlers          
	},
	{ HE_STATE_INIT,
	NULL,
	NULL,
	init_state_handlers
	},
	{ HE_STATE_MAIN,
	MainStateEnter,
	//NULL,
	StateExit,
	main_state_handlers
	},
	{ HE_STATE_FB,
	FbrowserStateEnter,

	StateExit,
	fb_state_handlers
	},
	{ HE_STATE_READ,
	ReadStateEnter,
	//NULL,
	StateExit,
	read_state_handlers
	},
	{ HE_STATE_EDIT,
	editStateEnter,
	//NULL,
	StateExit,
	edit_state_handlers
	},
	{ HE_STATE_MARK,
	MarkStateEnter,
	//NULL,
	StateExit,
	mark_state_handlers
	},
	{ HE_STATE_GOTO,
	GotoStateEnter,
	//NULL,
	StateExit,
	goto_state_handlers
	},
	{ HE_STATE_ABOUT,
	AboutStateEnter,
	StateExit,
	about_state_handlers
	}

};
void ELF_HandleEvent( EVENT_STACK_T * ev_st, void * app, APP_ID_T app_id, REG_ID_T reg_id )
{
    APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
    //UINT32                  state;
	if ( papp->apt.focused ) 
	{
		//state = papp->apt.state;
		//if ( state == MC_STATE_FB || state == MC_STATE_BM ) 
		//{
			EVENT_T *	event = AFW_GetEv(ev_st);


		//	if ( event->code == EV_KEY_PRESS || event->code == EV_KEY_RELEASE ) 
		//	{
		//	if(event->data.key_pressed!=99)			
		//	APP_UtilStopTimer(app);	
			if(event->data.key_pressed==KEY_GREEN)
			event->data.key_pressed=KEY_1;
		//	}
					     

				


		//}
	}else 
	APP_UtilStopTimer(app);	
	


	APP_HandleEvent(ev_st, app, app_id, reg_id);
}
UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
		{
			tbl[i].code = (*base)++;
		}
		i++;
	}
	return *base;
}

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
		{
			return tbl[i].code;
		}
		i++;
	}

	return 0;
}
UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
    UINT32                  status;
	//UINT32* iii;

	dbg("HandleUITokenGranted:Enter",NULL);
    status = APP_HandleUITokenGranted( ev_st, app );
	//iii=EV_MsgNotif;


    if( (status == RESULT_OK) && (papp->apt.token_status == 2) )
    {
	if(cmd_file)
	{
	papp->mode=MODE_CMD;
	status = APP_UtilChangeState( HE_STATE_READ, ev_st, app ); 
	}
	else
     status = APP_UtilChangeState( HE_STATE_MAIN, ev_st, app );      
    }

    return status;
}
UINT32 util_asc2ul( const char * s, UINT32 count )
{
    char    b;
    UINT32    res = 0;
    
    while ( count > 0 ) {
        b = *s++;
        if ( b >= '0' && b <= '9' ) {
            b -= '0';
        } else if ( b >= 'A' && b <= 'F' ) {
            b = b - 'A' + 10;
        } else if ( b >= 'a' && b <= 'f' ) {
            b = b - 'a' + 10;
        } else
            b = 0;
        res = res << 4;
        res |= b;
        count--;
    }
    
    return res;
}

UINT32 param2uri(char *param, WCHAR *uri)
{
    _u64                    tmp;
    DL_FS_MID_T             fid;

    if (strlen(param) > 16) { //  ?
        u_atou(param, uri);
    } else { // id
        tmp.R0 = util_asc2ul(param+0, 8);
        tmp.R1 = util_asc2ul(param+8, 8);
    
        if (tmp.R0==0 && tmp.R1==0) {
            u_atou(param, uri);
        } else {
            memcpy(&fid, &tmp, sizeof(UINT64));
            DL_FsGetURIFromID( &fid, uri );
        }
    }
    return RESULT_OK;
}
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    UINT32              evcode_base;
	UINT16 i,j;
	char buf[FILEURI_MAX_LEN+1];
    if (strlen(param)) 
	{
	cmd_file=TRUE;
    param2uri(param, file_open);
	}
    for (i=strlen(file_uri)-1; i > 0 ; i--)
			if (file_uri[i] == '/') break;
		
		for (j=0; j <= i ; j++)
			buf[j] = file_uri[j];
		buf[j] = 0;
		buf[j] = 0;
		u_atou(buf,file_dir);
	
	udbg("file_open=%s",file_open);	
    evcode_base = reserve; 
	dbg("reserve=%d",reserve);	
	dbg("Register:Enter",NULL);
	LdrInitEventHandlersTbl( main_state_handlers, &evcode_base ); //ʾ˵



    status = APP_Register( &evcode_base,           
                           1,                      
                           state_handling_table,   
                           HE_STATE_MAX,           
                           (void*)startApp );   
                   
    
    LdrStartApp(evcode_base);  
 

    return 1;   
	
}
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 ) 
{
    APP_TXTEDIT_T     *app = NULL;
    UINT32 status = RESULT_OK;
	dbg("startApp:Enter",NULL);


    app = (APP_TXTEDIT_T*)APP_InitAppData( (void *)ELF_HandleEvent, 
                                              sizeof(APP_TXTEDIT_T), 
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );


    status = APP_Start( ev_st,
                        &app->apt,
                        HE_STATE_INIT, 
                        state_handling_table,
                        destroyApp,
                        app_name,
                        0 );
//    app->name[0] = 0;
	app->openfile[0] = 0;
	app->filedir[0] = 0;
    app->apt.dialog= 0;
	//app->type = 0;
	app->d_true=FALSE;
    app->flist= NULL;
	app->mark= NULL;
	app->mode=MODE_NULL;
	app->setmode=0;
	app->offset=0;
	app->tem_x=0;
	app->set=FALSE;
	//app->R_TIME=FALSE;
	app->READ=FALSE;
	bmap_uir[0]='/';
	readmark(ev_st,app);
	readset(ev_st,app);
	readmap();
	map_uir[0]='/';
	pic_uir[0]='/';
	if(cmd_file)
	u_strcpy(app->openfile,file_open);
    display_size = UIS_CanvasGetDisplaySize();
    return RESULT_OK;
}
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
    APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;

	dbg("destroyApp:Enter",NULL);
    APP_ConsumeEv( ev_st, app );

	if(papp->openfile[0]!=0)
	{
	papp->mode=MODE_END;
	papp->cur_pos=MARKMAX;
	booksave( ev_st, app );
	}
	if ( papp->apt.dialog ) {
		status = APP_UtilUISDialogDelete( &papp->apt.dialog );
		dbg("ELF_Exit: APP_UtilUISDialogDelete DONE, status = %d", status);
	}


	dbg("ELF_Exit: 1", NULL);
	if(papp->flist)
	{
	suFreeMem(papp->flist);
	papp->flist = NULL;
	}
	dbg("ELF_Exit: 2", NULL);
	if(papp->mark)
	{
	suFreeMem(papp->mark);
	papp->mark = NULL;
	}
	dbg("ELF_Exit: 3", NULL);
	if(PIC)
	{
	suFreeMem(PIC);
	PIC = NULL;
	}
	dbg("ELF_Exit: 4", NULL);
    status = APP_Exit( ev_st, app, 0 );
	//dbg("ELF_Exit: lib=%s", Lib);
	dbg("ELF_Exit: lib=%p", Lib);
    LdrUnloadELF(&Lib); 
	dbg("ELF_Exit: 6", NULL);
    return status;
}
UINT32 SetStringRes( RESOURCE_ID * res, const WCHAR * text )
{
	size_t		sz = (u_strlen(text) + 1)*sizeof(WCHAR);
	if ( *res == 0 ) {
		return DRM_CreateResource( res, RES_TYPE_STRING, text, sz );
	} else {
		return DRM_SetResource( *res, text, sz );
	}
}
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
    SU_PORT_T               port = papp->apt.port;
	UINT32					starting_num;
	UINT32					return_num;
	dbg("MainStateEnter:Enter",NULL);
	if(type!=ENTER_STATE_ENTER) return RESULT_OK;

	pos_i=0;
				if(papp->set)
				{	
					if(papp->setmode==MAIN_SET_C)
					{
					SetStringRes(&Resources[RES_LIST_CAPTION], set_c);
					starting_num=6;
					pos_i=2;
					}else if(papp->setmode==MAIN_TYPE)
					{
					SetStringRes(&Resources[RES_LIST_CAPTION], set_type);
					starting_num=TYPE_MAX;
					pos_i=3;
					pos[pos_i]=papp->type;
					}else if(papp->setmode==MAIN_ATYPE)
					{
					SetStringRes(&Resources[RES_LIST_CAPTION], set_type);
					starting_num=TYPE_MAX-1;
					pos_i=4;
					pos[pos_i]=atype-1;
					}
					else
					{
					SetStringRes(&Resources[RES_LIST_CAPTION], set_);
					starting_num=SET_MAX;
					pos_i=1;
					}
				}	
				else if(papp->mode==MODE_MENU)
				{
				starting_num=MENU_MAX;
				SetStringRes(&Resources[RES_LIST_CAPTION], menu_);
				}
				else 
				{
				starting_num=MAIN_MAX-1;
				SetStringRes(&Resources[RES_LIST_CAPTION], edit_name);
				}
			    	dialog = UIS_CreateList( &port,
			    							 0,
			    							 starting_num,
			    							 0,
			    							 &return_num,
			    							 0,
			    							 2,
			    							 NULL,
			    							 Resources[RES_LIST_CAPTION]);
					if(dialog == 0) return RESULT_FAIL;
			    
			        papp->apt.dialog = dialog;

					mSendListItems(ev_st, app, 1, return_num);
					if(papp->d_true)
					{
					papp->d_true=FALSE;
					if(pos[pos_i]>starting_num)
					pos[pos_i]=starting_num;;
					APP_UtilAddEvUISListChange( ev_st, app, 0, pos[pos_i], starting_num, TRUE, 2, FBF_LEAVE, 0, NULL );
					}
	
    return RESULT_OK;
}
UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
    APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
	UINT32			status;
	dbg("StateExit",NULL);
  if ( type == EXIT_STATE_SUSPEND )
      return RESULT_OK;
	papp->READ=FALSE;
	status=APP_UtilUISDialogDelete( &papp->apt.dialog );

	return status;
}
UINT32 mSendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
	APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
	LIST_ENTRY_T			*plist=NULL; 
	UINT32					i, index, status=RESULT_OK;
	dbg("mSendListItems:Enter",NULL);
	if( num==0 ) return RESULT_FAIL;
	
	plist = malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;
	for( index=0, i=start; i<start+num ; i++, index++) 
	{
        plist[index].editable = FALSE;			
		plist[index].content.static_entry.can_mark = 1;
	}
	if(papp->set)
	{
	if(papp->setmode==MAIN_SET_C)
	{
	UIS_MakeContentFromString( "q0q1q2i3", &(plist[0].content.static_entry.text),set_txt,set_c,L"R : ",SET_C_I[0]);
	UIS_MakeContentFromString( "q0q1q2i3", &(plist[1].content.static_entry.text),set_txt,set_c,L"G : ",SET_C_I[1]);
	UIS_MakeContentFromString( "q0q1q2i3", &(plist[2].content.static_entry.text),set_txt,set_c,L"B : ",SET_C_I[2]);
	UIS_MakeContentFromString( "q0q1q2i3", &(plist[3].content.static_entry.text),set_back,set_c,L"R : ",SET_C_I[3]);
	UIS_MakeContentFromString( "q0q1q2i3", &(plist[4].content.static_entry.text),set_back,set_c,L"G : ",SET_C_I[4]);
	UIS_MakeContentFromString( "q0q1q2i3", &(plist[5].content.static_entry.text),set_back,set_c,L"B : ",SET_C_I[5]);

	}else if(papp->setmode==MAIN_TYPE)
	{
	
	for(index=0, i=start; i<start+num ; i++, index++) 
	UIS_MakeContentFromString( "q0", &(plist[index].content.static_entry.text),lang_type[i]);
	
	}else if(papp->setmode==MAIN_ATYPE)
	{
	
	for(index=0, i=start; i<start+num ; i++, index++) 
	UIS_MakeContentFromString( "q0", &(plist[index].content.static_entry.text),lang_type[i+1]);
	
	}
	else
	{
		for( index=0, i=start; i<start+num ; i++, index++) 
		MAKEContent( ev_st, app,&(plist[index].content.static_entry.text), i );
	//UIS_MakeContentFromString( "q0q1i2", &(plist[0].content.static_entry.text),set_y,L" : ",SET_Y);
	//UIS_MakeContentFromString( "q0q1i2", &(plist[1].content.static_entry.text),set_t,L" : ",SET_T);
	//UIS_MakeContentFromString( "q0q1q2", &(plist[2].content.static_entry.text),set_type,L" : ",lang_type[papp->type]);
	//UIS_MakeContentFromString( "q0q1g2", &(plist[3].content.static_entry.text),set_type_o,L" : ",map_id);
	//UIS_MakeContentFromString( "q0q1", &(plist[4].content.static_entry.text),L"MAP : ",map_uir);

	//UIS_MakeContentFromString( "q0", &(plist[5].content.static_entry.text),set_c);
	}
	}
	else
	{
	UIS_MakeContentFromString( "q0", &(plist[0].content.static_entry.text),open);
	UIS_MakeContentFromString( "s0", &(plist[1].content.static_entry.text),LANG_BOOKMARKS);
	if(papp->mode==MODE_MENU)
	UIS_MakeContentFromString( "q0", &(plist[2].content.static_entry.text),goto_);
	UIS_MakeContentFromString( "q0", &(plist[num-2].content.static_entry.text),set_);
	UIS_MakeContentFromString( "s0", &(plist[num-1].content.static_entry.text),LANG_ABOUT);
	}
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status != RESULT_FAIL )
	{
		status = UIS_HandleEvent(papp->apt.dialog, ev_st);
	}

	free(plist);

	return status;
}

UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	//APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	EVENT_T					*event;
	UINT32					start, num;
	//if( !papp->apt.focused ) return RESULT_OK;
	event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;


	APP_ConsumeEv( ev_st, app );



     mSendListItems( ev_st, app, start, num );
  

    return RESULT_OK;
}
UINT32 mSelectItem( EVENT_STACK_T *ev_st,  void *app ) 
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
    UINT32 index = pos[pos_i];
	UINT32					start;
	if(papp->set)
	{	
			
		if(papp->setmode==MAIN_TYPE)
		{
		index+=SET_MAX;
		}else if(papp->setmode==MAIN_ATYPE)
		{
		index+=SET_MAX+1;
		}
		else if(papp->setmode==MAIN_SET_C)
		{
		//index+=MAIN_END-MAIN_MAX;
		papp->setmode=MAIN_END+index-1;
		start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
		return start;
		}
		index+=MAIN_MAX;
	}	
	else if(papp->mode!=MODE_MENU&&index>2)
	index++;
    switch (index) {
    case MAIN_OPEN:
	dbg("mSelectItem ENTER: MAIN_OPEN",NULL);
        start=APP_UtilChangeState(HE_STATE_FB, ev_st, app ); //
        break;

    case MAIN_MARK:
	dbg("mSelectItem ENTER: MAIN_MARK",NULL);
        start=APP_UtilChangeState(HE_STATE_MARK, ev_st, app );//ǩ
        break;
		
	case MAIN_GOTO:
	dbg("mSelectItem ENTER: MAIN_GOTO",NULL);

	   start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
       break;
	   
	case MAIN_SET:
	dbg("mSelectItem ENTER: MAIN_GOTO",NULL);
		papp->set=TRUE;
		start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	case MAIN_ABOUT:
	dbg("mSelectItem ENTER: MAIN_GOTO",NULL);

		start=APP_UtilChangeState(HE_STATE_ABOUT, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;  
	case MAIN_SET_Y:
	dbg("mSelectItem ENTER: MAIN_SET_Y",NULL);
		papp->setmode=MAIN_SET_Y;
		start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	
	case MAIN_SET_T:
	dbg("mSelectItem ENTER: MAIN_SET_T",NULL);
		papp->setmode=MAIN_SET_T;
		start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	case MAIN_SET_H:
	dbg("mSelectItem ENTER: MAIN_SET_T",NULL);
		papp->setmode=MAIN_SET_H;
		start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	case MAIN_SET_X:
	dbg("mSelectItem ENTER: MAIN_SET_X",NULL);
		papp->setmode=MAIN_SET_X;
		start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	   
	case MAIN_TYPE:
	dbg("mSelectItem ENTER: MAIN_TYPE",NULL);
		papp->setmode=MAIN_TYPE;
		papp->d_true=TRUE;
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	case MAIN_ATYPE:
	dbg("mSelectItem ENTER: MAIN_ATYPE",NULL);
		papp->setmode=MAIN_ATYPE;
		papp->d_true=TRUE;
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;  
	case  MAIN_TYPE_OFF:
	dbg("mSelectItem ENTER: MAIN_TYPE_OFF",NULL);
		papp->setmode=MAIN_TYPE_OFF;
		index=0;
		start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break; 
  	case  MAIN_MAP:
	dbg("mSelectItem ENTER: MAIN_TYPE_OFF",NULL);
		papp->setmode=MAIN_MAP;
		index=0;
		start=APP_UtilChangeState(HE_STATE_FB, ev_st, app ); //
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break; 
	 case  MAIN_BMAP:
	dbg("mSelectItem ENTER: MAIN_TYPE_OFF",NULL);
		papp->setmode=MAIN_BMAP;
		index=0;
		start=APP_UtilChangeState(HE_STATE_FB, ev_st, app ); //
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;    
	case MAIN_SET_C:
	dbg("mSelectItem ENTER: MAIN_SET_C",NULL);
		papp->setmode=MAIN_SET_C;
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	   
	case MAIN_SET_B:
	dbg("mSelectItem ENTER: MAIN_SET_C",NULL);
		papp->setmode=MAIN_SET_B;
		index=0;
		start=APP_UtilChangeState(HE_STATE_GOTO, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	   
  	case  MAIN_PIC:
	dbg("mSelectItem ENTER: MAIN_TYPE_OFF",NULL);
		papp->setmode=MAIN_PIC;
		index=0;
		start=APP_UtilChangeState(HE_STATE_FB, ev_st, app ); //
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break; 	   

	   
	/*case MAIN_TYPE_AUTO:
	dbg("mSelectItem ENTER: MAIN_TYPE_AUTO",NULL);
		papp->type=TYPE_AUTO;
		papp->setmode=0;
		if(papp->mode==MODE_MENU)
		papp->mode=MODE_EDIT;
		papp->d_true=TRUE;
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	  
	case MAIN_TYPE_GB:
	dbg("mSelectItem ENTER: MAIN_TYPE_GB",NULL);
		papp->type=TYPE_ANSI;
		papp->d_true=TRUE;
		//papp->setmode=0;
		//if(papp->mode==MODE_MENU)
		//papp->mode=MODE_EDIT;
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	case MAIN_TYPE_BIG:
	dbg("mSelectItem ENTER: MAIN_TYPE_BIG",NULL);
		papp->type=TYPE_BIG;
		papp->d_true=TRUE;
	 break;	
	 case MAIN_TYPE_BIG5:
	dbg("mSelectItem ENTER: MAIN_TYPE_BIG",NULL);
		papp->type=TYPE_BIG5;
		papp->d_true=TRUE;
	 break;	
	case MAIN_TYPE_XBIG5:
	dbg("mSelectItem ENTER: MAIN_TYPE_BIG",NULL);

		papp->type=TYPE_XBIG5;
		papp->d_true=TRUE;
		//papp->setmode=0;
		//if(papp->mode==MODE_MENU)
		//papp->mode=MODE_EDIT;
		//if(papp->mode==MODE_MENU)
		//papp->mode=MODE_EDIT;
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;  
	case  MAIN_TYPE_U:
	dbg("mSelectItem ENTER:  MAIN_TYPE_U",NULL);

		papp->type=TYPE_UCS;
		papp->d_true=TRUE;
		//papp->setmode=0;
		//if(papp->mode==MODE_MENU)
		//papp->mode=MODE_EDIT;
		//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
       //start=APP_UtilChangeState(HE_STATE_SET, ev_st, app );//
       break;
	case  MAIN_TYPE_UL:
	dbg("mSelectItem ENTER:  MAIN_TYPE_UL",NULL);
		papp->type=TYPE_UCL;
		papp->d_true=TRUE;
    break;
	
	case  MAIN_TYPE_UTF8:
	dbg("mSelectItem ENTER:  MAIN_TYPE_UTF8",NULL);
		papp->type=TYPE_UTF8;
		papp->d_true=TRUE;
	break;*/
	
	}
	if(index>SET_END&&index<=TYPE_END)
	{
	if(papp->setmode==MAIN_TYPE)
	{
	papp->type=index-SET_END;
	if(papp->mode==MODE_MENU)
	papp->mode=MODE_EDIT;
	}
	else //if(papp->setmode==MAIN_ATYPE)
	atype=index-SET_END;
	papp->d_true=TRUE;
	papp->setmode=0;
	//start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );

	saveset(app);
	}
	if(index>MAIN_SET_X)
	start=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
	if(papp->mode==MODE_EDIT)
	{
	papp->d_true=FALSE;
	start=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
	papp->set=FALSE;
	}
	

	
	return start;
}
UINT32 mback( EVENT_STACK_T *ev_st,  void *app ) 
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	UINT32                	    status;

	if(papp->mode==MODE_EDIT)
	{
	papp->setmode=0;
	papp->set=FALSE;
	papp->mode=MODE_NULL;
	status=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
	}
	else
	if(papp->set)
	{
	papp->d_true=TRUE;
	if(papp->setmode==MAIN_SET_C)
	papp->setmode=MAIN_SET;
	else if(papp->setmode==MAIN_TYPE||papp->setmode==MAIN_ATYPE)
	papp->setmode=MAIN_SET;
	else
	papp->set=FALSE;
	status=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
	}	
	else if(papp->mode==MODE_MENU)
	{

	papp->mode=MODE_NULL;
	status=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
	}
	else
	status=destroyApp(ev_st, app );
		
	return status;
}
   
UINT32	readmark( EVENT_STACK_T *ev_st,  void *app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	UINT8 i;
	WCHAR uri[FILEURI_MAX_LEN+1];
	papp->mark=(BM_LIST_T *) suAllocMem(sizeof(BM_LIST_T)*(MARKMAX), NULL);
	u_strcat(file_dir,L"setting/");
	u_strcpy(uri,file_dir);
	        if (!DL_FsDirExist(uri))
            DL_FsMkDir(uri,  0 );
	u_strcat(uri,L"edit.mark");	
	udbg("uri=%s",uri);
	if(DL_FsFFileExist(uri)) //ȡǩ
	{
	FILE_HANDLE_T f;
	size_t readen;
	f = DL_FsOpenFile(uri, FILE_READ_MODE, 0);
	for(i=0;i<MARKMAX;i++)
	{
	DL_FsReadFile( &papp->mark[i].sel, 1, 1, f, &readen );
	DL_FsReadFile( &papp->mark[i].offset, 4, 1, f, &readen );
	DL_FsReadFile( &papp->mark[i].tem_j, 4, 1, f, &readen );
	DL_FsReadFile( &papp->mark[i].uri, 200, 1, f, &readen );
	papp->mark[i].name = u_strrchr(papp->mark[i].uri,'/')+1;

	dbg("offset=%d",papp->mark[i].offset);
	dbg("tem_j=%d",papp->mark[i].tem_j);
	udbg("uri=%s",papp->mark[i].uri);
	}
	DL_FsCloseFile(f);
	}
	else
	{
	for(i=0;i<MARKMAX;i++)
	papp->mark[i].sel=FALSE;
	}
	
	return RESULT_OK;
}
UINT32	readset( EVENT_STACK_T *ev_st,  void *app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	WCHAR uri[FILEURI_MAX_LEN+1];
	FILE_HANDLE_T f;
	size_t readen;
	u_strcpy(uri,file_dir);
	u_strcat(uri,L"edit.set");
	if(DL_FsFFileExist(uri))
	{
	f = DL_FsOpenFile(uri, FILE_READ_MODE, 0);
	DL_FsReadFile( &SET_Y, 1, 1, f, &readen );
	DL_FsReadFile( &SET_T, 1, 2, f, &readen );
	DL_FsReadFile( &SET_C_I, 1, 6, f, &readen );
	DL_FsReadFile( &map_id, 1, 4, f, &readen );
	DL_FsReadFile( &map_uir, 1, 100, f, &readen );
	DL_FsReadFile( &papp->type, 1, 1, f, &readen );
	DL_FsReadFile( &pic_uir, 1, 100, f, &readen );
	DL_FsReadFile( &r_pic, 1, 1, f, &readen );
	DL_FsReadFile( &SET_H, 1, 1, f, &readen );
	DL_FsReadFile( &SET_X, 1, 1, f, &readen );
	DL_FsReadFile( &SET_B, 1, 1, f, &readen );
	DL_FsReadFile( &bmap_uir, 1, 100, f, &readen );
	DL_FsReadFile( &atype, 1, 1, f, &readen );
	DL_FsCloseFile(f);
	}
	else
	{
	SET_Y=16;
	SET_T=5000;
	SET_H=10;
	SET_X=4;
	SET_B=TRUE;
	SET_C_I[2]=0xff;
	SET_C_I[3]=0xff;
	SET_C_I[4]=0xff;
	SET_C_I[5]=0xff;
	map_id=0x10c3e800;
	papp->type=0;
	atype=1;
	}
	if(r_pic)
	readpic();


	return RESULT_OK;
}
UINT16 readmap(void)
{
	FILE_HANDLE_T f;
	size_t readen;
	if(DL_FsFFileExist(bmap_uir))
	{
	f = DL_FsOpenFile(bmap_uir, FILE_READ_MODE, 0);
	DL_FsReadFile( g2bTable, 1, 15228, f, &readen );
	DL_FsCloseFile(f);
	}
	return 0;
}
void readpic(void)
{
	FILE_HANDLE_T f;
	size_t readen;
	if(PIC)
	suFreeMem(PIC);
	PIC_SIZE =0;
	if(DL_FsFFileExist(pic_uir))
	{
	f = DL_FsOpenFile(pic_uir, FILE_READ_MODE, 0);
	PIC_SIZE = DL_FsGetFileSize(f);
    PIC = (UINT8*) suAllocMem(PIC_SIZE,NULL);
	DL_FsReadFile( PIC, PIC_SIZE, 1, f, &readen );
    DL_FsCloseFile(f);
	}else	
	r_pic=FALSE;
	//return RESULT_OK;
}
UINT32 mKeypress( EVENT_STACK_T *ev_st,  void *app )
{
	EVENT_T *		event = AFW_GetEv(ev_st);
	UINT32                	    status=RESULT_OK,KP=event->data.key_pressed;
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	APP_ConsumeEv(ev_st, app);

	if(papp->set)
	{
		if(papp->setmode==MAIN_SET_C)
		{
			switch(KP)
			{
			case KEY_4:
			SET_C_I[pos[pos_i]-1]-=1;
			break;
			
			case KEY_6:
			SET_C_I[pos[pos_i]-1]+=1;
			break;
			
			case KEY_1:
			SET_C_I[pos[pos_i]-1]-=10;
			break;
			
			case KEY_3:
			SET_C_I[pos[pos_i]-1]+=10;
			break;
			
			case KEY_5:
			status=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
			}
		saveset(app);
		APP_UtilAddEvUISListChange( ev_st, app, 0, pos[pos_i], 6, TRUE, 2, FBF_LEAVE, 0, NULL );
		}
			
	}
	if(KP==KEY_5&&papp->mode!=MODE_MENU)
	{
	papp->mode=MODE_P;
	status=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
	}
	return status;
}

UINT32	gotoread( EVENT_STACK_T *ev_st,  void *app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	UINT32                	    status=RESULT_OK;
	if(papp->READ)
	{
	papp->mode=MODE_NULL;
	status=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
	}
	return status;
	
}
UINT32 mHandleNavigate( EVENT_STACK_T * ev_st, void * app )
{
	//APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	EVENT_T *		event = AFW_GetEv(ev_st);
	
	pos[pos_i] = event->data.index;
	
	return RESULT_OK;
}
UINT32 MAKEContent( EVENT_STACK_T * ev_st, void * app,CONTENT_T * dst, UINT8 cont )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	switch (cont+MAIN_MAX) 
	{
	case MAIN_SET_Y:
	UIS_MakeContentFromString( "q0q1i2", dst,set_y,L" : ",SET_Y);
	break;
	
	case MAIN_SET_T:
	UIS_MakeContentFromString( "q0q1i2", dst,set_t,L" : ",SET_T);
	break;
	
	case MAIN_SET_H:
	UIS_MakeContentFromString( "q0q1i2", dst,set_h,L" : ",SET_H);
	break;
	
	case MAIN_SET_X:
	UIS_MakeContentFromString( "q0q1i2", dst,set_x,L" : ",SET_X);
	break;	
	
	case MAIN_ATYPE:
	UIS_MakeContentFromString( "q0q1q2q3", dst,lang_type[0],set_type,L" : ",lang_type[atype]);
	break;	
	
	case MAIN_TYPE:
	UIS_MakeContentFromString( "q0q1q2", dst,set_type,L" : ",lang_type[papp->type]);
	break;
	
	case MAIN_TYPE_OFF:
	UIS_MakeContentFromString( "q0q1g2", dst,set_type_o,L" : ",map_id);
	break;
	
	case MAIN_MAP:
	UIS_MakeContentFromString( "q0q1", dst,L"MAP : ",map_uir);
	break;
	
	case MAIN_BMAP:
	UIS_MakeContentFromString( "q0q1", dst,L"BIGMAP : ",bmap_uir);
	break;
	
	case MAIN_SET_C:
	UIS_MakeContentFromString( "q0", dst,set_c);
	break;
	
	case MAIN_SET_B:
	if(SET_B)
	UIS_MakeContentFromString( "q0q1", dst,set_b,L" : YES");
	else
	UIS_MakeContentFromString( "q0q1", dst,set_b,L" : NO");
	break;
	
	
	case MAIN_PIC:
	if(r_pic)
	UIS_MakeContentFromString( "q0q1q2", dst,set_back,L" : ",pic_uir);
	else
	UIS_MakeContentFromString( "q0q1q2", dst,set_back,L" : ",noname);
	break;
	

	}
	return RESULT_OK;
}






