#include "Graphics.h"
#include "app.h"

UINT32 DrawLine(INT16 x1, INT16 y1, INT16 x2, INT16 y2)
{
    GRAPHIC_POINT_T begin;
    GRAPHIC_POINT_T end;

    begin.x = x1;
    begin.y = y1;
    end.x = x2;
    end.y = y2;

    UIS_CanvasDrawLine(begin, end, dialog);

    return RESULT_OK;
}

UINT32 DrawRect(INT32 x, INT32 y, UINT32 w, UINT32 h) // 
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasDrawRect(region, 0, dialog);

    return RESULT_OK;
}


UINT32 FillRect(INT32 x, INT32 y, UINT32 w, UINT32 h) //  ?
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasFillRect(region, dialog);

    return RESULT_OK;
}


UINT32 SetFillColor(UINT8 r, UINT8 g, UINT8 b, UINT8 t) //ɫ
{
    COLOR_T                 color;

    color.red = r;
    color.green = g;
    color.blue = b;
    color.transparent = t;

    UIS_CanvasSetFillColor(color);

    return RESULT_OK;
}

UINT32 SetForegroundColor(UINT8 r, UINT8 g, UINT8 b, UINT8 t) // ǰɫ
{
    COLOR_T                 color;

    color.red = r;
    color.green = g;
    color.blue = b;
    color.transparent = t;

    UIS_CanvasSetForegroundColor(color);

    return RESULT_OK;
}


UINT32 DrawText(WCHAR *str, INT32 x, INT32 y, INT16 a_h, INT16 a_v)//д
{
    GRAPHIC_POINT_T anchor_point;
    COLOR_T                 color;

    color.transparent = 255;

    anchor_point.x = x;
    anchor_point.y = y;

    UIS_CanvasSetFont(1, dialog);

    UIS_CanvasSetBackgroundColor( color);

    UIS_CanvasDrawColorText (str,
							 0,
							 (UINT16)u_strlen(str),  	// ֳ
							
							anchor_point,              // coordinates of the points of attachment 
							 (UINT16)(a_v|a_h),	    // value of the points of attachment. For example: ANCHOR_LEFT | ANCHOR_TOP 
							 dialog
							 );
    return RESULT_OK;
}

UINT32 DrawImageId( INT16 x, INT16 y)
{
     PICTURE_TYPE_UNION_T picture_data;
    GRAPHIC_POINT_T anchor_point;

    CANVAS_IMAGE_HANDLE_T image_handle;
    GRAPHIC_POINT_T image_size;
    GRAPHIC_REGION_T image_region;


   // picture_data.PointerValue.resourcePicturePointerValue = PIC;
   // picture_data.PointerValue.imageSize = PIC_SIZE;
    picture_data.img.data = PIC;
    picture_data.img.size = PIC_SIZE;

    anchor_point.x = x;
    anchor_point.y = y;

    image_handle = UIS_CanvasOpenImageAndGetSize(STORED_IN_MEMORY_TYPE,
								  picture_data,
								  &image_size);	

    UIS_CanvasSetImageAttribute(image_handle,
                                //IA_OBEY_TRANSPARENCY,
                                IMAGE_OBEY_TRANSPARENCY,
							    NULL);

    UIS_CanvasRenderImageToBuffer(image_handle,
                                  image_size,
                                  anchor_point,
                                  (UINT16)(ANCHOR_LEFT|ANCHOR_TOP),
                                  &image_region,
                                  Copy,
                                  dialog);


    UIS_CanvasCloseImage(image_handle);

    return RESULT_OK;
}


