#include "app.h"
#include <res_def.h>
#include <synlib.h>


// -----------------------------------------------------------------------------------------
// Local typedefs

typedef struct
{
	WCHAR *			ext;
	const RESOURCE_ID *		res;
} EXT_DESCR_T;


// -----------------------------------------------------------------------------------------
// Local constants
const RESOURCE_ID		stat_resource[];
const RESOURCE_ID		stat_resource[] = {
	0x120002C2,
	RES_GIF_FILE_AUDIO,
	RES_GIF_FILE_IMAGE,
	RES_GIF_FILE_VIDEO,
	0x120001EF
};
#define FILE_TYPE_NULL stat_resource[0]

static const EXT_DESCR_T	ext_arr[] = {

	
	
	{ L"MID", &stat_resource[1] },
	{ L"MP3", &stat_resource[1] },
	{ L"WAV", &stat_resource[1] },
	{ L"WMA", &stat_resource[1] },
	{ L"ARM", &stat_resource[1] },
	
	{ L"GIF", &stat_resource[2] },
	{ L"JPG", &stat_resource[2] },
	{ L"BMP", &stat_resource[2] },
	{ L"PNG", &stat_resource[2] },
	
	{ L"3GP", &stat_resource[3] },
	{ L"MP4", &stat_resource[3] },
	
	{ L"TXT", &stat_resource[4] },

	{ NULL, 0 }
};



RESOURCE_ID GetIconByExt( WCHAR * ext1 )
{
	WCHAR		ext[16];
	size_t		len;
	const EXT_DESCR_T *	elist;

	if ( ext1 == NULL )
		return FILE_TYPE_NULL;
	len = u_strlen(ext1);
	if ( len > 15 )
		return FILE_TYPE_NULL;
	u_strcpy(ext, ext1);
	u_strmakeupper(ext);
	
	elist = &ext_arr[0];
	while ( elist->ext != NULL ) {
		if ( u_strcmp(ext, elist->ext) == 0 ) {
	
		return *(elist->res);


		}
		elist++;
	}
	return FILE_TYPE_NULL;
}


