#include "app.h"
UINT32 bSendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 bHandleListReq( EVENT_STACK_T *ev_st,  void *app );
UINT32 bback( EVENT_STACK_T *ev_st,  void *app );
UINT32 booksave( EVENT_STACK_T *ev_st,  void *app );
UINT32 bKeypress( EVENT_STACK_T *ev_st,  void *app );
UINT32 bookopen( EVENT_STACK_T *ev_st,  void *app );
UINT32 bookdel( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleNavigate( EVENT_STACK_T * ev_st, void * app );
UINT32 savefile( EVENT_STACK_T * ev_st, void * app);
const WCHAR noname[]={0x672A,0x4F7F,0x7528,0};
const EVENT_HANDLER_ENTRY_T mark_state_handlers[]  =
{


	{ EV_DIALOG_DONE,							bback			},
    { EV_REQUEST_LIST_ITEMS,					bHandleListReq	},
	{ EV_LIST_NAVIGATE,							HandleNavigate },
	{ EV_SELECT,								bookopen		},
    { EV_KEY_PRESS,								bKeypress		},
    { EV_DONE,									bback			},

    { STATE_HANDLERS_END,           		      	  NULL },
};
UINT32 bKeypress( EVENT_STACK_T *ev_st,  void *app )
{
	EVENT_T     *event = AFW_GetEv(ev_st);
	UINT32		KP=event->data.key_pressed, status=RESULT_OK;
	APP_ConsumeEv(ev_st, app);
	switch(KP)
	{
		case KEY_1:
		status=booksave( ev_st, app );
		
		break;
		case KEY_GREEN:
		status=booksave( ev_st, app );

		break;
		case 7:
		status=bookdel( ev_st, app );

		break;
	}
	return status;
}
UINT32 MarkStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
    SU_PORT_T               port = papp->apt.port;
	UINT32					starting_num;

	dbg("MainStateEnter:Enter",NULL);
	if(type!=ENTER_STATE_ENTER) return RESULT_OK;
    	dialog = UIS_CreateList( &port,
    							 0,
    							 MARKMAX,
    							 0,
    							 &starting_num,
    							 0,
    							 2,
    							 NULL,
    							 LANG_BOOKMARKS
								 );
		if(dialog == 0) return RESULT_FAIL;
    
        papp->apt.dialog = dialog;
		bSendListItems(ev_st, app, 1, starting_num);
		
    return RESULT_OK;
}
UINT32 bSendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
	APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
	LIST_ENTRY_T			*plist=NULL; 
	UINT32					i, index, status=RESULT_OK;
	INT32				err;

	dbg("mSendListItems:Enter",NULL);
	if( num==0 ) return RESULT_FAIL;
	plist = (LIST_ENTRY_T *) suAllocMem(sizeof(LIST_ENTRY_T)*num, &err);
		if ( err != RESULT_OK )
		return RESULT_FAIL;
	dbg("mSendListItems:plist",NULL);
	for( index=0, i=start;i<start+num; i++, index++) 
	{
	dbg("mSendListItems:i=%d,index=%d",i,index);
        plist[index].editable = FALSE;	
		plist[index].content.static_entry.can_mark = 1;	
		//papp->mark[i-1].sel=FALSE;	
		if(papp->mark[i-1].sel)
		UIS_MakeContentFromString( "p0q1", &(plist[index].content.static_entry.text),0x120001EF,papp->mark[i-1].name);
		else
		UIS_MakeContentFromString( "p0q1", &(plist[index].content.static_entry.text),0x120001EF,noname);
		
	}
	dbg("mSendListItems:APP_UtilAddEvUISListData",NULL);

	


	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T) * num,
									   plist );
	 dbg("mSendListItems:status",NULL);
	if( status != RESULT_FAIL )
	{
		status = UIS_HandleEvent(papp->apt.dialog, ev_st);
	}
	dbg("mSendListItems:Free",NULL);
	suFreeMem( plist );
	dbg("mSendListItems:end",NULL);
	return RESULT_OK;
}
UINT32 bHandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	EVENT_T *		event = AFW_GetEv(ev_st);
	UINT32			start, num, status;
	
	dbg("HandleListReq: Enter", 0);
	if ( !papp->apt.focused )
		return status;	
	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;
	APP_ConsumeEv( ev_st, app );
	
	status = bSendListItems(ev_st, app, start, num );
	dbg("HandleListReq: start = %d, num = %d", start, num);	
	dbg("HandleListReq: END, status = %d", status);
	return status;
}
UINT32 bback( EVENT_STACK_T *ev_st,  void *app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	UINT32                	    status=RESULT_OK;
	if(papp->mode==MODE_MARK||papp->mode==MODE_MENU)
	{
	papp->mode=MODE_NULL;
	status=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
	}
	else 
	{
	papp->d_true=TRUE;
	status=APP_UtilChangeState(HE_STATE_MAIN, ev_st, app );
	}	
	return status;
}
UINT32 booksave( EVENT_STACK_T *ev_st,  void *app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	UINT32                	    status=RESULT_OK;
	UINT32 index = papp->cur_pos-1;
	if(papp->mode==MODE_MENU||papp->mode==MODE_MARK||papp->mode==MODE_END)  //˵ģʽ 򱣴
	{
	//FILE_HANDLE_T f;
	//UINT8 i;
	//size_t w;
	u_strcpy(papp->mark[index].uri,papp->openfile);
	papp->mark[index].name = u_strrchr(papp->mark[index].uri,'/')+1;
	papp->mark[index].offset=papp->offset;
	dbg("tem_j=%d",papp->tem_j);
	dbg("tem_x=%d",papp->tem_x);
	if(papp->tem_j>papp->tem_x)
	papp->mark[index].tem_j=papp->tem_j-papp->tem_x;
	else papp->tem_j=0;

	papp->mark[index].sel=TRUE;
	//status=APP_UtilAddEvUISListChange( ev_st, app, 0, papp->cur_pos, MARKMAX, TRUE, 2, FBF_LEAVE, 0, NULL );
	status=savefile(ev_st, app);	
		/*f = DL_FsOpenFile( L"/c/1book.txt",FILE_WRITE_MODE,0);
		if (f == FILE_HANDLE_INVALID) 
		{
		DL_FsCloseFile(f);
		return status;
		}

		for(i=0;i<MARKMAX;i++)
		{
		DL_FsWriteFile( &papp->mark[i].sel,1, 1, f, &w);
		DL_FsWriteFile( &papp->mark[i].offset,4, 1, f, &w);
		DL_FsWriteFile( &papp->mark[i].tem_j,4, 1, f, &w);
		DL_FsWriteFile( &papp->mark[i].uri,200, 1, f, &w);
		}
		DL_FsCloseFile(f);*/
	}
	
    return status;
}
UINT32 bookopen( EVENT_STACK_T *ev_st,  void *app )
{	UINT32                	    status=RESULT_OK;
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;

	UINT32 index = papp->cur_pos-1;
	if(papp->mark[index].sel)
	{
	//cmd_file=FALSE;
	u_strcpy(papp->openfile,papp->mark[index].uri);
	u_strcpy(papp->filedir,papp->mark[index].uri);
	papp->offset=papp->mark[index].offset;
	papp->tem_j=papp->mark[index].tem_j;
	papp->mode=MODE_EDIT;
	status=APP_UtilChangeState(HE_STATE_READ, ev_st, app );
	}
	
    return status;
}
UINT32 bookdel( EVENT_STACK_T *ev_st,  void *app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	UINT32                	    status;
	UINT32 index = papp->cur_pos-1;
	papp->mark[index].sel=FALSE;
	//status=APP_UtilAddEvUISListChange( ev_st, app, 0, papp->cur_pos, MARKMAX, TRUE, 2, FBF_LEAVE, 0, NULL );	
	status=savefile(ev_st, app); 
    return status;
}

UINT32 HandleNavigate( EVENT_STACK_T * ev_st, void * app )
{
	APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
	EVENT_T *		event = AFW_GetEv(ev_st);
	
	papp->cur_pos = event->data.index;
	
	return RESULT_OK;
}
UINT32 savefile( EVENT_STACK_T * ev_st, void * app )
{
		APP_TXTEDIT_T			*papp = (APP_TXTEDIT_T*) app;
		FILE_HANDLE_T f;
		UINT8 i;
		UINT32 status=RESULT_OK;
		size_t w;
		WCHAR uri[FILEURI_MAX_LEN+1];
	u_strcpy(uri,file_dir);
	u_strcat(uri,L"edit.mark");
		f = DL_FsOpenFile( uri,FILE_WRITE_MODE,0);
		if (f == FILE_HANDLE_INVALID) 
		{
		DL_FsCloseFile(f);
		return RESULT_OK;
		}

		for(i=0;i<MARKMAX;i++)
		{
		DL_FsWriteFile( &papp->mark[i].sel,1, 1, f, &w);
		DL_FsWriteFile( &papp->mark[i].offset,4, 1, f, &w);
		DL_FsWriteFile( &papp->mark[i].tem_j,4, 1, f, &w);
		DL_FsWriteFile( &papp->mark[i].uri,200, 1, f, &w);
		dbg("sel=%d",papp->mark[i].sel);
		dbg("offset=%d",papp->mark[i].offset);
		dbg("tem_j=%d",papp->mark[i].tem_j);
		udbg("uri=%s",papp->mark[i].uri);
		}
		DL_FsCloseFile(f);
		if(papp->mode!=MODE_END)
		status=APP_UtilAddEvUISListChange( ev_st, app, 0, papp->cur_pos, MARKMAX, TRUE, 2, FBF_LEAVE, 0, NULL );	
		return status;
}
