#include "app.h"
#include <uis.h>
#include <res_def.h>
#include "../dbg/dbg.h"

#define BACK_STATE			HE_STATE_MAIN
#define APP_VERSION					0x01000000
const UINT32	app_version	=APP_VERSION | 0x00000001;


static const WCHAR		s_e314521[] = {'e','3','1','4','5','2','1',0};




static UINT32 ABHandleBack( EVENT_STACK_T * ev_st, void * app );




const EVENT_HANDLER_ENTRY_T about_state_handlers[] =
{
	{ EV_DONE,					ABHandleBack },

	{ STATE_HANDLERS_END,		NULL }
};



UINT32 AboutStateEnter( EVENT_STACK_T * ev_st, void * app, ENTER_STATE_TYPE_T type )
{
	APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
	SU_PORT_T		port = papp->apt.port;
	UIS_DIALOG_T	dialog;
	CONTENT_T		cnt;
	CONTENT_T		cnt_ver, cnt_author;
	UINT32			status;
	dbg("ViewerStateEnter: Enter, type = %d", type);
	if ( type != ENTER_STATE_ENTER )
		return RESULT_OK;
	
	// TODO: add your code here
	status = UIS_MakeContentFromString( "s0Si2q1i3q1i4q1i5", &cnt_ver, LANG_VERSION_, L".",
			((app_version >> 24) & 0xFF), // 2
			((app_version >> 16) & 0xFF),
			((app_version >>  8) & 0xFF),
			((app_version      ) & 0xFF)
		);
	if ( status == RESULT_OK )
		status = UIS_MakeContentFromString( "s0Sq1", &cnt_author, LANG_AUTHOR_, s_e314521 );
	
	if ( status == RESULT_OK )
		status = UIS_MakeContentFromString( "s0Nq1Nr2Nr3", &cnt, LANG_ABOUT, edit_name, &cnt_ver, &cnt_author );
	
	dbg("ViewerStateEnter: UIS_MakeContentFromString DONE, status = %d", status);
	
	if ( status != RESULT_OK )
		return status;
	
	dialog = UIS_CreateViewer( &port, &cnt, NULL );
	dbg("ViewerStateEnter: UIS_CreateViewer DONE, dialog = %d", dialog);
	
	if ( dialog == 0 )
		return RESULT_FAIL;
	papp->apt.dialog = dialog;
	
	dbg("ViewerStateEnter: END", 0);
	return RESULT_OK;
}



UINT32 ABHandleBack( EVENT_STACK_T * ev_st, void * app )
{
	APP_TXTEDIT_T           *papp = (APP_TXTEDIT_T*)app;
	UINT32			status;
	
	dbg("HandleBack: Enter", 0);
	APP_ConsumeEv(ev_st, app);
	
	// TODO: add your code here

	papp->d_true=TRUE;	
	status = APP_UtilChangeState( BACK_STATE, ev_st, app );
	dbg("HandleBack: END, status = %d", status);
	return status;
}


