#ifndef GRAPHICS_H
#define GRAPHICS_H
#include <canvas.h>
#include <synlib.h>
extern UIS_DIALOG_T dialog;

#define SetFont(x) UIS_CanvasSetFont( x, dialog)
#define SetFontStyle(x) UIS_CanvasSetFontStyle( x, dialog)

UINT32 DrawLine(INT16 x1, INT16 y1, INT16 x2, INT16 y2);
UINT32 DrawRect(INT32 x, INT32 y, UINT32 w, UINT32 h);
UINT32 FillRect(INT32 x, INT32 y, UINT32 w, UINT32 h);
UINT32 SetFillColor(UINT8 r, UINT8 g, UINT8 b, UINT8 t);
UINT32 SetForegroundColor(UINT8 r, UINT8 g, UINT8 b, UINT8 t);
UINT32 DrawText(WCHAR *str, INT32 x, INT32 y, INT16 a_h, INT16 a_v);
UINT32 DrawImageId( INT16 x, INT16 y);
enum  //type pictures ... picture_type 
{
    DRM_PICTURE_TYPE,
    IMAGE_PATH_TYPE,
    STORED_IN_MEMORY_TYPE,
    FILE_HANDLE_TYPE,
    IMAGE_PATH_WITH_OFFSET
};
enum  // drawOp
{
	AlphaBlend,
	Copy,
  NotUsed1,
	Invert,
	NotCopy,
  Resize,
	Xor,
  NotUsed2,
  Move
}; 
UINT32 UIS_CanvasRenderImageToBuffer(CANVAS_IMAGE_HANDLE_T image_handle,
                                     GRAPHIC_POINT_T image_size,
                                     GRAPHIC_POINT_T anchorpoint,
                                     UINT16 anchor_value,
                                     GRAPHIC_REGION_T * image_region,
                                     UINT8 drawOp,
                                     UIS_DIALOG_T handle);
#endif
