#ifndef _PP_PLAYER_H_
#define _PP_PLAYER_H_

#include <apps.h>
#include <canvas.h>
#include <uis.h>
#include <func.h>

#define DRMRES_FOLDER		0x120000CE
#define DRMRES_FILE_AUDIO	0x120000CD
#define DRMRES_SELECTED		0x120000CC
#define DRMRES_NEXT		    0x12000052
#define dbg PFprintf

extern UIS_DIALOG_T         dialog=0;

typedef struct
{ 
WCHAR name[128];
}FILEINFO;

typedef enum
{
    PLAYER_STATE_ANY,
    PLAYER_STATE_MAIN,
    
    PLAYER_STATE_MAX 
} PLAYER_STATES_T;

typedef struct
{ 
    APPLICATION_T           apt;
    FILEINFO * flist;

} APP_PLAYER_T;

typedef enum
{ 
    SHELL_STATE_ANY,

    SHELL_STATE_INIT,
    SHELL_STATE_MAIN,

    SHELL_STATE_MAX
} SHELL_STATES_T;

typedef struct
{ 
    APPLICATION_T           apt;

} APP_SHELL_T;


typedef enum
{
    DELETE=0,
    PLAY,
    PAUSE,
    STOP,
    REWIND
} STATES_PLAYER;


const WCHAR exit[3]={0x9000,   /**/0x51FA,   /**/0};
const WCHAR hide[3]={0x9690,   /**/0x85CF,   /**/0};
const WCHAR mode0[3]={0x5355,   /**/0x4E00,   /*һ*/0};
const WCHAR mode1[3]={0x91CD,   /**/0x590D,   /**/0};
const WCHAR mode2[3]={0x987A,   /*˳*/0x5E8F,   /**/0};
const WCHAR error1[9]={0x006C,0x0072,0x0063,	0x6587,   /**/	0x4EF6,   /**/	0x4E0D,   /**/	0x5B58,   /**/	0x5728,   /**/	0};
const WCHAR error2[8]={0x006C,0x0072,0x0063,	0x6587,   /**/	0x4EF6,   /**/	0x9519,   /**/	0x8BEF,   /**/	0};
const WCHAR error3[10]={0x006C,0x0072,0x0063,	0x5185,   /**/	0x5B58,   /**/	0x5206,   /**/	0x914D,   /**/	0x9519,   /**/	0x8BEF,   /**/	0};
const WCHAR error4[9]={0x006C, 0x0072, 0x0063, 0x6587, 0x4EF6, 0x88AB, 0x52A0, 0x5BC6, 0};//ļ
const WCHAR version[13]=L"pp_lrc  v1.6";



UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );
void id2uri( const char * s,WCHAR * target);
/******* PLAYER ******/
UINT32 player_startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 player_destroyApp( EVENT_STACK_T *ev_st,  void *app );
UINT32 player_MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 player_Keypress( EVENT_STACK_T *ev_st,  void *app );
UINT32 player_Keyrelease( EVENT_STACK_T *ev_st,  void *app );
UINT32 player_Timer( EVENT_STACK_T *ev_st,  void *app );
UINT32 Play( EVENT_STACK_T *ev_st,  void *app ); // ???
UINT32 Stop(void); // 
UINT32 Pause(void); // ?
UINT32 PlayComplete( EVENT_STACK_T *ev_st,  void *app ); //  ?
void Back(EVENT_STACK_T *ev_st,  void *app); // 
void Next(EVENT_STACK_T *ev_st,  void *app); // ?
UINT32 Create(EVENT_STACK_T *ev_st,  void *app); // 
UINT32 Delete(void); // 
UINT32 Seek(INT32 seektime);
UINT32 SeekPlay(EVENT_STACK_T *ev_st,  void *app); // ??seek
UINT32 search(EVENT_STACK_T *ev_st,  void *app);

/******* SHELL ******/
UINT32 shell_startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 );
UINT32 shell_destroyApp( EVENT_STACK_T *ev_st,  void *app );
UINT32 shell_HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );
UINT32 shell_MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 shell_Keypress( EVENT_STACK_T *ev_st,  void *app );

void draw_time(void);
void draw_pos(void);
void draw_bar(void);
void draw_bar_all(void);
void draw_vol(void);
void draw_circle_s(void);
void draw_num(void);
void draw_name(void);
UINT32 get_focus(EVENT_STACK_T *ev_st,  void *app);
void backg(void);



UINT32 sec2min(UINT32 seconds, WCHAR *str);
UINT32 ShowState(UINT8 state);
// #ifdef DESKTOP
void ShowStr(WCHAR * string, UINT8 status);
void ShowName(void);
void ShowTime(void);
void ShowVolume(UINT8 volume);
// #endif

//void drawcir(UINT16 x,UINT16 y,UINT16 r,int n,UINT16 b,UINT16 f);
void get_rain_f(UINT16 i);
//void drawico(UINT16 x,UINT16 y,UINT8 id);


GRAPHIC_METRIC_T getfontsize(WCHAR *str,	UINT8 font_id);
void draw_lrc(void);
void draw_lrc_info(void);
void GetLRCFile(void);

#endif //_PP_PLAYER_H_