#include "pp_player.h"
#include "graphics.h"
#include "lrc.h"


UINT32 evcode_base;
DRAWING_BUFFER_T		screenbuf; //ʾ
GRAPHIC_POINT_T     display_size;//Ļʾߴ

#ifdef DESKTOP
WCHAR Operator[10];
#endif
WCHAR filename[256];//ŵĸ
WCHAR cur_dir[256];
UINT16 cur=0;//ǰ
UINT16 count=0;//
MME_GC_MEDIA_FILE   *mme_media_file = NULL;
SU_PORT_T           port;

CLK_TIME_T time_n; // ǰϵͳʱ
CLK_TIME_T time_m; // ǰʾʱ

LRC_INFO_T    *lrc = NULL;
UINT16         pos_lrc=0; //ǰʾڼ
UINT8          iRet = 100;
BOOL           lrc_flag=TRUE; // ǷҪ

INT32 timeStarPress=0;
UINT8 timeWait = 3;
INT32 timePosition=0; //ʱ
UINT32 timeDuraction=0; //ʱ
UINT32 timeRew=1; //
INT8 Z = 1; //

UINT8 State_Player = 0;//״̬

BOOL LongPress = FALSE;
//BOOL StarPress = FALSE;
BOOL allowPlay = FALSE;
BOOL isCanvas = FALSE;
UINT8 bar_id=0;
UINT8 circle_s=2;//0-- 1--ѭ 2--ȫ



const char player_app_name[APP_NAME_LEN] = "PP_Player";
const char shell_app_name[APP_NAME_LEN] = "PP_s_Player";


const EVENT_HANDLER_ENTRY_T player_any_state_handlers[] =
{  
	{ EV_KEY_PRESS,                player_Keypress },
	{ EV_KEY_RELEASE,            player_Keyrelease },
	{ EV_TIMER_EXPIRED,       	      player_Timer },
	{ STATE_HANDLERS_END,           		  NULL },
};
const EVENT_HANDLER_ENTRY_T player_main_state_handlers[] =
{
	{ EV_MME_OPEN_SUCCESS,				  Play },
	{ EV_MME_PLAY_COMPLETE,		  PlayComplete },
	{ EV_MME_SEEK_SUCCESS,			  SeekPlay },
	{ STATE_HANDLERS_END,           	  NULL },
};


const EVENT_HANDLER_ENTRY_T shell_any_state_handlers[] =
{  
    { EV_REVOKE_TOKEN,            APP_HandleUITokenRevoked },
    { STATE_HANDLERS_END,          					  NULL },
};
const EVENT_HANDLER_ENTRY_T shell_init_state_handlers[] =
{
    { EV_GRANT_TOKEN,           shell_HandleUITokenGranted },
    { STATE_HANDLERS_END,         		  			  NULL },
};
const EVENT_HANDLER_ENTRY_T shell_main_state_handlers[] =
{
	{ 0x7ED,                                     get_focus },   // 0x7ED Ӻأȡ
	{ EV_GAIN_FOCUS,                             get_focus },   // ȡ
	{ EV_LOSE_FOCUS,                      shell_destroyApp },   // ʧȥ
	{ EV_MME_PLAY_COMPLETE,		          shell_destroyApp },
//	{ EV_DIALOG_DONE,                     shell_destroyApp },
//	{ EV_DONE,                            shell_destroyApp },
	{ EV_INK_KEY_PRESS,                   shell_Keypress   },
	{ STATE_HANDLERS_END,           		      	  NULL },
};



static const STATE_HANDLERS_ENTRY_T player_state_handling_table[] =
{
    { PLAYER_STATE_ANY,
      NULL,
      NULL,
      player_any_state_handlers
    },

    { PLAYER_STATE_MAIN,
      player_MainStateEnter,
      NULL,
      player_main_state_handlers
    }

};
const STATE_HANDLERS_ENTRY_T shell_state_handling_table[] =
{
    { SHELL_STATE_ANY,
      NULL, 
      NULL, 
      shell_any_state_handlers
    },

    { SHELL_STATE_INIT,
      NULL,
      NULL,
      shell_init_state_handlers
    },
    
    { SHELL_STATE_MAIN,
      shell_MainStateEnter,
      NULL,
      shell_main_state_handlers
    }
};

/* This entry for all elves, must be declared the case */
/* File_uri - the path to the elf (similar argv [0]) */
/* Param - parameters elf (same as the rest argv) */
/* Reserve - dedicated base eventcode-s (reserved 64 A) */
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    evcode_base = reserve;     //Keeping reserve 
    
    
    if(param!=NULL)
    	id2uri(param,filename);
    else
    	return 0;
    	
//#ifdef DEBUG
//    u_PFprintf("filename=%s\n",filename);
//#endif

    //shell_canvas_state_handlers[0].code = *EV_DisplayTimeout;
	//// Dozapolnem our table instances where there is STATE_HANDLERS_RESERVED 
    //LdrInitEventHandlersTbl( shell_playlists_state_handlers, &evcode_base );
    //LdrInitEventHandlersTbl( shell_fbrowser_state_handlers, &evcode_base );

	// Registriruem annex Shell 
    status = APP_Register( &evcode_base,                 // At what event should run annex 
                           1,                            // Number of events, which should run annex 
                           shell_state_handling_table,   // Table states 
                           SHELL_STATE_MAX,              // Number of states 
                           (void*)shell_startApp );      // function caused at startup 

     evcode_base++;

#ifdef DEBUG
    PFprintf("******Register******  evcode_base for shell : 0x%X\n", evcode_base-1);
#endif

	// Registriruem annex Play 
    status = APP_Register( &evcode_base,
                           1, 
                           player_state_handling_table,
                           PLAYER_STATE_MAX,
                           (void*)player_startApp );

#ifdef DEBUG
    PFprintf("******Register******  evcode_base for play : 0x%X\n", evcode_base);
#endif

    LdrStartApp(evcode_base-1);   // Run immediately Shell 
    LdrStartApp(evcode_base);    // Run immediately Play 
    

    return 1;
}
void id2uri( const char * s,WCHAR * target)
{
	char	b;
	UINT32	res[2];
	int count=8;
	
	while ( count > 0 )
	{
		b= *s++;
		if ( b >= '0' && b <= '9')
		{
			b -= '0';
		}
		else if ( b >= 'A' && b <= 'F' )
		{
			b = b - 'A' + 10;
		}
		else if ( b >= 'a' && b <= 'f' )
		{
			b = b - 'a' + 10;
		}
		else
			b = 0;
			
		res[0] = res[0] << 4;
		res[0] |= b;
		count--;
	}
	
	count=8;
	
		while ( count > 0 )
	{
		b= *s++;
		if ( b >= '0' && b <= '9')
		{
			b -= '0';
		}
		else if ( b >= 'A' && b <= 'F' )
		{
			b = b - 'A' + 10;
		}
		else if ( b >= 'a' && b <= 'f' )
		{
			b = b - 'a' + 10;
		}
		else
			b = 0;
			
		res[1] = res[1] << 4;
		res[1] |= b;
		count--;
	}
	DL_FsGetURIFromID((UINT64*)&res,filename);

}



UINT32 player_startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_PLAYER_T     *app = NULL;
    UINT32 status = RESULT_OK;

    app = (APP_PLAYER_T*)APP_InitAppData( (void *)APP_HandleEventPrepost,
                                                  sizeof(APP_PLAYER_T),
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                              2, 0, 0 );
		status = APP_Start( ev_st,
                            &app->apt,
                            PLAYER_STATE_MAIN,
                            player_state_handling_table,
                            player_destroyApp,
                            player_app_name,
                            0 );
    return RESULT_OK;
}
UINT32 player_destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
	APP_PLAYER_T * papp=(APP_PLAYER_T*)app;
    UINT32  status;

	if(isCanvas)
		AFW_CreateInternalQueuedEvAux (EV_MME_PLAY_COMPLETE,0x64,0,0);

    APP_UtilStopTimer( app );

#ifdef DEBUG
	PFprintf( "**********player_destroyApp*********** APP_UtilStopTimer( app )\n");
#endif

	if (mme_media_file != 0)
		Delete();
		
#ifdef DEBUG
	PFprintf( "**********player_destroyApp*********** free(papp->flist)\n");
#endif

	if (papp->flist != NULL)
		free(papp->flist);

//	if (lrc != NULL)
		DESTROY_LRC(&lrc);

#ifdef DESKTOP
	ShowStr(Operator, Network_STATUS);
	ShowStr(NULL, GPRS_STATUS);
#endif
	
	DL_AudPlayTone( 0,  1 );
	status = APP_Exit( ev_st, app, NULL );
	
	LdrUnloadELF(&Lib);
		
    return status;
}
UINT32 player_MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
#ifdef DESKTOP
	STATUS value;
	UIS_GetCurrentStatusValue(Network_STATUS,  &value);	
	u_strcpy(Operator, value.quoted_string);
#endif
	port=((APPLICATION_T*)(app))->port;
	
	
	search(ev_st,app);
	Create(ev_st,app);

    return RESULT_OK;
}
UINT32 player_Keypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
    
	UINT8 volume=0;
	UINT8 Volume_id=4;

	if (KeypadLock())
		return RESULT_OK;
		
	if (isCanvas || WorkingTable())
	{
		switch (event->data.key_pressed)
		{
		case 14://left soft
			if (WorkingTable())
				break;
		case KEY_RED:
			player_destroyApp(ev_st,app);
			break;
		
		case 11:
			if (WorkingTable())
				break;
		 	circle_s++;
		 	circle_s=circle_s%3;
		 	draw_circle_s();
		 	break;
		 	
		case 10://*
//			StarPress = FALSE;
			if (isCanvas)
				break;
			timeStarPress = timePosition;
//			APP_UtilStopTimer( app );
//			APP_UtilStartTimer( 1000,  11,  app );
			break;
		 	
		case 6:
			if (WorkingTable())
				break;
		case KEY_RIGHT://right
			APP_UtilStopTimer( app );
			APP_UtilStartTimer( 1000,  2,  app );
			timeRew = 1;
			Z = 1;
			APP_ConsumeEv( ev_st, app );
			break;
		
		case 4:
			if (WorkingTable())
				break;
		case KEY_LEFT://lift
			APP_UtilStopTimer( app );
			APP_UtilStartTimer( 1000,  2,  app );
			timeRew = 1;
			Z = -1;
			APP_ConsumeEv( ev_st, app );
			break;
		
		case 2:
			if (WorkingTable())
				break;
		case 44://up
	        if (!APP_MMC_Util_IsVoiceCall())
			{
	            APP_UtilStopTimer( app );
	    
	            switch (State_Player)
				{
				case PLAY :
					allowPlay = FALSE;
					Pause();
				break;
	    
				case STOP:
				case PAUSE:
					allowPlay = TRUE;
					Play(ev_st, app);
				break;
				        
				case DELETE:
					Create(ev_st,app);
				break;
				}
				APP_ConsumeEv( ev_st, app );	
			}
			break;
			
		case 8:
			if (WorkingTable())
				break;
		case KEY_DOWN:
			if (isCanvas)
			{
		        APP_UtilStopTimer( app );
		        allowPlay = FALSE;
		        Stop();
		        
				APP_ConsumeEv( ev_st, app );
			}
			else if(WorkingTable())
			{
				LdrStartApp(evcode_base-1);
				APP_ConsumeEv( ev_st, app );
			}
			break;
		
		case 1:
			if (WorkingTable())
				break;
		case KEY_VOLUP:
			if (namecmp((char*)LdrGetPlatformName(), "LTE"))
				Volume_id=2;
			DL_AudGetVolumeSetting(Volume_id, &volume);
               
			if (volume < 7 ) volume++;
			DL_AudSetVolumeSetting(Volume_id, volume);

#ifdef DESKTOP
			ShowVolume(volume);
			timeWait = 0;
#endif

			draw_vol();
			APP_ConsumeEv( ev_st, app );
			break; 
			
		case 7:
			if (WorkingTable())
				break;
		case KEY_VOLDOWN:
			if (namecmp((char*)LdrGetPlatformName(), "LTE"))
				Volume_id=2;
			DL_AudGetVolumeSetting(Volume_id, &volume);

			if (volume > 0) volume--;
			DL_AudSetVolumeSetting(Volume_id, volume);

#ifdef DESKTOP
			ShowVolume(volume);
			timeWait = 0;
#endif

 			draw_vol();
			APP_ConsumeEv( ev_st, app );
			break; 
		}
	}
	else
	{
		switch (event->data.key_pressed)
		{
			case KEY_SMART:
				APP_UtilStopTimer( app );
				switch (State_Player)
				{
				case PLAY :
					allowPlay = FALSE;
					Pause();
					break;

				case STOP:
				case PAUSE:
					allowPlay = TRUE;
//					lrc_flag  = TRUE;
					Play(ev_st, app);
					break;

				case DELETE:
					Create(ev_st,app);
					break;
				}
				APP_ConsumeEv( ev_st, app );
			break;

			case KEY_VOLUP:
				APP_UtilStopTimer( app );
				APP_UtilStartTimer( 1000,  4,  app );
			break; 
			
			case KEY_VOLDOWN:
				APP_UtilStopTimer( app );
				APP_UtilStartTimer( 1000,  5,  app );
			break; 
			
			case 10://*
				timeStarPress = timePosition;
//				StarPress = FALSE;
//				APP_UtilStopTimer( app );
//				APP_UtilStartTimer( 1000,  11,  app );
//				LdrStartApp(evcode_base-1);
			break;

//			case KEY_RED:
//				player_destroyApp(ev_st,app);
//			break;
		}
	}
    

    return RESULT_OK;
}
UINT32 player_Keyrelease( EVENT_STACK_T *ev_st,  void *app )
{
	EVENT_T     *event = AFW_GetEv(ev_st);
	//UINT8 volume=0;
    //UINT8 Volume_id=4;
	
	if (isCanvas || WorkingTable())
	{
		switch (event->data.key_pressed)
		{
			case 6:
				if (WorkingTable())
					break;
			case KEY_RIGHT :
				APP_UtilStopTimer( app );
					
					if (!LongPress)
					{
						Next(ev_st,app);
					}
					else
					{
						State_Player = PLAY;
						Seek(timePosition*1000);
					}
					
					LongPress = FALSE;
						
					//APP_ConsumeEv( ev_st, app );
			break;
			
			case 4:
				if (WorkingTable())
					break;
			case KEY_LEFT :
				APP_UtilStopTimer( app );
					
					if (!LongPress)
					{
						Back(ev_st,app);
					}
					else
					{
						State_Player = PLAY;
						Seek(timePosition*1000);
					}
					
					LongPress = FALSE;

						
					//APP_ConsumeEv( ev_st, app );
			break;
			
			
			case 10://*
				if (isCanvas)
					break;
				if (timePosition - timeStarPress > 1)
					LdrStartApp(evcode_base-1);
//				StarPress = !StarPress;
				
//#ifdef DEBUG
//    PFprintf("******KeyRelease******  LongPress = %d\n", LongPress);
//#endif

				break;
		}
	}
	else
	{
		switch (event->data.key_pressed)
		{
			case 10://*
				if (timePosition - timeStarPress > 1)
					LdrStartApp(evcode_base-1);
//				StarPress = !StarPress;
				
//#ifdef DEBUG
//    PFprintf("******KeyRelease******  LongPress = %d\n", LongPress);
//#endif

				break;
		}
	}

	return RESULT_OK;
}
UINT32 player_Timer( EVENT_STACK_T *ev_st,  void *app )
{
	switch (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID) 
	{
//		case 11:
//			if (!StarPress)
//				LdrStartApp(evcode_base-1);
//			StarPress = !StarPress;
//#ifdef DEBUG
//    PFprintf("******GetLRC****** lrc timer = 11\n");
//    PFprintf("******GetLRC****** lrc LongPress = %d\n", LongPress);
//#endif
//
//			break;

		case 2: ///
			APP_UtilStopTimer( app );
			LongPress = TRUE;
			Pause();
			State_Player = REWIND;
			MME_GC_playback_get_attribute(mme_media_file, POSITION, &timePosition);
			
			APP_UtilStartCyclicalTimer( 100,  6,  app );
			APP_ConsumeEv(ev_st, app );
		break;
		
		case 4: // +++
			APP_UtilStopTimer( app );
			LongPress = TRUE;
			Next(ev_st,app);
			APP_ConsumeEv(ev_st, app );
		break;
		
		case 5: // ---
			APP_UtilStopTimer( app );
			LongPress = TRUE;
			Back(ev_st,app);
			APP_ConsumeEv(ev_st, app );
		break;
		
		case 6:
			if (timePosition%10 == 0)
				timeRew++;
			timePosition += Z*timeRew;
            if (timePosition > (INT32)timeDuraction)
            	timePosition = timeDuraction;
            else if(timePosition < 0)
            	timePosition = 0;
            	
			draw_pos();
			draw_bar();
#ifdef DESKTOP
            if ((timePosition%5 == 0)) ShowTime();
#endif
			APP_ConsumeEv(ev_st, app );
        break;

		case 0:
    		//dbg("draw \n");
//    		MME_GC_playback_get_attribute(mme_media_file, POSITION, &timePosition);

#ifdef DEBUG
    PFprintf("******timer****** lrc timer = 0\n");
//    PFprintf("******timer****** lrc LongPress = %d\n", LongPress);
    PFprintf("******timer****** lrc State_Player = %d\n", State_Player);
#endif

			if (State_Player == PAUSE)
			{
				State_Player = PLAY;
				ShowState(State_Player);
			}
    		timePosition++;
#ifdef DESKTOP
    		ShowName();
    		if (timeWait > 2)
    			ShowTime();
    		else
    			timeWait++;
#endif
			time_n.second++;
			if (time_n.second > 59)
			{
				time_n.second -= 60;
				time_n.minute++;
			}
			if (time_n.minute > 59)
			{
				time_n.minute -= 60;
				time_n.hour++;
			}
			if (time_n.hour > 23)
				time_n.hour -= 24;
			
			if (time_n.minute != time_m.minute && isCanvas)
				draw_time();
    		
    		if(isCanvas)
    		{
    			draw_pos();
    			draw_bar();
				p_key(5);    //ͨģⰴ5~~
    			if (lrc_flag && iRet==0)
    			{
	    			draw_lrc();
	    		}
    		}
    	break;
	}

	return RESULT_OK;
}
UINT32 Create(EVENT_STACK_T *ev_st,  void *app)
{
	IFACE_DATA_T    if_data;
	
	//dbg("creat \n");

    if (DL_FsFFileExist(filename))
    {
        if (mme_media_file == 0) 
        {
        	if_data.port=port;
            mme_media_file = MME_GC_playback_create(&if_data,filename, 0, 0, 0, 0, 0, 0);
        }
        
        if (mme_media_file != 0)
        {
        	//dbg("!=0\n");
            allowPlay = TRUE;
            lrc_flag = TRUE;
            State_Player = STOP;
            timePosition = 0;
        }
        else
        {
#ifdef DEBUG
    PFprintf("******Create****** lrc Create mme_media_file=0\n");
#endif
        	return player_destroyApp(ev_st,app);
        }
		GetLRCFile();
#ifdef DEBUG
    PFprintf("******Create****** GetLRCFile()    ok\n");
    PFprintf("******Create****** lrc iRet = %d\n",iRet);
#endif

    }
    else
    {
        Next(ev_st,app);
    }
    
	return RESULT_OK;
}
UINT32 Delete()
{
	UINT32 Error=1;
	
	//dbg("del\n");

	if (mme_media_file != 0) 
	{
		Error = MME_GC_playback_delete(mme_media_file);
		mme_media_file = (MME_GC_MEDIA_FILE *) NULL;
	}
	
	if (Error == 0)
	{
		State_Player = DELETE;
		ShowState(State_Player);
    }

#ifdef DEBUG
    PFprintf("******Delete******  Delete--No Destroy..\n");
#endif

	DESTROY_LRC(&lrc);

#ifdef DEBUG
    PFprintf("******Delete******  Delete--Destroy   ok!\n");
#endif

	return Error;
}
UINT32 Play( EVENT_STACK_T *ev_st,  void *app )
{
	UINT32 Error=1;
	
	APP_UtilStopTimer( app );

#ifdef DEBUG
    PFprintf("******Play******  mme_media_file = %X\n", mme_media_file);
    PFprintf("******Play******  allowPlay = %d\n", allowPlay);
#endif

	if (mme_media_file != 0 && allowPlay == TRUE) 
		Error = MME_GC_playback_start(mme_media_file, 0, 0);
	
#ifdef DEBUG
    PFprintf("******Play******  Error = MME_GC_playback_start(mme_media_file, 0, 0) = %d\n",Error);
#endif

	if (Error == 0)
	{
		State_Player = PLAY;
		ShowState(State_Player);
#ifdef DESKTOP
		ShowName();
		ShowTime();
#endif
		MME_GC_playback_get_attribute(mme_media_file, DURATION, &timeDuraction);
		MME_GC_playback_get_attribute(mme_media_file, POSITION, &timePosition);
		
#ifdef DEBUG
    PFprintf("******Play******  timeDuraction = %d\n",timeDuraction);
    PFprintf("******Play******  timePosition = %d\n",timePosition);
#endif
	
//		timePosition++;    //+1?? patch the offset
		DL_ClkGetTime(&time_n);
		draw_time();
		draw_pos();
		draw_bar_all();
		draw_bar();
		draw_vol();
		draw_num();
		draw_name();
		if(timePosition == 0 || iRet != 0)
			draw_lrc_info();
		else
			draw_lrc();
//		if (iRet==0)
//		{
//			lrc.tlrc[lrc.num_t].time  = timeDuraction*1000;
//			lrc.tlrc[lrc.num_t].index = 0;
//			draw_lrc();
//		}
//		else if(iRet!=0 && lrc_flag)
//		{
//			draw_lrc_info();
//			lrc_flag = FALSE;
//		}
		APP_UtilStartCyclicalTimer( 1000,  0,  app );
	}
	//dbg("play \n");

	return Error;
}
UINT32 Stop()
{
	UINT32 Error=1;
	//dbg("stop \n");

#ifdef DEBUG
    PFprintf("******Stop****** \n");
#endif
	if (mme_media_file != 0) 
		Error = MME_GC_playback_stop(mme_media_file);

	if (Error == 0)
	{
		State_Player = STOP;
		ShowState(State_Player);
		timePosition = 0;
		draw_pos();
		draw_bar_all();
		draw_lrc_info();
//		draw_lrc_all();
//		draw_bar();
	}
	
	return Error;
}
UINT32 Pause()
{
	UINT32 Error=1;
	
	//dbg("pause \n");
#ifdef DEBUG
    PFprintf("******Pause****** \n");
#endif

	if (mme_media_file != 0) 
		Error = MME_GC_playback_pause(mme_media_file);
	
	if (Error == 0)
	{
        State_Player = PAUSE;
        ShowState(State_Player);
    }


	return Error;
}
UINT32 PlayComplete(EVENT_STACK_T *ev_st,  void *app)
{
    MME_PLAY_COMPLETE_T *attach = AFW_GetEv(ev_st )->attachment;

#ifdef DEBUG
    PFprintf("******PlayComplete****** \n");
#endif
    if ( mme_media_file == attach->media_handle)
    {

#ifdef L7e
        if (attach->status == 127)
#else
        if (attach->status == 1)
#endif
		{
			if(circle_s==0)//
			{
				Delete();
#ifdef DEBUG
    PFprintf("******PlayComplete******  Only Play One\n");
#endif
			    return player_destroyApp(ev_st,app);
			}
			else if(circle_s==1)//ѭ
			{
				Delete();
				Create(ev_st,app);
			}
			else//ȫѭ
			{
				 Next(ev_st,app);
			}
		}
		else
		{
			APP_UtilStopTimer( app );
			if (APP_MMC_Util_IsVoiceCall())
			{
#ifdef DEBUG
    PFprintf("******PlayComplete******  Calling...\n");
#endif
				State_Player = PAUSE;
#ifdef DEBUG
    PFprintf("******PlayComplete******  State_Player = %d...\n", State_Player);
#endif
				ShowState(State_Player);
			}
#ifdef DEBUG
    PFprintf("******PlayComplete******  timePosition = %d\n", timePosition);
#endif
			Seek(timePosition*1000);
		}
	}
	
	return RESULT_OK;
}
UINT32 Seek (INT32 seektime)
{
	UINT32 Error=1;
	Error = MME_GC_playback_seek(mme_media_file, seektime);
#ifdef DEBUG
    PFprintf("******Seek******  Error = %d\n", Error);
#endif
	return Error;
}
UINT32 SeekPlay(EVENT_STACK_T *ev_st,  void *app)
{
	UINT32 Error=1;
	
	APP_UtilStopTimer( app );

#ifdef DEBUG
    PFprintf("******SeekPlay******  APP_UtilStopTimer\n");
#endif

//	if (mme_media_file != 0 && State_Player == PLAY) 
	if (mme_media_file != 0 && ((State_Player == PLAY)||(State_Player == PAUSE)))
		Error = MME_GC_playback_start(mme_media_file, 0, 0);
	
//	draw_bar_all();
//#ifdef DEBUG
//    PFprintf("******SeekPlay******  SeekPlay\n");
//#endif

	if (Error == 0)
	{
		APP_UtilStartCyclicalTimer( 1000,  0,  app );

#ifdef DEBUG
    PFprintf("******SeekPlay******  APP_UtilStartCyclicalTimer( 1000,  0,  app )\n");
#endif

		ShowState(State_Player);
#ifdef DESKTOP
		ShowName();
#endif
	}
	
	return Error;
}
void Next(EVENT_STACK_T *ev_st,  void *app)
{
	APP_PLAYER_T *	papp = (APP_PLAYER_T *)(app);
	//dbg("next \n");
	Delete();
	APP_UtilStopTimer(app);

	if(count>1)
	{
	   cur++;
	   cur=cur%count;
	   u_strcpy(SplitPath(filename,L"/"),papp->flist[cur].name);
	   ////u_PFprintf("filename=%s",filename);
	}
	
	Create(ev_st,app);
}
void Back(EVENT_STACK_T *ev_st,  void *app)
{
	APP_PLAYER_T *	papp = (APP_PLAYER_T *)(app);
	//dbg("back \n");
	Delete();
	APP_UtilStopTimer(app);
	if(count>1)
	{
		if(cur==0)
			cur=count-1;
		else
		{
			cur--;
			cur=cur%count;
		}
	
		u_strcpy(SplitPath(filename,L"/"),papp->flist[cur].name);
		////u_PFprintf("filename=%s",filename);
	}
	Create(ev_st,app);
}

UINT32 search(EVENT_STACK_T *ev_st,  void *app)
{

	APP_PLAYER_T *	papp = (APP_PLAYER_T *)(app);
	FS_SEARCH_PARAMS_T		fs_sp;
	FS_SEARCH_RESULT_T		fs_sres;
	FS_SEARCH_HANDLE_T		fs_shandle;
	WCHAR *		name;
	UINT16		fc,cres;
	WCHAR ext[10];
	UINT32 status;
	int i,j;
	//FILEINFO *	fcur = NULL;
 
#ifdef DEBUG
    PFprintf("*********search***********\n");
#endif

  u_strcpy(cur_dir,L"file:/");
	memcpy(&cur_dir[6],filename,(SplitPath(filename,L"/")-filename)*sizeof(WCHAR));
	////PFprintf("u_strlen(cur_dir)111111=%d\n",u_strlen(cur_dir));
//	*(cur_dir+u_strlen(cur_dir))=0xfffe;
	////PFprintf("u_strlen(cur_dir)222222=%d\n",u_strlen(cur_dir));
	////PFprintf("(cur_dir)=%d\n",*(cur_dir+u_strlen(cur_dir)));
//	u_strcpy(cur_dir+u_strlen(cur_dir), L"*.m4a");
	////u_PFprintf("cur_dir=%s\n",cur_dir);
//	*(cur_dir+u_strlen(cur_dir))=0xfffe;
//	u_strcpy(cur_dir+u_strlen(cur_dir), L"*.mp3");
	u_strcat(cur_dir, L"\xFFFE*.mp3\xFFFE*.m4a");

	
	fs_sp.flags = 0x1C; // or
//	fs_sp.flags = 1 | 8 | 0x10 ;
//	fs_sp.flags = 0xD;
	fs_sp.attrib = 0;
	fs_sp.mask = 0;
	status = DL_FsSSearch( fs_sp, cur_dir, &fs_shandle, &fc, 0 );
	
	if ( status != RESULT_OK )
	{
		return status;
	}
                 //PFprintf("fc=%d\n",fc);
	papp->flist = (FILEINFO *) malloc( sizeof(FILEINFO)*fc );
	if ( !papp->flist )
	{ //Unable to allocate memory 
		DL_FsSearchClose(fs_shandle);
		
#ifdef DEBUG
    PFprintf("******search****** lrc search papp->flist=0\n");
#endif
		return player_destroyApp(ev_st, papp);
	}
	
	for ( i=0, j=0; i<=fc && fc>0; i++ )
	{
		cres = 1;
		status = DL_FsSearchResults( fs_shandle, i, &cres, &fs_sres );

		//fcur = &flist[j];
		if ( status == RESULT_OK )
		{
			name = SplitPath(fs_sres.name, L"/");
			u_strcpy( ext,SplitPath(name, L"."));
			u_strmakeupper( ext );//תд
			if ( name == NULL )
				continue;
			else if(u_strcmp(ext, L"M4A")==0 || u_strcmp(ext, L"MP3")==0)
				u_strcpy(papp->flist[j].name, name);
			
			if(!u_strcmp(name,SplitPath(filename,L"/")))
			{
				cur=j;
				//PFprintf("cur=%d\n",cur);
			}
			
			j++;
		}
	}
	count= j;
	//PFprintf("j=%d\n",j);
	DL_FsSearchClose(fs_shandle);
	//for(i=0;i<j;i++)
	 //u_PFprintf("file=%s\n",papp->flist[j].name);
	
#ifdef DEBUG
    PFprintf("******search****** lrc search count = %d\n", count);
#endif
	return status;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
UINT32 shell_startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_SHELL_T     *app = NULL;
    UINT32 status = RESULT_OK;
    //int i;
#ifdef DEBUG
    PFprintf("***************shell_startApp************** lrc reg_id = %d\n", reg_id);
#endif
	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
		return RESULT_FAIL;
	
	app = (APP_SHELL_T*)APP_InitAppData( (void *)APP_HandleEvent,
										  sizeof(APP_SHELL_T),
										  reg_id,
										  0, 1,
										  1,
										  1, 1, 0 );
	status = APP_Start( ev_st,
						&app->apt,
						SHELL_STATE_INIT,
						shell_state_handling_table,
						shell_destroyApp,
						shell_app_name,
						0 );

#ifdef DEBUG
    PFprintf("***************shell_startApp************** OK\n");
#endif

    return RESULT_OK;
}
UINT32 shell_destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;
	APPLICATION_T           *papp = (APPLICATION_T*) app;

	isCanvas=0;
	//free(file_list);
	//dbg("exit-shell\n");
//	APP_UtilStopTimer(app );
	APP_UtilUISDialogDelete(  &papp->dialog );
	status = APP_Exit( ev_st, app, 0 );
	
	return status;
}
UINT32 shell_HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    status = APP_HandleUITokenGranted( ev_st, app );

    if( (status == RESULT_OK) && (papp->token_status == 2) )
    {
            status = APP_UtilChangeState( SHELL_STATE_MAIN , ev_st, app );
    }

    return status;
}
UINT32 shell_MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    SU_PORT_T               port = papp->port;

#ifdef DEBUG
	PFprintf("***********shell_MainStateEnter**************\n");
#endif

	if(type!=ENTER_STATE_ENTER) 
		return RESULT_OK;
	
	display_size = UIS_CanvasGetDisplaySize();
    screenbuf.w = display_size.x+1;
    screenbuf.h = display_size.y+1;
    screenbuf.buf = NULL;
		
	dialog = UIS_CreateColorCanvas ( &port, &screenbuf, TRUE ); // create canvas 
	
    if(dialog == 0) return RESULT_FAIL;
    papp->dialog = dialog;
	isCanvas=1;
	
    DL_ClkGetTime(&time_n);
	backg();
	draw_pos();
	draw_lrc_info();

    return RESULT_OK;
}
//		  SetFillColor(255,asd.percent*255/50,0,0);
//		  SetForegroundColor(255,asd.percent*255/50,0,0);

UINT32 shell_Keypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
		switch (event->data.key_pressed)
		{
		case 20:
			break;
				
		case 15://rs
		case 10://*
			isCanvas=0;
			APP_ConsumeEv( ev_st, app );
			return shell_destroyApp(ev_st,app);
			break;
		}
		return NULL;
}

#ifndef BLUE
#ifndef WALKMAN
void get_rain_f(UINT16 i)
{
	i=i%1530;
		
	if(i<=255)//->
		SetForegroundColor(255,i,0,128);
	else if(i<=510)//->
		SetForegroundColor(510-i,255,0,128);
	else if(i<=765)//->ǳ
		SetForegroundColor(0,255,i-510,128);
	else if(i<=1020)//ǳ->
		SetForegroundColor(0,1020-i,255,128);
	else if(i<=1275)//->
		SetForegroundColor(i-1020,0,255,128);
	else if(i<=1530)//->
		SetForegroundColor(255,0,1530-i,128);
//	SetForegroundColor(0,255,255,128);
}
#endif
#endif

//ͼ
UINT32 get_focus(EVENT_STACK_T *ev_st,  void *app)
{
	backg();
	draw_bar_all();
	draw_lrc_info();
#ifdef DEBUG
	PFprintf("***********get_focus**************\n");
#endif
	return NULL;
}
void backg()
{
	//UINT8 volume=0;
  //UINT8 Volume_id=4;
	
// #ifdef WALKMAN

// #else
	// int i;
	// for(i=0;i<=display_size.x;i++)
	// {
		// get_rain_f(i*8);
		// DrawLine(i,0,i,display_size.y);
	// }
// #else
//	SetFillColor(0x4A,0xB9,0xED,0);
//	FillRect(6,83,i,14);
#ifdef BLUE
	SetForegroundColor(0x94,0xB0,0xC8,0xFF);
	DrawLine(0,0,175,0);
	DrawLine(0,219,175,219);
	SetForegroundColor(0x90,0xA7,0xC4,0xFF);
	DrawLine(0,1,175,1);
	DrawLine(0,218,175,218);
	SetForegroundColor(0x90,0xA1,0xBF,0xFF);
	DrawLine(0,2,175,2);
	DrawLine(0,217,175,217);
	SetForegroundColor(0x83,0xA0,0xBE,0xFF);
	DrawLine(0,3,175,3);
	DrawLine(0,216,175,216);
	SetForegroundColor(0x7C,0x9E,0xBC,0xFF);
	DrawLine(0,4,175,4);
	DrawLine(0,215,175,215);
	SetForegroundColor(0x76,0x97,0xB8,0xFF);
	DrawLine(0,5,175,5);
	DrawLine(0,214,175,214);
	SetForegroundColor(0x72,0x8F,0xB4,0xFF);
	DrawLine(0,6,175,6);
	DrawLine(0,213,175,213);
	SetForegroundColor(0x69,0x90,0xB3,0xFF);
	DrawLine(0,7,175,7);
	DrawLine(0,212,175,212);
	SetForegroundColor(0x59,0x83,0xAF,0xFF);
	DrawLine(0,8,175,8);
	DrawLine(0,211,175,211);
	SetForegroundColor(0x16,0x5F,0x9C,0xFF);
	DrawLine(0,9,175,9);
	DrawLine(0,210,175,210);
	SetForegroundColor(0x00,0x59,0x91,0xFF);
	DrawLine(0,10,175,10);
	DrawLine(0,209,175,209);
	SetForegroundColor(0x00,0x63,0xA3,0xFF);
	DrawLine(0,11,175,11);
	DrawLine(0,208,175,208);
	SetForegroundColor(0x06,0x72,0xB7,0xFF);
	DrawLine(0,12,175,12);
	DrawLine(0,207,175,207);
	SetForegroundColor(0x12,0x86,0xC2,0xFF);
	DrawLine(0,13,175,13);
	DrawLine(0,206,175,206);
	SetForegroundColor(0x25,0x9B,0xD1,0xFF);
	DrawLine(0,14,175,14);
	DrawLine(0,205,175,205);
	SetForegroundColor(0x33,0xA3,0xDF,0xFF);
	DrawLine(0,15,175,15);
	DrawLine(0,204,175,204);
	SetForegroundColor(0x4A,0xAD,0xE9,0xFF);
	DrawLine(0,16,175,16);
	DrawLine(0,203,175,203);
	SetForegroundColor(0x59,0xBC,0xF0,0xFF);
	DrawLine(0,17,175,17);
	DrawLine(0,202,175,202);
	SetForegroundColor(0x6B,0xCF,0xFB,0xFF);
	DrawLine(0,18,175,18);
	DrawLine(0,201,175,201);
	SetForegroundColor(0x8A,0xD9,0xFF,0xFF);
	DrawLine(0,19,175,19);
	DrawLine(0,200,175,200);
	SetForegroundColor(255,255,255,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x00000000);
		FillRect(0, 0, 175, 19);
		FillRect(0, 200, 175, 19);
		SetFillColor_x(0x20202000);
		FillRect(0, 21, 176, 177);
		SetForegroundColor_x(0x90909000);
		DrawLine(0, 20, 175, 20);
		DrawLine(0, 199, 175, 199);
		SetForegroundColor_x(0xFF5F0000);
	#else
		int i=0;
		for(i=0;i<=display_size.x;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,0,i,display_size.y);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif
	

	// DrawText((WCHAR*)version,50,2,ANCHOR_LEFT, ANCHOR_TOP);
	// DrawText((WCHAR*)L"EDY",74,203,ANCHOR_LEFT, ANCHOR_TOP);
	// DrawText((WCHAR*)exit,4,202,ANCHOR_LEFT, ANCHOR_TOP);
	// DrawText((WCHAR*)hide,142,202,ANCHOR_LEFT, ANCHOR_TOP);
	
	// SetForegroundColor(0,0,0,0);
	DrawText((WCHAR*)version,3,1,ANCHOR_LEFT, ANCHOR_TOP);
	DrawText((WCHAR*)L"EDY",73,202,ANCHOR_LEFT, ANCHOR_TOP);
	DrawText((WCHAR*)exit,3,201,ANCHOR_LEFT, ANCHOR_TOP);
	DrawText((WCHAR*)hide,141,201,ANCHOR_LEFT, ANCHOR_TOP);
//	DrawText((WCHAR*)hide,172,200,ANCHOR_RIGHT, ANCHOR_TOP);
//	SetForegroundColor(255,255,255,0);
//	drawcir(88,130,69,1,0,360);
	
	//draw_bar_all();
	draw_time();
	draw_name();
	draw_vol();
	draw_circle_s();
	draw_num();
}
void draw_name()
{
#ifdef BLUE
	SetFillColor(0x4A,0xB9,0xED,0);
	FillRect(0,20,176,19);
	SetForegroundColor(0,0,0,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
		FillRect(0,21,176,18);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		int i;
		for(i=0;i<=display_size.x;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,20,i,39);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif
		
	// SetForegroundColor(255,255,255,0);
	// DrawText((WCHAR*)SplitPath(filename,L"/"),6,21,ANCHOR_LEFT, ANCHOR_TOP);
	// SetForegroundColor(0,0,0,0);
	DrawText((WCHAR*)SplitPath(filename,L"/"),5,20,ANCHOR_LEFT, ANCHOR_TOP);
}

void draw_time()
{
	WCHAR buf[6];
    // GRAPHIC_METRIC_T    string_size;
	
#ifdef BLUE
	SetForegroundColor(0x94,0xB0,0xC8,0xFF);
	DrawLine(120,0,175,0);
	SetForegroundColor(0x90,0xA7,0xC4,0xFF);
	DrawLine(120,1,175,1);
	SetForegroundColor(0x90,0xA1,0xBF,0xFF);
	DrawLine(120,2,175,2);
	SetForegroundColor(0x83,0xA0,0xBE,0xFF);
	DrawLine(120,3,175,3);
	SetForegroundColor(0x7C,0x9E,0xBC,0xFF);
	DrawLine(120,4,175,4);
	SetForegroundColor(0x76,0x97,0xB8,0xFF);
	DrawLine(120,5,175,5);
	SetForegroundColor(0x72,0x8F,0xB4,0xFF);
	DrawLine(120,6,175,6);
	SetForegroundColor(0x69,0x90,0xB3,0xFF);
	DrawLine(120,7,175,7);
	SetForegroundColor(0x59,0x83,0xAF,0xFF);
	DrawLine(120,8,175,8);
	SetForegroundColor(0x16,0x5F,0x9C,0xFF);
	DrawLine(120,9,175,9);
	SetForegroundColor(0x00,0x59,0x91,0xFF);
	DrawLine(120,10,175,10);
	SetForegroundColor(0x00,0x63,0xA3,0xFF);
	DrawLine(120,11,175,11);
	SetForegroundColor(0x06,0x72,0xB7,0xFF);
	DrawLine(120,12,175,12);
	SetForegroundColor(0x12,0x86,0xC2,0xFF);
	DrawLine(120,13,175,13);
	SetForegroundColor(0x25,0x9B,0xD1,0xFF);
	DrawLine(120,14,175,14);
	SetForegroundColor(0x33,0xA3,0xDF,0xFF);
	DrawLine(120,15,175,15);
	SetForegroundColor(0x4A,0xAD,0xE9,0xFF);
	DrawLine(120,16,175,16);
	SetForegroundColor(0x59,0xBC,0xF0,0xFF);
	DrawLine(120,17,175,17);
	SetForegroundColor(0x6B,0xCF,0xFB,0xFF);
	DrawLine(120,18,175,18);
	SetForegroundColor(0x8A,0xD9,0xFF,0xFF);
	DrawLine(120,19,175,19);
	SetForegroundColor(255,255,255,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x00000000);
		FillRect(120, 0, 175, 19);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		int i=120;
		for(i=120;i<=display_size.x;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,0,i,19);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif

	if (time_n.hour < 10)
	{
		buf[0] = L'0';
		u_ultou(time_n.hour, &buf[1]);
	}
	else
		u_ultou(time_n.hour, buf);
	
	buf[2] = L':';
	
	if (time_n.minute < 10)
	{
		buf[3] = L'0';
		u_ultou(time_n.hour, &buf[4]);
	}
	else
		u_ultou(time_n.minute, &buf[3]);
	buf[5] = 0;
	
	DrawText((WCHAR*)buf, 126, 1, ANCHOR_LEFT, ANCHOR_TOP);
	time_m = time_n;
}

void draw_num()
{
	WCHAR* buf;
	UINT16 tmp = count;
	UINT8  num = 0;
	
#ifdef BLUE
	SetFillColor(0x4A,0xB9,0xED,0);
	FillRect(0,40,120,19);
	SetForegroundColor(0,0,0,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
		FillRect(0,40,120,19);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		int i;
		for(i=0;i<=120;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,40,i,59);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif

	do{
		num++;
		tmp /= 10;
	} while(tmp > 0);
	buf = (WCHAR*)malloc(2*(num+1)*sizeof(WCHAR));
	memset(buf, 0, 2*(num+1)*sizeof(WCHAR));
	
//	memset(buf1, 0, 6);
	num = 0;
	tmp = cur+1;
	do{
		num++;
		tmp /= 10;
	} while(tmp > 0);
	
	u_ultou(cur+1, buf);
	u_strcat(buf, L"/");
	u_ultou(count, buf+num+1);
//	u_strcat(buf, buf1);
	DrawText((WCHAR*)buf,6,40,ANCHOR_LEFT, ANCHOR_TOP);
	free(buf);
}
void draw_circle_s()
{
#ifdef BLUE
	SetFillColor(0x4A,0xB9,0xED,0);
	FillRect(120,40,56,19);
	SetForegroundColor(0,0,0,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
		FillRect(120,40,56,19);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		int i;
		for(i=126;i<=176;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,40,i,59);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif

	switch(circle_s)
	{
	case 0:
		DrawText((WCHAR*)mode0,126,40,ANCHOR_LEFT, ANCHOR_TOP);
		break;
	case 1:
		DrawText((WCHAR*)mode1,126,40,ANCHOR_LEFT, ANCHOR_TOP);
		break;
	case 2:
		DrawText((WCHAR*)mode2,126,40,ANCHOR_LEFT, ANCHOR_TOP);
		break;
	}
}
void draw_pos()
{
	WCHAR buf[10];
	WCHAR buff[20];
	
#ifdef BLUE
	SetFillColor(0x4A,0xB9,0xED,0);
	FillRect(0,60,120,19);
	SetForegroundColor(0,0,0,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
		FillRect(0,60,120,19);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		int i;
		for(i=0;i<126;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,60,i,79);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif

	sec2min(timePosition, buff);
	sec2min(timeDuraction, buf);
	u_strcat(buff, L"/");
	u_strcat(buff, buf);
	DrawText((WCHAR*)buff,6,60,ANCHOR_LEFT, ANCHOR_TOP);
}
void draw_vol()
{
	WCHAR buf[6] = L"Vol:";
	UINT8 volume=0;
	UINT8 Volume_id=4;
	
#ifdef BLUE
	SetFillColor(0x4A,0xB9,0xED,0);
	FillRect(120,60,56,19);
	SetForegroundColor(0,0,0,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
		FillRect(120,60,56,19);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		int i;
		for(i=126;i<176;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,60,i,79);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif
	
	if (namecmp((char*)LdrGetPlatformName(), "LTE"))
	Volume_id=2;
	DL_AudGetVolumeSetting(Volume_id, &volume);

	u_ultou(volume, &buf[4]);
	buf[5] = 0;
	DrawText(buf,126,60,ANCHOR_LEFT, ANCHOR_TOP);
}
void draw_bar()
{
	//SetForegroundColor(255,255,255,0);
	//drawcir(88,130,140,1,0,360);
//	SetForegroundColor(0,0,0,0);
//	drawcir(88,130,70,1,(timePosition-1)*360/timeDuraction,360/timeDuraction);
	int i = timePosition*164/timeDuraction;
//	SetFillColor(0x4A,0xB9,0xED,0);
//	SetFillColor(0x96,0xC0,0x66,0);
//	SetFillColor(0xFF,0x33,0xFF,0);
	if (i > 0)
	{
#ifdef WALKMAN
		SetFillColor_x(0xFF642100);
#else
		SetFillColor(128,0,255,0);
#endif
		FillRect(6,83,i-1,10);
	}
	if (i < 164)
	{
#ifdef BLUE
		SetFillColor(0x61,0xBC,0xEA,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
	#else
		SetFillColor(255,255,255,0);
	#endif
#endif
		FillRect(6+i,83,163-i,10);
	}
//	for(i=6+i;i<170;i++)
//	{
//		get_rain_f(i*8);
//		DrawLine(i,83,i,97);
//	}
}
void draw_bar_all()
{
#ifdef WALKMAN
	SetFillColor_x(0x20202000);
	FillRect(0,80,176,19);

	SetForegroundColor_x(0xFFFFFF00);
	DrawRect(5,82,165,12);
#else
	#ifdef BLUE
		SetFillColor(0x4A,0xB9,0xED,0);
		FillRect(0,80,176,19);
		SetForegroundColor(0,0,0,0);
		DrawRect(5,82,165,12);
	#else
		int i;
		for(i=0;i<176;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,80,i,99);
		}
		SetForegroundColor(0,0,0,0);
		DrawRect(5,82,165,12);
	#endif
#endif

}


//
UINT32 sec2min(UINT32 seconds, WCHAR *str)
{
    WCHAR  buf[8];

    u_ltou( (INT32)(seconds/60),  buf );

    if ((seconds/60) < 10) {
        u_strcpy(str, L"0");
        u_strcat(str, buf);
    } else {
        u_strcpy(str, buf);
    }
    
    u_strcat(str, L":");

    u_ltou( (INT32)(seconds%60),  buf );

    if ((seconds%60) < 10) {
        u_strcat(str, L"0");
    }

    u_strcat(str, buf);

    return RESULT_OK;
}

UINT32 ShowState(UINT8 state)
{
	STATUS   status_data;

	switch(state)
	{
		case PLAY:
			status_data.integer = 1;
			break;
		case PAUSE:
			status_data.integer = 2;
			break;
		default:
			status_data.integer = 0;
			break;
	}

    UIS_SetStatus(ITUNES_STATE_STATUS, status_data);
    
#ifdef DEBUG
    PFprintf("******ShowState****** song UIS_SetStatus( %d )...\n", State_Player);
#endif

	return RESULT_OK;
}

#ifdef DESKTOP
void ShowStr(WCHAR * string, UINT8 status)
{
	STATUS   status_data;

    status_data.quoted_string = string;
    UIS_SetStatus(status, status_data);
}

void ShowName(void)
{
    if (WorkingTable())
    {
        ShowStr((WCHAR*)SplitPath(filename,L"/"), Network_STATUS);
    }
}

void ShowTime(void)
{
    WCHAR bufT[16];

    if (WorkingTable())
    {
        sec2min(timePosition, bufT);
        u_strcat(bufT, L" / ");
        sec2min(timeDuraction, bufT+u_strlen(bufT));
    
        ShowStr(bufT, GPRS_STATUS);
    }
}

void ShowVolume(UINT8 volume)
{
    WCHAR str_volume[16];

    if (WorkingTable())
    {
        u_strcpy(str_volume, L"Vol: ");
        u_ltou( volume,  str_volume+u_strlen(str_volume) );
        ShowStr(str_volume, GPRS_STATUS);
    }
}
#endif

GRAPHIC_METRIC_T getfontsize(WCHAR *str,	UINT8 font_id)
{
	GRAPHIC_METRIC_T string_size;

	UIS_CanvasGetStringSize(str,&string_size,font_id);
	return string_size;
}

void draw_lrc()
{
	int i=0;
	WCHAR buff[100];
	WCHAR tmp[2];
	UINT16 lenth=0;
	UINT8  row=0;
	UINT8  pos_tmp=0;
	UINT32 t_pos=0;
	
#ifdef DEBUG
    PFprintf("******draw_lrc****** begin...\n");
#endif

	t_pos = timePosition*1000 + lrc->offset + 500;
	for (i=0; i<lrc->num_t; i++)
	{
		if (t_pos>=lrc->tlrc[i].time && t_pos<lrc->tlrc[i+1].time)
		{
			pos_tmp = i;
			break;
		}
	}
	if (pos_lrc == pos_tmp)
		return;
	
#ifdef DEBUG
    PFprintf("******draw_lrc****** lrc pos_lrc=%d\n",pos_lrc);
#endif
	
	pos_lrc = pos_tmp;
#ifdef BLUE
	SetFillColor(0x4A,0xB9,0xED,0);
	FillRect(0,100,176,99);
	SetForegroundColor(0,0,0,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
		FillRect(0,100,176,98);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		for(i=0;i<=display_size.x;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,100,i,199);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif
//	SetFillColor(0x85,0xD5,0xF5,0);
	
	// ǰ
	row = 100;
	lenth = 0;
//	SetForegroundColor(128,0,255,0);
//	SetForegroundColor(0xFF,0x33,0xFF,0);
	if(pos_lrc == lrc->num_t)
	{
		u_strcpy(buff, L"    ==OVER==    ");
		DrawText(buff, 5, row, ANCHOR_LEFT, ANCHOR_TOP);
	}
	else
	{
		for(i=0; i<u_strlen(lrc->slrc[lrc->tlrc[pos_lrc].index].txt); i++)
		{
			tmp[0] = lrc->slrc[lrc->tlrc[pos_lrc].index].txt[i];
			tmp[1] = 0;
			if (lenth+getfontsize(tmp, 1).width < 166)
			{
//				FillRect(0,row,176,20);
				DrawText(tmp, 5+lenth, row, ANCHOR_LEFT, ANCHOR_TOP);
				lenth += getfontsize(tmp, 1).width;
			}
			else if(row < 180)
			{
				row += 20;
//				FillRect(0,row,176,20);
				DrawText(tmp, 5, row, ANCHOR_LEFT, ANCHOR_TOP);
				lenth = getfontsize(tmp, 1).width;
			}
			else
				break;
		}
	}
	
	// һ
	row += 20;
	lenth = 0;
#ifdef WALKMAN
	SetForegroundColor_x(0xFFBB8800);
#else
	SetForegroundColor(128,128,128,0);
#endif
	if (pos_lrc == lrc->num_t-1)
	{
		u_strcpy(buff, L"    ==OVER==    ");
		DrawText(buff, 5, row, ANCHOR_LEFT, ANCHOR_TOP);
	}
	else if(pos_lrc == lrc->num_t)
	{
		buff[0] = 0;
		DrawText(buff, 5, row, ANCHOR_LEFT, ANCHOR_TOP);
	}
	else
	{
		for(i=0; i<u_strlen(lrc->slrc[lrc->tlrc[pos_lrc+1].index].txt); i++)
		{
			tmp[0] = lrc->slrc[lrc->tlrc[pos_lrc+1].index].txt[i];
			tmp[1] = 0;
			if (lenth+getfontsize(tmp, 1).width < 166)
			{
				DrawText(tmp, 5+lenth, row, ANCHOR_LEFT, ANCHOR_TOP);
				lenth += getfontsize(tmp, 1).width;
			}
			else if(row < 180)
			{
				row += 20;
				DrawText(tmp, 5, row, ANCHOR_LEFT, ANCHOR_TOP);
				lenth = getfontsize(tmp, 1).width;
			}
			else
				break;
		}
	}
	
//	SetForegroundColor(0,0,0,0);
//	DrawText(buff, 5,100,ANCHOR_LEFT, ANCHOR_TOP);
}

void draw_lrc_info()
{
#ifdef BLUE
	SetFillColor(0x4A,0xB9,0xED,0);
	FillRect(0,100,176,99);
	SetForegroundColor(0,0,0,0);
#else
	#ifdef WALKMAN
		SetFillColor_x(0x20202000);
		FillRect(0,100,176,98);
		SetForegroundColor_x(0xFFFFFF00);
	#else
		int i;
		for(i=0;i<176;i++)
		{
			get_rain_f(i*8);
			DrawLine(i,100,i,199);
		}
		SetForegroundColor(0,0,0,0);
	#endif
#endif

#ifdef DEBUG
    PFprintf("******draw_lrc_info****** begin...\n");
#endif

	if (iRet == 4)   //޸
	{
		DrawText((WCHAR*)error1, 20,100,ANCHOR_LEFT, ANCHOR_TOP);
		lrc_flag = FALSE;
	}
	else if (iRet == 1)  //ڴ
	{
		DrawText((WCHAR*)error3, 20,100,ANCHOR_LEFT, ANCHOR_TOP);
		lrc_flag = FALSE;
	}
	else if (iRet == 5)  //ļ
	{
		DrawText((WCHAR*)error4, 20,100,ANCHOR_LEFT, ANCHOR_TOP);
		lrc_flag = FALSE;
	}
	else if (iRet > 0)  //ļ
	{
		DrawText((WCHAR*)error2, 20,100,ANCHOR_LEFT, ANCHOR_TOP);
		lrc_flag = FALSE;
	}
	else
	{
		
		DrawText((WCHAR*)lrc->title,  5,100,ANCHOR_LEFT, ANCHOR_TOP);
		DrawText((WCHAR*)lrc->artist, 5,120,ANCHOR_LEFT, ANCHOR_TOP);
		DrawText((WCHAR*)lrc->album,  5,140,ANCHOR_LEFT, ANCHOR_TOP);
		DrawText((WCHAR*)lrc->by,     5,160,ANCHOR_LEFT, ANCHOR_TOP);
		lrc_flag = TRUE;
	}
}

void GetLRCFile()
{
	UINT8          *bufR=NULL;
	UINT32          readen;
	FILE_HANDLE_T   f;
	UINT32          fSize;
	WCHAR           nameLrcFile[255];
//	int             i=0;
	
//	if (iRet == 0)
//	{
//		DESTROY_LRC(&lrc);
//	}

#ifdef DEBUG
    u_PFprintf("******GetLRCFile****** song filename=%s\n",filename);
#endif

	u_strcpy(nameLrcFile, L"file://b/mobile/audio/lrc/");
	u_strcat(nameLrcFile, SplitPath(filename, L"/"));
    nameLrcFile[u_strlen(nameLrcFile)-3] = 0;
	u_strcat(nameLrcFile, L"lrc");

#ifdef DEBUG
    u_PFprintf("******GetLRCFile****** lrc filename=%s\n",nameLrcFile);
#endif

	if (!DL_FsFFileExist(nameLrcFile))
	{
	    nameLrcFile[u_strlen(nameLrcFile)-3] = 0;
		u_strcat(nameLrcFile, L"txt");
		if (!DL_FsFFileExist(nameLrcFile))
		{
			iRet = NO_FILE;
			return;
		}
	}
//	if (DL_FsFFileExist(nameLrcFile)) //    
//	{
		f = DL_FsOpenFile(nameLrcFile, FILE_READ_MODE, 0);
		fSize = DL_FsGetFileSize(f);
		bufR = (UINT8*)malloc( fSize * sizeof(UINT8) );
		if (bufR == NULL)
		{
			iRet = NO_MEM;
			return;
		}
		DL_FsReadFile( bufR, fSize, 1, f, &readen );
        DL_FsCloseFile(f);
		
		lrc = GetLRCFromBuf(bufR, fSize, &iRet);
		free(bufR);
//	}
//	else
//	{
//	    nameLrcFile[u_strlen(nameLrcFile)-3] = 0;
//		u_strcat(nameLrcFile, L"txt");
//		iRet = NO_FILE;
//	}
	
//#ifdef DEBUG
//    PFprintf("******GetLRCFile****** lrc title[0] = 0x%04X\n",lrc->title[0]);
//    PFprintf("******GetLRCFile****** lrc artist[0] = 0x%04X\n",lrc->artist[0]);
//    PFprintf("******GetLRCFile****** lrc album[0] = 0x%04X\n",lrc->album[0]);
//    PFprintf("******GetLRCFile****** lrc by[0] = 0x%04X\n",lrc->by[0]);
//    PFprintf("******GetLRCFile****** lrc offset = %d\n",lrc->offset);
//#endif

}
