#ifndef LRC_H_
#define LRC_H_

#include <apps.h>

#define isSkip(u) ((u)==0x000A || (u)==0x000D || (u)==0x0020)  // is or not need skip
#define isBLetter(u) ((u)>64 && (u)<91)  // Big Letter
#define isLLetter(u) ((u)>97 && (u)<122)  // Little Letter
#define isNumber(u)  ((u)>47 && (u)<58)   // Number

#define MAX_CACHE_SIZE 1024

#define OK         0
#define NO_MEM     1
#define FILE_ERROR 2
#define CODE_ERROR 3
#define NO_FILE    4
#define MD_FILE    5

// #ifdef PATCH
#define   mapadd  0x10c3e800 //for patch  E398 
// #define   mapadd  0x10D6D920 //for patch L7 acr
// #define   mapadd  0x10CFA630 //for patch L7 09R
// #endif

// lrc time info
typedef struct
{
    UINT32     time;       // 本句歌词的时间(ms)
    UINT16     index;
} LRC_TIME_T;

// lrc text info
typedef struct
{
	WCHAR   *txt;
	UINT16   size;
} LRC_TEXT_T;

// lrc file info
typedef struct
{
	WCHAR       *title;    //歌名
	WCHAR       *artist;   //艺术家
	WCHAR       *album;    //唱片
	WCHAR       *by;       //歌词作者
	INT16        offset;       //歌词时间偏移
	
	UINT8        num_t;    //歌词时间数
	UINT8        num_s;    //歌词句数
	
	LRC_TIME_T  *tlrc;     //歌词时间信息
	LRC_TEXT_T  *slrc;     //歌词内容
} LRC_INFO_T;


int GetCodeType(UINT8* str) 
{
	if (!str || (str[0] == 0 && str[1] == 0))
		return 0;
	
	if (str[0] == 0xFF && str[1] == 0xFE)
		return 2; //unicode le

	else if (str[0] == 0xFE && str[1] == 0xFF)
		return 3; //unicode be

	else if (str[0] == 0xEF && str[1] == 0xBB && str[2] == 0xBF)
		return 4; //utf8

	else
		return 1; //ansi gb
}

/*
UINT16 GBToUBE(WCHAR* u_buf, UINT8* g_buf, UINT16 len)
{
	UINT16 i=0;
	UINT16 k=0;      // num of unicode
	
	UINT16 tmp=0;    // offset in map
	UINT8  temp[2];

#ifndef PATCH
	UINT32          readen;
	FILE_HANDLE_T   f;
	UINT8          *buf_map;//[0x3B7C];  //map of gb2312 to unicode
	WCHAR nameMapFile[23] = L"file://b/ELF/gb2uc.map";

	if (DL_FsFFileExist(nameMapFile))
	{
		f = DL_FsOpenFile(nameMapFile, FILE_READ_MODE, 0);
		buf_map = (UINT8*)malloc( 0x3B7C );
		DL_FsReadFile( buf_map, 0x3B7C, 1, f, &readen );
        DL_FsCloseFile(f);
	}
	else
		return 0;
#endif
	
	u_buf[k++] = 0xFEFF;
	while (i < len)
	{
		if (g_buf[i]<0xA1)
		{
			if (g_buf[i]<0x20 && g_buf[i]!=0x0D && g_buf[i]!=0x0A)
			{
				i++;
				continue;
			}
			else
			{
				u_buf[k++] = g_buf[i++];
			}
		}
		else
		{
			tmp = g_buf[i] - 0xA1;
			if (g_buf[i] > 0xA9)
				tmp -= 0x06;
			tmp = (((tmp<<8)|g_buf[i+1]) - tmp*0xA2 - 0xA1) << 1;
			if (tmp < 0x3B7C)
			{
#ifdef PATCH
				temp[0] = *(UINT8*)(mapadd+tmp);
				temp[1] = *(UINT8*)(mapadd+tmp+1);
#else
				temp[0] = buf_map[tmp];
				temp[1] = buf_map[tmp+1];
#endif
				u_buf[k++] = (temp[1] << 8) | temp[0];
				i += 2;
			}
			else
			{
				i++;
				continue;
			}
		}
	}
#ifndef PATCH
	free(buf_map);
#endif
	
	return k;
}*/

UINT16 GBK2UBE(WCHAR* u_buf, UINT8* g_buf, UINT16 len)
{
	UINT16 i=0;
	UINT16 k=0;      // num of unicode
	
	UINT16 tmp=0;    // offset in map
	UINT8  temp[2];

	u_buf[k++] = 0xFEFF;
	while (i < len)
	{
		if (g_buf[i]<0x81)
		{
			if (g_buf[i]<0x20 && g_buf[i]!=0x0D && g_buf[i]!=0x0A)
			{
				i++;
				continue;
			}
			else
			{
				u_buf[k++] = g_buf[i++];
			}
		}
		else
		{
			tmp = g_buf[i] - 0x81;
			tmp = tmp * 0xBF + g_buf[i+1] - 0x40;
			tmp = tmp << 1;
			if (tmp < 0xBC04)
			{
				temp[0] = *(UINT8*)(mapadd+tmp);
				temp[1] = *(UINT8*)(mapadd+tmp+1);

				u_buf[k++] = (temp[1] << 8) | temp[0];
				i += 2;
			}
			else
			{
				i++;
				continue;
			}
		}
	}
	return k;
}

UINT16 UTF8ToUBE(WCHAR* u_buf, UINT8* u8_buf, UINT16 len)
{
	UINT16 i=0;
	UINT16 k=0;

	while (i < len)
	{
	    if ((u8_buf[i] >> 7) == 0x00)  //单字节编码 0xxxxxxx
		{
	    	u_buf[k++]=u8_buf[i++];
		}
	    else if ((u8_buf[i] >> 5) == 0x06) //双字节编码 110xxxxx 10xxxxxx
		{
	    	u_buf[k++] = ((u8_buf[i] & 0x1F) << 6) | (u8_buf[i+1] & 0x3F);
			i += 2;
		}
	    else if ((u8_buf[i] >> 4) == 0xe)  //三字节编码 1110xxxx 10xxxxxx 10xxxxxx
	   	{
	    	u_buf[k++] = ((u8_buf[i] & 0x0F)<<12) | ((u8_buf[i+1] & 0x3F)<<6) | (u8_buf[i+2] & 0x3F);
	    	i += 3;
	    }
	    else
	    {
	    	i++;
	    	continue;
	    }
	}
    return k;
}

UINT16 ULEToUBE(WCHAR* ube_buf, UINT8* ule_buf, UINT16 len)
{
	UINT16 i=0,j=0;
	for(i=0; i<len; i+=2)
	{
		ube_buf[j++] = (ule_buf[i+1] << 8) | ule_buf[i];
	}
	return j;
}

UINT16 UBEToUBE(WCHAR* ube_buf, UINT8* buf, UINT16 len)
{
	UINT16 i=0,j=0;
	for(i=0; i<len; i+=2)
	{
		ube_buf[j++] = (buf[i] << 8) | buf[i+1];
	}
	return j;
}


UINT32 LRC_SortByTime(LRC_TIME_T* tlrc, UINT16 num)
{
	UINT16 i,j;
	UINT16 tmp16;
	UINT32 tmp32;
	for (i=0; i<num-1; i++)
	{
		for (j=i+1; j<num; j++)
		{
			if (tlrc[i].time > tlrc[j].time)
			{
				tmp32         = tlrc[i].time;
				tlrc[i].time  = tlrc[j].time;
				tlrc[j].time  = tmp32;
				tmp16         = tlrc[i].index;
				tlrc[i].index = tlrc[j].index;
				tlrc[j].index = tmp16;
			}
		}
	}
	return OK;
}

void DESTROY_LRC(LRC_INFO_T** lrc)
{
	UINT16 i;
	
	if ((*lrc) != NULL)
	{
		if ((*lrc)->title != NULL)
		{
			free((*lrc)->title);
			(*lrc)->title = NULL;
		}
		if ((*lrc)->artist != NULL)
		{
			free((*lrc)->artist);
			(*lrc)->artist = NULL;
		}
		if ((*lrc)->album != NULL)
		{
			free((*lrc)->album);
			(*lrc)->album = NULL;
		}
		if ((*lrc)->by != NULL)
		{
			free((*lrc)->by);
			(*lrc)->by = NULL;
		}
		if ((*lrc)->tlrc != NULL)
		{
			free((*lrc)->tlrc);
			(*lrc)->tlrc = NULL;
		}
		if ((*lrc)->slrc != NULL)
		{
			for (i=0; i<(*lrc)->num_s; i++)
			{
				if ((*lrc)->slrc[i].txt != NULL)
				{
					free((*lrc)->slrc[i].txt);
					(*lrc)->slrc[i].txt = NULL;
				}
			}
			free((*lrc)->slrc);
			(*lrc)->slrc = NULL;
		}
		free((*lrc));
		(*lrc) = NULL;
	}
}

LRC_INFO_T* INIT_LRC()
{
	LRC_INFO_T* lrc = NULL;
	lrc = (LRC_INFO_T*)malloc(sizeof(LRC_INFO_T));
	if (lrc == NULL)
	{
		DESTROY_LRC(&lrc);
		return NULL;
	}
	lrc->title = NULL;
	lrc->title = (WCHAR*)malloc(sizeof(WCHAR));
	if (lrc->title == NULL)
	{
		DESTROY_LRC(&lrc);
		return NULL;
	}
	lrc->title[0] = 0;
	lrc->artist = NULL;
	lrc->artist = (WCHAR*)malloc(sizeof(WCHAR));
	if (lrc->artist == NULL)
	{
		DESTROY_LRC(&lrc);
		return NULL;
	}
	lrc->artist[0] = 0;
	lrc->album = NULL;
	lrc->album = (WCHAR*)malloc(sizeof(WCHAR));
	if (lrc->album == NULL)
	{
		DESTROY_LRC(&lrc);
		return NULL;
	}
	lrc->album[0] = 0;
	lrc->by = NULL;
	lrc->by = (WCHAR*)malloc(sizeof(WCHAR));
	if (lrc->by == NULL)
	{
		DESTROY_LRC(&lrc);
		return NULL;
	}
	lrc->by[0] = 0;
	lrc->offset = 0;
	lrc->num_t = 0;
	lrc->num_s = 0;
	lrc->tlrc = NULL;
	lrc->slrc = NULL;
	return lrc;
}

LRC_INFO_T* GetLRCFromBuf(UINT8* buf, UINT16 size, UINT8* iRet)
{
	LRC_INFO_T     *lrc = NULL;
	WCHAR          *u_buf = NULL;
	UINT16          lenth = 0;
	UINT16          i,j;
//	UINT16          tmp[8];
	UINT32          temp;
	LRC_TIME_T      lrc_time[MAX_CACHE_SIZE];
	UINT16          n_time = 0;
	UINT16          lrc_txt_off[MAX_CACHE_SIZE];
	UINT16          lrc_txt_len[MAX_CACHE_SIZE];
	UINT16          n_txt  = 0;
//	UINT16          time_offset = 0;
	INT8            time_offset_flag = 1;
	
	u_buf = (WCHAR*)malloc((size+1)*sizeof(WCHAR));
	if (u_buf == NULL)
	{
		*iRet = NO_MEM;
		return NULL;
	}

	i = 1;
	
	switch(GetCodeType(buf))
	{
	case 1:
		// lenth = GBToUBE(u_buf, buf, size);
		lenth = GBK2UBE(u_buf, buf, size);
		break;
	case 2:
		lenth = ULEToUBE(u_buf, buf, size);
		break;
	case 3:
		lenth = UBEToUBE(u_buf, buf, size);
		break;
	case 4:
		lenth = UTF8ToUBE(u_buf, buf, size);
		break;
	case 0:
	default:
		*iRet = CODE_ERROR;
		return NULL;
	}
	if (lenth < 1)
	{
		*iRet = FILE_ERROR;
		return NULL;
	}
	
	if (u_buf[lenth-1]!=0x000D && u_buf[lenth-1]!=0x000A)
	{
		u_buf[lenth] = 0x000A;
	}
	
//	INIT_LRC(&lrc);
	lrc = INIT_LRC();

	while(i < lenth && n_time < MAX_CACHE_SIZE)
	{
		if (u_buf[i]==0x005B)
		{
			// lrc time
			if (isNumber(u_buf[i+1]))
			{
				while(u_buf[i]==0x005B)
				{
					if(isNumber(u_buf[i+1]))	// [
					{
						i++;
						temp = 0;
						while(isNumber(u_buf[i]))
						{
							temp *= 10;
							temp += u_buf[i++]-48;
						}
						lrc_time[n_time].time = temp*60000;
						if(u_buf[i]==0x003A)
							i++;
						else
						{
							DESTROY_LRC(&lrc);
							*iRet = FILE_ERROR;
							return NULL;
						}
						temp = 0;
						while(isNumber(u_buf[i]))
						{
							temp *= 10;
							temp += u_buf[i++]-48;
						}
						lrc_time[n_time].time += temp*1000;
						if(u_buf[i]==0x002E)
						{
							i++;
							if (isNumber(u_buf[i]))
								lrc_time[n_time].time += (u_buf[i++]-0x0030)*100;
							if (isNumber(u_buf[i]))
								lrc_time[n_time].time += (u_buf[i++]-0x0030)*10;
							if (isNumber(u_buf[i]))
								lrc_time[n_time].time += u_buf[i++]-0x0030;
						}
						lrc_time[n_time].index = n_txt;
						n_time++;
						i++;
//						memset(tmp, 0, 8*sizeof(UINT16));
//						i++;
//						tmp[1] = u_buf[i++]-0x0030;		// min
//						tmp[2] = u_buf[i++]-0x0030;
//						i++;							// :
//						tmp[3] = u_buf[i++]-0x0030;		// sec
//						tmp[4] = u_buf[i++]-0x0030;
//						if(u_buf[i++]==0x002E)			// .
//						{
//							tmp[5] = u_buf[i++]-0x0030;	//ms
//							tmp[6] = u_buf[i++]-0x0030;
//							if(u_buf[i]!=0x005D)			// ]
//								tmp[7] = u_buf[i++]-0x0030;
//						}
//						i++;
//						temp = tmp[1]*600000+tmp[2]*60000+tmp[3]*10000+tmp[4]*1000+tmp[5]*100+tmp[6]*10+tmp[7];
//		//				lrc->tlrc[lrc->num].time  = temp;
//		//				lrc->tlrc[lrc->num].index = n_txt;
//		//				lrc->num++;
//						lrc_time[n_time].time  = temp;
//						lrc_time[n_time].index = n_txt;
//						n_time++;
					}
				}
				
				// lrc txt
				lrc_txt_off[n_txt] = i;
				while(u_buf[i]!=0x000D && u_buf[i]!=0x000A)
					i++;
				lrc_txt_len[n_txt] = i - lrc_txt_off[n_txt];
				n_txt++;
		
				i++;
				while ( isSkip(u_buf[i]) )
					i++;
			}
			
			// song title
//			if (u_buf[i]==0x0074 && u_buf[i+1]==0x0069 && u_buf[i+2]==0x003A)	// [ti:
			else if (u_strncmp(&u_buf[i], L"[ti:", 4)==0)
			{
				i += 4;
				j = 0;
				if (u_buf[i]==0x005D)
				{
					i++;
					j = i;
					while(u_buf[i]!=0xD && u_buf[i]!=0xA)
						i++;
					j = i - j;
				}
				else
				{
					j = i;
					while(u_buf[i]!=0x005D)
						i++;
					j = i - j;
				}
				if (lrc->title != NULL)
				{
					free(lrc->title);
					lrc->title = NULL;
				}
				lrc->title = (WCHAR*)malloc((j+1) * sizeof(WCHAR));
				if (lrc->title == NULL)
				{
					DESTROY_LRC(&lrc);
					*iRet = NO_MEM;
					return NULL;
				}
				memcpy(lrc->title, &u_buf[i-j], j * sizeof(WCHAR));
				lrc->title[j] = 0;
				while ( isSkip(u_buf[i]) )
					i++;
			}
			// song artist
//			if (u_buf[i]==0x0061 && u_buf[i+1]==0x0072 && u_buf[i+2]==0x003A)	// [ar:
			else if (u_strncmp(&u_buf[i], L"[ar:", 4)==0)
			{
				i += 4;
				j = 0;
				if (u_buf[i]==0x005D)
				{
					i++;
					j = i;
					while(u_buf[i]!=0xD && u_buf[i]!=0xA)
						i++;
					j = i - j;
				}
				else
				{
					j = i;
					while(u_buf[i]!=0x005D)
						i++;
					j = i - j;
				}
				if (lrc->artist != NULL)
				{
					free(lrc->artist);
					lrc->artist = NULL;
				}
				lrc->artist = (WCHAR*)malloc((j+1) * sizeof(WCHAR));
				if (lrc->artist == NULL)
				{
					DESTROY_LRC(&lrc);
					*iRet = NO_MEM;
					return NULL;
				}
				memcpy(lrc->artist, &u_buf[i-j], j * sizeof(WCHAR));
				lrc->artist[j] = 0;
				while ( isSkip(u_buf[i]) )
					i++;
			}
			// song album
//			if (u_buf[i]==0x0061 && u_buf[i+1]==0x006C && u_buf[i+2]==0x003A)	// [al:
			else if (u_strncmp(&u_buf[i], L"[al:", 4)==0)
			{
				i += 4;
				j = 0;
				if (u_buf[i]==0x005D)
				{
					i++;
					j = i;
					while(u_buf[i]!=0xD && u_buf[i]!=0xA)
						i++;
					j = i - j;
				}
				else
				{
					j = i;
					while(u_buf[i]!=0x005D)
						i++;
					j = i - j;
				}
				if (lrc->album != NULL)
				{
					free(lrc->album);
					lrc->album = NULL;
				}
				lrc->album = (WCHAR*)malloc((j+1) * sizeof(WCHAR));
				if (lrc->album == NULL)
				{
					DESTROY_LRC(&lrc);
					*iRet = NO_MEM;
					return NULL;
				}
				memcpy(lrc->album, &u_buf[i-j], j * sizeof(WCHAR));
				lrc->album[j] = 0;
				while ( isSkip(u_buf[i]) )
					i++;
			}
			// lrc by
//			if (u_buf[i]==0x0062 && u_buf[i+1]==0x0079 && u_buf[i+2]==0x003A)	// [by:
			else if (u_strncmp(&u_buf[i], L"[by:", 4)==0)
			{
				i += 4;
				j = 0;
				if (u_buf[i]==0x005D)
				{
					i++;
					j = i;
					while(u_buf[i]!=0xD && u_buf[i]!=0xA)
						i++;
					j = i - j;
				}
				else
				{
					j = i;
					while(u_buf[i]!=0x005D)
						i++;
					j = i - j;
				}
				if (lrc->by != NULL)
				{
					free(lrc->by);
					lrc->by = NULL;
				}
				lrc->by = (WCHAR*)malloc((j+1) * sizeof(WCHAR));
				if (lrc->by == NULL)
				{
					DESTROY_LRC(&lrc);
					*iRet = NO_MEM;
					return NULL;
				}
				memcpy(lrc->by, &u_buf[i-j], j * sizeof(WCHAR));
				lrc->by[j] = 0;
				while ( isSkip(u_buf[i]) )
					i++;
			}
			// lrc offset
//			if (u_buf[i]==0x006F && u_buf[i+1]==0x0066 && u_buf[i+2]==0x0066
//				&& u_buf[i+3]==0x0073 && u_buf[i+4]==0x0065 && u_buf[i+5]==0x0074 && u_buf[i+6]==0x003A)
			else if (u_strncmp(&u_buf[i], L"[offset:", 8)==0)
			{
				i += 8;
				if (u_buf[i]==0x002D) // -
				{
					time_offset_flag = -1;
					i++;
				}
				lrc->offset = 0;
				while (u_buf[i]!=0x005D)
				{
					if (u_buf[i]>=0x0030 && u_buf[i]<=0x0039)
					{
						lrc->offset *= 10;
						lrc->offset += u_buf[i++]-0x0030;
					}
				}
				lrc->offset	*= time_offset_flag;
				
//#ifdef DEBUG
//    PFprintf("******GetLRCFromBuf****** lrc offset = %d\n",lrc->offset);
//#endif

				i++;
				while ( isSkip(u_buf[i]) )
					i++;
			}
			// lrc key
//			else if (u_buf[i+1]==0x006B && u_buf[i+1]==0x0065 && u_buf[i+1]==0x0079 && u_buf[i+1]==0x003A)
			else if (u_strncmp(&u_buf[i], L"[key:", 5)==0)
			{
				DESTROY_LRC(&lrc);
				*iRet = MD_FILE;
				return NULL;
			}
			else
			{
				i++;
				while(u_buf[i]!=0x005B && i<lenth && n_time < MAX_CACHE_SIZE)
					i++;
			}
		}
		else
			while(u_buf[i]!=0x005B && i<lenth && n_time < MAX_CACHE_SIZE)
				i++;
	}
	
	lrc->num_t = n_time;
	lrc->num_s = n_txt;
	lrc->tlrc = NULL;
	lrc->tlrc = (LRC_TIME_T*)malloc((lrc->num_t+1) * sizeof(LRC_TIME_T));
	if (lrc->tlrc == NULL)
	{
		DESTROY_LRC(&lrc);
		*iRet = NO_MEM;
		return NULL;
	}
	memcpy(lrc->tlrc, lrc_time, lrc->num_t*sizeof(LRC_TIME_T));
	lrc->tlrc[lrc->num_t].time  = 0xFFFFFFFF;
	lrc->tlrc[lrc->num_t].index = 0;

	lrc->slrc = NULL;
	lrc->slrc = (LRC_TEXT_T*)malloc(lrc->num_s * sizeof(LRC_TEXT_T));
	if (lrc->slrc == NULL)
	{
		DESTROY_LRC(&lrc);
		*iRet = NO_MEM;
		return NULL;
	}
	for (i=0; i<lrc->num_s; i++)
	{
		lrc->slrc[i].txt = NULL;
		lrc->slrc[i].txt = (WCHAR*)malloc((lrc_txt_len[i]+1) * sizeof(WCHAR));
		if (lrc->slrc[i].txt == NULL)
		{
			DESTROY_LRC(&lrc);
			*iRet = NO_MEM;
			return NULL;
		}
		lrc->slrc[i].size = lrc_txt_len[i];
		memcpy(lrc->slrc[i].txt, &u_buf[lrc_txt_off[i]], lrc->slrc[i].size * sizeof(WCHAR));
		lrc->slrc[i].txt[lrc->slrc[i].size] = 0;
	}
	
	LRC_SortByTime(lrc->tlrc, lrc->num_t);
	
	free(u_buf);
	u_buf = NULL;
	
	*iRet = 0;
	return lrc;
}

#endif /*LRC_H_*/
