#ifndef GRAPHICS_H_
#define GRAPHICS_H_

UINT32 DrawLine(INT16 x1, INT16 y1, INT16 x2, INT16 y2)
{
    GRAPHIC_POINT_T begin;
    GRAPHIC_POINT_T end;

    begin.x = x1;
    begin.y = y1;
    end.x = x2;
    end.y = y2;

    UIS_CanvasDrawLine(begin, end, dialog);

    return RESULT_OK;
}

UINT32 DrawRect(INT32 x, INT32 y, UINT32 w, UINT32 h) //
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasDrawRect(region, 0, dialog);

    return RESULT_OK;
}

UINT32 DrawRectxy(INT32 x, INT32 y, UINT32 x2, UINT32 y2) //xyʾ
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x2;
    region.lrc.y = y2;

    UIS_CanvasDrawRect(region, 0, dialog);

    return RESULT_OK;
}

UINT32 DrawRoundRect(INT32 x, INT32 y, UINT32 w, UINT32 h, UINT16 arcW, UINT16 arcH,UINT8 fill) //ԲǾ
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasDrawRoundRect(region, 	
                            arcW, //ֱ
							arcH, // ֱ
							fill,
							dialog);
    return RESULT_OK;
}

UINT32 FillRect(INT32 x, INT32 y, UINT32 w, UINT32 h) //ʵľ
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasFillRect(region, dialog);

    return RESULT_OK;
}

UINT32 DrawArc_any(INT16 x, INT16 y, UINT16 w, UINT16 h, UINT16 startAngle, UINT16 arcAngle,UINT8 fill)//Բ
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x;
    region.ulc.y = y;
    region.lrc.x = x+w;
    region.lrc.y = y+h;

    UIS_CanvasDrawArc(region,
                      startAngle,  // ʼĽǶ
                      arcAngle,	  // ĽǶ
                      fill,
                      dialog);	

    return RESULT_OK;
}

UINT32 DrawArc(INT16 x, INT16 y, UINT16 r, UINT16 startAngle, UINT16 arcAngle,UINT8 fill)//׼ Բ
{
    GRAPHIC_REGION_T        region;

    region.ulc.x = x-r;
    region.ulc.y = y-r;
    region.lrc.x = x+r;
    region.lrc.y = y+r;

    UIS_CanvasDrawArc(region,
                      startAngle,  // ʼĽǶ
                      arcAngle,	  // ĽǶ
                      fill,
                      dialog);	

    return RESULT_OK;
}


UINT32 SetFillColor(UINT8 r, UINT8 g, UINT8 b, UINT8 t) //ɫ
{
    COLOR_T                 color;

    color.red = r;
    color.green = g;
    color.blue = b;
    color.transparent = t;

    UIS_CanvasSetFillColor(color);

    return RESULT_OK;
}

UINT32 SetFillColor_u2c(UINT16 u);
UINT32 SetFillColor_u2c(UINT16 u) //ɫ
{
    COLOR_T                 color;

    color.red = u/0x1000*16;
    color.green = (u%0x1000)/0x100*16;
    color.blue = (u%0x100)/0x10*16;
    color.transparent = u%0x10*16;

    UIS_CanvasSetFillColor(color);

    return RESULT_OK;
}

UINT32 SetFillColor_x(UINT32 u);//0xffffffff
UINT32 SetFillColor_x(UINT32 u) //ɫ
{
    COLOR_T                 color;

    color.red = u/0x1000000;
    color.green = (u%0x1000000)/0x10000;
    color.blue = (u%0x10000)/0x100;
    color.transparent = u%0x100;

    UIS_CanvasSetFillColor(color);

    return RESULT_OK;
}


UINT32 SetForegroundColor(UINT8 r, UINT8 g, UINT8 b, UINT8 t) // ǰɫ
{
    COLOR_T                 color;

    color.red = r;
    color.green = g;
    color.blue = b;
    color.transparent = t;

    UIS_CanvasSetForegroundColor(color);

    return RESULT_OK;
}

UINT32 SetForegroundColor_u2c(UINT16 u);
UINT32 SetForegroundColor_u2c(UINT16 u) // ǰɫU2C
{
    COLOR_T                 color;

    color.red = u/0x1000*16;
    color.green = (u%0x1000)/0x100*16;
    color.blue = (u%0x100)/0x10*16;
    color.transparent = u%0x10*16;

    UIS_CanvasSetForegroundColor(color);

    return RESULT_OK;
}

UINT32 SetForegroundColor_x(UINT32 u);
UINT32 SetForegroundColor_x(UINT32 u) // ǰɫU2C
{
    COLOR_T                 color;

    color.red = u/0x1000000;
    color.green = (u%0x1000000)/0x10000;
    color.blue = (u%0x10000)/0x100;
    color.transparent = u%0x100;

    UIS_CanvasSetForegroundColor(color);

    return RESULT_OK;
}


UINT32 DrawText(WCHAR *str, INT32 x, INT32 y, INT16 a_h, INT16 a_v)//д
{
    GRAPHIC_POINT_T anchor_point;
    COLOR_T                 color;

    color.transparent = 255;

    anchor_point.x = x;
    anchor_point.y = y;

    UIS_CanvasSetFont(1, dialog);

    UIS_CanvasSetBackgroundColor( color);

    UIS_CanvasDrawColorText (str,
							 0,
							 (UINT16)u_strlen(str),  	// ֳ
							 anchor_point,              // coordinates of the points of attachment 
							 (UINT16)(a_v|a_h),	    // value of the points of attachment. For example: ANCHOR_LEFT | ANCHOR_TOP 
							 dialog
							 );
    return RESULT_OK;
}

UINT32 DrawDrmImage( RESOURCE_ID DrmValue, INT16 x, INT16 y, INT16 a_h, INT16 a_v)//һDRMͼ
{
    PICTURE_TYPE_UNION_T picture_data;
    GRAPHIC_POINT_T anchor_point;
   

    anchor_point.x = x;
    anchor_point.y = y;

    picture_data.DrmValue = DrmValue;

    

//draw a kartiku 			
    UIS_CanvasDrawImage(DRM_PICTURE_TYPE,			// type. Which will take a picture. DRM, file .... 
                        picture_data,
                        anchor_point,
                        (UINT16)(a_v|a_h),
                        0,
                        dialog);

    return RESULT_OK;
}

UINT32 DrawPathImage( IMAGE_PATH_T PathValue, INT16 x, INT16 y, INT16 a_h, INT16 a_v)//ⲿͼƬ
{
    PICTURE_TYPE_UNION_T picture_data;
    GRAPHIC_POINT_T anchor_point;
    
   
     
    anchor_point.x = x;
    anchor_point.y = y;

    picture_data.PathValue = PathValue;

//draw a kartiku 			
    UIS_CanvasDrawImage(IMAGE_PATH_TYPE,			// type. Which will take a picture. DRM, file .... 
                        picture_data,
                        anchor_point,
                        (UINT16)(a_v|a_h),
                        Xor,
                        dialog);

    return RESULT_OK;
}

UINT32 floodfill(INT32 x,INT32 y,UINT16 color);
UINT32 floodfill(INT32 x,INT32 y,UINT16 color)
{
	    SetFillColor_u2c(color);
	    FillRect(x,y,6,6);
	    
    return RESULT_OK;
}

#endif
