#ifndef UTIL_H
#define UTIL_H

#include <typedefs.h>



/* Unicode strings routines */

/* Convert unicode string to ascii (valid only for ascii-range symbols) */
char* u_utoa( const WCHAR* ustr,  char* astr );

/* Convert ascii string to unicode */
WCHAR* u_atou( char* astr,  WCHAR* ustr );

WCHAR* u_strcpy( WCHAR* dst,  WCHAR* src );

WCHAR* u_strcat( WCHAR* dst,  WCHAR* src );

UINT32 u_strlen( WCHAR* str );

INT32 u_strcmp( WCHAR* str1,  WCHAR* str2 );

INT32 u_strncmp( WCHAR* str1,  WCHAR* str2,  UINT32 n );

WCHAR* u_strmakelower( WCHAR* str );

WCHAR* u_strmakeupper( WCHAR* str );

WCHAR* u_ltou( INT32 value,  WCHAR* str );

WCHAR* u_ultou( UINT32 value,  WCHAR* str );

INT32 u_atol( WCHAR* str );

void *memset(void *s,int c,UINT32 n);

void *memcpy(void *dest,const void *src,UINT32 n);
/* ANSI strings routines */

/* Quick compare strings */
UINT32 namecmp( char* str1,  char* str2 ); //returns 1 if equal

char* strcpy( char* dst,  char* src );
char* strcat( char* dst,  char* src );

INT32 strcmp( char* str1,  char* str2 );
INT32 strncmp( char* str1,  char* str2,  UINT32 n ); 

INT32 strtol( char* str,  char** endstr,  int radix );
UINT32 strtoul( char* str,  char** endstr,  int radix );

UINT32 strlen( char* str );

void *suAllocMem( UINT32 size, INT32 *result ); //result can be NULL
void suFreeMem( void *ptr );

void srand(UINT32 seed);

UINT32 rand(void);


#endif
