
#ifndef UIS_H
#define UIS_H

#include <apps.h>
#include <typedefs.h>
#include <stdarg.h>
#include <resources.h>

enum
{
    ACTION_OP_ADD = 0,
    ACTION_OP_DELETE,
    ACTION_OP_UPDATE
};

typedef struct
{
     UINT8 operation; // What to do with the current paragraph (ACTION_OP_ *) 
     EVENT_CODE_T event; // Event, which is created when choosing this action 
     RESOURCE_ID action_res; // Resource, describing the action (see RES_ACTION_LIST_ITEM_T) 

} ACTION_ENTRY_T;

typedef struct
{
    UINT8             count;            // Number of elements 
    ACTION_ENTRY_T    action[16];       // dL list of teams working with a list of action 

} ACTIONS_T;

typedef struct
{
    char             format[40];
    UINT32            count;
    UINT32            data[40];
} CONTENT_T;


       /* Supporting functions */ 
       
       
/* Creates content */ 
UINT32 UIS_MakeContentFromString( char *format,  CONTENT_T *dst,  ... );
/* More information about the string format: 
     The line consists of pointers to incoming parameters 
     specifiers and alignment. 
     Pointers are formed as the type and number of parameters in functions, 
     possible types: 
     q - pointer to a string WCHAR 
     s - a resource line 
     i - int 
     g - hex int 
     p - resource pictures 
     r - CONTENT_T 
     f - pointer to file 
     Specifiers alignment: 
     N - new line 
     S - distribution of the text 
     C - text in the center 
     L - trimmed with "...", if the line is too long 
     M - the middle of the text (vertical alignment) 
     T - text on top 
     B - text bottom 
     
     For example: "MCq0p1" = "Output middle and at the center first 
     parameter after dst as string, and the second - as a picture "*/ 

/* Standard handler EV_GRANT_TOKEN */ 
UINT32 APP_HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );

/* Standard handler EV_REVOKE_TOKEN */ 
UINT32 APP_HandleUITokenRevoked( EVENT_STACK_T *ev_st,  void *app );

/* Same as APP_UtilChangeState, but it still will be ejected (consumed) event */ 
UINT32 APP_UtilConsumeEvChangeState( UINT8 new_state,  EVENT_STACK_T *ev_st,  void *app );

/* Sends events dialogue */ 
UINT32 UIS_HandleEvent( UIS_DIALOG_T dialog,  EVENT_STACK_T *ev_st );

/* Call the complete repainting UI */ 
UINT32 UIS_Refresh( void );
UINT32 UIS_ForceRefresh( void );

/* Removes dialogue and exposes it to NULL */ 
UINT32 APP_UtilUISDialogDelete( UIS_DIALOG_T  *pdialog );

///UIS_SetActionList






       /* Functions of establishing dialogues */ 

enum
{
    NOTICE_TYPE_DEFAULT = 0,
    NOTICE_TYPE_OK,
    NOTICE_TYPE_FAIL,
    NOTICE_TYPE_WAIT
   /* In fact, the more they try to go 
      options - thus you'll help the development of the SDK */ 
};

/* Creates a window with the message. type = NOTICE_TYPE_ * */ 
UIS_DIALOG_T UIS_CreateTransientNotice( SU_PORT_T *port,  CONTENT_T *content,  UINT8 type );

/* Creates dialogue request */ 
UIS_DIALOG_T UIS_CreateConfirmation( SU_PORT_T *port,  CONTENT_T *content );
  

/* Creates a dialogue-list */ 
UIS_DIALOG_T UIS_CreateList (SU_PORT_T * port, 
                              UINT32 param1, // = 0 ID? 
                              UINT32 count, // Number of items on the list 
                              UINT32 marks, // Something associated with marked 
                              UINT32 * starting_num, // How many items should be served to initialize 
                              UINT8 param5, // = 0 
                              UINT8 param6, // = 2 
                              ACTIONS_T * actions, // Action List 
                              RESOURCE_ID caption); // Title List 


typedef struct
{
    UINT16	            type;
    RESOURCE_ID	        label;
    BOOL	              readonly;
    BOOL	              show;
    BOOL	              unk5;
    UINT32	            maxlen;
    RESOURCE_ID	        resource;
    UINT32	            unk8;
} FIELD_DESCR_T;

typedef struct
{
    RESOURCE_ID       descr_res;    // Resurs with FIELD_DESCR_T 
    UINT32            data;         // Current value (RESOURCE_ID / WCHAR */ CONTENT_T */ UINT32) 
    BOOL              unk3;     
    BOOL              unk4;
    BOOL              unk5;         // = 0
} FIELD_T; 


typedef struct
{
    CONTENT_T           text;
    UINT32              unk1;
    RESOURCE_ID         marks[2];
    RESOURCE_ID         unk3[2];
    RESOURCE_ID         unk4[2];
    UINT8               unk5;
    UINT8               unk6; // = 1
} STATIC_LIST_ENTRY_T;  

typedef union
{
     STATIC_LIST_ENTRY_T static_entry; // Used when editable == FALSE 
     FIELD_T editable_entry; // Used when editable == TRUE 
    UINT8                   pad[0xEC];
} LIST_CONTENT_T;


typedef struct
{
    BOOL                    editable;   //   ? 
    UINT32                  unk1;       // ??
    LIST_CONTENT_T          content;
    
    UINT8                   pad[0xF8-0xEC-0x8];
} LIST_ENTRY_T;


/* ? - */
UIS_DIALOG_T UIS_CreateStaticList( SU_PORT_T  *port,
                                   UINT32          param1,          // = 0 ID?
                                   UINT32          count,
                                   UINT32          marks,
                                   LIST_ENTRY_T    *entries, 
                                   UINT8           param5,          // = 0
                                   UINT8           param6,          // = 2
                                   ACTIONS_T       *actions,
                                   RESOURCE_ID     caption );
                                    

UIS_DIALOG_T UIS_CreateCharacterEditor( SU_PORT_T  *port,
                                        WCHAR           *text,
                                        UINT8           edit_type,
                                        UINT32          maxlen,
                                        BOOL            masked, //?
                                        ACTIONS_T       *actions, 
                                        RESOURCE_ID     dlgres ); 
/* 
   Values edit_type: 
0 - Every Word From Big Letters 
1 - a simple text 
2 - Each proposal. With big letters 
3 - similar to very long lines 
4 - phone number 
5 - ALL CAPS BIG 
6 - a string of numerical sequence segments 
7 - a simple text without changing regimes 
8 - similarly, without going into detail 
9 - as 4, without additional menu 
10 - analog, without going into detail 
11 - as 0, with the possibility of entering an empty row 
12 - as 1, with the possibility of entering an empty row 
23 - url 
28 - a string of Attacements 
29 - also, but can and empty 
32 - only numbers 
*/
UIS_DIALOG_T UIS_CreateViewer( SU_PORT_T  *port,
                               CONTENT_T       *contents,
                               ACTIONS_T       *actions );
                        
UIS_DIALOG_T UIS_CreatePictureAndTextList( SU_PORT_T  *port,
                                           UINT32          param1,
                                           UINT32          count, 
                                           UINT32          *starting_num, 
                                           UINT8           param4, // = 2
                                           UINT8           param5, // = 0
                                           UINT8           param6, // = 1, try 0,2,...
                                           ACTIONS_T       *actions, 
                                           RESOURCE_ID     dlgres );

// creates a headband 										   
UIS_DIALOG_T UIS_CreateSplashScreenFs( SU_PORT_T * port, WCHAR * uri, UINT32 unk );	// unk = 0x7D0
UIS_DIALOG_T UIS_CreateSplashScreen( SU_PORT_T * port, RESOURCE_ID img, UINT32 unk );	// unk = 0xD3 , 0x7D0

// Drops progressbar
UIS_DIALOG_T UIS_CreateProgressBar( SU_PORT_T *	port,
									RESOURCE_ID	res_img,	// 0x12000055
									CONTENT_T *	content,
									UINT8		u3,				// =0
									UINT8		perc,			// ?   !	// &(app) + 0x4d
									UINT32		u6,				// =0
									WCHAR *		str,			// ?
									ACTIONS_T *	actions,
									RESOURCE_ID	caption );		// can be =0
#define EV_PROGRESS_UPDATE  0x213F
typedef struct {
	UINT32		u1;
	WCHAR *		str;
	UINT8		pad[0x5C];
} PROGRESS_UPDATE_DATA_T ;


typedef union 
{
WCHAR   *str;
RESOURCE_ID res;
UINT8  int1;
} NOTICE_VALUE_T;


typedef struct
{
   UINT8  status;
   NOTICE_VALUE_T  value;
} NOTICE_STATUS_T;
UINT32 DL_DbPhoneBookFindCachedRecordByTelno(UINT32 P0,WCHAR *Telno,UINT32 P2,void *record); //P2=0;P0=0
UIS_DIALOG_T UIS_CreateIncomingCallNotice(SU_PORT_T *port, CONTENT_T *content,UINT8 type1,UINT8 type2,ACTIONS_T *actions);
UINT32 UIS_SetNoticeStatus(UINT8 status, NOTICE_STATUS_T *p1, UIS_DIALOG_T dialog);

// Skin
extern const WCHAR * SKIN_FOLDER;

UINT16 UIS_GetCurrentSkinIndex( void );
UINT16 UIS_GetDefaultSkinIndex( void );
WCHAR * UIS_GetSkinName( UINT16 skin_id );
UINT16 UIS_GetNumSkins( void );
void UIS_SetSkin( UINT16 skin_id );


#endif