#ifndef RESOURCES_H 
#define RESOURCES_H 

#include <typedefs.h> 

/* ID resource resource types formed as a senior byte and number of this type of resource 
     For example, 0x01000496 = "System Error" 
     Ids for strings and images are taken, respectively, and from lengpaka DRM */ 


#define RES_TYPE_STRING 0x01 
#define RES_TYPE_ACTION 0x06
#define RES_TYPE_FIELD	0x0d 
#define RES_TYPE_ENUM	0x10
#define RES_TYPE_GRAPHICS 0x12
#define RES_TYPE_ANIMATION 0x12


typedef UINT32 RESOURCE_ID; 

// Create a resource 
UINT32 DRM_CreateResource( RESOURCE_ID      *res_id,
                           UINT32           type,       //RES_TYPE_*
                           void             *data,
                           UINT32           size );

// Get the contents of the resource 
UINT32 DRM_GetResource (RESOURCE_ID res_id, 
                         void * buf, 
                         UINT32 size); 

// Get the size of the resource 
UINT32 DRM_GetResourceLength (RESOURCE_ID res_id, UINT32 * size); 

// Change resource 
UINT32 DRM_SetResource( RESOURCE_ID     res_id,
                        void            *data,
                        UINT32          size );

// Destroy resource 
UINT32 DRM_ClearResource (RESOURCE_ID res_id); 

/* Structure to describe resource for Action-a */ 
typedef struct 
{
RESOURCE_ID softkey_label; // The inscription on soft-button 
     RESOURCE_ID list_label; // The inscription on the list of action 
     INT8 softkey_priority; // Priority location on the softknopkah, negative -- 
     // To the left soft, positive - to the right 
     INT8 list_priority; // Priority Action of the list, two points 
     // With the highest priority placed on softknopkah, and looks forward softkey_priority 
     BOOL isExit; //?? Yavletsya whether the team exit the application 
     BOOL sendDlgDone; // Sends whether additional events EV_DIALOG_DONE 
} RES_ACTION_LIST_ITEM_T; 




#endif