#ifndef MME_H 
#define MME_H 

#include <typedefs.h>

#ifdef L7e
#define EV_MME_RANGE_START		  0xE0000
#else 
#define EV_MME_RANGE_START		  0xC1000
#endif

#define EV_MME_OPEN_SUCCESS        EV_MME_RANGE_START+0x0 //  0xC1000 // successfull file opening 
#define EV_MME_OPEN_ERROR          EV_MME_RANGE_START+0x1 //  0xC1001 // not successfull file opening 
#define EV_MME_SEEK_SUCCESS        EV_MME_RANGE_START+0x2 //  0xC1002 //  occurs after use of the fMME_GC_playback_seek 
#define EV_MME_SEEK_ERROR          EV_MME_RANGE_START+0x3 //  0xC1003 //  ?seek
#define EV_MME_PLAY_COMPLETE       EV_MME_RANGE_START+0xD //  0xC100D // arose at the end of play 
#define EV_MME_CLOSE_COMPLETE      EV_MME_RANGE_START+0x14 //  0xC1014 // ??
#define EV_MME_STOP_COMPLETE       EV_MME_RANGE_START+0x15 //  0xC1015 // ??
#define EV_MME_STOPPED_AT_TIME     EV_MME_RANGE_START+0x16 //  0xC1016 //   ?


/*******************************/ 

typedef enum 
{ 
// image 

MMSS_MIME_TYPE_IMAGE_GIF = 0, 
MMSS_MIME_TYPE_IMAGE_BMP, 
MMSS_MIME_TYPE_IMAGE_WBMP, 
MMSS_MIME_TYPE_IMAGE_PNG, 
MMSS_MIME_TYPE_IMAGE_JPEG, 
MMSS_MIME_TYPE_IMAGE_EMS_USERDEFINED_PICTURE, 
MMSS_MIME_TYPE_IMAGE_EMS_USERDEFINED_ANIMATION, 
MMSS_MIME_TYPE_IMAGE_EMS_PREDEFINED_ANIMATION, 
MMSS_MIME_TYPE_IMAGE_SLIDESHOW, 
MMSS_MIME_TYPE_IMAGE_EMSBMP, 
MMSS_MIME_TYPE_IMAGE_SIS, 
// audio 

MMSS_MIME_TYPE_AUDIO_MID = 11, 
MMSS_MIME_TYPE_AUDIO_MIDI, 
MMSS_MIME_TYPE_AUDIO_MIX, 
MMSS_MIME_TYPE_AUDIO_BAS, 
MMSS_MIME_TYPE_AUDIO_MP3, 
MMSS_MIME_TYPE_AUDIO_AAC, 
MMSS_MIME_TYPE_AUDIO_AU, 
MMSS_MIME_TYPE_AUDIO_AIFF, 
MMSS_MIME_TYPE_AUDIO_PCM, 
MMSS_MIME_TYPE_AUDIO_ADPCM, 
MMSS_MIME_TYPE_AUDIO_WAV, 
MMSS_MIME_TYPE_AUDIO_WMA, 
MMSS_MIME_TYPE_AUDIO_PLAYLIST, 
MMSS_MIME_TYPE_AUDIO_AMR, 
MMSS_MIME_TYPE_AUDIO_AMRWB, 
MMSS_MIME_TYPE_AUDIO_MP4, 
MMSS_MIME_TYPE_AUDIO_M4A, 
MMSS_MIME_TYPE_AUDIO_GSM610, 
MMSS_MIME_TYPE_AUDIO_JSR135_TONESEQ, 
MMSS_MIME_TYPE_AUDIO_REAL, 
MMSS_MIME_TYPE_AUDIO_MMA, 
MMSS_MIME_TYPE_AUDIO_QCELP, 
MMSS_MIME_TYPE_AUDIO_XMF, 


// Video 

MMSS_MIME_TYPE_VIDEO_ASF =34, 
MMSS_MIME_TYPE_VIDEO_WMV, 
MMSS_MIME_TYPE_VIDEO_MP4, 
MMSS_MIME_TYPE_VIDEO_MPEG4, 
MMSS_MIME_TYPE_VIDEO_H263, 
MMSS_MIME_TYPE_VIDEO_SDP, 
MMSS_MIME_TYPE_VIDEO_RAW, 
MMSS_MIME_TYPE_VIDEO_TST, 
MMSS_MIME_TYPE_VIDEO_RTSP, 
MMSS_MIME_TYPE_VIDEO_RAM, 
MMSS_MIME_TYPE_VIDEO_REAL, 
MMSS_MIME_TYPE_VIDEO_NOA, 
MMSS_MIME_TYPE_VIDEO_NOW, 
MMSS_MIME_TYPE_VIDEO_3G2, 
MMSS_MIME_TYPE_VIDEO_SVG, 
MMSS_MIME_TYPE_VIDEO_MMV, 
MMSS_MIME_TYPE_VIDEO_END, 

// ringtone 
MMSS_MIME_TYPE_RINGER_IMELODY =50, 
MMSS_MIME_TYPE_RINGER_MOTOROLA_TONE, 
MMSS_MIME_TYPE_RINGER_MYMIX, 
MMSS_MIME_TYPE_RINGER_MMT, 
MMSS_MIME_TYPE_RINGER_END, 

MMSS_MIME_TYPE_END = MMSS_MIME_TYPE_RINGER_END, 
MMSS_MIME_TYPE_INVALID 
}MMSS_MIME_TYPE_T; 




// DVD / / 
typedef void * MME_GC_MEDIA_FILE; 

typedef struct
{
   IFACE_DATA_T                 iface_data;
   MME_GC_MEDIA_FILE            media_handle;
   UINT8						status; // = 1 // at the end of play on L7e somehow 128
} MME_PLAY_COMPLETE_T; 

typedef struct
{
   IFACE_DATA_T          iface_data;
   MME_GC_MEDIA_FILE   	 media_handle;
} MME_OPEN_SUCCESS_T;


// Open uri for playback, and returns a pointer to open file 
MME_GC_MEDIA_FILE MME_GC_playback_create (IFACE_DATA_T  *data, WCHAR * uri, UINT32 unk1, UINT32 unk2, UINT32 unk3, UINT32 unk4, UINT32 unk5, UINT32 unk6); 

// Close the file 
UINT32 MME_GC_playback_delete (MME_GC_MEDIA_FILE media_file); 

// Start playback file 
UINT32 MME_GC_playback_start (MME_GC_MEDIA_FILE media_file, UINT32 unk1, UINT32 unk2); 

// Stop playback file 
UINT32 MME_GC_playback_stop (MME_GC_MEDIA_FILE media_file); 

// Pause 
UINT32 MME_GC_playback_pause (MME_GC_MEDIA_FILE media_file); 

// ms interval at ms. from the beginning of the file 
UINT32 MME_GC_playback_seek (MME_GC_MEDIA_FILE media_file, UINT32 ms); 

// get attributes 
/*
typedef enum 
{
DURATION = 1, 
DURATION_MS, 
POSITION = 73, 
POSITION_MS 
}ATTRIBUTE_NAME; 

UINT32 MME_GC_playback_get_attribute (MME_GC_MEDIA_FILE handle, 
                                      ATTRIBUTE_NAME attribute_name, 
                                       void * attribute_value 
                                       ); 
*/
typedef struct 
{
    WCHAR           *str;
    UINT16          str_size;
} STRING_T;

typedef struct 
{
    WCHAR           *str;
    UINT16          str_size;
    UINT8           unk0[4];
    UINT8           unk1[4];
} RATING_T;

typedef struct 
{
    STRING_T   title;
    STRING_T   author;
    STRING_T   copyright;
    STRING_T   description;
    STRING_T   performer;
    STRING_T   genre;
    RATING_T   rating;
    STRING_T   location;
    STRING_T   date;
    STRING_T   album;

} MEDIA_FILE_INFO_T;

typedef enum 
{
   PLAY_RATE_1X = 1,
   PLAY_RATE_2X,
   PLAY_RATE_3X,
   PLAY_RATE_4X,
   PLAY_RATE_MAX
} PLAY_RATE_T;

typedef enum{
    CODEC_NONE=0,
	MP3_CODEC=2,
    AAC_CODEC,
    MIDI_CODEC,
    WAV_CODEC,
    AMR_CODEC=15
} AUDIO_CODEC_TYPE_T;


typedef struct
{
    UINT32        				bit_rate;
    AUDIO_CODEC_TYPE_T          audio_codec;
    UINT32        				sampling_freq;
    UINT8           			audio_mode;    // 0=Mono, 1=Stereo 
    UINT16       				unk1[7];
    UINT8            			wav_bit_rate; // 0 =4, 1=8, 2=16 Kb/s
    UINT16            			unk2[7];
} AUDIO_FORMAT_T;


#ifdef L7e
#define ATTRIBUTE_RANGE_1 	0x5C
#else
#define ATTRIBUTE_RANGE_1 	71
#endif


typedef enum
{
  // get ?set
	FILE_INFO = 0, 				// MEDIA_FILE_INFO_T
	DURATION,    				// UINT32
	DURATION_MS, 				// UINT32
	FILE_SIZE,					// UINT32
	MEDIA_PATH = 6,				// WCHAR
	PLAY_RATE = 8,				// PLAY_RATE_T
	MEDIA_STOP_TIME = 58,			// UINT32
	MEDIA_STOP_TIME_MS = 60,		// UINT32
	PLAYBACK_AUDIO_VOLUME = 63, 	// UINT8
	MEDIA_VOLUME,				// UINT8		
  
   // get
    AUDIO_FORMAT = ATTRIBUTE_RANGE_1,		// AUDIO_FORMAT_T
	POSITION     = ATTRIBUTE_RANGE_1 + 3,		// UINT32
//	POSITION=74,				// UINT32
	POSITION_MS,				// UINT32
	PAUSE_POSITION = 114			// UINT32
} ATTRIBUTE_NAME_T;

//  ?
UINT32 MME_GC_playback_get_attribute( MME_GC_MEDIA_FILE     handle,
									  ATTRIBUTE_NAME_T   		attribute_name,
								      void  				*attribute_value
									);

// ??
UINT32 MME_GC_playback_set_attribute( MME_GC_MEDIA_FILE		handle,
									  ATTRIBUTE_NAME_T   	attribute_name,
									  void  				*attribute_value
									);

#endif