#ifndef FILESYSTEM_H
#define FILESYSTEM_H

#include <typedefs.h>


typedef UINT16          		    FILE_HANDLE_T;
#define FILE_HANDLE_INVALID   	0xFFFF
typedef UINT64					DL_FS_ID;


/* ݧ mode  DL_FsOpenFile.  էҧߧާ - . ڧѧߧڧ
	ѧߧէѧߧ ߧܧڧ C stdio.h  */
enum
{
     FILE_READ_MODE = 0,// dL Open reading 
     FILE_WRITE_MODE,// For the Record 
     FILE_WRITE_EXIST_MODE,// Record, if the file does not exist 
     FILE_APPEND_MODE,// Record the end of the file 
     FILE_READ_PLUS_MODE,//Open for reading and writing 
     FILE_WRITE_PLUS_MODE, //Create for reading and writing 
     FILE_WRITE_EXIST_PLUS_MODE,// Create for reading and writing, if not there 
     FILE_APPEND_PLUS_MODE // Open or create a file for reading/writing to the end 
};

/* ݧ whence  DL_FsSeekFile */
enum
{
    SEEK_WHENCE_SET = 0,
    SEEK_WHENCE_CUR,
    SEEK_WHENCE_END
};

#define FS_ATTR_DEFAULT    	0x0000
#define FS_ATTR_READONLY   	0x0001
#define FS_ATTR_HIDDEN     	0x0002
#define FS_ATTR_SYSTEM     	0x0004
#define FS_ATTR_VOLUME     	0x0008
#define FS_ATTR_DIRECTORY  	0x0010
#define FS_ATTR_ARCHIVE    	0x0020

typedef struct
{
	//Values bit unclear. In FBrowser used 00011100b (0x1C). 
	// 0x1C:ǰļУļУ
	// 0x0D:ļ
	//It is known that bits 00000100b (0x4) is responsible for sorting by name 
#ifdef L7e
	UINT32				flags;
#else 
    UINT8				flags;  // ߧѧ֧ߧڧ ҧڧ ߧ ߧ.  FBrowser ڧݧ٧ӧѧݧ 00011100b(0x1C). ٧ӧ֧ߧ,  ҧڧ 00000100b(0x4) ӧ֧ѧ֧ ٧ ڧӧܧ  ڧާ֧ߧ
#endif

    //Obviously, the result of fall in the files, whose attributes & mask == attrib
    UINT16				attrib; // ֧ӧڧէߧ,  ֧٧ݧѧ ѧէѧ  ѧۧݧ,  ܧ ѧڧҧ&mask==attrib
    UINT16				mask;
} FS_SEARCH_PARAMS_T;


typedef struct
{
    WCHAR			name[259]; // ݧߧ ڧާ ѧݧۧ ( ק)
    UINT16			attrib;
   	UINT16			unk1;
} FS_SEARCH_RESULT_T;
typedef struct {
	WCHAR		volume[3];
	WCHAR		descr[13];	// flash (for phone)
	size_t		free_size;	// in bytes
	size_t		vol_size;	// in bytes
	UINT16		attr;		// ??. For vol /b attr==type
	UINT8		unk1;		// 0x01
	UINT8		unk2;		// 0x00
	UINT16		type;		// ?? 0x40 - TRANS / 0x01 - flash. FileSystem???
	UINT16		unk3;
	UINT32		unk4;		// pointer to DSP??? only for TRANS

} VOLUME_DESCR_T;


// ֧ڧ٧ӧ֧ߧ ѧѧާ֧ ݧ֧է֧ ٧ѧէѧӧѧ ߧݧק

FILE_HANDLE_T DL_FsOpenFile( WCHAR* uri,  UINT8 mode,  UINT16 param3 );

UINT8 DL_FsCloseFile( FILE_HANDLE_T handle );

UINT8 DL_FsReadFile( void* buffer,
                     UINT32 size,
                     UINT32 count,
                     FILE_HANDLE_T handle,
                     UINT32* read );

UINT8 DL_FsWriteFile( void* buffer,
                      UINT32 size,
                      UINT32 count, 
                      FILE_HANDLE_T handle,
                      UINT32* written);

UINT8 DL_FsFSeekFile( FILE_HANDLE_T handle,  INT32 off,  UINT8 whence );

UINT32 DL_FsGetFileSize( FILE_HANDLE_T handle );

UINT32 DL_FsSGetFileSize( WCHAR* uri,  UINT16 param1);

BOOL DL_FsDirExist( WCHAR* uri );
BOOL DL_FsFFileExist( WCHAR* uri );

UINT32 DL_FsFGetPosition( FILE_HANDLE_T handle );

UINT8 DL_FsRenameFile( FILE_HANDLE_T handle,  WCHAR* new_name );

UINT8 DL_FsSRenameFile( WCHAR* old_uri,  WCHAR* new_name,  UINT16 param2 );

UINT8 DL_FsDeleteFile( WCHAR* uri,  UINT16 param1 );

UINT8 DL_FsFMoveFile( WCHAR* src_uri,  WCHAR* dst_uri,  UINT16 param2 );

UINT8 DL_FsMkDir( WCHAR* uri,  UINT16 param1 );

UINT8 DL_FsRmDir( WCHAR* uri,  UINT16 param1,  UINT8 param2 ); //param1=0 param2 = 0|1

UINT8 DL_FsFSetAttr( FILE_HANDLE_T handle,  UINT16 attrib );

UINT8 DL_FsSSetAttr( WCHAR* uri,  UINT16 param1,  UINT16 attrib );

UINT16 DL_FsGetAttr( FILE_HANDLE_T handle );

UINT16 DL_FsSGetAttr( WCHAR* uri,  UINT16 param1 );


typedef UINT8 FS_SEARCH_HANDLE_T;

/* ߧܧڧ ڧߧߧߧԧ ڧܧ ѧۧݧ */
/* search_string ާڧ֧ ڧ uri ѧܧ, ԧէ ӧ֧էק ڧ, ٧ѧ֧ ѧ٧է֧ݧڧ֧ݧ 0xFFFE, ٧ѧ֧ ѧ֧ߧ.
	ѧڧާ֧: "file://b/Elf/\xFFFE*.elf" */
UINT16 DL_FsSSearch( FS_SEARCH_PARAMS_T		params,
						  WCHAR					*search_string,
                          FS_SEARCH_HANDLE_T	*handle, 		// out
                          UINT16				*res_count,		// out
                          UINT16 				param4 );

/* ߧܧڧ էݧ ݧ֧ߧڧ [ѧ] ڧܧ ֧٧ݧѧ ڧܧ */
UINT16 DL_FsSearchResults( FS_SEARCH_HANDLE_T		handle,
                           		 UINT16 				start_index, // 0 based
                                 UINT16					*count,		 // in and out
                                 FS_SEARCH_RESULT_T		*results );

UINT16 DL_FsSearchClose( FS_SEARCH_HANDLE_T handle );

void DL_FsFlush( void );

//Receive a list of discs
WCHAR * DL_FsVolumeEnum( WCHAR * result ); // result = {0,'/',0,'a',0xff,0xfe,0,'/', ...}

/*  ?(? */
VOLUME_DESCR_T * DL_FsGetVolumeDescr( WCHAR * volume, VOLUME_DESCR_T * vd );


/*   ID ?*/
DL_FS_ID *	DL_FsGetIDFromURI( const WCHAR * file_uri, DL_FS_ID * fid );
UINT32      DL_FsGetIDFromURI32(WCHAR* url,UINT16 *ID);
/*   ?? ?ID */
WCHAR *		DL_FsGetURIFromID( const DL_FS_ID * fid, WCHAR * file_uri );

#endif

