#ifndef EVENTS_H 
#define EVENTS_H 

#include <typedefs.h> 

// See EVENT_T? EVENT_DATA_T@apps.h 

#define EV_GRANT_TOKEN 30 
#define EV_REVOKE_TOKEN 31 

#define EV_KEY_PRESS 500 // key_pressed 
#define EV_KEY_RELEASE 501 // key_pressed 

// Voznikae? Pr? Completion of the dialogue? 
#define EV_DIALOG_DONE 0x201C 
// Voznikae? Pr? Pressed? Key "Naza? 
#define EV_DONE 0x2020 
// Voznikae? Pr? Pressed? Joystick? Entrusted? Down? List 
#define EV_LIST_NAVIGATE 0x2043 // index 
// Voznikae? Pr? Pressed? Joystick? List or? Buttons "Vybo? 
#define EV_SELECT 0x2058 // EVENT_DATA_T.index 
// Sends? To lists? ask? regular? batch of data 
#define EV_REQUEST_LIST_ITEMS 0x202C // list_items_req 
// Sends? queries? 
#define EV_NO 0x2046 
#define EV_YES 0x2079 
#define EV_CANCEL 0x2008
// Adopted data 
#define EV_DATA 0x200F // EVENT_T:: attachment 
//? 
#define EV_BROWSE 0x2006 

// Voznikae? Pr? Changes? User? Any on? 
#define EV_DATA_CHANGE 0x2011 // index 
// Zaprosit? Data 
#define EV_REQUEST_DATA 0x202B // data_req 

// Timer Srabotal 
#define EV_TIMER_EXPIRED 0x8205A // (DL_TIMER_DATA_T *) EVENT_T:: attachment 

#define EV_IN_PHOTO 1019 
#define EV_SMS_INBOX 1329 
#define EV_CALL_INBOX 0x790 
#define EV_BLOCK_KEYBOARD 1707 
#define EV_UNBLOCK_KEYBOARD 1694 
#define EV_SHOW_MYNUMBER 1931 
#define EV_OPEN_MENU 8377 
#define EV_OPEN_GAMEAPP 0x03d6 
#define EV_PlayFunLight 0x0cc7 
#define EV_PauseFunLight 0xCC6 

#define EV_INCALLING 0x0670 
#define EV_INSMSING 0x04E3 

// Getting Focal 
#define EV_GAIN_FOCUS 20 
// Loss of focus 
#define EV_LOSE_FOCUS 21 
// Close saver 
#define EV_USER_ACTIVITY 0x7EE 
// Registration online 
#define EV_REG_NETWORK 0x8200B 

typedef enum 
{ 
       FBF_FREE = 100, // OS should release a buffer 
       FBF_LEAVE // Annex shall be followed? For liberation? Buffer? 
} FREE_BUF_FLAG_T; 

typedef struct 
{ 
     UINT32 bufsize; 
     UINT32 index; 
     UINT8 unk2; 
} REQUEST_DATA_T; 

typedef struct 
{ 
     UINT32 ID; //? Identifikato? List 
     UINT32 begin_idx; // Nachalny? Index target list of elements? 
     UINT8 count; // How much? Edemento? List of required 
} REQUEST_LIST_ITEMS_T; 

/* Frame? otvechayusch? for data transmission? event */ 
typedef union 
{
     UINT8 key_pressed; 
     UINT32 index; 
     REQUEST_LIST_ITEMS_T list_items_req; 
     REQUEST_DATA_T data_req; 

     // ELF parameters 
     ELF_PARAMS_T start_params; 
     // padding to real size 
     UINT8 pad [0xFC]; 
} EVENT_DATA_T; 

typedef struct 
{ 
     UINT32 data_tag; 
     EVENT_DATA_T data; 
} ADD_EVENT_DATA_T; 

/* Struktur? Described? Events */ 
typedef struct tagEVENT_T 
{ 
     EVENT_CODE_T code; 
     UINT32 unk1; 
     UINT32 ev_port; 
     UINT8 unk2; 
     BOOL is_consumed; 
     BOOL is_firstpass; 
     UINT8 unk3; 
     UINT32 unk4; 
     UINT32 unk5; 
     struct tagEVENT_T * next; 
     UINT32 data_tag; 
     EVENT_DATA_T data; 
     BOOL is_attach; 
     UINT16 att_size; 
     void * attachment; 
     UINT8 unk6; 
} EVENT_T; // size = 296 


typedef struct 
{ 
     EVENT_CODE_T code; 
     UINT8 unk1; 
     UINT8 unk2; 
     EVENT_T * top; 
     void * unk3; 
     UINT8 unk4 [6]; 
     UINT8 unk5; 
} EVENT_STACK_T; 

// Get current? Event from the list 
EVENT_T * AFW_GetEv (EVENT_STACK_T * ev_st); 

// Function? Added? events (? different? variation? data for events) 
UINT32 AFW_AddEvNoD (EVENT_STACK_T * ev_st, 
                      UINT16 event_code); 

UINT32 AFW_AddEvEvD (EVENT_STACK_T * ev_st, 
                      UINT16 event_code, 
                      ADD_EVENT_DATA_T * data); 

UINT32 AFW_AddEvAux (EVENT_STACK_T * ev_st, 
                      UINT16 event_code, 
                      FREE_BUF_FLAG_T free_buf, 
                      UINT32 att_size, 
                      void * attachment); 

UINT32 AFW_AddEvAuxD (EVENT_STACK_T * ev_st, 
                       UINT16 event_code, 
                       ADD_EVENT_DATA_T * data, 
                       FREE_BUF_FLAG_T free_buf, 
                       UINT32 att_size, 
                       void * attachment); 

// Udalet latest? Iwi? From the list 
UINT32 APP_ConsumeEv (EVENT_STACK_T * ev_st, void * app); 

// ¼ͨԻ				  
UINT32 AFW_TranslateEvEvD( EVENT_STACK_T    *ev_st,
                           UINT16           event_code,
                           ADD_EVENT_DATA_T *data );	
                           
//¼ev_list_items Ӧev_request_list_items  
UINT32 APP_UtilAddEvUISListData (EVENT_STACK_T * ev_st, 
                                  void * app, 
                                  UINT32 param2, // = 0 
                                  UINT32 begin_index, 
                                  UINT8 count, 
                                  FREE_BUF_FLAG_T free_buf, 
                                  UINT32 bufsize, 
                                  void * buffer); 

//ev_request_dataΪصʵ
UINT32 APP_UtilAddEvUISGetDataForItem (EVENT_STACK_T * ev_st, 
                                        void * app, 
                                        UINT32 index); 


// Update sheet 
UINT32 APP_UtilAddEvUISListChange (EVENT_STACK_T * ev_st, 
                                    void * app, 
                                    UINT32 param2, // = 0 
                                    UINT32 position, 
                                    UINT8 size, 
                                    BOOL refresh_data, 
                                    UINT8 param6, // = 2 
                                    FREE_BUF_FLAG_T free_buf, 
                                    UINT32 bufsize, // NULL? 
                                    void * buffer); // NULL? 
// Transition to a sheet item 
UINT32 APP_UtilAddEvChangeListPosition (EVENT_STACK_T * p_evg,
                                          void * app, 
                                          UINT32 position, 
                                          FREE_BUF_FLAG_T free_buf, 
                                          UINT32 bufsize, 
                                          void * buffer); 
#endif 