#ifndef CANVAS_H
#define CANVAS_H

#include <typedefs.h>
#include <util.h>
#include <mme.h>

/*******************************/
// for the determination of pressing the buttons? fishing? floor? inventory? 
#define EV_INK_KEY_PRESS 		  0x2034 //  EVENT_DATA_T
#define EV_INK_KEY_RELEASE		  0x2035 //  EVENT_DATA_T

/*******************************/

// point? privyazk? text? images 
// vertikaln?					
#define ANCHOR_BASELINE               64 //  text only? 
#define ANCHOR_BOTTOM                 32 
#define ANCHOR_TOP                    16 
#define ANCHOR_VCENTER                2  //only picture 

// gorizontaln? 
#define ANCHOR_RIGHT                  8 
#define ANCHOR_LEFT                   4  
#define ANCHOR_HCENTER                1  

// use the "mud?. example: ANCHOR_LEFT | ANCHOR_TOP 

/*******************************/


// style? font ... font_style 
#define FONT_STYLE_PLAIN		0xFF
#define FONT_STYLE_ITALIC		0x01
#define FONT_STYLE_BOLD			0x02
#define FONT_STYLE_BOLD_ITALIC	(FONT_STYLE_ITALIC | FONT_STYLE_BOLD)

/*******************************/

typedef struct
{
    UINT8 * buf; // buffer? "Painting. Must be NULL 
    UINT16 w; // width 
    UINT16 h; // height 
} DRAWING_BUFFER_T;

typedef struct
{
	UINT8 red;
	UINT8 green;
	UINT8 blue;
	UINT8 transparent; // transparency 
} COLOR_T;

typedef struct 
{
     INT16 x; // gorizontaln? x coordinate of 
     INT16 y; // vertikaln? coordinates 
} GRAPHIC_POINT_T;

typedef struct 
{
     GRAPHIC_POINT_T ulc; // Ͻ
     GRAPHIC_POINT_T lrc; // ½
} GRAPHIC_REGION_T;	

enum  // drawOp
{
	AlphaBlend,
	Copy,
  NotUsed1,
	Invert,
	NotCopy,
  Resize,
	Xor,
  NotUsed2,
  Move
}; 



typedef UINT8 CANVAS_IMAGE_HANDLE_T;

typedef struct 
{
    UINT16 height;
    UINT16 width;
} GRAPHIC_METRIC_T;

typedef enum
{
    UIS_WALLPAPER_LAYOUT_CURRENT = 0,           
    UIS_WALLPAPER_LAYOUT_CENTERED,          
    UIS_WALLPAPER_LAYOUT_TILED
    //  ... still possible? options 
} WALLPAPER_LAYOUT_T;	

typedef enum
{
    IMAGE_NO_ATTRIBUTES,
    IMAGE_FRAME_COMPLETED_CONFIRMATION,
    IMAGE_CYCLE_COMPLETED_CONFIRMATION,
    IMAGE_ANIMATION_COMPLETED_CONFIRMATION,
    IMAGE_FORCED_STILL_IMAGE,
    IMAGE_BACKGROUND_TRANSPARENT_IMAGE,
    IMAGE_BACKGROUND_TRANSPARENT_COLOR,
    IMAGE_BACKGROUND_TRANSPARENT_GRADIENT,
	
    IMAGE_BACKGROUND_TRANSPARENT_TILED_IMAGE,
    IMAGE_BACKGROUND_WALLPAPER_NEEDED,
 
    IMAGE_START_ANIMATION_AGAIN,
    IMAGE_BACKGROUND_EXCLUDING_IMAGE,
    IMAGE_CHANGE_ONLY_FOR_SUCCESS, 
    IMAGE_NO_PAINT_WHITE,
    IMAGE_NO_PAINT_WHITE_WITH_CROSS,
    IMAGE_PAINT_WHITE_AND_PAINT_WHITE_WITH_CROSS,
    IMAGE_NO_OF_CYCLES_OF_ANIMATION,
    IMAGE_DECODE_WALLPAPER_GRAYSCALE,
    IMAGE_PRESERVE_BACKGROUND_GRAYSCALE,
    IMAGE_RETURN_HANDLE_EVENT,
    IMAGE_GET_WIDTH,
    IMAGE_GET_HEIGHT,
    IMAGE_GET_FRAME_DELAY,
    IMAGE_OBEY_TRANSPARENCY,

    IMAGE_BLEND_VALUE,

    IMAGE_CLOSE_FILE_ON_RETURN,
    IMAGE_DO_NOT_UPDATE_DISPLAY,
    IMAGE_GET_SCALING_FACTOR,
    IMAGE_CHANGE_BUFFER_DIMENSIONS,
    IMAGE_GET_TYPE,
    IMAGE_GET_FRAME_NUMBER,
    IMAGE_GET_NUMBER_OF_FRAMES,
    IMAGE_GET_ID,
    IMAGE_SEND_EVENT,
    IMAGE_DECODE_THUMBNAIL,    
    IMAGE_GET_THUMBNAIL_WIDTH, 
    IMAGE_GET_THUMBNAIL_HEIGHT, 
    IMAGE_MME_DECODE_HIGHEST_SCALE_FACTOR,
    IMAGE_GET_REGION_ULCX,
    IMAGE_GET_REGION_ULCY,
    IMAGE_FORMAT
	// is still possible? options 
} IMAGE_ATTRIBUTE_TYPE_T;


/*******************************/

//sozdat? Canvas
UIS_DIALOG_T UIS_CreateColorCanvas( SU_PORT_T  *port,
                       DRAWING_BUFFER_T * drawing_buffer,
                       BOOL use_soft_icon_area );
                       
UIS_DIALOG_T UIS_CreateColorCanvasWithWallpaper( SU_PORT_T * port,
                                                 DRAWING_BUFFER_T * drb,
                                                BOOL use_soft_icons_region,
                                                BOOL b_wallp );

/* Color? poumolchani? 
BackgroundColor - white 
FillColor - white 
ForegroundColor - blue 
*/
					   
/*******************************/				

// draw a line? 				
void UIS_CanvasDrawLine(GRAPHIC_POINT_T begin,
                        GRAPHIC_POINT_T end,
						UIS_DIALOG_T handle);	   

// draw a zakrashenny? rectangle 
void UIS_CanvasFillRect(GRAPHIC_REGION_T region,
                        UIS_DIALOG_T handle);

// draw a rectangle 				
void UIS_CanvasDrawRect(GRAPHIC_REGION_T region,
                        BOOL fill, //  zalivk? 
                        UIS_DIALOG_T handle);

// draw a rounded rectangle 
void UIS_CanvasDrawRoundRect (GRAPHIC_REGION_T region, 
                              UINT16 arcW, // horizontal diameter? Rp? 
                              UINT16 arcH, // vertical diameter? Rp? 
                              BOOL fill, 
                              UIS_DIALOG_T handle); 					
	
// draw a circle arc mud? ellipse?
void UIS_CanvasDrawArc(GRAPHIC_REGION_T region,
						UINT16 startAngle,    //  nachalny? Corner
						UINT16 arcAngle,	  // the final corner 
						BOOL fill,
						UIS_DIALOG_T handle);	
					
// draw a mnogougolni? 	
void UIS_CanvasDrawPoly(UINT16 number_of_vertices,
						GRAPHIC_POINT_T  *array,
						BOOL fill,
						UIS_DIALOG_T handle);	
						
/*******************************/

// draw a line 			
void UIS_CanvasDrawColorText( WCHAR *string,
							  UINT16 offset,
							  UINT16 strlen,  			   // length of the line 
							  GRAPHIC_POINT_T anchor_point, // coordinates of the points? Privyazk? 
							  UINT16 anchor_value,		   // value points? Privyazk? For example: ANCHOR_LEFT | ANCHOR_TOP 
							  UIS_DIALOG_T handle);	
							 
//  ?
UINT32 UIS_CanvasSetFont( UINT8 font_id, // 0 - NetMonitor, 1- General Font...  ?MotoLangEditor
						  UIS_DIALOG_T handle);


	
// return style? font 
UINT8 UIS_CanvasGetFontStyle(UIS_DIALOG_T handle);		
// sets the style? font 			  
UINT32 UIS_CanvasSetFontStyle(UINT8 font_style, UIS_DIALOG_T handle);		  
						 

// size of the line returns 
UINT32 UIS_CanvasGetStringSize( WCHAR * str,
								GRAPHIC_METRIC_T * string_size, // size of the line 
								UINT8 font_id );	
// font size 				
UINT32 UIS_CanvasGetFontSize ( UINT8 font_id, GRAPHIC_METRIC_T * font_size);								
						
/*******************************/

// draw a kartik? 
enum  //type pictures ... picture_type 
{
    DRM_PICTURE_TYPE,
    IMAGE_PATH_TYPE,
    STORED_IN_MEMORY_TYPE,
    FILE_HANDLE_TYPE,
    IMAGE_PATH_WITH_OFFSET
};


typedef UINT32	RESOURCE_ID;

typedef WCHAR *IMAGE_PATH_T; //  path? picture 

typedef struct 
{
    const void *resourcePicturePointerValue;  // Location pointer? pa? ty //ڴеָ
    UINT32 imageSize;                     	  // size of the image 
} PICTURE_POINTER_T;

typedef struct 
{
    FILE_HANDLE_T fileHandle;
    UINT32 imageOffset;
    UINT32 imageSize;
} UIS_FILE_HANDLE_T;

typedef struct 
{
    IMAGE_PATH_T  	  PathValue;
    MMSS_MIME_TYPE_T  mimeFormat; // ͼƬ
    UINT32            imageOffset;
    UINT32            imageSize;
} FILE_PATH_WITH_OFFSET_T;

typedef union 
{
    RESOURCE_ID           	DrmValue;
    IMAGE_PATH_T            	PathValue;
    PICTURE_POINTER_T       	PointerValue;
    UIS_FILE_HANDLE_T           FileHandleValue;  
    FILE_PATH_WITH_OFFSET_T 	PathWithOffsetValue;
} PICTURE_TYPE_UNION_T; 
/*
enum  // drawOp
{
	AlphaBlend,
	Copy,
  NotUsed1,
	Invert,
	NotCopy,
  Resize,
	Xor,
  NotUsed2,
  Move
};
*/
enum  // draw_op
{
	DRAW_OP_ALPHA,
	DRAW_OP_DRAW,
	DRAW_OP_FILLALPHA_NOIMAGE,
	DRAW_OP_INVERT,
	DRAW_OP_UNK2,
	DRAW_OP_UNK3,
	DRAW_OP_INVERT2,
	DRAW_OP_UNK4,	// empty
	DRAW_OP_UNK5,
	DRAW_OP_UNK6
};

UINT32 UIS_CanvasDrawPicture( UINT8 *		p_buf,		//DRAWING_BUFFER_T::p_buf
							RESOURCE_ID 	res_id,		// 0x0200yyyy
							GRAPHIC_REGION_T		region,//
							BOOL			b_reverse );
							
UINT32 UIS_CanvasDrawImage(UINT8 picture_type,			// ty? Whether from? Brother? Picture. DRM, file .... 
						   PICTURE_TYPE_UNION_T picture_data,
						   GRAPHIC_POINT_T anchor_point,
						   UINT16 anchor_value,
						   UINT8 drawOp,
						   UIS_DIALOG_T handle);	

UINT32 UIS_CanvasDrawWallpaper(CANVAS_IMAGE_HANDLE_T image_handle,
							   GRAPHIC_REGION_T srcArea,
							   GRAPHIC_REGION_T destRegion,
							   UINT8 drawOp,
							   WALLPAPER_LAYOUT_T layout,
							   UIS_DIALOG_T handle);		

	
// opening? picture 	 
CANVAS_IMAGE_HANDLE_T UIS_CanvasOpenImage(UINT8 picture_type,
					  PICTURE_TYPE_UNION_T picture_data);	
										  
// opening? picture? receives its size 							  
CANVAS_IMAGE_HANDLE_T UIS_CanvasOpenImageAndGetSize(UINT8 picture_type,
                                                    PICTURE_TYPE_UNION_T picture_data,
                                                     GRAPHIC_POINT_T *attributes);	
                                                     
// adjourn? picture 									  
UINT32 UIS_CanvasCloseImage(CANVAS_IMAGE_HANDLE_T image_handle);	
								  
// update? size? 
UINT32 UIS_CanvasResizeImage(CANVAS_IMAGE_HANDLE_T image_handle,
							 UINT16 percent, /// zoom? Percent? 
							 GRAPHIC_REGION_T srcArea, // The original image size 
							 GRAPHIC_REGION_T destRegion,// the new? Size 
							 UINT8 drawOp, 
							 UIS_DIALOG_T handle);		
							 
// size of the image returns 							 
GRAPHIC_POINT_T UIS_CanvasGetImageSize(UINT8 picture_type,
									   PICTURE_TYPE_UNION_T picture_data);

// setting? attribute 
UINT32 UIS_CanvasSetImageAttribute(CANVAS_IMAGE_HANDLE_T image_handle,
                                    IMAGE_ATTRIBUTE_TYPE_T attribute_type,
							        void* attribute_value);			
// receives attribute 						
UINT32 UIS_CanvasGetImageAttribute(CANVAS_IMAGE_HANDLE_T image_handle,
                                    IMAGE_ATTRIBUTE_TYPE_T attribute_type,
							        void* attribute_value);		

// תͼ񵽻ָ
UINT32 UIS_CanvasDecodeImageToPointer(CANVAS_IMAGE_HANDLE_T image_handle, void* pointer);									
						

// һָ
UINT32 UIS_CanvasInsert(UIS_DIALOG_T handle,void* pointer, GRAPHIC_POINT_T point);	


// moves Region 
UINT32 UIS_CanvasMoveRegion(GRAPHIC_REGION_T source_region,
                            GRAPHIC_REGION_T dest_region,
                            UIS_DIALOG_T handle);					


UINT32 UIS_CanvasDrawColorBitmap( void*         picture_bytes,  //һֽ-ȣ߶ȵĵڶֽ
																	   // 8 bpp  rgb332 16 - bpp  rgb565  
								GRAPHIC_POINT_T  ulc_anchor_point,
								UIS_DIALOG_T  handle );		

//һͼƬϡ GIFͼ
UINT32 utility_draw_image( RESOURCE_ID res_id,
							GRAPHIC_REGION_T region,
							void * p_attr,
							void * drawBuf );								


				
/*******************************/	

// sets the color zalivk? 
void UIS_CanvasSetFillColor(COLOR_T color);	
// returns zalivk color? 
COLOR_T UIS_CanvasGetFillColor(void);



// sets the color for the line? rectangles, text ..... 
void UIS_CanvasSetForegroundColor(COLOR_T color);
// returns for the color line? rectangles, text ..... 
COLOR_T UIS_CanvasGetForegroundColor(void);


void UIS_CanvasSetBackgroundColor(COLOR_T color);
COLOR_T UIS_CanvasGetBackgroundColor(void);


// width line? 
void UIS_CanvasSetLineWidth(UINT16 width);
UINT16 UIS_CanvasGetLineWidth(void);


/*******************************/	

// update 
void UIS_CanvasRefreshDisplayRegion(UIS_DIALOG_T handle, GRAPHIC_REGION_T region);
void UIS_CanvasRefreshDisplayBuffer(UIS_DIALOG_T handle);	

/*******************************/
				   
// returns vozmozhnu? depths? color? bit? 
UINT32 UIS_CanvasGetColorDepth (void);


// size of the display returns 
GRAPHIC_POINT_T UIS_CanvasGetDisplaySize(void);

//
void UIS_CanvasDrawPixel(GRAPHIC_POINT_T point,UIS_DIALOG_T handle);

//includes off lights
UINT32 UIS_CanvasSetBackLight(BOOL state);

#endif