#define DEBUG_APP_NAME				"NET_test"

#include "test_net.h"
#include "..\dbg\dbg.h"


#define HTTP_HOST			"motofan.ru"
#define HTTP_USER_AGENT		"NetTestApp/0.1"



//    
socket_f *				socket = NULL;
socket_connect_f *		socket_connect = NULL;
socket_write_f *		socket_write = NULL;
socket_read_f *			socket_read = NULL;
socket_bind_f *			socket_bind = NULL;
socket_close_f *		socket_close = NULL;
socket_delete_f *		socket_delete = NULL;


UINT32			evcode_base;

HSOCK			g_socket;

/*  .        */
const char app_name[APP_NAME_LEN] = DEBUG_APP_NAME;

//   http  2   ,     ,
//     GET  ,    
//  POST       "Content-Length",    
const char sock_write_data[] = 
"GET / HTTP/1.1\n"
"Host: " HTTP_HOST "\n"
"User-Agent: " HTTP_USER_AGENT "\n"
"\n";


//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
	{ EV_KEY_PRESS,			HandleKeypress			},

	//      
	{ STATE_HANDLERS_END,		NULL				},
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
	{ STATE_HANDLERS_RESERVED,	HandleAPIAnsw		},	//      socket api. (evcode_base + 0)
	{ STATE_HANDLERS_RESERVED,	HandleSockAnsw		},	//      . (evcode_base + 1)
	{ STATE_HANDLERS_END,		NULL				},
};

/*   ,    -  .
	   ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
	{ HW_STATE_ANY,			// State
	  NULL,					//    state
	  NULL,					//    state
	  any_state_handlers	//   
	},

	{ HW_STATE_MAIN,
	  MainStateEnter,
	  NULL,
	  main_state_handlers
	}
};


UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T * tbl,  UINT32 base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END ) {
		if(tbl[i].code==STATE_HANDLERS_RESERVED)
			tbl[i].code = base++;
		i++;
	}
	return base;
}

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char * file_uri, char * param, UINT32 reserve )
{
	UINT32 status = RESULT_OK;
	
	LdrInitEventHandlersTbl((EVENT_HANDLER_ENTRY_T *)main_state_handlers, reserve);
	
	evcode_base = reserve;	//  reserve

	dbg("Register: Enter, file_uri = %s, param = %s", file_uri, param);
/*   */
	status = APP_Register( &evcode_base,			//      
						   1,						// - ,     
						   state_handling_table,	//  
						   HW_STATE_MAX,			//  
						   (void*)ELF_Start );		// ,   
	dbg("Register: APP_Register DONE, status = %d", status);
	

	LdrStartApp(reserve);	//  
	
	dbg("Register: END", NULL);
	
	return 1;				//    ,  
}


UINT32 ELF_Start( EVENT_STACK_T *ev_st, REG_ID_T reg_id, void * reg_hdl )
{
	APP_ELF	*	app = NULL;
	UINT32		status = RESULT_OK;
	
	dbg("ELF_Start: Enter", NULL);
	
	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK ) {
		return RESULT_FAIL; //     
	} else {
		app = (APP_ELF *)APP_InitAppData( (void *)APP_HandleEventPrepost,	//    
												sizeof(APP_ELF),			//   
												reg_id,
												0, 1,
												0,
												2, 0, 0 );

		dbg("ELF_Start: APP_InitAppData DONE, app = 0x%p", app);
		status = APP_Start( ev_st,
							&app->apt,
							HW_STATE_MAIN, //  
							state_handling_table,
							ELF_Exit,
							app_name,
							0 );
		dbg("ELF_Start: APP_Start DONE, status = %d", status);
		
		g_socket = HSOCK_INVALID;
	}

	dbg("ELF_Start: END", NULL);
	
	return RESULT_OK;
}


/*     */
UINT32 ELF_Exit( EVENT_STACK_T *ev_st, void *app )
{
	UINT32 status;

	dbg("ELF_Exit: Enter", NULL);
	
	/*    */
	status = APP_Exit( ev_st,(APPLICATION_T*) app, NULL );
	dbg("ELF_Exit: APP_Exit DONE, status = %d", status);
	
	dbg("ELF_Exit: call LdrUnloadELF... END", NULL);
	/*   */
	LdrUnloadELF(&Lib); // &Lib    
	
	return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T * ev_st, void * app, ENTER_STATE_TYPE_T type )
{
	ADD_EVENT_DATA_T	add_data;
	dbg("MainStateEnter: type = %d, app = 0x%p", type, app);
	
	//  API  SynSock
	add_data.data_tag = 0;
	add_data.data.params[0] = evcode_base + 0;		//      
	SockReqAPI(add_data);
	
	return RESULT_OK;
}


UINT32 HandleAPIAnsw( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *	event = AFW_GetEv(ev_st);
	UINT32		status = RESULT_OK;
	int			i;
	
	dbg("APIAnsw: Enter", NULL);
	
	APP_ConsumeEv( ev_st, app );
	
	socket = (socket_f *)(event->data.params[0]);
	socket_connect = (socket_connect_f *)(event->data.params[1]);
	socket_write = (socket_write_f *)(event->data.params[2]);
	socket_read = (socket_read_f *)(event->data.params[3]);
	socket_bind = (socket_bind_f *)(event->data.params[4]);
	socket_close = (socket_close_f *)(event->data.params[5]);
	socket_delete = (socket_delete_f *)(event->data.params[6]);
	
	// ,    .  ,    
	for ( i=0; i<7; i++ ) {
		if ( event->data.params[i] == NULL ) {
			return RESULT_FAIL;
		}
	}
	
	return RESULT_OK;
}
UINT32 HandleSockAnsw( EVENT_STACK_T *ev_st, void *app )
{
	EVENT_T *	event = AFW_GetEv(ev_st);
	UINT32		status = RESULT_OK;
	UINT32		answ = event->data.params[0];
	char *		data;
	UINT32		len;
	
	if ( answ == SOCK_ANSW_CREATE ) {
		//  
		dbg("SockAnsw: CREATE, status = %d", event->data.params[1]);
		
	} else if ( answ == SOCK_ANSW_READY ) {
		//    
		dbg("SockAnsw: READY", NULL);
		
	} else if ( answ == SOCK_ANSW_DATA ) {
		//  
		dbg("SockAnsw: DATA", NULL);
		
		if ( g_socket != HSOCK_INVALID ) {
			data = malloc(1024*5);
			len = 1024*5;
			while ( len != 0 ) {
				len = socket_read( g_socket, data, 1024*5 );
				if ( len )
					dbg("socket_read DONE, len = %d, data:\n%s", len, data);
			}
			free(data);
		}
		
	} else if ( answ == SOCK_ANSW_DELETE ) {
		//   - 
		dbg("SockAnsw: DELETE", NULL);
		g_socket = HSOCK_INVALID;
		
	} else if ( answ == SOCK_ANSW_ERROR ) {
		// 
		err("SockAnsw: ERROR", NULL);
	}
	
	return RESULT_OK;
}



UINT32 HandleKeypress( EVENT_STACK_T *ev_st, void *app )
{
	EVENT_T *			event = AFW_GetEv(ev_st);
	UINT32				status = RESULT_OK;
	UINT32				wr, len;
	char *				data;
	
	APP_ConsumeEv( ev_st, app );
	
	if ( event->data.key_pressed == KEY_RED ) {
		DL_AudPlayTone(3, 1);
		return ELF_Exit(ev_st, app);
	}
	if ( socket == NULL ) {
		//   Socket API
		return RESULT_OK;
	}
	
	switch ( event->data.key_pressed ) {
		case KEY_0:
			if ( g_socket != HSOCK_INVALID ) {
				//   
				break;
			}
			//  ,  ,     
			//        ,         (evcode_base + 1)
			g_socket = socket(SOCK_TCP, evcode_base + 1);
			
			//      ,        
			//  -     8
			if ( g_socket == HSOCK_INVALID ) {
				dbg("can't create socket", NULL);
			}
			break;
		case KEY_1:
			if ( g_socket != HSOCK_INVALID ) {
				if ( socket_connect(g_socket, HTTP_HOST, 80) != -1 ) {
					dbg("socket_connect OK...", NULL);
				} else {
					dbg("socket_connect ERROR", NULL);
				}
			}
			break;
		case KEY_2:
			if ( g_socket != HSOCK_INVALID ) {
				data = (char *)sock_write_data;	//   ,   
				len = strlen(data);		//  
				while ( len > 0 ) {
					wr = socket_write(g_socket, data, len);
					dbg("socket_write DONE, %d", wr);
					if ( wr == -1 ) {
						//   
						err("socket is not ready %d", g_socket);
						break;
					} else if ( wr == 0 && len > 0 ) {
						//  ...
						err("can't write to socket", NULL);
						break;
					}
					len -= wr;
					data+= wr;
				}
			}
			break;
		case KEY_3:
			if ( g_socket != HSOCK_INVALID ) {
				data = malloc(1024*5);
				len = 1024*5;
				len = socket_read( g_socket, data, len );
				dbg("socket_read DONE, len = %d, data:\n%s", len, data);
				free(data);
			}
			break;
		case KEY_4:
			if ( g_socket != HSOCK_INVALID ) {
				status = socket_close( g_socket );
				dbg("socket_close DONE, status = %d", status);
			}
			break;
		case KEY_5:
			if ( g_socket != HSOCK_INVALID ) {
				status = socket_delete( g_socket );
				dbg("socket_delete DONE, status = %d", status);
			}
			break;
		case KEY_6:
		case KEY_7:
		case KEY_8:
		case KEY_9:
		default:
			return RESULT_OK;
	}
	
	return RESULT_OK;
}















