#include <apps.h> 
#include <charset_conv.h>
#include "xmpp_lng.h"

static char	xmpp_lg[128];

static const WCHAR *xmpp_lang_rus[] = 
{
	/*Russian*/
	L"Тема:\n",
	L"Инфо о клиенте:\n",
	L"Название: ",
	L"Версия: ",
	
	L"Инфо о контакте:\n",
	L"JID: ",
	L"ФИО: ",
	L"Фамилия: ",
	L"Имя: ",
	L"Отчество: ",
	L"LG_VCARD_N_PREFIX: ",
	L"LG_VCARD_N_SUFFIX: ",
	L"Псевдоним: ",
	L"Дата рождения: ",
	L"Пол: ",

	L"Организация: ",
	L"Отдел: ",
	L"Название должности: ",
	L"Должность: ",

	L"E-Mail: ",
	L"Личный E-Mail: ",
	L"Рабочий E-Mail: ",
	L"LG_VCARD_EMAIL_INTERNET: ",
	L"LG_VCARD_EMAIL_PREF: ",
	L"LG_VCARD_EMAIL_X400: ",

	L"Домашний телефон: ",
	L"Рабочий телефон: ",
	L"LG_VCARD_TEL_VOICE: ",
	L"Факс: ",
	L"Пейджер: ",
	L"LG_VCARD_TEL_MSG: ",
	L"Мобильный телефон: ",
	L"LG_VCARD_TEL_VIDEO: ",
	L"LG_VCARD_TEL_BBS: ",
	L"LG_VCARD_TEL_MODEM: ",
	L"LG_VCARD_TEL_ISDN: ",
	L"LG_VCARD_TEL_PCS: ",
	L"LG_VCARD_TEL_PREF: ",
	L"Телефон: ",

	L"Дом: ",
	L"LG_VCARD_ADR_WORK: ",
	L"LG_VCARD_ADR_POSTAL: ",
	L"LG_VCARD_ADR_PARCEL: ",
	L"LG_VCARD_ADR_DOM: ",
	L"LG_VCARD_ADR_PREF: ",
	L"LG_VCARD_ADR_POBOX: ",
	L"LG_VCARD_ADR_EXTADD: ",
	L"Адрес: ",
	L"Город: ",
	L"Регион(область): ",
	L"Почтовый индекс: ",
	L"Страна: ",

	L"Домашняя страница: ",

	L"О себе: ",
	L"Часовой пояс: "
	
	L"LOGO: ",
	L"PHOTO: "
}; 

static const WCHAR *xmpp_lang_eng[] = 
{
	/*English*/
	L"Subject:\n",
	L"Client info:\n",
	L"Name: ",
	L"Version: ",
	
	L"Contact info:\n",
	L"JID: ",
	L"FN: ",
	L"Famile: ",
	L"Name: ",
	L"LG_VCARD_N_MIDDLE: ",
	L"LG_VCARD_N_PREFIX: ",
	L"LG_VCARD_N_SUFFIX: ",
	L"Nick: ",
	L"Birthday: ",
	L"Gender: ",

	L"ORGNAME: ",
	L"ORGUNIT: ",
	L"Title: ",
	L"Role: ",

	L"Email: ",
	L"LG_VCARD_EMAIL_HOME: ",
	L"LG_VCARD_EMAIL_WORK: ",
	L"LG_VCARD_EMAIL_INTERNET: ",
	L"LG_VCARD_EMAIL_PREF: ",
	L"LG_VCARD_EMAIL_X400: ",

	L"Home telephone: ",
	L"Work telephone: ",
	L"LG_VCARD_TEL_VOICE: ",
	L"Fax: ",
	L"Pager: ",
	L"LG_VCARD_TEL_MSG: ",
	L"LG_VCARD_TEL_CELL: ",
	L"LG_VCARD_TEL_VIDEO: ",
	L"LG_VCARD_TEL_BBS: ",
	L"LG_VCARD_TEL_MODEM: ",
	L"LG_VCARD_TEL_ISDN: ",
	L"LG_VCARD_TEL_PCS: ",
	L"LG_VCARD_TEL_PREF: ",
	L"LG_VCARD_TEL_NUMBER: ",

	L"Home: ",
	L"LG_VCARD_ADR_WORK: ",
	L"LG_VCARD_ADR_POSTAL: ",
	L"LG_VCARD_ADR_PARCEL: ",
	L"LG_VCARD_ADR_DOM: ",
	L"LG_VCARD_ADR_PREF: ",
	L"LG_VCARD_ADR_POBOX: ",
	L"LG_VCARD_ADR_EXTADD: ",
	L"Street: ",
	L"LG_VCARD_ADR_LOCALITY: ",
	L"Region: ",
	L"ZIP code: ",
	L"Coutry: ",

	L"URL: ",

	L"About: ",
	L"TZ: ",
	
	L"LOGO: ",
	L"PHOTO: "
};

const char *xmpp_mood[] = 
{
	"", // 0
	"angry", // 1
	"", // 2
	"stressed", // Уставший 3
	"", // 4
	"", // 5
	"serious", // Думаю 6
	"", // 7
	"", // 8
	"", // 9
	"activity", // Кофе 10
	"", // 11
	"", // 12
	"", // 13
	"contented", // Весело 14
	"", // 15
	"", // 16
	"", // 17
	"", // 18
	"sick", // Болею 19
	"", // 20
	"", // 21
	"", // 22
	"", // 23
	"", // 24
	"", // 25
	"happy", // Наладонник 26
	"", // 27
	"", // 28
	"excited", // Туалет 29
	"amazed", // Вопрос 30
	"", // 31
	"in_love", // Сердце 32
	"curious", // Ищу 33
	"flirtatious", // Любовь 34
	"impressed" // Дневник 35
};

const char *xmpp_activity_types[] = 
{
	"grooming",
	"eating",
	"drinking",
	"having_appointment",
	"traveling",
	"exercising",
	"working",
	"talking",
	"inactive",
	"relaxing"

};

const char *xmpp_activity[] = 
{
	"",	// 0
	"",	// 1
	"taking_a_bath", // Водные процедуры 2
	"", // 3
	"partying", // Вечеринка  4
	"having_a_beer", // Пиво  5
	"", // 6
	"eating", // Кушаю 7
	"watching_tv", // ТВ 8
	"socializing", // Друзья 9
	"having_coffee", // Кофе 10
	"", // 11
	"having_appointment", // Дела 12
	"commuting", // Кино 13
	"", // 14
	"on_the_phone", // Телефон 15
	"gaming", // Играю 16
	"studying", // Учёба 17
	"shopping", // Покупки 18
	"", // 19
	"sleeping", // Сплю 20
	"swimming", // Отрываюсь 21
	"reading", // В инете 22
	"working", // Инженеринг 23
	"writing", // Печатаю 24
	"going_out", // Канапе 25
	"", // 26
	"in_real_life", // Мобильник 27
	"ahanging_out", // Дремлю 28
	"", // 29
	"", // 30
	"watching_a_movie", // Путь 31
	"", // 32
	"", // 33
	"", // 34
	"", // 35

};
const char *xmpp_pyicq_t_xstatuses[] = 
{
	"",
	"xstatus_angry",
	"xstatus_taking_a_bath",
	"xstatus_tired",
	"xstatus_party",
	"xstatus_drinking_beer",
	":xstatus_thinking",
	"xstatus_eating",
	"xstatus_watching_tv",
	"xstatus_meeting",
	"xstatus_coffee",
	"xstatus_listening_to_music",
	"xstatus_business",
	"xstatus_shooting",
	"xstatus_having_fun",
	"xstatus_on_the_phone",
	"xstatus_gaming",
	"xstatus_studying",
	"xstatus_shopping",
	"xstatus_feeling_sick",
	"xstatus_sleeping",
	"xstatus_surfing",
	"xstatus_browsing",
	"xstatus_working",
	"xstatus_typing",
	"xstatus_cn1",
	"xstatus_cn2",
	"xstatus_cn3",
	"xstatus_cn4",
	"xstatus_cn5",
	"xstatus_de1",
	"pyicq:xstatus_de2",
	"xstatus_de3",
	"xstatus_ru1",
	"xstatus_ru2",
	"xstatus_ru3",
};
char* xmpp_lang(UINT8 lng)
{
	LANGUAGE_T LGID;
	
	DRM_GetCurrentLanguage(&LGID);
	

	if (LGID == LNG_RUSSIAN)
		UCS2toCP1251( xmpp_lang_rus[lng], xmpp_lg); 
	else
		UCS2toCP1251( xmpp_lang_eng[lng], xmpp_lg);
		
	return xmpp_lg;
}