
#include "vCard.h"
#include "protocol.h"
#include <file.h>

#define N_VCARD_FIELDS 52

extern XMPP_CALL_BACK_F *handleAppNtf;

const char *vcard_index[N_VCARD_FIELDS] =
{
  "JABBERID",
  "FN",
  
  "N/FAMILY",
  "N/GIVEN",
  "N/MIDDLE",
  "N/PREFIX",
  "N/SUFFIX",

  "NICKNAME",
  "BDAY",
  "GENDER",

  "ORG/ORGNAME",
  "ORG/ORGUNIT",
  "TITLE",
  "ROLE",

  "EMAIL/USERID",
  "EMAIL/HOME",
  "EMAIL/WORK",
  "EMAIL/INTERNET",
  "EMAIL/PREF",
  "EMAIL/X400",

  "TEL/HOME",
  "TEL/WORK",
  "TEL/VOICE",
  "TEL/FAX",
  "TEL/PAGER",
  "TEL/MSG",
  "TEL/CELL",
  "TEL/VIDEO",
  "TEL/BBS",
  "TEL/MODEM",
  "TEL/ISDN",
  "TEL/PCS",
  "TEL/PREF",
  "TEL/NUMBER",

  "ADR/HOME",
  "ADR/WORK",
  "ADR/POSTAL",
  "ADR/PARCEL",
  "ADR/DOM",
  "ADR/PREF",
  "ADR/POBOX",
  "ADR/EXTADD",
  "ADR/STREET",
  "ADR/LOCALITY",
  "ADR/REGION",
  "ADR/PCODE",
  "ADR/CTRY",
    
  "URL",

  "DESC",
  "TZ",
  
  "!PHOTO", //      
  "!LOGO" //      
};

char  vcard_buf[1042];

void Add_vCard_Value(char *jid, char *par_name, char *val)
{
  int field_id = 0;
  
  while (field_id<N_VCARD_FIELDS && strcmp(par_name, vcard_index[field_id]))
    field_id++;
  
	if (field_id < N_VCARD_FIELDS){
	
		strcat( vcard_buf, xmpp_lang(LG_VCARD_JABBERID + field_id) );
		UTF8toCP1251( val, vcard_buf+strlen(vcard_buf) );
		strcat( vcard_buf, "\n" );
		if ( !strcmp(par_name, "NICKNAME") ) {
				ContactListFindContact(jid)->vcard_nick = malloc( strlen(val) );
				UTF8toCP1251( val, ContactListFindContact(jid)->vcard_nick );
			}
				
	}
	handleAppNtf( XMPP_NTF__USER_INFO, jid, vcard_buf, strlen(vcard_buf) );
				
}
void DecodePhoto(WCHAR *uri, void *data)
{
	char *buf;
	size_t datlen, binlen;

	datlen = strlen(data);

	buf = malloc(datlen);
		
	if ( !buf ) {
		mfree(data);
		cprint("\x8C DecodePhoto: malloc error!\n");
		return;
	}
	memclr(buf, datlen);
	binlen = base64_decode(data, buf);
	dbgf("Base64Decode: binlen = %d, datlen: = \n", binlen, datlen );
  
	if ( binlen <= 0 ) {
		cprint("\x8C DecodePhoto: decode error (zero length)!\n");
		mfree(data);
		mfree(buf);
		return;
	}

	FILE_HANDLE_T f = FILE_Open( uri, FILE_WRITE_MODE );

	FILE_Write( f, buf, binlen );
	FILE_Close( f );


	// Cleanup
	mfree(buf);
	mfree(data);
}

//  
void SavePhoto( char *jid, XMLNode *photonode, BOOL logo)
{
	// Prepare path
	//     ...
	XMLNode *binval = XML_Get_Child_Node_By_Name(photonode, "BINVAL");
	
	if( !binval ) return;
 
	if(binval->value)
	{
		char 				buf_[256];
		WCHAR       		uri[256];
		WCHAR extension[] = L".jpg";
		
		u_strcpy(uri, DevilsDir);
		u_atou(jid, uri+u_strlen(uri));
	
  
		XMLNode *ph_node = XML_Get_Child_Node_By_Name(photonode, "TYPE");
		if(ph_node) {
		
			char *ph_node_val = ph_node->value;
			
			if(!strcmp(ph_node_val, "image/jpeg")) {
				u_strcpy(extension, L".jpg");
			} else if(!strcmp(ph_node_val, "image/png")) {
				u_strcpy(extension, L".png");
			} else if(!strcmp(ph_node_val, "image/gif")) {
				u_strcpy(extension, L".gif");
			}
		}// else    

		u_strcat(uri, extension);

		// Decode & write
		int ln = strlen(binval->value);
		
		if(logo)
			Add_vCard_Value( jid, "!LOGO", u_utoa(uri, buf_));
		else
			Add_vCard_Value( jid, "!PHOTO", u_utoa(uri, buf_));

		char *buf = malloc(ln + 1);
		
		if ( !buf ) 
			cprint("\x8C malloc buffer error!\n");
		else {
			memcpy(buf, binval->value, ln);
			buf[ln] = 0;
			DecodePhoto( uri, buf );
		}
	}
}

//  vCard
void Process_vCard(char *from, XMLNode *vCard)
{
  //     vCard
  char field_name[256];
  XMLNode *vCard_Node = vCard->subnode;
  XMLNode *vCard_NodeL2;
  
  vcard_buf[0] = NULL;
  while(vCard_Node)
  {
    if (vCard_Node->name)
    {
      if (vCard_Node->value)
        Add_vCard_Value(from, vCard_Node->name, vCard_Node->value);
		
	  if (strcmp(vCard_Node->name, "PHOTO") && strcmp(vCard_Node->name, "LOGO")) //       ...
      {
        vCard_NodeL2 = vCard_Node->subnode;
        while (vCard_NodeL2) //    
	    {  
          if (vCard_NodeL2->name && vCard_NodeL2->value)
          {
            sprintf(field_name, "%s/%s", vCard_Node->name, vCard_NodeL2->name);
            Add_vCard_Value(from, field_name, vCard_NodeL2->value);
          }

          vCard_NodeL2 = vCard_NodeL2->next;
        }
      }
    }

    vCard_Node = vCard_Node->next;
  }
  // Save photo :))
  XMLNode *photo = XML_Get_Child_Node_By_Name(vCard, "PHOTO");
  if(photo)
    if(photo->subnode) SavePhoto(from, photo, 0);
  
  XMLNode *logo = XML_Get_Child_Node_By_Name(vCard, "LOGO");
  if(logo)
    if(logo->subnode) SavePhoto(from, logo, 1);

}
//EOL,EOF
