#include <mem.h>
#include <utilities.h>

#include "sockio.h"
#include "protocol.h"

char        			*xml_buffer; 	//    
int                  	xml_buf_size=0; //    

char 					*Rstream_p;      //    
int   					Rstream_n;       //  
extern XMPP_CALL_BACK_F *handleAppNtf;

SO_PUBLIC size_t		session_traffic;

z_stream 				d_stream;        //  
z_stream 				c_stream;        //  

int HandleSockAnsw(int msg, int param)
{

	switch ( msg ) {
	
		case MSG_SOCKET_CREATE:
			dbg("SockAnsw: MSG_SOCKET_CREATE");
			SockConnect(xmpp_account.server, xmpp_account.port);
			break;
		case MSG_SOCKET_NOWRITE:
			dbg("SockAnsw: XOFF");
			break;
			
		case MSG_SOCKET_READY:
			dbg("SockAnsw: MSG_SOCKET_READY");
			if ( param != RESULT_OK ) {
				handleAppNtf(XMPP_NTF__SOCKET_ERROR, NULL, NULL, 0);
				XMPPDisconnect();
				break;
			}
			if ( xmpp_state != XMPPL_NOT_CONNECTED ) break;
			
			xmpp_state = XMPPL_SEND_WELCOME;
			handleAppNtf(XMPP_NTF__SEND_WELCOME, NULL, NULL, 0);
			XMPPSendWelcomePacket();	
			break;
			
		case MSG_SOCKET_DATA: //  
			dbg("SockAnsw: MSG_SOCKET_DATA");
			SockReadPacket(); //   
			break;
		
		case MSG_SOCKET_DISCONNECT: //   - 
			dbg("SockAnsw: DELETE");
			handleAppNtf(XMPP_NTF__SOCKET_DELETE, NULL, NULL, 0);
			XMPPDisconnect();
			break;
		
		case MSG_SOCKET_ERROR:  // 
			dbg("SockAnsw: ERROR");
			cprintf("\x8E Error: can't connect to internet\n");
			xmpp_state = XMPPL_ERROR;
			handleAppNtf(XMPP_NTF__SOCKET_ERROR, NULL, NULL, 0);
			XMPPDisconnect();
			break;
	}
	return 0;
}

int SockCreatSocket() {

	dbg("SockCreatSocket");
	
	handleAppNtf(XMPP_NTF__CONNECTING, NULL, NULL, 0);
	//  ,  
	if ( socket_create( SOCK_TCP, (const void *) HandleSockAnsw ) < 0 )  {
		dbg("SockCreatSocket: error! can't create socket!");
		handleAppNtf(XMPP_NTF__SOCKET_ERROR, NULL, NULL, 0);
		XMPPDisconnect();
		return -1;
	}
	
	Rstream_n = NULL;
	Rstream_p = NULL;
	session_traffic = NULL;
	
	return 0;
}


int SockConnect(const char *hostname, int port) {

	dbgf("SockConnect: hostname = %s, port = %i", hostname, port);

		if ( socket_connect(hostname, port) != -1 ) {
			dbg("SockConnect: OK...");
            return true;
		} else {
			dbg("SockConnect: ERROR...");
            return false;
		}

	return true;
}


int SockClose( void ) {

	dbgf("SockClose" );
    socket_close();
	free_socket();
	
	Rstream_n = NULL;
	session_traffic = NULL;
}

int SockSend(const char *data, size_t data_len) {

	size_t 	len;
	int 	err;
	char 	*compr_buf;
	size_t	compr_buf_len;

	if( !xmpp_account.zlib_on )
	{
		len = socket_send(data, data_len);
	}
	/*else
	{
		compr_buf_len = 1024;
		compr_buf = malloc( compr_buf_len );
		memclr(compr_buf, compr_buf_len);
		c_stream.next_in = (Byte*)data;
		c_stream.avail_in = data_len;
		c_stream.next_out = (Byte*)compr_buf;
		c_stream.avail_out = compr_buf_len;
		do {
		  c_stream.next_out = (Byte*)compr_buf;
		  c_stream.avail_out = compr_buf_len;
		  err = deflate(&c_stream, Z_SYNC_FLUSH);
		  
		   //     
		  if (err == Z_STREAM_ERROR) {
			cprintf("\x8E Error: Deflate %d\n", err);
			XMPPDisconnect();
		  }
		  len = socket_send(compr_buf, compr_buf_len - c_stream.avail_out);
		  
		} while( c_stream.avail_out == 0 );
	}*/
	session_traffic += len;
#ifdef DEBUG
	cprintf("SockSend %i b \n", len);
#	ifdef DEBUG_XML_DATA
		dbgf("SockSend: %i b,\n%s\n", len, data);
#	endif
#endif

	return len;
}

void * realloc( void * ptr, size_t sz )
{
	INT32	err = 0;

	void * 	newptr = suAllocMem(sz, &err);
	
	if ( newptr == NULL || err != 0 ) {
		dbgf("realloc: can't allocate %d bytes", sz);
		mfree( ptr );
		return NULL;
	}
	
	if ( newptr ) 
		memcpy( newptr, ptr, sz );
	else {
		dbg( "realloc: memory allocate fail, return NULL" );
		mfree( ptr );
		return NULL;
	}
	mfree(ptr);
	return newptr;
}

int SockReadPacket() {

	char	*p;
	char	rb[2048];
	char	c;
	int		i=0, j=0;

	i = socket_read( rb, sizeof(rb) ); if( i <= 0 ) return -1; 

	rb[i] = '\0';		//    

	session_traffic += i;
#ifdef DEBUG
	cprintf("SockRead %i b\n", i);
#	ifdef DEBUG_XML_DATA
		dbgf("SockRead: %i b,\n%s\n", i, rb);
#	endif	
#endif
	if ( xmpp_account.zlib_on ) {
	/*
	   // ZLib      
		d_stream.next_in  = (BYTE*)rb;
		d_stream.avail_in = (UINT32)i;
			do {
				d_stream.next_out = (BYTE*)((Rstream_p=realloc(Rstream_p,Rstream_n+i+1))+Rstream_n); //   
				d_stream.avail_out = (UINT32)i;
				int err = inflate(&d_stream, Z_SYNC_FLUSH);

					switch ( err ) {
				  
						case Z_NEED_DICT:
						case Z_DATA_ERROR:
						case Z_MEM_ERROR:
							cprintf("\x8E Error: Inflating: #%d\n", err);
							XMPPDisconnect();
						return;
					}

				Rstream_n += (i - d_stream.avail_out);
				
			} while(d_stream.avail_out == 0);
*/
	} else {
		Rstream_p = realloc(Rstream_p, Rstream_n+i); 

		if( !Rstream_p ) {
			Rstream_n = 0;
			return -1;
		}

		memcpy(Rstream_p+Rstream_n, rb, i);
		Rstream_n += i;
	}

	//  
	Rstream_p[Rstream_n] = 0; //  \0  
	i = 0; // 
	j = 0; // 
	p = Rstream_p;
	// if ((strstr(p,"</stream:stream>"))&&(xmpp_status == XMPPS_OFFLINE)) ; //  ,  .
	while((p=strstr(p,"<?xml version='1.0'"))) {i--; p++;} // -   xml,    
	p = Rstream_p;
	
	while((p=strstr(p,"<stream:stream"))) {i--; p++;} // -   stream,     (fuckin' XMPP)
	p = Rstream_p;
	
	while((c=*p++))
	{
		if (c=='<') {
			j++;
			if (*p!='/') i++; else i--;
		}

		//    : <tag/>
		if( c == '>' && (char)*(p-2) == '/' ) {
			i--;
			goto L_END;
		}

		if ( c == '>' ) {
		L_END:
		  j--;
			if ( (!i) && (!j) ) {
				// ,   
				int bytecount = p - Rstream_p;
				xml_buffer = malloc(bytecount);

				if( !xml_buffer ) {
					dbg( "SockRead: memory allocate for xml_buffer fail, return NULL" );
					return -1;
				}
				xml_buf_size = bytecount;
				memcpy(xml_buffer, Rstream_p, bytecount); 
				xml_buffer[bytecount] = 0; //    

				memcpy((p=Rstream_p), Rstream_p+bytecount, (Rstream_n-=bytecount)+1); //     \0
				XMPPProcessXMLPacket( xml_buffer, xml_buf_size );  // XML-        
				mfree(xml_buffer);
			}
		}
	}
	dbg("SockRead: done");
	return Rstream_n;
}
