/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2003 Imendio AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __LM_SHA_H__
#define __LM_SHA_H__

#define SHA1_HASH_SIZE 20

/* Hash size in 32-bit words */
#define SHA1_HASH_WORDS 5

struct _SHA1Context {
  UINT64 totalLength;
  UINT32 hash[SHA1_HASH_WORDS];
  UINT32 bufferLength;
  union {
    UINT32 words[16];
    UINT8 bytes[64];
  } buffer;
};

typedef struct _SHA1Context SHA1Context;


void SHA1Init (SHA1Context *sc);
void SHA1Update (SHA1Context *sc, const void *udata, UINT32 len);
void SHA1Final (SHA1Context *sc, UINT8 hash[SHA1_HASH_SIZE]);

#endif /* __LM_SHA_H__ */
