#ifndef XMPP_PROTOCOL_H
#define XMPP_PROTOCOL_H


#include "../src/app.h"		// mJabber Application
#include "../src/accounts.h"	

#include "sockio.h"			//    
#include "contact_list.h"

#include "sha.h"			//       SHA-1
#include "base64.h"			
#include "clients.h"		//  
#include "xmpp_lng.h"		// 
#include "xml_parser.h"

#define NOT_IN_LIST 				"Not in list"

#define XMPP_PING_TIMER_PERIOD 		(60*1000)
#define XMPP_PING_TIMER_ID 			(0x9FAA0)

#define UCS2toUTF8(ucs2, utf8) 		DL_Char_convUCS2toUTF8String(ucs2, u_strlen(ucs2)*sizeof(WCHAR), utf8, (u_strlen(ucs2)+1)*sizeof(WCHAR))
#define UTF8toUCS2(utf8, ucs2) 		DL_Char_convUTF8toUCS2String((UINT8*)utf8, strlen(utf8), ucs2, (strlen(utf8)+1)*sizeof(WCHAR))

#define  VERSION_NODE				"http://mjabber.elfov.net.ru"

typedef void XMPP_CALL_BACK_F( UINT32 nid, char * jid, void * data, UINT32 data_sz );

// 
typedef enum {
	XMPPS_NONE = 0,
	XMPPS_ONLINE, 	 // 
	XMPPS_FREECHAT,  //  
	XMPPS_AWAY, 	 // 
	XMPPS_DND, 		 //  
	XMPPS_NA,		 // 
	XMPPS_INVISIBLE, // 
	XMPPS_OFFLINE,	 // 
	XMPPS_UNAVAILABLE,
	XMPPS_ERROR,
	XMPPS_SUBSCRIBE,
	XMPPS_SUBSCRIBED,
	XMPPS_UNSUBSCRIBE,
	XMPPS_UNSUBSCRIBED,
	XMPPS_MAX
} XMPP_STATUS;

enum
{
	XMPPL_NOT_CONNECTED,    //  ,  
	XMPPL_SEND_WELCOME,
	XMPPL_ZLIB_INIT_ACK,    //    ZLib
	XMPPL_LOGIN,			//      PLAIN
	XMPPL_LOGGED,			//  
	XMPPL_BIND,				//   
	XMPPL_SESSION,			//   
	XMPPL_ROSTER,			//  
	XMPPL_BOOKMARKS,		//   
	XMPPL_PRESENSE,			//  
	XMPPL_READY,			//     
	XMPPL_ERROR             //  
};


enum {
	XMPP_NTF__ERROR = 0,
	XMPP_NTF__SET_HOST_ERROR,
	XMPP_NTF__SOCKET_DELETE,
	XMPP_NTF__SOCKET_ERROR,
	XMPP_NTF__JID_PW_ERROR,		
	XMPP_NTF__DISCONNECT,

	// XMPP connectiong state msgs
	XMPP_NTF__BEGIN = 0x0100,
	XMPP_NTF__CONNECTING,
	XMPP_NTF__SEND_WELCOME,
	XMPP_NTF__ZLIB_INIT_ACK,	
	XMPP_NTF__LOGIN,
	XMPP_NTF__LOGGED,
	XMPP_NTF__BIND,		//   
	XMPP_NTF__SESSION,	//   
	XMPP_NTF__ROSTER,	//    
	XMPP_NTF__BOOKMARKS,//   
	XMPP_NTF__PRESENSE,	//    
	XMPP_NTF__READY,	//      

	XMPP_NTF__EVENTS = 0x0200,
	XMPP_NTF__USER_STATUS = XMPP_NTF__EVENTS,
	XMPP_NTF__USER_XSTATUS,		//   -
	XMPP_NTF__USER_TYPING,		//  
	XMPP_NTF__USER_INFO,		//  vCard 
	XMPP_NTF__CLIENT_INFO,
	XMPP_NTF__INCOMING_MESSAGE,	//  
	XMPP_NTF__INCOMING_MESSAGE_SYSTEM,	//   
	XMPP_NTF__INCOMING_MESSAGE_UNSUPPORTED,

	XMPP_NTF__REGISTRATION_INSTRUCTIONS,
	XMPP_NTF__REGISTRATION_DATA,
	XMPP_NTF__REGISTRATION_SUCCESSFUL,
	
	XMPP_NTF__END
};
typedef struct {				//    UTF-8

	char        login[32];		// 
	char        server[32];		// 
	int			port;			// 
	char		resource[32];	// 
	UINT8		priority;		// 
	char        password[32]; 	// 
	char		time_zone[3]; 	//  
	UINT8		status;			//  
	char 		status_msg[7][64*2]; //  
	UINT8		xstatus;		// X-
	UINT8		muc_ajoin;		//   
	char        full_jid[256];	// login@server.ru/resource
	BOOL		zlib_enable;	// / ZLIB 
	BOOL		zlib_on;
	UINT32		ping_timer;
	BOOL		cl_save;
	
} XMPPACCOUNT_T;

typedef struct {				
	BOOL		edit_email;	//   E-mail
	BOOL		edit_username;

	char        username[32];	// 
	char        password[32];	// 
	char		email[32];	// Email

} RESISTER_INFO_T;

typedef struct {	// UTF-8		
	char        title[16];	// 
	char        str[128];	// 
} XSTATUS_T;


extern WCHAR        	DevilsDir[256];	//  devils/  
extern XMPPACCOUNT_T	xmpp_account;
extern UINT8 			xmpp_state;   	//  
extern const char *		presences[13];
extern ldrElf *			jabber_elf;

#ifdef __cplusplus
extern "C" {
#endif

SO_PUBLIC int XMPPInit( ldrElf * elf, XMPP_CALL_BACK_F * xmppCallBack ); 
SO_PUBLIC int XMPPUninit( void );
SO_PUBLIC int XMPPHandleEvent( EVENT_STACK_T * ev_st, APPLICATION_T * app );

SO_PUBLIC int XMPPConnect( SETTING_T * setting, ACCOUNT_T * acnt ); 	//   xmpp_account.server
SO_PUBLIC int XMPPDisconnect( void ); 				// 
SO_PUBLIC BOOL XMPPIsReady( void );					//  TRUE     

SO_LOCAL void XMPPSendWelcomePacket(void);			//  
SO_LOCAL void XMPPCompressionAsk(void);				//    
SO_LOCAL void XMPPUsePlainAuthReport(void);  		//      PLAIN
SO_LOCAL void XMPPBindResource(void);				//   
SO_LOCAL void XMPPInitSession(void);				//  
SO_LOCAL void XMPPSendRosterQuery(void);			//   
SO_LOCAL void XMPPSendBookmarksRequest(void);		//      
SO_LOCAL void XMPPSendPresence(void);				//   

SO_LOCAL void XMPPProcessXMLPacket(char* xmlbuf, int size);	//   
SO_LOCAL void XMPPProcessDecodedXML(XMLNode* node);			//    XML-
SO_LOCAL void XMPPProcessIqRequest(XMLNode* nodeEx);		//   Iq-
SO_LOCAL void XMPPProcessPresenceChange(XMLNode* nodeEx);	//   
SO_LOCAL void XMPPProcessIncomingMessage(XMLNode* nodeEx);	//   

SO_LOCAL void XMPPReportVersionInfo(char* id, char *to);
SO_LOCAL void XMPPReportTimeInfo(char* id, char *to);
SO_LOCAL void XMPPReportDiscoInfo(char* id, char *to);
SO_LOCAL void XMPPReportDelivery(char *mess_id, char *to);
SO_LOCAL void XMPPReportPING(char* id, char *to);

SO_PUBLIC void XMPPSendVersionRequest(const char *to);				//       JID
SO_PUBLIC void XMPPSendVcardRequest(const char *to);				//   vcard

SO_PUBLIC void XMPPSendTranportRegisterRequest(const char *to);		//   
SO_PUBLIC void XMPPSendTranportUnregisterRequest(const char *to);	//  
SO_PUBLIC void XMPPSendTranportRegisterLogin(const char *to, RESISTER_INFO_T *reg_info );

SO_LOCAL  void XMPPSendServiceUnavailable(const char *to, const char *id);
SO_LOCAL  void XMPPSendFeatureNotImplemented(const char *id, const char *to); 


SO_PUBLIC void XMPPCheckStatus(const char *to);	//      JID

SO_PUBLIC void XMPPSubscribe(const char *to);	//  
SO_PUBLIC void XMPPSubscribed(const char *to);	// 
SO_PUBLIC void XMPPUnsubscribed(const char *to);//  

SO_PUBLIC void XMPPSetStatus(UINT8 status, const char *message);		//  
SO_PUBLIC void XMPPSetXStatus(UINT8 xstatus, const char *message);		//  X-

SO_PUBLIC void XMPPAddContact(const char *jid, const char *group);	 	//  
SO_PUBLIC void XMPPRenameContact(const char *jid, const char *new_name);//  
SO_PUBLIC void XMPPMoveContact(const char *jid, const char *new_group);	//    
SO_PUBLIC void XMPPRemoveContact(const char *jid);						//  

SO_PUBLIC void XMPPSendMsg(const char *jid, const char *message);//  
SO_PUBLIC void XMPPSendAttention(const char *jid);
SO_PUBLIC void XMPPSendUrl(const char *jid, const char *url);	 //  

SO_PUBLIC void XMPPSendComposing( const char* to );
SO_PUBLIC void XMPPCancelComposing( const char* to );
/*
SO_PUBLIC void XMPPEnterConference(char *room, char *roomnick, char *roompass, UINT8 message_num); //   
SO_PUBLIC void XMPPLeaveConference(char* room); 							//   
*/
SO_LOCAL void InitZlib(void);

SO_LOCAL void XstatusInit( void );
SO_LOCAL void XstatusUninit( void );
SO_PUBLIC char * XstatusGetItemStr( int index );	//   -  utf-8
SO_PUBLIC void XstatusReplaceItemStr( int index, char *str ); // str =  -  win-1251

SO_PUBLIC char * CP1251toUTF8(const char * src, char * dst);
#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
