#ifndef XMPP_CONTACT_LIST_H
#define XMPP_CONTACT_LIST_H

#include <apps.h>
#include <list_ctrl.h>
#include <solib.h>

#include "xml_parser.h"


#define MSG_COUNT	16

enum {
	SUB_NONE,
	SUB_TO,
	SUB_FROM,
	SUB_BOTH
};

enum
{
	CONTACT_DEF,		//  
	CONTACT_GROUP,		// 
	CONTACT_MUC,		// 
	CONTACT_TRANSPORT	// 
	
};

typedef enum {
	AFFILIATION_NONE,
	AFFILIATION_OUTCAST,
	AFFILIATION_MEMBER,
	AFFILIATION_ADMIN,
	AFFILIATION_OWNER
	
}JABBER_GC_AFFILIATION;

typedef enum {
	ROLE_NONE,
	ROLE_VISITOR,
	ROLE_PARTICIPANT,
	ROLE_MODERATOR
}JABBER_GC_ROLE;

typedef struct
{
	JABBER_GC_AFFILIATION 	aff;
	JABBER_GC_ROLE 			role;
	char 					*real_jid;
	
}CONF_DATA;

enum {
	MSG_TYPE_IN,	// 
	MSG_TYPE_OUT,	// 
	MSG_TYPE_SYSTEM,// 
	MSG_TYPE_URL	// 

};
typedef struct {
    CLK_DATE_T  date;	// 
    CLK_TIME_T  time;	// 
    UINT8       type;	//   (//)
	UINT32		len;	//   
    char        *text;	//  
} MSG_T;

typedef struct
{
	char		*nick;			// 
	char		*vcard_nick;	//     vCard
	char		*jid;			// JID
	UINT8		group_id; 		//  
	UINT8		status;			//  
	UINT8		xstatus;		// X- 
	char		*status_msg;	//  
	char		*xstatus_msg;	// X- 
	char		*resource;		// 
	//char		*time
	UINT8		priority;		//  
	UINT8		subscription; 	// 
	BOOL 		new_msg;		//   
	UINT8		client_id;		//  
	BOOL		chat;			//    
	char		*password;		//  
	UINT8		message_num;
	UINT8		type;			//  
	BOOL 		composing;		//   
	CONF_DATA 	muc_privs;      //     -    -
	LIST		history;		//  
	
} CONTACT_T; //   .

void ContactListInit( void );
void ContactListUninit( void );

int ContactListFillRoster(XMLNode* items);	//  

int ContactListAddContact(char* jid, char* nick, UINT8 subscription, UINT8 group_id);	//    
int ContactListDeleteContact(const char* jid);	//  

int ContactListChangeParams(char* jid, char* nick, UINT8 subscription, UINT8 group_id);	//   
int ContactListChangeStatus(char *jid, UINT8 status);									//    
int ContactListChangeComposingStatus(char *jid, BOOL composing);						//   

void ContactListInitGroupsList(void);		//  
void ContactListKillGroupsList(void);		//   .     

int ContactListAddGroup(char *gr_name);		//    .       1
int ContactListGetGroupID(char *gr_name);	//  ID    gr_name  -1,   

SO_PUBLIC char* ContactListGetGroupNameByID(int gr_id);	//     ID = gr_id  NULL,   
SO_PUBLIC int ContactListGetGroupCount(void);			//   

SO_PUBLIC int ContactListUpdate( UINT32 params, UINT8 curren_group );
SO_PUBLIC int ContactListShort( void );
SO_PUBLIC int ContactListGetNum(void);							//     
SO_PUBLIC CONTACT_T* ContactListGetContact( int index );		//     
SO_PUBLIC CONTACT_T* ContactListFindContact( const char *jid );	//  jid'a    

SO_PUBLIC int ContactListGetContactCount(int group_id);			//      
SO_PUBLIC int ContactListGetOnlineContactCount(int group_id);	//       
SO_PUBLIC int ContactListGetIncomingMsgCount(void);				//    
SO_PUBLIC int ContactListGetChatCount(void);					//     
SO_PUBLIC int ContactListGetNumberOfOnlineUsers(void);			//    

SO_PUBLIC int ContactListMsgAdd( CONTACT_T * c, MSG_T * msg );
SO_PUBLIC int ContactListMsgFreeQueue( CONTACT_T * c );
SO_PUBLIC int ContactListMsgGetNum( CONTACT_T * c );
SO_PUBLIC MSG_T * ContactListMsgGet( CONTACT_T * c, UINT16 i );

int ContactListAddSystemMessage(char* jid, char status, char* status_msg);

char*  UtilGetJIDByFullJID(char * full_jid, char jid[]);	// login@jabber.ru/resourse > login@jabber.ru
char*  UtilGetResourceByFullJID(char* full_jid);			// login@jabber.ru/resourse > resourse
int    UtilGetPresenceIndex(char* presence_str); 			//          
int	   UtilGetAffRoleIndex(char* str);						//      /    
char*  UtilGetIcqTransport( void );

#endif
