#include <apps.h> 
#include <charset_conv.h>
#include "lng.h"

static char	lg[128];

static const WCHAR *lang_rus[] = 
{
	/*Russian*/
	L"Подключится",
	L"Отключится", 
	L"Статус",
	L"X-Статус", 
	L"Включить звук", 
	L"Отключить звук", 
	L"Настройки", 
	L"О продукте...", 
	L"Выход", 
	L"Свернуть", 
	L"Добав. контакт", 
	
	L"Чат", 
	L"Сообщение...", 
	L"Проверить статус", 
	L"Инфо о контакте",
	L"Инфо o клиенте",
	L"Копировать JID", 
	L"Подписка",
	L"Переместить в группу",
	L"Удалить...",
	L"Переименовать",
	L"Регистрация",
	L"История",

	L"Меню Контакта",
	L"Копировать",
	L"Цитировать",
	L"Вставить",
	L"Очистить историю",
	L"Удалить чат",
	L"Отправить ссылку",
	
	L"Обновить ник",
	
	L"Онлайн",
	L"Готов поболтать",
	L"Отсутствую",
	L"Не беспокоить",
	L"Недоступен",
	L"Невидимый",
	L"Оффлайн",
	L"Unavailable",
	L"Error",
	
	L"Имя пользвателя:",
	L"Сервер:",
	L"Порт:",
	L"Ресурс:",
	L"Приоритет:",
	L"Пароль:",
	
	L"Пользователь:",
	L"Ивент запуска:",
	L"Часовой пояс:",
	L"Консоль:",
	L"Цветовая палитра:",
	L"Громкость:",
	L"Исходящ. оп. о наборе:",
	L"Автоподключение:",
	L"Скрывать пуст. группы:",
	L"Разв-ть при нов. сообщ.:",
	L"Исп-вать редактор UIX:",
	L"Хранить историю:",
	L"ZLIB сжатие траффика:",
	
	L"Число сообщений:",
	
	L"Смайлики",
	
	L"Выбрать",
	L"Назад",
	L"Открыть",
	L"Меню",
	L"Отправить",
	L"Изменить",
	L"KM",
	L"Войти",
	L"Пожалуйста, подождите...\n",
	L"Регистрация прошла успешно...\n",
	
	
	L"Клиент: ",
	L"Группа: ",
	L"Статусное сообщение: ",
	L"xTraz сообщение: ",
	
	L"Авторизовать",
	L"Запрос авторизации",
	L"Отмена авторизации"
	
}; 

static const WCHAR *lang_eng[] = 
{
	/*English*/
	L"Connect", 
	L"Disconnect", 
	L"Status",
	L"X-Status", 
	L"Sound on", 
	L"Sound off", 
	L"Settings", 
	L"About...", 
	L"Exit", 
	L"Hide", 
	L"Add contact", 
	
	L"Chat", 
	L"Message...", 
	L"Check status",
	L"Contact info",
	L"Client info",
	L"Copy JID", 
	L"Subscription",
	L"Move to group",
	L"Delete...",
	L"Rename",
	L"Registaration",
	L"History",

	L"Contact menu",
	L"Copy",
	L"Quote",
	L"Paste",
	L"Free history",
	L"Delete chat",
	L"Send URL",
	
	L"Update nick",
	
	L"Online",
	L"Free for chat",
	L"Away",
	L"Do not distrub",
	L"N/A",
	L"Invisible",
	L"Offline",
	L"Unavailable",
	L"Error",
	
	L"Username:",
	L"Server:",
	L"Port:",
	L"Resource:",
	L"Priority:",
	L"Password:",
	
	L"User:",
	L"Run event:",
	L"Time zone:",
	L"Console:",
	L"Color theme:",
	L"Volume:",
	L"Coming notif. of set:"
	L"Autoconnect:",
	L"Hide empty groups:",
	L"Show app under new msg:",
	L"Use UIX editor:",
	L"Save history:",
	L"ZLIB compression:",
	
	L"Message Number: ",
	
	L"Smiles",
	
	L"Select",
	L"Back",
	L"Open",
	L"Menu",
	L"Send",
	L"Edit",
	L"CM",
	L"Enter",
	L"Please wait...\n",
	L"Registration successful...\n",
	
	L"Client: ",
	L"Group: ",
	L"Status message: ",
	L"xTraz message: ",
	
	L"Authorize",
	L"Request authorization",
	L"Cancellation of authorization"
}; 

const char *xstatus_eng[] = 
{
	"N/A",
	"Angry",
	"Duck",
	"Tired",
	"Party",
	"Beer",
	"Thinking",
	"Eating",
	"TV",
	"Friends",
	"Coffee",
	"Music",
	"Business",
	"Camera",
	"Funny",
	"Phone",
	"Games",
	"College",
	"Shopping",
	"Sick",
	"Sleeping",
	"Surfing",
	"Internet",
	"Engineering",
	"Typing",
	"Canape",
	"Pocket PC",
	"Mobile",
	"Drowse",
	"WC",
	"Question",
	"Way",
	"Heart",
	//"Cigarette",
	//"Sex",
	"Search",
	"Love",
	"Journal"
	
}; 

char* lang(UINT8 lng)
{
	LANGUAGE_T LGID;
	
	DRM_GetCurrentLanguage(&LGID);
	

	if (LGID == LNG_RUSSIAN)
		UCS2toCP1251( lang_rus[lng], lg); 
	else
		UCS2toCP1251( lang_eng[lng], lg);
		
	return lg;
}
