#include "app.h"
#include "background.h"
#include "icons.h"

#include "../src_xmpp/protocol.h"

static UINT32 				BackgroundKeypress( EVENT_STACK_T *ev_st,  APPLICATION_T *app );
static UINT32 				DrawDesktopStatus( EVENT_STACK_T *ev_st,  APPLICATION_T *app );

static UINT8  				pkey;

EVENT_HANDLER_ENTRY_T background_state_handlers[] =
{
	{ EV_KEY_RELEASE,           BackgroundKeypress },
	{ EV_IDLE_FOCUS,             DrawDesktopStatus },
    { STATE_HANDLERS_END,         			  NULL },
};


void AppHandleEvent( EVENT_STACK_T *ev_st, APPLICATION_T *app, APP_ID_T app_id, REG_ID_T reg_id )
{
	XMPPHandleEvent( ev_st, app );
	UIX_HandleEvent( ev_st, app );

	APP_HandleEvent(ev_st, app, app_id, reg_id);
}

UINT32 appHide( APPLICATION_T *app )
{
    dbg("appHide");

	return AppChangeState(app, APP_STATE_BG, FALSE);
	
}
UINT32 appShow( APPLICATION_T *app )
{
	APP_ELF_T		*papp = (APP_ELF_T *)(app);
    dbg("appShow");
	
	InitResouces();
	return AppChangeState(app, papp->last_state, TRUE);
}

UINT32 BackgroundStateEnter( EVENT_STACK_T * ev_st, APPLICATION_T * app, ENTER_STATE_TYPE_T type )
{
	UINT32			status;
	dbgf("BackgroundStateEnter: Enter, type = %d", type);
	status = RESULT_OK;
	if ( type == ENTER_STATE_ENTER ) {
		status = APP_ChangeRoutingStack( app, ev_st,
			AppHandleEvent,
			AFW_PREPROCESSING,
			AFW_POSITION_TOP,
			1,
			AFW_APP_CENTRICITY_NONE );
	}
	
	return status;
}

UINT32 BackgroundStateExit( EVENT_STACK_T * ev_st, APPLICATION_T * app, EXIT_STATE_TYPE_T type )
{
	UINT32			status;
	dbgf("BackgroundStateExit: Enter, type = %d", type);
	status = RESULT_OK;
	if ( type == EXIT_STATE_EXIT ) {
		status = APP_ChangeRoutingStack( app, ev_st,
			AppHandleEvent,
			AFW_FOCUS,
			AFW_POSITION_TOP,
			1,
			AFW_APP_CENTRICITY_SECONDARY );
	}
	return status;
}

/*  , EV_KEY_PRESS    */
UINT32 BackgroundKeypress( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
	
    if (GET_KEY(ev_st) == BACKGROUND_RESTORE_KEY2) { // # 
        if(pkey == BACKGROUND_RESTORE_KEY1) {
            pkey = 0;
            APP_ConsumeEv(ev_st, app);
            appShow(app);
        }
		
    } else if (GET_KEY(ev_st) == BACKGROUND_RESTORE_KEY1) {  // *
        pkey = GET_KEY(ev_st);
    } else {
        pkey = 0;
    } 
	

    return RESULT_OK;
}

extern AHIBITMAP_T 		*image_icons, *image_xstatus, bmp_status_icons;
	
UINT32 DrawDesktopStatus( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
	
	if( !WorkingTable() ) return RESULT_OK;
	
	if ( ContactListGetIncomingMsgCount() ) {					//   
		char	buf[8];
		DrawIcon(&bmp_status_icons, 1, 16, setting.status);  		//  
		DrawIcon(image_icons, 18, 16, ICON_IN_MSG );
		strcpy(buf, "#");
		itoa(ContactListGetIncomingMsgCount(), buf+strlen(buf), 10);	//   
		SetFgColor(0xFFFFFF);
		DrawText(buf, 35, 20, 0);
	} else if( XMPPIsReady() ) {
		DrawIcon(&bmp_status_icons, 1, 16, setting.status);  		//  
		DrawIcon(image_xstatus, 18, 16, setting.xstatus ); 	//  x-

	} else {
		DrawIcon(&bmp_status_icons, 1, 16, XMPPS_OFFLINE);  		//   
	}
	
	AHG_Flush();
	
    return RESULT_OK;
}
