#ifndef START_MENU_H
#define START_MENU_H
#include <apps.h> 	// ! !
#include <loader.h>
#include <ATI.h>
#include <paint.h>
#include <u.h>
#include <mem.h>
#include <utilities.h>
#include <func.h>
#include <res_def.h>
#include <charset_conv.h>

#include "../src_xmpp/contact_list.h"

#include "../../libuix/include/api.h"
#include "../../libuix/include/cs.h"


#ifdef	EMUELF
#	define  DrawLine			_DrawLine
#	define  DrawRect			_DrawRect
#	define  FillRect			_FillRect
#	define  DrawText			_DrawText
#	define  DrawTextW			_DrawTextW
#endif

#ifdef	DEBUG
#define  ELF_NAME				"mJabber_dbg"
#define  ELF_NAME_W			   L"mJabber_dbg"
#else
#define  ELF_NAME				"mJabber"
#define  ELF_NAME_W			   L"mJabber"
#endif

#define  ELF_VER				"v0.5"
#define  ELF_VER_W			   L"v0.5"
#define  DEBUG_APP_NAME			ELF_NAME
#define  LOG_FILE  				L"file://b/"ELF_NAME".log"

#include <tadbg.h> 	// 

// ----------------------------------------------------------------------------------------- //

/*    .      */
typedef struct
{ 
    APPLICATION_T		apt; /*   ,   */
	UINT8				last_state;		//     
	UINT8       		entries_num;	// -   .
} APP_ELF_T;

/*   */
typedef enum
{
    APP_STATE_ANY, /* ANY-state   */
	APP_STATE_INIT, 	//  
	APP_STATE_BG, 		//  .
	APP_STATE_MAIN, 	//  .
	APP_STATE_EDIT, 	// -
	APP_STATE_VIEWER, 	// .
	APP_STATE_MENU, 	// .
	APP_STATE_CONNECT, 	// .
	APP_STATE_SMILES, 	//   .
	APP_STATE_CHAT,  	//  .
	APP_STATE_SETTING,	// .
    APP_STATE_MAX /*   */
} APP_STATES_T;


typedef enum
{
	MAIN, 				//  .
	CHAT,				// 
	SET_STATUS, 		//   .
	SET_XSTATUS, 		//   x-.
	CONNECT, 			// .
	MAIN_MENU, 			//  .
	SETTINGS, 			//  .
	CONTACT_MENU,		//  
	SUBSCRIPTION_MENU,	//   .
	MUC_ENTER_UI,		//    
	CLIENT_INFO, 		//   .
	CONTACT_INFO, 		//   .
	MSG_VIEWER,
	REGISTRATION,		//   .
	ADD_CONTACT,		//  .
	SELECT_GROUP,		//   
	
	ACCOUNTS_SELECT,
	ACCOUNTS_EDIT,
	
	EDIT_MSG,	 		//  .
	EDIT_URL,	 		//  URL.
	EDIT_STATUS_MSG,	//  -.
	EDIT_XSTATUS_MSG,	//  x--.
	
	EDIT_LOGIN, 		//  .
	EDIT_SERVER, 		//  .
	EDIT_PORT, 			//  .
	EDIT_RESOURCE, 		//  .
	EDIT_PRIORITY, 		//  .
	EDIT_PASSWORD, 		//  .
	
	
	EDIT_EV_CODE, 		//   .
	EDIT_TIME_ZONE, 	//   .
	EDIT_RENAME,		//  .
	
	EDIT_REG_USERNAME,	
	EDIT_REG_PASSWORD,	
	EDIT_REG_EMAIL,
	
	EDIT_MUC_NICK,		
	EDIT_MUC_PASS,
	EDIT_MUC_MESSAGE_NUM,
	ABOUT, 				//  ...
	EXIT 				// 
}STATES_T;

typedef struct	//    win-1251
{
	UINT8		account_current;//    	
	UINT32 		ev_code; 		//  
	BOOL 		sound_on;		// true -  
	char		time_zone[3]; 	//  
	UINT8		status;			//  
	char 		status_msg[7][64]; //  
	UINT8		xstatus;		// X-
	UINT8		muc_ajoin;		//   
	BOOL		show_off_contacts;//   
	UINT8		console;		//     EP2.0
	UINT8		color_theme;	//  
	UINT8		volume;			// 
	BOOL		composing_events;//    
	BOOL		auto_connect;	// 
	BOOL		hide_empty_groups;//   
	BOOL		show_app_under_new_msg;	//     .
	BOOL		use_uix_editor;	// true -    UIX.
	BOOL		save_history;	// true -  
	BOOL		zlib_enable;	// true - zlib  
	
} SETTING_T; // 

extern SETTING_T 	setting;

typedef struct
{
	UINT8		select;		//    
	UINT8		menu;		//  
	UINT8		chat;		//  
	UINT8		group;		//   
	UINT8		first_idx;	//     
	UINT8		sel_account;
	UINT8		connect_percent;	//  
	char		connect_text[128];
	UINT8		x;			// 
	UINT8		y;			//    
} ITEM;

typedef struct
{
	UINT32  text;			// 
	UINT32  text2;			//  
	UINT32  cursor;			// 
	UINT32  cursor2;		//  
	UINT32	clock;			// 
	UINT32 	chat;			//    
	UINT32  background;		// 
	UINT32  bg_element;		//    
	UINT32  border;			//    

} COLOR; //  

#define  COLOR_THEME_COUNT	5
extern const char* color_theme[];

ldrElf * _start( WCHAR * uri, WCHAR * params );

static UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 ); 
static UINT32 destroyApp( EVENT_STACK_T *ev_st,  APPLICATION_T *app ); // 
	   UINT32 AppChangeState( APPLICATION_T * app, UINT8 new_state, BOOL force_show );
static UINT32 HandleChangeState( EVENT_STACK_T * ev_st, APPLICATION_T * app );

static UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );
static UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );
static UINT32 ViewerStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );
static UINT32 MenuStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );
static UINT32 ConnectStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );
static UINT32 SmilesStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );
static UINT32 ChatStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );
static UINT32 SettingStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type );

static UINT32 StateExit( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  EXIT_STATE_TYPE_T type );

static UINT32 HandleUITokenGranted( EVENT_STACK_T * ev_st, APPLICATION_T * app );
static UINT32 HandleTimer( EVENT_STACK_T *ev_st,  APPLICATION_T *app );
static UINT32 HandlePlay( EVENT_STACK_T *ev_st,  APPLICATION_T *app );
static UINT32 HandlePlayComplete( EVENT_STACK_T *ev_st,  APPLICATION_T *app );

static UINT32 HandleReqExit( EVENT_STACK_T *ev_st,  APPLICATION_T *app );	//    PM
static UINT32 HandleNavigate( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 idx );	//   
static UINT32 HandleSelect( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 idx ); //   
static UINT32 HandleBack( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode ); //   

static UINT32 HandleEditDone( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 l ); // "Done"   UIX

static UINT32 HandleEditData( EVENT_STACK_T *ev_st,  APPLICATION_T *app );
static UINT32 HandleEditOk( EVENT_STACK_T *ev_st,  APPLICATION_T *app );	// "Ok"   UIS
static UINT32 HandleEditCancel( EVENT_STACK_T *ev_st,  APPLICATION_T *app ); // ""   UIS

// Chat
static UINT32 HandleMessage( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );
static UINT32 HandleContactMenu( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );
static UINT32 HandleCopy( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );	
static UINT32 HandleQuote( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );	// 
static UINT32 HandlePaste( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );	// 
static UINT32 HandleFreeHistory( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode ); //  
static UINT32 HandleDeleteChat( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode ); //  
static UINT32 HandleSendUrl( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode ); //  

static UINT32 HandleUpdateNick( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );	//  

static UINT32 HandleSend( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );	//  
static UINT32 HandleSmiles( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );	// 
static UINT32 HandleSendTranportRegisterLogin( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );
static UINT32 HandleAccountSelect( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );
static UINT32 HandleAccountAddNew( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );
static UINT32 HandleAccountDelete( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode );

//static void * ListEntryReq( APPLICATION_T * app, UINT32 idx );
static void * MenuEntryReq( APPLICATION_T * app, UINT32 idx );
static void * ChatEntryReq( APPLICATION_T * app, UINT32 idx );
static void * SettingEntryReq( APPLICATION_T * app, UINT32 idx );

//  
static UINT32 ListKeypress( EVENT_STACK_T * ev_st,  APPLICATION_T * app ); //     .
static UINT32 ConnectKeypress( EVENT_STACK_T * ev_st,  APPLICATION_T * app );//     
static UINT32 SmilesKeypress( EVENT_STACK_T * ev_st,  APPLICATION_T * app ); //       

static UINT32 DrawSmiles(void);		//    
static UINT32 DrawList( APPLICATION_T *app );	 //  

static UINT32 DrawTitleBar(UINT8 icon, const char *text);				// 
static UINT32 DrawSoftBar(const char *left, const char *right);			//  
static UINT32 DrawMainSoftBar(void);									//    
static UINT32 DrawScroll( UINT8 pos, UINT8 cnt, UINT8 size );			// 
	   UINT32 DrawIcon(AHIBITMAP_T *bitmap, UINT8 x, UINT8 y, UINT8 icon_index);

static UINT32 DrawLoadingScreen(char *text, UINT8 percent);	
static UINT32 DrawContact(CONTACT_T *contact, UINT8 x, UINT8 y);

static UINT32 SelectItemMainMenu( EVENT_STACK_T *ev_st,  APPLICATION_T *app );		//    
static UINT32 SelectItemContactMenu( EVENT_STACK_T *ev_st,  APPLICATION_T *app );	//    
static UINT32 SelectItemSmiles( EVENT_STACK_T *ev_st,  APPLICATION_T *app );		//  
static UINT32 SelectItemSubscriptionMenu( EVENT_STACK_T *ev_st,  APPLICATION_T *app ); //

static UINT32 ReadSetting( void ); 	//  
static UINT32 SaveSetting( void ); 	//  

static UINT32 MsgDb_MsgAdd(char *jid, char *text, UINT8 type);//    	
static UINT32 MsgDb_LoadDb(char *jid); 			//   15           
static UINT32 MsgDb_GetCount(char *jid); 		//     

static UINT32 LoadTheme( UINT8 theme_index );	//   
	   UINT32 InitResouces( void );	//  

static UINT32 Create( WCHAR *name );	// 
static UINT32 SetVol(BOOL vol); //  

static UIX_ICON_T ElfGetIcon( AHIBITMAP_T *image, UINT8 i );

static void XMPPProtocolNonify( UINT32 id, char * jid, void * data, UINT32 data_sz );

#ifdef	DEBUG
static void	ReportPhoneInfo( void );
#endif	

#endif
