#include "app.h"
#include "lng.h"
#include "icons.h"
#include "background.h"

#include "accounts.h"

#include "../src_xmpp/protocol.h"

AHIBITMAP_T 		bmp_status_icons;

AHIBITMAP_T			*image_icons,
					*image_icq,
					*image_mrim,
					*image_vkontakte,
					*image_logo,
					*image_smiles,
					*image_clients,
					*image_xstatus;
 
static COLOR		color; 					// Цветовая палитра				
static STATES_T		state;
static BOOL 		im_connect;

static RESISTER_INFO_T    reg_info;

WCHAR        		pathMsgDb[256], 		// папка history/
					file_cfg[256]; 			// Jabber.cfg
					
static UINT8        max_items;				// Сколько пунктов может влезть на экран
					
static char			quoting[128],			// Загаловок цитаты
					msg[2048+1], 			// Буффер для редактора сообщений
					viewer_content[2048+1]; // Буффер для просмотощика	

MME_GC_MEDIA_FILE 	mme_media_file = NULL; 	// id открытого mp3 файла
UIS_DIALOG_T        dialog; 				// Диалог
SETTING_T 			setting;				// Настройки
ldrElf       	 	elf;					// Структура эльфа
ITEM 				item; 					// Пункты меню

const char* color_theme[] = {
							 "Black",
							 "Green",
							 "MRIM",
							 "Silver",
							 "D[i]chat"
};

/* Название приложения. Длина строки именно такая и никакая иначе */
const char app_name[APP_NAME_LEN] = ELF_NAME; 

/* Обработчики событий для каждого state-а */
/* Обработчики событий для APP_STATE_ANY (используется в любом state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
	{ EV_REVOKE_TOKEN,	  APP_HandleUITokenRevoked },
	{ EV_TIMER_EXPIRED,       		   HandleTimer },
	{ EV_PM_API_EXIT,				    destroyApp },	// PM API: cmd EXIT
	{ EV_MME_OPEN_SUCCESS,              HandlePlay },
    { EV_MME_PLAY_COMPLETE,     HandlePlayComplete },
	{ STATE_HANDLERS_RESERVED,	 HandleChangeState },
    { STATE_HANDLERS_END,           		  NULL },
};
static EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
	{ EV_GRANT_TOKEN,	      HandleUITokenGranted },
	{ STATE_HANDLERS_END,					  NULL }
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_INK_KEY_PRESS,               ListKeypress },
    { STATE_HANDLERS_END,                     NULL },
};
static EVENT_HANDLER_ENTRY_T edit_state_handlers[] =
{
    { EV_DATA,                      HandleEditData },
    { EV_DONE,                        HandleEditOk },
	{ EV_CANCEL,                  HandleEditCancel },
    { STATE_HANDLERS_END,         	          NULL },
};
static EVENT_HANDLER_ENTRY_T connect_state_handlers[] =
{
    { EV_INK_KEY_PRESS,            ConnectKeypress },
    { STATE_HANDLERS_END,                     NULL },
};
static EVENT_HANDLER_ENTRY_T smiles_state_handlers[] =
{
    { EV_INK_KEY_PRESS,             SmilesKeypress },
    { STATE_HANDLERS_END,                     NULL },
};

/* Таблица соответствий обработчиков, состояний и функций входа-выхода из состояния.
   Порядок состояний такой же, как в enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { APP_STATE_ANY,              // State
      NULL,                       // Обработчик входа в state
      NULL,                       // Обработчик выхода из state
      any_state_handlers          // Список обработчиков событий
    },
	{ APP_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },
	{ APP_STATE_BG,
      BackgroundStateEnter,
	  BackgroundStateExit,
      background_state_handlers
    },
    { APP_STATE_MAIN,
      MainStateEnter,
      StateExit,
      main_state_handlers
    },
	{ APP_STATE_EDIT,
      EditStateEnter,
      StateExit,
      edit_state_handlers
	},
	{ APP_STATE_VIEWER,
      ViewerStateEnter,
      StateExit,
      NULL
    },
	{ APP_STATE_MENU,
      MenuStateEnter,
      StateExit,
      NULL
    },
	{ APP_STATE_CONNECT,
      ConnectStateEnter,
      StateExit,
      connect_state_handlers
    },
	{ APP_STATE_SMILES,
      SmilesStateEnter,
      StateExit,
      smiles_state_handlers
    },
	{ APP_STATE_CHAT,
      ChatStateEnter,
      StateExit,
      NULL
    },
	{ APP_STATE_SETTING,
      SettingStateEnter,
      StateExit,
      NULL
    }
	
};

static const APP_STATE_NAME_TABLE_T state_name_table[] =
{
	{APP_STATE_ANY,			"ANY"},
	{APP_STATE_INIT,		"INIT"},
	{APP_STATE_BG,			"BACKGROUND"},
	{APP_STATE_MAIN,		"MAIN"},
	{APP_STATE_EDIT,		"EDIT"},
	{APP_STATE_VIEWER,		"VIEWER"},
	{APP_STATE_MENU,		"MENU"},
	{APP_STATE_CONNECT,		"CONNECT"},
	{APP_STATE_SMILES,		"SMILES"},
	{APP_STATE_CHAT,		"CHAT"},
	{APP_STATE_SETTING,		"SETTING"},
	{APP_STATE_MAX,			NULL}
};

/* Это entry для всех эльфов, должна быть объявлена именно так */
/* uri - путь к эльфу (аналогично argv[0]) */
/* params - параметры эльфа (аналогично остальным argv) */
ldrElf * _start( WCHAR * uri, WCHAR * params )
{
    ldrElf *		pelf;
	UINT32			reserve;
	UINT32			status;
	int				i;
	dbg( "======================================");
	dbg( ELF_NAME" "ELF_VER" "__DATE__" / " __TIME__ );
	dbg("_start: Enter");
	
	// ищем запущеный эльф по имени эльфа
	pelf = ldrFindElf(app_name);
	if ( pelf != NULL ) {
		// приложение уже запущено, вызвать запущеное
		ldrSendEvent( pelf->evbase );
		return NULL;
	}
	// база ивентов
	reserve = ldrRequestEventBase();
	// заполняем структуру эльфа
	elf.name = (char *)app_name;
	elf.app = NULL;
	
	// инитим таблицы ивентов
	for ( i=0; i<APP_STATE_MAX; i++ )
		reserve = ldrInitEventHandlersTbl((EVENT_HANDLER_ENTRY_T *)state_handling_table[i].htable, reserve);
	
	i = u_strlen( uri ) - 1;
	while ( i >= 0 && uri[i] != L'/' ) i--;
	i++;
	elf.dir = malloc( i * sizeof(WCHAR) );
	if ( elf.dir )
		u_strncpy( elf.dir, uri, i );	// папка эльфа с слэшом в конце

	u_mkpath(pathMsgDb, elf.dir, L"history/", 0);
    DL_FsMkDir(pathMsgDb, 0);
	
	// Получаем путь к папке с аватарами
	u_mkpath(DevilsDir, elf.dir, L"devils/", 0);
    DL_FsMkDir(DevilsDir, 0);
	
	// Получаем путь к конфигу
	u_mkpath(file_cfg, elf.dir, ELF_NAME_W L".cfg", 0);
	
	ReadSetting();
	InitResouces();	// Загружем графику
	
	LoadTheme(setting.color_theme);	
	
	if( setting.ev_code ) 
		elf.evbase = setting.ev_code;
	else
		elf.evbase = reserve ++;
	
	/* Регистрируем приложение */
	 status = APP_Register( &elf.evbase,            // На какое событие должно запускаться приложение
                           1,                       // Кол-во событий, на которое должно запускаться приложение
                           state_handling_table,    // Таблица состояний
                           APP_STATE_MAX,            // Количество состояний
                           (void*)startApp );   // Функция, вызываемая при запуске
	
	if ( status == RESULT_OK )
		ldrSendEvent( elf.evbase );
	 else {
		cprint(DEBUG_APP_NAME ":\x84 can't register app\n");
		return NULL;
	}

#ifdef DEBUG
	ReportPhoneInfo();
#endif

    return &elf; 
}

/* Функция вызываемая при старте приложения */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )
{
	APP_ELF_T *		papp;
	UINT32			status;
	LIST 				___; 
	List_Init(&___, NULL);
		
	// Если приложение уже запужено то разворачиваем его
	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK ) {
		appShow( elf.app );
		return RESULT_FAIL;
	}
	
	AHG_Init();	// Инит драйвера 
	max_items = 9;
	
	// Устанавливаем громкость
	if( !setting.sound_on )
		SetVol(0);	// Безвучный режим	
	else
		SetVol(1);	// Звук включен
	
    papp = (APP_ELF_T*)APP_InitAppData((void*)AppHandleEvent, 
                                            sizeof(APP_ELF_T), // Размер структуры приложения
                                            reg_id,
                                            0,
											0,			// history size
											1,			// priority
											AFW_APP_CENTRICITY_SECONDARY,
											AFW_FOCUS,
											AFW_POSITION_TOP );	
	
	if ( !papp )
	{
		dbg("can't init app data");
		ldrUnloadElf();
		return RESULT_FAIL;
	}
	
    status = APP_Start( ev_st,
                        &papp->apt,
                        APP_STATE_INIT, // Начальное состояние
                        state_handling_table,
                        destroyApp,
                        app_name,
                        state_name_table );
	
	// Теперь приложение может обрабатывать события
	if ( status == RESULT_OK ) {
		elf.app = &papp->apt;
		XMPPInit( &elf, XMPPProtocolNonify );
		AccountInit();	// Инит учетных записей
		cprint(ELF_NAME ":\x82 Started\n");
	}
	else
	{
		cprint(ELF_NAME ": Start Failed!\n");
		APP_HandleFailedAppStart( ev_st, &papp->apt, 0 );
		return ldrUnloadElf(); 
	}
	
	
	if( setting.auto_connect ) APP_UtilChangeState(APP_STATE_CONNECT, ev_st, &papp->apt );
	
    return RESULT_OK;
}


/* Функция выхода из приложения */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
	UINT32			status;
	EVENT_T *		event = AFW_GetEv(ev_st);
	
	dbgf("destroyApp: Enter, event = 0x%p, code = 0x%X", event, event->code);
		
	if ( event != NULL ) {
		// это нажатие красной кнопки
		appHide(app);
		return RESULT_OK;
	}
	
	AHG_Done();	// Завершаем работу драйвера ATI
		
	if ( state_handling_table[app->state].exit_fn != NULL && app->state != APP_STATE_BG )
		(state_handling_table[app->state].exit_fn)(ev_st, app, EXIT_STATE_EXIT);
		
	cprint( ELF_NAME ":\x8E Exit\n" );
	
	AccountUninit();
	XMPPUninit();
	
    /* Завершаем работу приложения */
    status = APP_Exit( ev_st, app, NULL );
	
    if(!setting.ev_code) ldrUnloadElf();
   
    return status;
}
// Изменить стэйт + насильно показать
UINT32 AppChangeState( APPLICATION_T * app, UINT8 new_state, BOOL force_show )
{
	ADD_EVENT_DATA_T	ed;
	UINT32				ev_code;
	
	ed.data_tag = 0;
	ed.data.pad[0] = new_state;
	ed.data.pad[1] = force_show;
	
	ev_code = ldrFindEventHandlerTbl(any_state_handlers, HandleChangeState);
	if ( ev_code > 0 )
		return
		AFW_CreateInternalQueuedEvPriv( ev_code, 0,
										app->afw_id,
										0, 0,
										&ed,
										FBF_FREE, 0, NULL, 0 );
	else
		return RESULT_FAIL;
}

UINT32 HandleChangeState( EVENT_STACK_T * ev_st, APPLICATION_T * app )
{
	APP_ELF_T *		papp = (APP_ELF_T *)(app);
	UINT32			status;
	EVENT_T *		event;
	
	status = RESULT_OK;
	event = AFW_GetEv(ev_st);
	APP_ConsumeEv(ev_st, app);
	if ( app->state == APP_STATE_BG && event->data.pad[0] != APP_STATE_BG ) {
		// если уже в бэке
		papp->last_state = event->data.pad[0];
		if ( event->data.pad[1] == TRUE ) {
			// нужно вызвать из бэка
			status = APP_UtilChangeState(papp->last_state, ev_st, app);
		}
	}
	else if ( event->data.pad[0] == APP_STATE_BG ) {
		// отправить в бэк
		if ( app->state != APP_STATE_BG ) {
			papp->last_state = app->state;
			status = APP_UtilChangeState(APP_STATE_BG, ev_st, app);
		}
	}
	else {
		// просто изменить стэйт
		status = APP_UtilChangeState(event->data.pad[0], ev_st, app);
	}
	return status;
}


/* Обработчик входа в main state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	APP_ELF_T *			papp = (APP_ELF_T *)(app);
	DRAWING_BUFFER_T 	bufd = {NULL, 176, 220};// Буфер для рисования, Canvas.
	
	
	dbg("MainStateEnter: start");
	if(type != ENTER_STATE_ENTER) return RESULT_OK;
	
	app->dialog = UIS_CreateColorCanvas( &app->port, &bufd, true ); // создаём канвас
	
	state = MAIN;
/*	AHIRECT_T				rect;

	rect.x1 = 0; 
	rect.y1 = 0; 
	rect.x2 = rect.x1 + 16; 
	rect.y2 = rect.y1 + 10;
	
	DrawPngImageFS(L"file://b/2.png", &rect, 0, 0);
*/
	papp->entries_num = ContactListUpdate(setting.show_off_contacts, item.group);
	DrawList(app);	// Рисуем список

	dbg("MainStateEnter: end");
	
    return RESULT_OK;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
UINT32 EditStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	dbgf("EditStateEnter: start, type = %d, substate = %d", type, state );
	if(type != ENTER_STATE_ENTER) return RESULT_OK;
	
	WCHAR		data_w[512];
	char		data_c[512];
	UINT16		data_len = 0;
	UINT32 		uix_ed_params = 0;
	UINT8		uis_ed_params = 0;
	
	switch(state)
	{
		case EDIT_MSG:
			CP1251toUCS2( msg, data_w );
			strcpy( data_c, msg );
			data_len = 512;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 3;
			strcpy(msg, "");
			if ( setting.composing_events ) XMPPSendComposing( ContactListGetContact(item.select)->jid );
			break;
		
		case EDIT_URL:
			CP1251toUCS2( msg, data_w );
			strcpy( data_c, msg );
			data_len = 512;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH;
			uis_ed_params = 23;
			strcpy(msg, "");
			if ( setting.composing_events ) XMPPSendComposing( ContactListGetContact(item.select)->jid );
			break;
		
		case ADD_CONTACT:
			u_strcpy( data_w, L"" );
			strcpy( data_c, "" );
			data_len = 128;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;
		
		case EDIT_STATUS_MSG:
			CP1251toUCS2( setting.status_msg[setting.status], data_w );
			strcpy( data_c, setting.status_msg[setting.status] );
			data_len = 64;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;
		
		case EDIT_XSTATUS_MSG:
			UTF8toUCS2( XstatusGetItemStr(setting.xstatus), data_w );
			UTF8toCP1251( XstatusGetItemStr(setting.xstatus), data_c );
			data_len = 64;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;

		case EDIT_EV_CODE:
			u_ltou(setting.ev_code, data_w);
			itoa( setting.ev_code, data_c, 10 );
			data_len = 4;
			uix_ed_params = INP_USE_DIGITAL;
			uis_ed_params = 32;
			break;
		
		case EDIT_LOGIN:
			CP1251toUCS2( AccountGet(item.sel_account)->login, data_w );
			strcpy( data_c, AccountGet(item.sel_account)->login );
			data_len = 32;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;
		
		case EDIT_SERVER:
			CP1251toUCS2( AccountGet(item.sel_account)->server, data_w );
			strcpy( data_c, AccountGet(item.sel_account)->server );
			data_len = 32;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH;
			uis_ed_params = 1;
			break;
		
		case EDIT_PORT:
			u_ltou( AccountGet(item.sel_account)->port, data_w );
			itoa( AccountGet(item.sel_account)->port, data_c, 10 );
			data_len = 4;
			uix_ed_params = INP_USE_DIGITAL;
			uis_ed_params = 32;
			break;
		
		case EDIT_RESOURCE:
			CP1251toUCS2( AccountGet(item.sel_account)->resource, data_w );
			strcpy( data_c, AccountGet(item.sel_account)->resource );
			data_len = 32;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH;
			uis_ed_params = 1;
			break;
		
		case EDIT_PRIORITY:
			u_ltou( AccountGet(item.sel_account)->priority, data_w );
			itoa( AccountGet(item.sel_account)->priority, data_c, 10 );
			data_len = 2;
			uis_ed_params = 32;
			break;
		
		case EDIT_PASSWORD:
			CP1251toUCS2( AccountGet(item.sel_account)->password, data_w );
			strcpy( data_c, AccountGet(item.sel_account)->password );
			data_len = 32;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS | INP_PW;
			uis_ed_params = 1;
			break;
		
		case EDIT_TIME_ZONE:
			CP1251toUCS2( setting.time_zone, data_w );
			strcpy( data_c, setting.time_zone );
			data_len = 3;
			uix_ed_params = INP_USE_DIGITAL;
			uis_ed_params = 1;
			break;
		
	   	case EDIT_RENAME:
			CP1251toUCS2( ContactListGetContact(item.select)->nick, data_w );
			strcpy( data_c, ContactListGetContact(item.select)->nick );
			data_len = 128;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;
		
		case EDIT_REG_USERNAME:
			CP1251toUCS2( reg_info.username, data_w );
			strcpy( data_c, reg_info.username );
			data_len = 64;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;
		
		case EDIT_REG_PASSWORD:
			CP1251toUCS2( reg_info.password, data_w );
			strcpy( data_c, reg_info.password );
			data_len = 64;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;
		
		case EDIT_REG_EMAIL:
			CP1251toUCS2( reg_info.email, data_w );
			strcpy( data_c, reg_info.email );
			data_len = 64;
			uix_ed_params = INP_USE_DIGITAL | INP_USE_ENGLISH | INP_USE_OTHERS;
			uis_ed_params = 1;
			break;
	} 
	
	if( setting.use_uix_editor ) {
		app->dialog = UIX_CreateInputDialog(app, data_len, data_c, uix_ed_params, HandleEditDone );
		UIX_DialogSetTitle(app->dialog, lang(LG_EDIT), ElfGetIcon(image_icons, ICON_EDIT));
	} else 
		app->dialog = UIS_CreateCharacterEditor( &app->port, data_w, uis_ed_params, data_len, FALSE, NULL, LANG_EDIT );
	
	
	if( setting.use_uix_editor ) UIX_Render(app->dialog);
	 
	return RESULT_OK;
}

UINT32 SmilesStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	DRAWING_BUFFER_T 	bufd = {NULL, 176, 220};// Буфер для рисования, Canvas.
	
	if(type != ENTER_STATE_ENTER) return RESULT_OK;

	app->dialog = UIS_CreateColorCanvas( &app->port, &bufd, true ); // создаём канвас

	DrawSmiles();
	
    return RESULT_OK;
}
UINT32 ViewerStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	dbgf("ViewerStateEnter: start, type = %d, substate = %d", type, state );
	
	if(type != ENTER_STATE_ENTER) return RESULT_OK;

	app->dialog = UIX_CreateTextViewDialog( app, viewer_content ); // создаём канвас
	
	switch(state)
	{
		case CHAT:
			UIX_DialogSetTitle( app->dialog, ContactListGetContact(item.select)->nick,
											 ElfGetIcon(&bmp_status_icons, ContactListGetContact(item.select)->status) );
			break;
			
		case ABOUT:
			UIX_DialogSetTitle(app->dialog, lang(LG_ABOUT), ElfGetIcon(image_icons, ICON_ABOUT));
			break;
			
		case CLIENT_INFO:
		case CONTACT_INFO:
			UIX_DialogSetTitle(app->dialog, ContactListGetContact(item.select)->jid, ElfGetIcon(image_icons, ICON_ABOUT));
			break;
			
		case MSG_VIEWER:
			UIX_DialogSetTitle(app->dialog, lang(LG_MSG), ElfGetIcon(image_icons, ICON_EDIT));
			break;
			
		case REGISTRATION:
			UIX_DialogSetTitle(app->dialog, lang(LG_REGISTRATION), ElfGetIcon(image_icons, ICON_EDIT));
			break;	
	}
	
	UIX_DialogAddAction(app->dialog, lang(LG_BACK), ( void *)HandleBack, ACTION_FLAG_LEFT_SOFT );	// Назад
	
	if( state == CHAT ) {
		UIX_DialogAddAction(app->dialog, lang(LG_MSG), ( void *)HandleMessage, 0 );	// Новое сообщение...				 
		UIX_DialogAddAction(app->dialog, lang(LG_CONTACT_MENU), ( void *)HandleContactMenu, 0 );
		UIX_DialogAddAction(app->dialog, lang(LG_COPY), ( void *)HandleCopy, 0 );
		UIX_DialogAddAction(app->dialog, lang(LG_QUOTE), ( void *)HandleQuote, 0 );
		UIX_DialogAddAction(app->dialog, lang(LG_PASTE), ( void *)HandlePaste, 0 );
		UIX_DialogAddAction(app->dialog, lang(LG_FREE_HISTORY), ( void *)HandleFreeHistory, 0 );
		UIX_DialogAddAction(app->dialog, lang(LG_DELETE_CHAT), ( void *)HandleDeleteChat, 0 );
		UIX_DialogAddAction(app->dialog, lang(LG_SEND_URL), ( void *)HandleSendUrl, 0 );
		UIX_DialogAddAction(app->dialog, lang(LG_MSG), ( void *)HandleMessage, ACTION_FLAG_RIGHT_SOFT );	// Новое сообщение...
	} else if( state == CONTACT_INFO ) {
		UIX_DialogAddAction(app->dialog, lang(LG_COPY), ( void *)HandleCopy, ACTION_FLAG_RIGHT_SOFT );
		if ( ContactListGetContact(item.select)->vcard_nick )
			UIX_DialogAddAction(app->dialog, lang(LG_UPDATE_NICK), ( void *)HandleUpdateNick, 0 );
	} else if( state == MSG_VIEWER ) {
		UIX_DialogAddAction(app->dialog, lang(LG_EDIT), ( void *)HandleMessage, ACTION_FLAG_RIGHT_SOFT );	// Изменить
		UIX_DialogAddAction(app->dialog, lang(LG_SEND), ( void *)HandleSend, 0 );	// Отправить
		//UIX_DialogAddAction(app->dialog, lang(LG_SMILES), ( void *)HandleSmiles, 0 );
	} else if( state == REGISTRATION ) {
		UIX_DialogAddAction(elf.app->dialog, "Ok", ( void *)HandleSelect, ACTION_FLAG_RIGHT_SOFT );
	} else {
		UIX_DialogAddAction(app->dialog, lang(LG_COPY), ( void *)HandleCopy, ACTION_FLAG_RIGHT_SOFT );
	}
	UIX_Render(app->dialog);
	
    return RESULT_OK;
}


UINT32 MenuStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	APP_ELF_T        	    *papp = (APP_ELF_T*)app;
    UIX_CALL_BACK_F 		*CallBackArr[2];
	
	dbgf("MenuStateEnter: start, type = %d, substate = %d", type, state );
	
	if(type != ENTER_STATE_ENTER) return RESULT_OK;
	
	CallBackArr[0] = (void *)HandleSelect;
	CallBackArr[1] = (void *)HandleBack;
	CallBackArr[2] = (void *)HandleNavigate;
	
	if( state != ACCOUNTS_EDIT )
		item.menu = 0;
	
	switch(state)
	{
		case MAIN_MENU:
				papp->entries_num = 9;
				break;
		case CONTACT_MENU: 
				papp->entries_num = 10;
				if(ContactListGetContact(item.select)->type == CONTACT_TRANSPORT) papp->entries_num += 2;
				break;
		case SUBSCRIPTION_MENU:
				papp->entries_num = 3;
				break;					
		case SET_STATUS:
				papp->entries_num = 6;
				break;
		case SET_XSTATUS:
				papp->entries_num = 36;
				break;	
		case ADD_CONTACT:	
		case SELECT_GROUP:
				papp->entries_num = ContactListGetGroupCount();
				break;	
		case REGISTRATION:
				papp->entries_num = 1;
				if( reg_info.edit_username ) 
					papp->entries_num ++;
					
				if( reg_info.edit_email ) 
					papp->entries_num ++;
				break;
				
		case ACCOUNTS_SELECT:
				papp->entries_num = AccountGetCount();
				break;
		case ACCOUNTS_EDIT:
				papp->entries_num = 6;
				break;
				
		case MUC_ENTER_UI:
				papp->entries_num = 3;
				break;
	}
			
	app->dialog = UIX_CreateListDialog(app, papp->entries_num, MenuEntryReq, CallBackArr);
	
	if( state == SET_STATUS ) 
		UIX_DialogSetTitle(app->dialog, lang(LG_STATUS), ElfGetIcon( &bmp_status_icons, setting.status ));
	else if( state == SET_XSTATUS ) 
		UIX_DialogSetTitle(app->dialog, lang(LG_XSTATUS), ElfGetIcon( &bmp_status_icons, setting.status ));
	else if( state == REGISTRATION ) {
		UIX_DialogAddAction(app->dialog, lang(LG_SEND), ( void *)HandleSendTranportRegisterLogin, 0 );
		UIX_DialogSetTitle(app->dialog, lang(LG_REGISTRATION), ElfGetIcon( &bmp_status_icons, setting.status ));
	} else if ( state == ACCOUNTS_SELECT ) {
		UIX_DialogAddAction(app->dialog, "Select", ( void *)HandleAccountSelect, 0 );
		UIX_DialogAddAction(app->dialog, "Add New", ( void *)HandleAccountAddNew, 0 );
		UIX_DialogAddAction(app->dialog, "Delete", ( void *)HandleAccountDelete, 0 );
		UIX_DialogSetTitle(app->dialog, "Accounts:", ElfGetIcon( &bmp_status_icons, setting.status ));
	} else if( state == ACCOUNTS_EDIT )
		UIX_DialogSetTitle(app->dialog, AccountGet(item.sel_account)->login, ElfGetIcon( &bmp_status_icons, setting.status ));
	 else 
		UIX_DialogSetTitle(app->dialog, lang(LG_MENU), ElfGetIcon( &bmp_status_icons, setting.status ));
		
	UIX_Render(app->dialog);

	dbg("MenuStateEnter: end");
    return RESULT_OK;
}

UINT32 ConnectStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	DRAWING_BUFFER_T 	bufd = {NULL, 176, 220};// Буфер для рисования, Canvas.

	if(type != ENTER_STATE_ENTER) return RESULT_OK;
	
	dbg("ConnectStateEnter: start");
	
	app->dialog = UIS_CreateColorCanvas( &app->port, &bufd, true ); // создаём канвас
	
	
	if( !im_connect ) {
		im_connect = true;
		XMPPConnect( &setting, AccountGet(setting.account_current) );
	}
	
	DrawLoadingScreen( item.connect_text, item.connect_percent );
	
	dbg("ConnectStateEnter: end");
	
    return RESULT_OK;
}
UINT32 ChatStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	APP_ELF_T			*papp = (APP_ELF_T*)app;
	UIX_CALL_BACK_F		*CallBackArr[2];
	CONTACT_T 			*contact = ContactListGetContact( item.select );
	if(type != ENTER_STATE_ENTER) return RESULT_OK;
	
	dbg("ChatStateEnter: start");
	

	CallBackArr[0] = (void *)HandleSelect;
	CallBackArr[1] = (void *)HandleBack;
	CallBackArr[2] = (void *)HandleNavigate;
	

	state = CHAT;

	if ( setting.save_history )
		MsgDb_LoadDb( contact->jid );	// Загружаем истоию сообщений из файла в память
									
	papp->entries_num = ContactListMsgGetNum( contact );
	
	app->dialog = UIX_CreateListDialog(app, papp->entries_num, ChatEntryReq, CallBackArr);
	
	
	if ( contact->composing && image_icons )					// Сообшение о наборе
		UIX_DialogSetTitle( app->dialog, contact->nick, ElfGetIcon(image_icons, ICON_PEN) );
	else if ( contact->new_msg && image_icons )					// Иконка входящего сообщения
		UIX_DialogSetTitle( app->dialog, contact->nick, ElfGetIcon(image_icons, ICON_IN_MSG) );
	//else if ( contact->subscription == SUB_NONE && image_icons )// Иконка авторизации
	//	UIX_DialogSetTitle( app->dialog, contact->nick, ElfGetIcon(image_icons, ICON_AUTH) );
	else 
		UIX_DialogSetTitle( app->dialog, contact->nick, ElfGetIcon(&bmp_status_icons, contact->status) );


	UIX_DialogAddAction(app->dialog, lang(LG_MSG), ( void *)HandleMessage, 0 );								 
	UIX_DialogAddAction(app->dialog, lang(LG_CONTACT_MENU), ( void *)HandleContactMenu, 0 );
	UIX_DialogAddAction(app->dialog, lang(LG_COPY), ( void *)HandleCopy, 0 );
	UIX_DialogAddAction(app->dialog, lang(LG_QUOTE), ( void *)HandleQuote, 0 );
	UIX_DialogAddAction(app->dialog, lang(LG_PASTE), ( void *)HandlePaste, 0 );
	UIX_DialogAddAction(app->dialog, lang(LG_FREE_HISTORY), ( void *)HandleFreeHistory, 0 );
	UIX_DialogAddAction(app->dialog, lang(LG_DELETE_CHAT), ( void *)HandleDeleteChat, 0 );
	UIX_DialogAddAction(app->dialog, lang(LG_SEND_URL), ( void *)HandleSendUrl, 0 );
	
	
	contact->new_msg = false; // ставим флаг, сообщение прочитанно
	contact->chat = true; // ставим флаг, что с этим контактом есть чат
	
	
	UIX_ListSetPos( app->dialog, papp->entries_num - 1 );// Установим положение курсора в конец списка
	item.chat = papp->entries_num - 1;
	
	dbg("ChatStateEnter: end");
	
    return UIX_Render( app->dialog );
}

UINT32 SettingStateEnter( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  ENTER_STATE_TYPE_T type )
{
	UIX_CALL_BACK_F 		*CallBackArr[2];
	
	if(type != ENTER_STATE_ENTER) return RESULT_OK;
	
	CallBackArr[0] = (void *)HandleSelect;
	CallBackArr[1] = (void *)HandleBack;
	CallBackArr[2] = (void *)HandleNavigate;
	
	app->dialog = UIX_CreateListDialog(app, 12, SettingEntryReq, CallBackArr);
	
	UIX_DialogSetTitle(app->dialog, lang(LG_SETTINGS), ElfGetIcon(image_icons, ICON_SETTINGS));
	
	UIX_Render(app->dialog);
	
    return RESULT_OK;
}

UINT32 StateExit( EVENT_STACK_T *ev_st,  APPLICATION_T *app,  EXIT_STATE_TYPE_T type )
{
	UINT32			status;
	if ( type != EXIT_STATE_EXIT ) return RESULT_OK;
	
	switch( app->state ) {
	
		case APP_STATE_MAIN:
		case APP_STATE_CONNECT:
		case APP_STATE_SMILES:
			status = APP_UtilUISDialogDelete( &app->dialog );
			break;
			
		case APP_STATE_EDIT:
			if( setting.use_uix_editor ) 
				status = APP_UtilUIXDialogDelete( &app->dialog );
			else
				status = APP_UtilUISDialogDelete( &app->dialog );
			break;
			
		case APP_STATE_VIEWER:
		case APP_STATE_MENU:
			status = APP_UtilUIXDialogDelete( &app->dialog );
			break;
			
		case APP_STATE_CHAT:
			status = APP_UtilUIXDialogDelete( &app->dialog );
			item.chat = 0;
			if( !setting.save_history )
				ContactListMsgFreeQueue( ContactListGetContact(item.select) );
			else
				ContactListMsgFreeQueue( ContactListGetContact(item.select) );
			break;
			
		case APP_STATE_SETTING:
			SaveSetting();
			status = APP_UtilUIXDialogDelete( &app->dialog );
			break;
	}
	return status;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T * ev_st, APPLICATION_T * app )
{
	UINT32			status;

	dbg("HandleUITokenGranted: enter");
	
	// Call standart event handler
	status = APP_HandleUITokenGranted( ev_st, app );
	dbgf("HandleUITokenGranted: APP_HandleUITokenGranted DONE, status = %d", status);
	
	// Application is ready, now change init state to main state with UI
	if( (status == RESULT_OK) && (app->token_status == 2) ) {
		status = APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
	}

	dbg("HandleUITokenGranted: end");
	return status;
}

UINT32 HandleTimer( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
	UINT32 				id = ((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID;
	
	switch( id ) 
	{
		
	} 

	return RESULT_OK;
}

UINT32 HandlePlay( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
    UINT32 error;
	
    if (mme_media_file)
    {
        error = MME_GC_playback_start(mme_media_file, 0, 0);   // воспроизводим
    }

    return error;
}

UINT32 HandlePlayComplete( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
    UINT32 error;

    if (mme_media_file)
    {
        error = MME_GC_playback_delete(mme_media_file); // удаляем, ранее созданный
        mme_media_file = (MME_GC_MEDIA_FILE *) NULL; // обнуляем id
    }

    return error;
}

UINT32 HandleNavigate( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 idx )
{
	switch ( app->state )
	{
		case APP_STATE_CHAT:
			item.chat = idx;
			break;
			
		case APP_STATE_MENU:
			item.menu = idx;
			break;
	}		
	return RESULT_OK;
}

UINT32 HandleSelect( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 idx )
{
	MSG_T			  *msgdb;
	
	dbgf( "HandleSelect: idx = %d", idx );
	APP_ConsumeEv( ev_st, app );
	
		switch ( app->state )
		{
			case APP_STATE_CHAT:
				msgdb = ContactListMsgGet(ContactListGetContact(item.select), item.chat );
				if( !msgdb ) return RESULT_FAIL;
				
				itoa(msgdb->date.day, viewer_content, 10);
				strcat(viewer_content, "/");
				itoa(msgdb->date.month, viewer_content+strlen(viewer_content), 10);
				strcat(viewer_content, "/");
				itoa(msgdb->date.year, viewer_content+strlen(viewer_content), 10);
				strcat(viewer_content, " ");
				itoa(msgdb->time.hour, viewer_content+strlen(viewer_content), 10);
				strcat(viewer_content, ":");
				if(msgdb->time.minute <= 9) strcat(viewer_content, "0");
				itoa(msgdb->time.minute, viewer_content+strlen(viewer_content), 10);
				
				strcat( viewer_content, "\n" );
				strcat( viewer_content, msgdb->text );
				
				APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
				break;
				
			case APP_STATE_VIEWER:
				if( state == REGISTRATION )
					return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				break;
				
			case APP_STATE_MENU:
			
				switch(state)
				{
					case MAIN_MENU:
						SelectItemMainMenu(ev_st, app);
						break;
					case CONTACT_MENU: 
						SelectItemContactMenu(ev_st, app);
						break;
					case SUBSCRIPTION_MENU:
						SelectItemSubscriptionMenu(ev_st, app);
						break;					
					case SET_STATUS:
						setting.status = idx + 1;
						SaveSetting();
						state = EDIT_STATUS_MSG;
						APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
						break;
						
					case SET_XSTATUS:
						setting.xstatus = idx;
						SaveSetting();
						if( idx ) {
							state = EDIT_XSTATUS_MSG;
							APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
						}else
							APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
						break;
					case SELECT_GROUP:
						XMPPMoveContact(ContactListGetContact(item.select)->jid,
										ContactListGetGroupNameByID( idx ));
						APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
						break;	
					case ADD_CONTACT:
						APP_UtilChangeState(APP_STATE_EDIT, ev_st, app );
						break;
					case REGISTRATION:
						if( !reg_info.edit_email && !reg_info.edit_username )  break;
						
						switch( idx ) {
							case 0:
								if( reg_info.edit_username )
									state = EDIT_REG_USERNAME;
								else
									state = EDIT_REG_EMAIL;
								break;
								
							case 1:
								if( reg_info.edit_username && reg_info.edit_email )
									state = EDIT_REG_EMAIL;
								else
									state = EDIT_REG_PASSWORD;
								break;
								
							case 2:
								state = EDIT_REG_PASSWORD;
								break;
						}
						APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
						break;	
				
					case ACCOUNTS_SELECT:
						if( AccountGetCount() ) {
							state = ACCOUNTS_EDIT;
							item.sel_account = item.menu;
							APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
						}
						break;
						
					case ACCOUNTS_EDIT:
							if(idx == 0)
								state = EDIT_LOGIN;
							else if(idx == 1)
								state = EDIT_SERVER;
							else if(idx == 2)
								state = EDIT_PORT;
							else if(idx == 3)
								state = EDIT_RESOURCE;
							else if(idx == 4)
								state = EDIT_PRIORITY;
							else if(idx == 5)
								state = EDIT_PASSWORD;
								
						APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
						break;
						
					case MUC_ENTER_UI:
						state = EDIT_MUC_NICK + idx;
						APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
						break;	
				}
				break; 
				
			case APP_STATE_SETTING:
					if(idx == 0) {
						state = ACCOUNTS_SELECT;
						return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
					}
					else if(idx == 1)
						state = EDIT_EV_CODE;
					else if(idx == 2)
						state = EDIT_TIME_ZONE;	
					else if(idx == 3){
					if (setting.console < 4) 
							   setting.console ++;
						  if (setting.console == 4)
							   setting.console = 0;
						return UIX_Render(app->dialog);	
					}
					else if(idx == 4){
					if (setting.color_theme < COLOR_THEME_COUNT) 
							   setting.color_theme ++;
						  if (setting.color_theme == COLOR_THEME_COUNT)
							   setting.color_theme = 0;
							   LoadTheme(setting.color_theme);
						return UIX_Render(app->dialog);  	
					}
					else if(idx == 5){
					if (setting.volume < 8) 
							   setting.volume ++;
						  if (setting.volume == 8)
							   setting.volume = 0;
							   SetVol(1);
						return UIX_Render(app->dialog);  	
					}
					else if(idx == 6){
						if (setting.composing_events) 
							setting.composing_events = false;
						else 
							setting.composing_events = true;
						return UIX_Render(app->dialog);  	
					}
					else if(idx == 7){
						if (setting.auto_connect) 
							setting.auto_connect = false;
						else 
							setting.auto_connect = true;
						return UIX_Render(app->dialog);  	
					}
					else if(idx == 8){
						if (setting.hide_empty_groups) 
							setting.hide_empty_groups = false;
						else 
							setting.hide_empty_groups = true;
						return UIX_Render(app->dialog);  	
					}
					else if(idx == 9){
						if (setting.show_app_under_new_msg) 
							setting.show_app_under_new_msg = false;
						else 
							setting.show_app_under_new_msg = true;
						return UIX_Render(app->dialog);  	
					}
					else if(idx == 10){
						if (setting.use_uix_editor) 
							setting.use_uix_editor = false;
						else 
							setting.use_uix_editor = true;
						return UIX_Render(app->dialog);  	
					}
					
					else if(idx == 11){
						if (setting.save_history) 
							setting.save_history = false;
						else 
							setting.save_history = true;
						return UIX_Render(app->dialog);  	
					}/*
					else if(idx == 11){
						if (setting.zlib_enable) 
							setting.zlib_enable = false;
						else 
							setting.zlib_enable = true;
						return UIX_Render(app->dialog);  	
					}	*/		
					APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
				break;	
		}
	
	return RESULT_OK;
}
// Назад
UINT32 HandleBack( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	APP_ConsumeEv( ev_st, app );

	switch (app->state)
    {	
		case APP_STATE_VIEWER:
			if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
				if ( state == CHAT || state == MSG_VIEWER ) {
					return APP_UtilChangeState(APP_STATE_CHAT, ev_st, app );
				} else {
					return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
				}
			}
		case APP_STATE_MENU:
			if ( state == REGISTRATION )
				return APP_UtilChangeState(APP_STATE_VIEWER, ev_st, app );
			else if ( state == ACCOUNTS_SELECT )
				return APP_UtilChangeState( APP_STATE_SETTING, ev_st, app );
			else if ( state == ACCOUNTS_EDIT ) {
				state = ACCOUNTS_SELECT;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );	
			} else
				return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			break;
			
		case APP_STATE_CHAT:		
		case APP_STATE_SETTING:
			return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			break;	
	}
	return RESULT_OK;
}
UINT32 HandleEditDone( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 l )
{
	void *			d;
	char *			s;
	WCHAR *			w;

	
	if ( l == (UINT32)(-1) || l == 0 ) {
		HandleEditCancel( ev_st, app ); // Cancel
	} else {
		d = UIX_MgrGetTopDlgByDialog(app->dialog);
		s = suAllocMem(sizeof(char)*(l+1), NULL);
		w = suAllocMem(sizeof(WCHAR)*(l+1), NULL);
		if ( UIX_InputDlgGetData(d, s, 0) == RESULT_OK ) {

			CP1251toUCS2( s, w );
			ldrSendEventToApp( app->afw_id,
								ldrGetConstVal(EV_DATA),
								w,
								sizeof(WCHAR)*(l+1),
								FBF_LEAVE
							 );
		
		}
		suFreeMem(s);
		suFreeMem(w);
	}
	return RESULT_OK;
}

// "Ok" в редакторе UIS
UINT32 HandleEditData( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
	EVENT_T *		event = AFW_GetEv(ev_st);
	char  			data[1024];
	APP_ConsumeEv( ev_st, app );

	
	if( event->attachment == NULL ) return RESULT_OK;

	UCS2toCP1251( event->attachment, data );
	
		switch(state)
		{
			case EDIT_MSG:
			case EDIT_URL:
				strcpy(viewer_content, data);
				state = MSG_VIEWER;
				if ( setting.composing_events ) XMPPCancelComposing( ContactListGetContact(item.select)->jid );
				return APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
			
			case ADD_CONTACT:
				XMPPAddContact( data, ContactListGetGroupNameByID(item.menu) );
				return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			
			case EDIT_STATUS_MSG:
				strcpy(setting.status_msg[setting.status], data);
				SaveSetting();
				if(XMPPIsReady()) XMPPSetStatus(setting.status, setting.status_msg[setting.status]);
				return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			/**/
			case EDIT_XSTATUS_MSG:
				XstatusReplaceItemStr(setting.xstatus, data);
				if(XMPPIsReady()) XMPPSetXStatus(setting.xstatus, data);
				return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
				
			case EDIT_LOGIN:
				strcpy(AccountGet(item.sel_account)->login, data);
				state = ACCOUNTS_EDIT;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				
			case EDIT_SERVER:
				strcpy(AccountGet(item.sel_account)->server, data);
				state = ACCOUNTS_EDIT;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				
			case EDIT_PORT:
				AccountGet(item.sel_account)->port = strtol(data, '\0', 10);
				state = ACCOUNTS_EDIT;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				
			case EDIT_RESOURCE:
				strcpy(AccountGet(item.sel_account)->resource, data);
				state = ACCOUNTS_EDIT;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
	
			case EDIT_PRIORITY:
				AccountGet(item.sel_account)->priority = strtol(data, '\0', 10);
				state = ACCOUNTS_EDIT;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
		
			case EDIT_PASSWORD:
				strcpy(AccountGet(item.sel_account)->password, data);
				state = ACCOUNTS_EDIT;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
			/**/
			case EDIT_EV_CODE:
				setting.ev_code = strtol(data, '\0', 10);
				SaveSetting();
				return APP_UtilChangeState( APP_STATE_SETTING, ev_st, app );
				
			case EDIT_TIME_ZONE:
				strcpy(setting.time_zone, data);
				SaveSetting();
				return APP_UtilChangeState( APP_STATE_SETTING, ev_st, app );
				
			case EDIT_RENAME:
				ContactListGetContact(item.select)->nick = malloc(strlen(data)+1);
				strcpy(ContactListGetContact(item.select)->nick, data);
				XMPPRenameContact( ContactListGetContact(item.select)->jid,
								   data );				   
				return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			
			
			case EDIT_REG_USERNAME:
				strcpy(reg_info.username, data);
				state = REGISTRATION;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				
			case EDIT_REG_PASSWORD:
				strcpy(reg_info.password, data);
				state = REGISTRATION;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				
			case EDIT_REG_EMAIL:
				strcpy(reg_info.email, data);
				state = REGISTRATION;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				
				
			case EDIT_MUC_NICK:
				strcpy(ContactListGetContact(item.select)->nick, data);
				state = MUC_ENTER_UI;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );	
				
			case EDIT_MUC_PASS:
				ContactListGetContact(item.select)->password = malloc(strlen(data)+1);
				strcpy(ContactListGetContact(item.select)->password, data);
				state = MUC_ENTER_UI;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				
			case EDIT_MUC_MESSAGE_NUM:
				ContactListGetContact(item.select)->message_num = strtol(data, '\0', 10);
				state = MUC_ENTER_UI;
				return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );	
		}
	
    return RESULT_OK;
}

UINT32 HandleEditOk( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
     EVENT_T       			   *event = AFW_GetEv(ev_st);
	 
	APP_ConsumeEv( ev_st, app );
	 
	event->data.index = 512;	// how many chars reqest from dialog
	AFW_AddEvEvD( ev_st, ldrGetConstVal(EV_REQUEST_DATA), (ADD_EVENT_DATA_T *)(&event->data_tag) );
	 
	 
    return RESULT_OK;
}

//Обработчик кнопки "Отмена" в редакторе
UINT32 HandleEditCancel( EVENT_STACK_T *ev_st,  APPLICATION_T *app )
{
	APP_ConsumeEv( ev_st, app );
	
	switch(state)
	{	
		case EDIT_STATUS_MSG:
			//if(XMPPIsReady()) XMPPSetStatus(setting.status, setting.status_msg[setting.status]);
			state = SET_STATUS;
			return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
		
		case EDIT_XSTATUS_MSG:
			//if(XMPPIsReady())  XMPPSetXStatus(setting.xstatus, XstatusGetItemStr(setting.xstatus) );	
			state = SET_XSTATUS;
			return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
			
		case ADD_CONTACT:
		case EDIT_RENAME:
		case EDIT_MUC_NICK:
		case EDIT_MUC_PASS:
		case EDIT_MUC_MESSAGE_NUM:
			return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
		
		case EDIT_MSG:
		case EDIT_URL:
		if ( setting.composing_events ) XMPPCancelComposing( ContactListGetContact(item.select)->jid );
		
			if( ContactListMsgGetNum( ContactListGetContact(item.select) ) )
				return APP_UtilChangeState( APP_STATE_CHAT, ev_st, app );
			else
				return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			
		case EDIT_REG_USERNAME:
		case EDIT_REG_PASSWORD:
		case EDIT_REG_EMAIL:
			state = REGISTRATION;
			return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
		
		case EDIT_LOGIN:
		case EDIT_SERVER:
		case EDIT_PORT:
		case EDIT_RESOURCE:
		case EDIT_PRIORITY:
		case EDIT_PASSWORD:
			state = ACCOUNTS_EDIT;
			return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
			
		case EDIT_EV_CODE:
		case EDIT_TIME_ZONE:
			return APP_UtilChangeState( APP_STATE_SETTING, ev_st, app );
	}

    return RESULT_OK;
}
/*********************************************************************/
// Новое сообщение...
UINT32 HandleMessage( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	APP_ConsumeEv( ev_st, app );
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		
		if( state == MSG_VIEWER )
			strcpy( msg, viewer_content );
		else 
			msg[0] = 0;

		state = EDIT_MSG;
		return APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
	}
	return RESULT_OK;
}
			
UINT32 HandleContactMenu( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
	
		state = CONTACT_MENU;
		return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleCopy( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	MSG_T *			msgdb;
	
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
	
		if( app->state == APP_STATE_VIEWER )
			if( state == CLIENT_INFO || state == CONTACT_INFO || state == ABOUT ) {
				CP1251toUCS2(viewer_content, clipboard);
				return APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
			}
			
		CLK_TIME_T	time;  
		CLK_DATE_T	date;  

		DL_ClkGetDate( &date );
		DL_ClkGetTime( &time );
		strcpy( quoting, "> " );
		msgdb = ContactListMsgGet(ContactListGetContact(item.select), item.chat );
		if(!msgdb) 
			return RESULT_FAIL;
		
		if( msgdb->type == MSG_TYPE_IN ) 
			strcat(quoting, ContactListGetContact(item.select)->nick);
		else 
			strcat(quoting, AccountGet(setting.account_current)->login);

		strcat(quoting, " ");
		itoa(date.day, quoting+strlen(quoting), 10);
		strcat(quoting, "/");
		itoa(date.month, quoting+strlen(quoting), 10);
		strcat(quoting, "/");
		itoa(date.year, quoting+strlen(quoting), 10);
		strcat(quoting, " ");
		itoa(time.hour, quoting+strlen(quoting), 10);
		strcat(quoting, ":");
		itoa(time.minute, quoting+strlen(quoting), 10);
		strcat(quoting, "\n");
		
		CP1251toUCS2(msgdb->text, clipboard);

		return APP_UtilChangeState( APP_STATE_CHAT, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleQuote( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
	
		if( !u_strlen(clipboard) ) return APP_UtilChangeState( APP_STATE_CHAT, ev_st, app );
		
		strcpy(viewer_content, quoting);
		strcat(viewer_content, "> ");
		UCS2toCP1251(clipboard, viewer_content+strlen(viewer_content));
		strcpy(msg, viewer_content);
		strcat(msg, "\n\n");

		state = MSG_VIEWER;
		return APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandlePaste( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
	
		if( !u_strlen(clipboard) ) return APP_UtilChangeState( APP_STATE_CHAT, ev_st, app );
		
		UCS2toCP1251(clipboard, viewer_content);

		state = MSG_VIEWER;
		return APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleFreeHistory( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		
		WCHAR	uri[256];
	
		u_strcpy(uri, pathMsgDb);
		u_atou( ContactListGetContact(item.select)->jid, uri+u_strlen(uri) );
		u_strcat(uri, L".mjh");
		DL_FsDeleteFile(uri, 0);
	
		ContactListGetContact(item.select)->chat = false;
	
		return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleDeleteChat( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
	
		ContactListGetContact(item.select)->chat = false;
		return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleSendUrl( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
	
		state = EDIT_URL;
		strcpy(msg, "");
		return APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
	}
	return RESULT_OK;
}
/*********************************************************************/
UINT32 HandleUpdateNick( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		
		CONTACT_T		*contact = ContactListGetContact(item.select);
		
		if ( !contact ) return RESULT_FAIL;
								   
		XMPPRenameContact( contact->jid, contact->vcard_nick );		
				
		return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
	}
	return RESULT_OK;
}
/*********************************************************************/
UINT32 HandleSend( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	APP_ConsumeEv( ev_st, app );
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		if( state == EDIT_URL )
			XMPPSendUrl(ContactListGetContact(item.select)->jid, viewer_content);
		else
			XMPPSendMsg(ContactListGetContact(item.select)->jid, viewer_content);
			
		MsgDb_MsgAdd(ContactListGetContact(item.select)->jid, viewer_content, MSG_TYPE_OUT); // добавим сообщение в базу
	
		return APP_UtilChangeState( APP_STATE_CHAT, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleSmiles( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
	
		return APP_UtilChangeState( APP_STATE_SMILES, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleSendTranportRegisterLogin( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		
		XMPPSendTranportRegisterLogin( ContactListGetContact(item.select)->jid, &reg_info );
		
		state = MAIN;
		return APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
	}
	return RESULT_OK;
}
/*********************************************************************/
UINT32 HandleAccountSelect( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		
		setting.account_current = item.menu;
		
		state = ACCOUNTS_SELECT;
		return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleAccountAddNew( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		
		AccountAddNew();
		
		state = ACCOUNTS_SELECT;
		return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
	}
	return RESULT_OK;
}
UINT32 HandleAccountDelete( EVENT_STACK_T * ev_st, APPLICATION_T * app, UINT32 mode )
{
	if ( mode == ACTION_KEY_PRESS || mode == ACTION_LIST ) {
		
		AccountDelete( item.menu );
		
		state = ACCOUNTS_SELECT;
		return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
	}
	return RESULT_OK;
}
/*********************************************************************/

static void * MenuEntryReq( APPLICATION_T * app, UINT32 idx )
{
	UIX_LIST_ENTRY_T    *e;
	
	// динамически создаем
	e = suAllocMem(sizeof(UIX_LIST_ENTRY_T), NULL);
	memclr(e, sizeof(UIX_LIST_ENTRY_T));
	
	
	if( image_icons ) e->flags = LE_FLAG_ICONIC;
	
	
	switch ( state )
	{
		case MAIN_MENU:
			e->flags = LE_FLAG_ICONIC;
			switch ( idx )
			{
				case 0:
					if(XMPPIsReady()){
						e->name = lang(LG_DISCONNECT);
						e->icon = ElfGetIcon(image_icons, ICON_DISCONNECT);
					}else{
						e->name = lang(LG_CONNECT);
						e->icon = ElfGetIcon(image_icons, ICON_CONNECT);
					}	
				break;
				case 1:	
					e->name = lang(LG_STATUS);
					e->icon = ElfGetIcon(&bmp_status_icons, setting.status);
				break;
				case 2:
					e->name = lang(LG_XSTATUS);
					e->icon = ElfGetIcon(image_xstatus, setting.xstatus);
				break;
				case 3:	
					if (setting.sound_on) {
					e->name = lang(LG_SONUD_OFF);
					e->icon = ElfGetIcon(image_icons, ICON_SOUND_ON);
				} else {
					e->name = lang(LG_SONUD_ON);
					e->icon = ElfGetIcon(image_icons, ICON_SOUND_OFF);
				}
				break;
				case 4:	
					if( !XMPPIsReady() ) e->flags = LE_FLAG_ICONIC | LE_FLAG_SELECTED;
					e->name = lang(LG_ADD_CONTACT);
					e->icon = ElfGetIcon(image_icons, ICON_ADD_CONTACT);
				break;
				case 5:	
					e->name = lang(LG_SETTINGS);
					e->icon = ElfGetIcon(image_icons, ICON_SETTINGS);
				break;
				case 6:	
					e->name = lang(LG_ABOUT);
					e->icon = ElfGetIcon(image_icons, ICON_ABOUT);
				break;	
				case 7:	
					e->name = lang(LG_EXIT);
					e->icon = ElfGetIcon(image_icons, ICON_EXIT);
				break;	
				case 8:	
					e->name = lang(LG_HIDE);
					e->icon = ElfGetIcon(image_icons, ICON_HIDE);
				break;
			}
		break;
		
		case CONTACT_MENU:
			switch ( idx )
			{
				case 0:
					e->name = lang(LG_MSG);
					e->icon = ElfGetIcon(image_icons, ICON_IN_MSG);
				break;
				case 1:	
					if(ContactListGetContact(item.select)->type == CONTACT_MUC)
					{
						e->name = lang(LG_CONNECT);
						e->icon = ElfGetIcon(image_icons, ICON_CONNECT);
					}
					else
					{
						e->name = "Wake";
						e->icon = ElfGetIcon(image_icons, ICON_SERVER_MSG);
					}
				break;
				case 2:
					e->name = lang(LG_CHECK_STATUS);
					e->icon = ElfGetIcon(&bmp_status_icons, ContactListGetContact(item.select)->status);
				break;
				case 3:
					e->name = lang(LG_CONTACT_INFO);
					e->icon = ElfGetIcon(image_icons, ICON_INFO);
				break;
				case 4:	
					e->name = lang(LG_CLIENT_INFO);
					e->icon = ElfGetIcon(image_icons, ICON_INFO);
				break;
				case 5:	
					e->name = lang(LG_COPY_JID);
					e->icon = ElfGetIcon(image_icons, ICON_COPY_JID);
				break;
				case 6:	
					e->name = lang(LG_SUBSCRIPTION);
					e->icon = ElfGetIcon(image_icons, ICON_SERVER_MSG);
				break;
				case 7:	
					e->name = lang(LG_MOVE_TO_GROUP);
					e->icon = ElfGetIcon(image_icons, ICON_GROUPS);
				break;	
				case 8:	
					e->name = lang(LG_DELETE);
					e->icon = ElfGetIcon(image_icons, ICON_DEL_CONTACT);
				break;	
				case 9:	
					e->name = lang(LG_RENAME);
					e->icon = ElfGetIcon(image_icons, ICON_RENAME);
				break;
				
				case 10:
					if(ContactListGetContact(item.select)->status == XMPPS_OFFLINE) {
						e->name = lang(LG_CONNECT);
						e->icon = ElfGetIcon(image_icons, ICON_CONNECT);
					} else {	
						e->name = lang(LG_DISCONNECT);
						e->icon = ElfGetIcon(image_icons, ICON_DISCONNECT);
					}
				break;	
				
				case 11:	
					e->name = lang(LG_REGISTRATION);
					e->icon = ElfGetIcon(image_icons, ICON_EDIT);
				break;
			}	
		break;
		
		case SUBSCRIPTION_MENU:
			switch ( idx )
			{
				case 0:
					e->name = lang(LG_AUTHORIZE);
					e->icon = ElfGetIcon(image_icons, ICON_SERVER_MSG);
				break;
					case 1:	
					e->name = lang(LG_REQUEST_AUTHORIZATION);
					e->icon = ElfGetIcon(image_icons, ICON_AUTH);
				break;
				case 2:
					e->name = lang(LG_CANCELLATION_OF_AUTHORIZATION);
					e->icon = ElfGetIcon(image_icons, ICON_EXIT);
				break;
			}
		break;
		
		case SET_STATUS:
			e->flags = LE_FLAG_ICONIC;
			switch ( idx )
			{
				case 0:
					e->name = lang(LG_ONLINE);
					e->icon = ElfGetIcon(&bmp_status_icons, XMPPS_ONLINE);
				break;
				case 1:	
					e->name = lang(LG_FREECHAT);
					e->icon = ElfGetIcon(&bmp_status_icons, XMPPS_FREECHAT);
				break;
				case 2:
					e->name = lang(LG_AWAY);
					e->icon = ElfGetIcon(&bmp_status_icons, XMPPS_AWAY);
				break;
				case 3:	
					e->name = lang(LG_DND);
					e->icon = ElfGetIcon(&bmp_status_icons, XMPPS_DND);
				break;
				case 4:	
					e->name = lang(LG_NA);
					e->icon = ElfGetIcon(&bmp_status_icons, XMPPS_NA);
				break;
				case 5:	
					e->name = lang(LG_INVISIBLE);
					e->icon = ElfGetIcon(&bmp_status_icons, XMPPS_INVISIBLE);
				break;
			}
		break;
		
		case SET_XSTATUS:
				e->name = xstatus_eng[idx];
				e->icon = ElfGetIcon(image_xstatus, idx);
		break;
		
		case ADD_CONTACT:
		case SELECT_GROUP:
				e->name = ContactListGetGroupNameByID(idx);
				e->icon = ElfGetIcon(image_icons, ICON_GROUPS);
		break;
		
		
		case REGISTRATION:
			e->flags = LE_FLAG_HAS_DATA;
			e->dtype = LE_DATA_TYPE_STR;

			switch ( idx )
			{
				case 0:
					if( reg_info.edit_username ) {
						e->name = lang(LG_USERNAME);
						e->d.s = (char*)reg_info.username;
					} else {
						e->name = (char*)"Email:";
						e->d.s = (char*)reg_info.email;
					}
					break;
			
				case 1:
					if( reg_info.edit_username && reg_info.edit_email ) {
						e->name = (char*)"Email:";
						e->d.s = (char*)reg_info.email;
					} else {
						e->name = lang(LG_PASSWORD);
						e->d.s = (char*)reg_info.password;
					}
					break;
					
				case 2:
					e->name = (char*)lang(LG_PASSWORD);
					e->d.s = (char*)reg_info.password;
					break;
			}
		break;
		
		case ACCOUNTS_SELECT:
				e->flags = 0;
				e->name = AccountGet(idx)->login;
				
				if( idx == setting.account_current ) {
					e->flags = LE_FLAG_HAS_DATA;
					e->dtype = LE_DATA_TYPE_STR;
					e->d.s = "+";
				}
		break;
		
		case ACCOUNTS_EDIT:
			e->flags = LE_FLAG_HAS_DATA;
			e->dtype = LE_DATA_TYPE_STR;

			switch ( idx )
			{
				case 0:
					e->name = lang(LG_USERNAME);
					e->dtype = LE_DATA_TYPE_STR;
					e->d.s = AccountGet(item.sel_account)->login;
				break;
				case 1:
					e->name = lang(LG_SERVER);
					e->dtype = LE_DATA_TYPE_STR;
					e->d.s = AccountGet(item.sel_account)->server;
				break;
				case 2:	
					e->name = lang(LG_PORT);
					e->dtype = LE_DATA_TYPE_UINT32;
					e->d.unum = AccountGet(item.sel_account)->port;
				break;
				case 3:	
					e->name = lang(LG_RESOURCE);
					e->dtype = LE_DATA_TYPE_STR;
					e->d.s = AccountGet(item.sel_account)->resource;
				break;
				case 4:	
					e->name = lang(LG_PRIORITY);
					e->dtype = LE_DATA_TYPE_UINT32;
					e->d.unum = AccountGet(item.sel_account)->priority;
				break;
				case 5:	
					e->name = lang(LG_PASSWORD);
					e->dtype = LE_DATA_TYPE_STR_PW;
					e->d.s =  AccountGet(item.sel_account)->password;
				break;
			}
			break;
/*
		case MUC_ENTER_UI:
		e->flags = LE_FLAG_HAS_DATA;
			switch ( idx )
			{
				case 0:
					e->name = "Nick: ";
					e->dtype = LE_DATA_TYPE_STR;
					e->d.s =  setting.password;
				break;
				case 1:	
					e->name = lang(LG_PASSWORD);
					e->dtype = LE_DATA_TYPE_STR_PW;
					e->d.s =  setting.password;
				break;
				case 2:
					e->name = "Message: ";
					e->dtype = LE_DATA_TYPE_UINT32;
					e->d.unum =  setting.password;
				break;
			}
			break;
*/
	}	
	return e;
}

static void * ChatEntryReq( APPLICATION_T * app, UINT32 idx )
{
	UIX_LIST_ENTRY_T *	e;
	MSG_T *				msgdb;
	
	// динамически создаем
	e = suAllocMem(sizeof(UIX_LIST_ENTRY_T), NULL);
	memclr(e, sizeof(UIX_LIST_ENTRY_T));
		
	msgdb = ContactListMsgGet( ContactListGetContact( item.select ), idx );
	
	if( !msgdb ) return NULL;
	
	if( image_icons ) 
		e->flags = LE_FLAG_ICONIC | LE_FLAG_FREE_MEM | LE_FLAG_FREE_NAME; // освободить e и e->name
	else
		e->flags = LE_FLAG_FREE_MEM | LE_FLAG_FREE_NAME; // освободить e и e->name
		
	e->name = (char *)suAllocMem(sizeof(char)*(25), NULL);
		
		switch ( msgdb->type ) {
		
			case MSG_TYPE_IN:
				strcpy((char *)e->name, "-> ");
				e->icon = ElfGetIcon(image_icons, ICON_IN_MSG);
				break;
				
			case MSG_TYPE_OUT:
				strcpy((char *)e->name, "<- ");
				e->icon = ElfGetIcon(image_icons, ICON_OUT_MSG2);
				break;
				
			case MSG_TYPE_SYSTEM:
				strcpy((char *)e->name, "-> ");
				e->icon = ElfGetIcon(image_icons, ICON_SERVER_MSG);
				break;
		}

	strncat((char *)e->name, msgdb->text, 20);
	((char *)(e->name))[24] = 0;
		
	return e;
}

static void * SettingEntryReq( APPLICATION_T * app, UINT32 idx )
{
	UIX_LIST_ENTRY_T    *e;
	// динамически создаем
	e = suAllocMem(sizeof(UIX_LIST_ENTRY_T), NULL);
	memclr(e, sizeof(UIX_LIST_ENTRY_T));
	
	e->flags = LE_FLAG_HAS_DATA;
	switch ( idx )
    {
		case 0:	
			e->name = lang(LG_USER);
			e->dtype = LE_DATA_TYPE_STR;
			if( AccountGet(setting.account_current) )
				e->d.s = AccountGet(setting.account_current)->login;
			else
				e->d.s = "N/A";
		break;
		
		case 1:
			e->name = lang(LG_RUN_EVENT);
			e->dtype = LE_DATA_TYPE_UINT32;
			e->d.unum = setting.ev_code;
		break;
		case 2:	
			e->name = lang(LG_TIME_ZONE);
			e->dtype = LE_DATA_TYPE_STR;
			e->d.s = setting.time_zone;
		break;	
		case 3:	
			e->name = lang(LG_CONSOLE);
			e->dtype = LE_DATA_TYPE_STR;
			if(!setting.console) e->d.s = "Off"; 
			else if(setting.console == 1)  e->d.s = "Only messages";
			else if(setting.console == 2)  e->d.s = "Only statuses";
			else if(setting.console == 3)  e->d.s = "All";
		break;	
		case 4:	
			e->name = lang(LG_COLOR_THEME);
			e->dtype = LE_DATA_TYPE_STR;
			e->d.s = color_theme[setting.color_theme];
		break;
		case 5:
			e->name = lang(LG_VOLUME);
			e->dtype = LE_DATA_TYPE_UINT32;
			e->d.unum = setting.volume;
		break;
		case 6:
			e->name = lang(LG_COMPOSING);
			e->dtype = LE_DATA_TYPE_BOOL;
			e->d.bval = setting.composing_events;
		break;
		case 7:
			e->name = lang(LG_AUTOCONNECT);
			e->dtype = LE_DATA_TYPE_BOOL;
			e->d.bval = setting.auto_connect;
		break;
		case 8:
			e->name = lang(LG_HIDE_EMPTY_GROUPS);
			e->dtype = LE_DATA_TYPE_BOOL;
			e->d.bval = setting.hide_empty_groups;
		break;
		case 9:
			e->name = lang(LG_SHOW_APP_UNDER_NEW_MSG);
			e->dtype = LE_DATA_TYPE_BOOL;
			e->d.bval = setting.show_app_under_new_msg;
		break;
		case 10:
			e->name = lang(LG_USE_UIX_EDITOR);
			e->dtype = LE_DATA_TYPE_BOOL;
			e->d.bval = setting.use_uix_editor;
		break;
		
		case 11:
			e->name = lang(LG_SAVE_HISTORY);
			e->dtype = LE_DATA_TYPE_BOOL;
			e->d.bval = setting.save_history;
		break;
		/*
		case 11:
			e->name = lang(LG_ZLIB_COMPRESSION);
			e->dtype = LE_DATA_TYPE_BOOL;
			e->d.bval = setting.zlib_enable;
		break;*/
	}
	return e;
}
UINT32 ListKeypress( EVENT_STACK_T * ev_st,  APPLICATION_T *app )
{
    APP_ELF_T        *papp = (APP_ELF_T*)app;
	EVENT_T 		 *event = AFW_GetEv(ev_st);
	APP_ConsumeEv( ev_st, app );
	
    switch (event->data.key_pressed)
    {
		 case KEY_2:
	     case KEY_UP:
			 		if (item.select == 0)
					    item.select = papp->entries_num;
					if (item.select > 0) 
                        item.select--;
                    if( papp->entries_num ) DrawList(app);
                    break;
					  
		 case KEY_8:	  
         case KEY_DOWN:
                    if (item.select < papp->entries_num) 
                        item.select ++;
					if (item.select == papp->entries_num)
						item.select = 0;
                    if( papp->entries_num ) DrawList(app);
					break;
		
		// Предыдущяя группа
		case KEY_LEFT:
		case_KEY_LEFT:;
			 		if (item.group == 0)
					     item.group = ContactListGetGroupCount();
					if (item.group > 0) 
                         item.group--;
					papp->entries_num = ContactListUpdate(setting.show_off_contacts, item.group);	
					if( setting.hide_empty_groups && !papp->entries_num ) // Если включено скрытые пустых групп
						goto case_KEY_LEFT;
					item.select = 0;
                    if( papp->entries_num ) DrawList(app);
                    break;
		// Следущая группа		    
         case KEY_RIGHT:
		 case_KEY_RIGHT:;
                    if (item.group < ContactListGetGroupCount()) 
                        item.group ++;
					if (item.group == ContactListGetGroupCount()) 
						item.group = 0;
					papp->entries_num = ContactListUpdate(setting.show_off_contacts, item.group);						
					if( setting.hide_empty_groups && !papp->entries_num ) // Если включено скрытые пустых групп
						goto case_KEY_RIGHT;
					item.select = 0;
                    if( papp->entries_num ) DrawList(app);
					break; 
		
		
		case KEY_SOFT_LEFT:
                state = MAIN_MENU;
				APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				break;
				
		case KEY_SOFT_RIGHT:
				if( !papp->entries_num ) return RESULT_OK;
				if(ContactListGetContact(item.select)->type == CONTACT_MUC && ContactListGetContact(item.select)->status == XMPPS_OFFLINE) return RESULT_OK;
                state = CONTACT_MENU;
				APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
				break;

		//Свернуть
		case KEY_RED:
		case KEY_GREEN:
				appHide( app );
				break;	
				

		//Выбрать
		case KEY_5:
        case KEY_JOY_OK:
				if(XMPPIsReady() && papp->entries_num) {
					if( ContactListGetContact(item.select)->chat ) {
						return APP_UtilChangeState( APP_STATE_CHAT, ev_st, app );
					} else {
						state = CONTACT_MENU;
						return APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
					}
				}	
				break;

		// В начало списка		
		case KEY_1:
				item.select = 0;
				DrawList(app);
                break;
		// В конец списка					
		case KEY_7:
				item.select = papp->entries_num - 1;
				DrawList(app);
                break;	
				
		case KEY_3:
				DrawList(app);
                break;
				
		case KEY_9:
				DrawList(app);
				break;
		
		case KEY_4:
				if(!XMPPIsReady() || !papp->entries_num) return RESULT_OK;
				state = CLIENT_INFO;
				
				XMPPSendVersionRequest(ContactListGetContact(item.select)->jid);
				strcpy(viewer_content, lang(LG_PLEASE_WAIT));
				APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
                break;


		case KEY_6:
				if(!XMPPIsReady() || !papp->entries_num) return RESULT_OK;
				state = CONTACT_INFO;
				XMPPSendVcardRequest(ContactListGetContact(item.select)->jid);
				strcpy(viewer_content, lang(LG_PLEASE_WAIT));
				APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
                break;	
				

		case KEY_0:	
				if(!XMPPIsReady() || !papp->entries_num) return RESULT_OK;
				state = CLIENT_INFO;
				strcpy(viewer_content, lang(LG_CLIENT));
				strcat(viewer_content, xmpp_clients[ContactListGetContact(item.select)->client_id].name);
				strcat(viewer_content, "\n");

				strcat(viewer_content, lang(LG_PRIORITY));
				itoa( ContactListGetContact(item.select)->priority, viewer_content+strlen(viewer_content), 10 );
				strcat(viewer_content, "\n");
				
				if ( ContactListGetContact(item.select)->resource ) {
					strcat(viewer_content, lang(LG_RESOURCE));
					strcat(viewer_content, ContactListGetContact(item.select)->resource);
					strcat(viewer_content, "\n");
				}
				/*if ( ContactListGetContact(item.select)->time ) {
					strcat(viewer_content, lang(LG_RESOURCE));
					strcat(viewer_content, ContactListGetContact(item.select)->time);
					strcat(viewer_content, "\n");
				}*/
				if ( ContactListGetContact(item.select)->status_msg ) {
					strcat(viewer_content, lang(LG_STATUS_MSG));
					strcat(viewer_content, ContactListGetContact(item.select)->status_msg);
					strcat(viewer_content, "\n");
				}
				
				if ( ContactListGetContact(item.select)->xstatus_msg ) {
					strcat(viewer_content, lang(LG_XSTATUS_MSG));
					strcat(viewer_content, ContactListGetContact(item.select)->xstatus_msg);
					strcat(viewer_content, "\n");
				}
				APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
				break;
		
		case KEY_STAR: // *
				ldrToggleConsole();
				break;
				
		case KEY_POUND:	// #
				if(setting.show_off_contacts)
					setting.show_off_contacts = false;
				else
					setting.show_off_contacts = true;
				
				item.select = 0;
				papp->entries_num = ContactListUpdate(setting.show_off_contacts, item.group);
				DrawList(app);
				break;
					
	}	
	return RESULT_OK;
}
UINT32 ConnectKeypress( EVENT_STACK_T * ev_st,  APPLICATION_T *app )
{
	APP_ELF_T			*papp = (APP_ELF_T*)app;
	EVENT_T				*event = AFW_GetEv(ev_st);
	APP_ConsumeEv( ev_st, app );

     switch (event->data.key_pressed)
     {
		//Свернуть
		case KEY_GREEN:
				appHide( app );
				break;	
				
		//Назад
		case KEY_RED:
		case KEY_SOFT_LEFT:
				im_connect = false;
				XMPPDisconnect();
				memclr(&item, sizeof(ITEM));
				APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
				AHG_Flush();
				break;
		}	
		
	return RESULT_OK;
}
UINT32 SmilesKeypress( EVENT_STACK_T * ev_st,  APPLICATION_T *app )
{
	APP_ELF_T         *papp = (APP_ELF_T*)app;
	EVENT_T *		 event = AFW_GetEv(ev_st);
	APP_ConsumeEv( ev_st, app );

     switch (event->data.key_pressed)
     {
		 case KEY_2:	
	     case KEY_UP:
			 		if (item.y == 0)
					     item.y = 4;
					if (item.y > 0) 
                         item.y--;
					 DrawSmiles();
                      break;
		case KEY_8:		  
        case KEY_DOWN:
					if (item.y < 4) 
                         item.y++;	 
					if (item.y == 4)
					     item.y = 0;
					  DrawSmiles();
					break;
					
		case KEY_4:	
	    case KEY_LEFT:
		 		 	if (item.x == 0)
					     item.x = 7;
					if (item.x > 0) 
                         item.x--;	  
					  DrawSmiles();
                      break;
		case KEY_6:		  
        case KEY_RIGHT:
					if (item.x < 7) 
                         item.x++;	 
					if (item.x == 7)
					     item.x = 0;	  
					 DrawSmiles();
					break;			
					
		//Выбрать
		case KEY_5:
		case KEY_JOY_OK:
		case KEY_SOFT_RIGHT:
				SelectItemSmiles( ev_st, app );
				break;
		
				
			
		//Назад
		case KEY_RED:
		case KEY_SOFT_LEFT:
				state = MSG_VIEWER;
				return APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
		}		
	return RESULT_OK;
}

//#####################################MAIN#####################################//

UINT32 DrawSmiles()
{
	AHIRECT_T				rect;
	UINT8					y, i, j;
	// Фон
	SetBrushColor(color.background);
	FillRect(0, 0, 176, 220);
	
	DrawTitleBar(ICON_SMILES, lang(LG_SMILES));
	DrawSoftBar(lang(LG_BACK), lang(LG_SELECT));
	

	y = 20;
	
	for( j = 0; j < 4; j++ ) { // Y
	
		for( i = 0; i < 7; i++ ) { // X
			rect.x1 = (i * 25); 
			rect.y1 = y + (j * 25); 
			rect.x2 = rect.x1 + 25; 
			rect.y2 = rect.y1 + 25;
			DrawBmpImage(image_smiles, &rect, (i * 25) + ((j * 7) * 25), 0); 
		}	
	}

	//рамка курсора
	SetBrushColor(color.cursor2);
	DrawRect((item.x*25), y+(item.y*25), 25, 25);
	
	AHG_Flush();

    return RESULT_OK;
}

//рисует список контактов
UINT32 DrawList(APPLICATION_T *app)
{
	APP_ELF_T        *papp = (APP_ELF_T*)app;
	char  			 buf[32];
	UINT8			 x=0, i=0, j=0, n=0, cursor_y=0; 
	CONTACT_T 		 *contact;

	SetBrushColor(color.background);
	FillRect(0, 0, 176, 220); // Фон
	
	// Загаловок
	SetBrushColor(color.bg_element); 
	FillRect(0, 0, 176, 20);
	SetBrushColor(color.border);
	DrawLine(0, 19, 176, 19);
	x = 2;
	if (ContactListGetIncomingMsgCount()) {
		DrawIcon(image_icons, x, 2, ICON_IN_MSG); // Иконка входящего сообщения
	} else if( XMPPIsReady() ) {
		DrawIcon(&bmp_status_icons, x, 2, setting.status); // Иконка статуса
	} else {
		DrawIcon(&bmp_status_icons, x, 2, XMPPS_OFFLINE); // Иконка оффлайн статуса
	}
	x += 17;
	SetFgColor( color.text );
	if(ContactListGetIncomingMsgCount()){
		strcpy(buf, "#");
		itoa(ContactListGetIncomingMsgCount(), buf+strlen(buf), 10);	// Число онлайн контактов
		DrawText(buf, x, 5, 0);
		x += StringWidth(buf);
	}
	
	DrawIcon(image_xstatus, x, 2, setting.xstatus ); // Иконка x-статуса
	
	if( setting.xstatus ) 
		x += 17;
	else if(ContactListGetIncomingMsgCount()) 
		x += StringWidth(" ");
	
	// Текст загаловка
	itoa(ContactListGetNumberOfOnlineUsers(), buf, 10);	// Число онлайн контактов
	strcat(buf, "/");
	itoa(ContactListGetNum(), buf+strlen(buf), 10);	// Общее число контактов
	strcat(buf, "-");
	itoa(session_traffic/1024, buf+strlen(buf), 10);	// Траффик
	strcat(buf, "Kb");
	DrawText(buf, x, 5, 0);
	
	
	if( setting.sound_on )
		DrawIcon(image_icons, 160, 2, ICON_SOUND_ON ); 
	else
		DrawIcon(image_icons, 160, 2, ICON_SOUND_OFF ); 
	
	
	// Время подключения
	//DL_DbFeatureGetCurrentState(SESSION_TIME, 

	while ( item.select < 0 )
		item.select += papp->entries_num;
	item.select = item.select;
	
	// проверяем выход курсора за экран
	// Если внизу за пределами экрана
	if ( item.select > item.first_idx + max_items - 1 ) {
		item.first_idx = item.select - max_items + 1;
	}
	// если вверху
	else if ( item.select < item.first_idx ) {
		item.first_idx = item.select;
	}
	
	cursor_y = 20 + ((item.select - item.first_idx) * 18);
	//курсор
	SetBrushColor(color.cursor); 
	FillRect(1, cursor_y, 167, 17);
	//рамка курсора
	SetBrushColor(color.cursor2);
	DrawRect(0, cursor_y, 167, 17);
	
	// строки
	// i - по строкам списка
	// j - по строкам на экране
	for ( i=item.first_idx, j=0; (i<papp->entries_num) && (j<max_items); i++, j++ ) 
	{
		DrawContact(ContactListGetContact(i), 2, 25 + (j * 18));
	}

	DrawMainSoftBar();
	DrawScroll( item.first_idx, max_items, papp->entries_num );
	AHG_Flush();
	
    return RESULT_OK;
}

// Загаловок
UINT32 DrawTitleBar(UINT8 icon, const char *text)
{

	SetBrushColor(color.bg_element); 
	FillRect(0, 0, 176, 20);
	SetBrushColor(color.border);
	DrawLine(0, 19, 176, 19);
	
	SetFgColor(color.text);

	DrawIcon(image_icons, 2, 2, icon ); // Иконка загаловка
	DrawText(text, 20, 5, false); 

    return RESULT_OK;
}

UINT32 DrawSoftBar(const char *left, const char *right)
{
	char    		 buf[8];
	CLK_TIME_T       time;

	SetBrushColor(color.bg_element); 
	FillRect(0, 200, 176, 20);
	SetBrushColor(color.border);
	DrawLine(0, 199, 176, 199);
	
	SetFgColor(color.text);
	DrawText(left, 3, 205, false);
	DrawText(right, 173-(StringWidth(right)), 205, false);
	

	//Часы 
	strcpy(buf, "");
	DL_ClkGetTime(&time);
	itoa(time.hour, buf+strlen(buf), 10);
	strcat(buf, ":");
	if(time.minute <= 9) strcat(buf, "0");
	itoa(time.minute, buf+strlen(buf), 10);
	SetFgColor(color.clock);
	DrawText(buf, (176-StringWidth(buf))/2, 205, false);
	
    return RESULT_OK;
}

UINT32 DrawMainSoftBar()
{
	char    		 buf[8];
	CLK_TIME_T       time;
	APP_ELF_T        *papp = (APP_ELF_T*)elf.app;

	SetBrushColor(color.bg_element); 
	FillRect(0, 196, 176, 24);
	SetBrushColor(color.border);
	DrawLine(0, 195, 176, 195);
		
	SetFgColor(color.text);
	DrawText(lang(LG_MENU), 3, 210, false);
	DrawText(lang(LG_CM), 173-StringWidth(lang(LG_CM)), 210, false);
	
	//Часы 
	strcpy(buf, "");
	DL_ClkGetTime(&time);
	itoa(time.hour, buf+strlen(buf), 10);
	strcat(buf, ":");
	if(time.minute <= 9) strcat(buf, "0");
	itoa(time.minute, buf+strlen(buf), 10);
	SetFgColor(color.clock);
	DrawText(buf, (176-StringWidth(buf))/2, 210, false);
	
	SetFgColor(color.text);
	 DrawText("<", 3, 198, false);
	 DrawText(">", 173-StringWidth(">"), 198, false);
	 
	if( XMPPIsReady() || papp->entries_num ) {
		//Имя группы 
		strcpy(buf, ContactListGetGroupNameByID(item.group));
		strcat(buf, " (");
		itoa(ContactListGetOnlineContactCount(item.group), buf+strlen(buf), 10 );	// Число онлайн контактов
		strcat(buf, "/");
		itoa(ContactListGetContactCount(item.group), buf+strlen(buf), 10 );		// Число оффлайн контактов
		strcat(buf, ")");
		DrawText(buf, (176-StringWidth(buf))/2, 198, false);
	} else {
		strcpy(buf, "Not connected");
		DrawText(buf, (176-StringWidth(buf))/2, 198, false);
	}	
    return RESULT_OK;
}

UINT32 DrawScroll( UINT8 pos, UINT8 cnt, UINT8 size ) // Ползунок
{
	UINT8 x = 176 - 8;
	UINT8 y = 20;
	UINT8 w = 8;
	UINT8 h = 220 - 20 - 25;
	UINT8 scroll_h;
	UINT8 cy;
	
	SetBrushColor(color.background);
	FillRect(x, y, w, h);
	if ( size <= cnt )
		// не нада рисовать
		return;
		
	SetBrushColor(color.border);
	DrawLine(x, y, x, y+h);
	
	/*scroll_h = (h * cnt) / size;
	if ( scroll_h < 5 )
		scroll_h = 5;
	// если приклеить к низу
	if ( (size - cnt - pos) <= 0 )
		cy = y + h - scroll_h;
	else
		cy = ((h * pos) / size) + y;
	*/
	SetBrushColor(color.bg_element);
	FillRect(x + 1, cy, x + w - 1, cy + scroll_h);
	
    return RESULT_OK;
}


UINT32 DrawIcon(AHIBITMAP_T *bitmap, UINT8 x, UINT8 y, UINT8 icon_index)
{
	AHIRECT_T		 rect;

	rect.x1 = x; 
	rect.y1 = y; 
	rect.x2 = rect.x1 + 16; 
	rect.y2 = rect.y1 + 16;

	DrawBmpImage(bitmap, &rect, icon_index*16, 0 );

    return RESULT_OK;
}

UINT32 DrawContact(CONTACT_T *c, UINT8 x, UINT8 y)
{
	AHIRECT_T		 rect;
	
	if ( !c ) return RESULT_FAIL;
	
	if(c->chat)
		SetFgColor(color.chat); // Цвет контактов с чатом
	else
		SetFgColor(color.text2);

	if ( c->composing ) { 							// Сообшение о наборе
		DrawIcon(image_icons, x, y-4, ICON_PEN);
	} else if ( c->new_msg ) {						// Иконка входящего сообщения
		DrawIcon(image_icons, x, y-4, ICON_IN_MSG );
	} else if ( c->subscription == SUB_NONE ){ 		// Иконка авторизации
		DrawIcon(image_icons, x, y-4, ICON_AUTH);
	} else if ( c->client_id == CLIENT_PYICQ_T && image_icq ) {  	// Иконка статусов ICQ
		DrawIcon(image_icq, x, y-4, c->status-1);
	} else if ( c->client_id == CLIENT_MRIM_TRANSPORT && image_mrim  ) { // Иконка статусов Mail.Ru Agent
		DrawIcon(image_mrim, x, y-4, c->status-1);	
	} else if ( c->client_id == CLIENT_VKONTAKTE && image_vkontakte ) { // Иконка статусов VKontakte
		DrawIcon(image_vkontakte, x, y-4, c->status-1);	
	} else {
		DrawIcon(&bmp_status_icons, x, y-4, c->status); // Иконка статуса
	}	
	
	if ( !c->xstatus || !image_xstatus ) {
		DrawText(c->nick, 18, y, 0);
	} else {
		DrawIcon(image_xstatus, 18, y-4, c->xstatus ); // Иконка x-статуса
		DrawText(c->nick, 34, y, 0);
	}
	
	DrawIcon(image_clients, 150, y-4, c->client_id);
	
	return RESULT_OK;
}	


UINT32 DrawLoadingScreen(char *text, UINT8 percent)
{
	AHIRECT_T		 rect;
	UINT8			 x;
	
	if( !elf.app->dialog ) return RESULT_OK;
	
	dbgf( "DrawLoadingScreen: enter, text = %s, percent = %d", text, percent );
	
	
	item.connect_percent = percent;
	strcpy(item.connect_text, text);
	
	
	SetBrushColor(0x524900);
	FillRect(0, 0, 176, 220); //фон

	SetBrushColor(0xAAAAAA);
	//DrawGradientRect(0, 220-2*percent, 5, 2*percent); // Левая шкала загрузки
	//DrawGradientRect(171, 220-2*percent, 5, 2*percent); // Правая шкала загрузки
	
	FillRect(0, 220-2*percent, 5, 2*percent); // Левая шкала загрузки
	FillRect(171, 220-2*percent, 5, 2*percent); // Правая шкала загрузки	
	
	SetFgColor(0xFFFFFF);
	DrawText(text, (176-StringWidth(text))/2, 210, 0);
	
	if ( !image_logo ) {
		DrawText(ELF_NAME" "ELF_VER, (176-StringWidth(ELF_NAME" "ELF_VER))/2, 100, 0);	
	} else {
	
		rect.y1 = (220 - image_logo->height)/2; 
		rect.y2 = rect.y1 + image_logo->height;
		
		
		for (x=0; x < image_logo->width; x++) {
		
			rect.x1 = ((176 - image_logo->width)/2) + x; 
			rect.x2 = rect.x1 + 1; 
			DrawBmpImage(image_logo, &rect, x, 0 );
		}
	}
	AHG_Flush();
	
    return RESULT_OK;
}

//Выбрать
UINT32 SelectItemMainMenu( EVENT_STACK_T *ev_st,  APPLICATION_T *app ) 
{
	APP_ELF_T		*papp = (APP_ELF_T*) app;
	UINT32			v = libGetVersion();
	
	switch(item.menu) {
	
		case 0:
			if(!XMPPIsReady()) {
				state = CONNECT;
				APP_UtilChangeState(APP_STATE_CONNECT, ev_st, app );
			} else {
				im_connect = false;
				XMPPDisconnect(); 
				memclr(&item, sizeof(ITEM));
				APP_UtilChangeState(APP_STATE_MAIN, ev_st, app );
			}
			break;
			
		//Статус
		case 1:
			state = SET_STATUS;
			APP_UtilChangeState(APP_STATE_MENU, ev_st, app );
			break;	
			
		//X-Статус	
		case 2:
			state = SET_XSTATUS;
			APP_UtilChangeState(APP_STATE_MENU, ev_st, app );
			break;
		
		//Вкл/Выкл звук		
		case 3:
			if(!setting.sound_on) {
				setting.sound_on = true;
				SetVol(1);
			} else {
				setting.sound_on = false;
				SetVol(0);
			}
			return UIX_Render( app->dialog );
			
			
		case 4:
			if(!XMPPIsReady()) return RESULT_OK;
			// Добавить контакт
			state = ADD_CONTACT;
			APP_UtilChangeState(APP_STATE_MENU, ev_st, app );
			break;
			
		case 5:
			state = SETTINGS;
			APP_UtilChangeState(APP_STATE_SETTING, ev_st, app );
			break;	
			
		case 6:
			state = ABOUT;
			char 		buf[1024];	
			const WCHAR *about_text = L"mJabber mobile XMPP-client.\n"
									L"(с) 2009-2010 R.U.S.H.A.N.\n"
									L"Version: " ELF_VER_W "\n"
									L"Official project site: \n"
									L"http://elfov.net.ru \n"
									L"\n"
									L"Thanks to MANЬЯК for logo & tests, sever20067 for tests\n"
									L"\n"
									// "Zlib version: %s\n"
									L"UIX libary version: %d.%d.%d.%d\n";					
			sprintf(viewer_content, UCS2toCP1251( about_text, buf ),
									// zlibVersion(),
									(UINT8)(v>>24),
									(UINT8)(v>>16),
									(UINT8)(v>> 8),
									(UINT8)(v    )
									 );							 
			APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
			break;
				
		// Выход	
		case 7:
			destroyApp( ev_st, app );
			break;
				
		// Свернуть	
		case 8:
			appHide( app );
			break;	
			
	}

	return RESULT_OK;
}

//Выбрать
UINT32 SelectItemContactMenu( EVENT_STACK_T *ev_st,  APPLICATION_T *app ) 
{
	switch( item.menu ) {
	//Сообщение
		case 0:
			state = EDIT_MSG;
			msg[0] = 0;
			APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
			break;
			
	
		case 1:
	// Выход из коференции
			/*if(ContactListGetContact(item.select)->type == CONTACT_MUC) 
				XMPPLeaveConference(ContactListGetContact(item.select)->jid);*/
	//Send Attention
			XMPPSendAttention(ContactListGetContact(item.select)->jid);
			APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			break;
			
	//Проверить статус
		case 2:
			XMPPCheckStatus( ContactListGetContact(item.select)->jid );
			APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			break;
	//Информация о контакте
		case 3:
			state = CONTACT_INFO;
			XMPPSendVcardRequest( ContactListGetContact(item.select)->jid );
			strcpy(viewer_content, lang(LG_PLEASE_WAIT));
			APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
			break;
	//Информация о клиенте
		case 4:	
			state = CLIENT_INFO;
			XMPPSendVersionRequest(ContactListGetContact(item.select)->jid);
			strcpy(viewer_content, lang(LG_PLEASE_WAIT));
			APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
			break;	
	//Копировать JID		
		case 5:
			CP1251toUCS2(ContactListGetContact(item.select)->jid, clipboard);
			APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			break;
	//Управление подпиской	
		case 6:
			state = SUBSCRIPTION_MENU;
			APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
			break;
	//Перенести в группу	
		case 7:
			state = SELECT_GROUP;
			APP_UtilChangeState( APP_STATE_MENU, ev_st, app );
			break;
			
	//Удалить...		
		case 8:
			XMPPRemoveContact( ContactListGetContact(item.select)->jid );
			APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			break;
	//Переименовать		
		case 9:
			state = EDIT_RENAME;
			APP_UtilChangeState( APP_STATE_EDIT, ev_st, app );
			break;
			
	//Подключится/Отключиткся	
		case 10:
			if(ContactListGetContact(item.select)->type == CONTACT_TRANSPORT){
				char pres_str[256];
				if(ContactListGetContact(item.select)->status == XMPPS_OFFLINE) {
					sprintf(pres_str,"<presence to='%s'/>", ContactListGetContact(item.select)->jid);
				} else {
					sprintf(pres_str, "<presence to='%s' type='unavailable'/>", ContactListGetContact(item.select)->jid);
				}
				SockSend( pres_str, strlen(pres_str) );
				APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
			}
			break;

		case 11:
			XMPPSendTranportRegisterRequest( ContactListGetContact(item.select)->jid );
			
			state = REGISTRATION;
			strcpy(viewer_content, lang(LG_PLEASE_WAIT));
			APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
			break;
		
	}
	
		return RESULT_OK;
}
//Выбрать
UINT32 SelectItemSmiles( EVENT_STACK_T *ev_st,  APPLICATION_T *app ) 
{
	char		*smiles_map[28] = { "O:-)", ":-))*size", ":-(", ";-)", ":-P", "8-)", ":-D",
									":-[", ":-O", ":-*", ":'(", ":-X", ">:o", ":-|", 
									":-/", "*jokingly*", "]:->", "[:-}", "*kissed*", ":-!", "*tired*",
									"*stop*", "*kissing*", "@}->--", "*thumbs up*", "*drink*", "*in love*", "@=" };
	UINT32		smile_indx;
	
	switch(item.y) {
		case 0:
			smile_indx = item.x;
			break;
		case 1:
			smile_indx = 7 + item.x;
			break;
		case 2:
			smile_indx = 14 + item.x;
			break;
		case 3:
			smile_indx = 21 + item.x;
			break;
	}
	
	
	strcat(viewer_content, " ");
	strcat(viewer_content, smiles_map[smile_indx]);
	
	state = MSG_VIEWER;
	return APP_UtilChangeState( APP_STATE_VIEWER, ev_st, app );
}


//Выбрать
UINT32 SelectItemSubscriptionMenu( EVENT_STACK_T *ev_st,  APPLICATION_T *app ) 
{

	switch(item.menu) {
	
		// Авторизовать
		case 0:
			XMPPSubscribed(ContactListGetContact(item.select)->jid);
			break;
			
		//Авторизоватся	
		case 1:
			XMPPSubscribe(ContactListGetContact(item.select)->jid);
			break;
			
		//Отклонить авторизацию	
		case 2:
			XMPPUnsubscribed(ContactListGetContact(item.select)->jid);
			break;
	}
	
	APP_UtilChangeState( APP_STATE_MAIN, ev_st, app );
	
		return RESULT_OK;
}


UINT32 ReadSetting() 
{
	UINT32 				r;
	FILE_HANDLE_T 		f;
	
	// читаем данные из конфига
	if (DL_FsFFileExist(file_cfg)) { // проверяем есть ли файл
	
		f = DL_FsOpenFile(file_cfg, FILE_READ_MODE, 0);
		DL_FsReadFile( &setting, sizeof(SETTING_T), 1, f, &r );
        DL_FsCloseFile(f);
		
        dbg("ReadSetting: done");
    } else { // если конфиг отсутствует, загружаем настройки по умолчанию
		dbg("ReadSetting: Read default settings");
		
		memclr( &setting, sizeof(SETTING_T) );
		
		setting.sound_on = true;
		setting.volume = 3;
		setting.save_history = true;
		strcpy( setting.time_zone, "+5" ); 
		setting.status = XMPPS_FREECHAT;
		strcpy( setting.status_msg[1], "Online" );
		strcpy( setting.status_msg[2], "Free for chat" );
		strcpy( setting.status_msg[3], "Away" );
		strcpy( setting.status_msg[4], "DND" );
		strcpy( setting.status_msg[5], "NA" );
	}
	
	return RESULT_OK;
}

// записываем в конфиг
UINT32 SaveSetting()
{
	UINT32 					w;
	FILE_HANDLE_T 			f;
	
	f = DL_FsOpenFile(file_cfg, FILE_WRITE_MODE, 0);
	// запись в файл
	DL_FsWriteFile( &setting, sizeof(SETTING_T), 1, f, &w );
		
	DL_FsCloseFile(f);
	
	dbg("Save Setting");
	return RESULT_OK;
}

UINT32 MsgDb_MsgAdd( char *jid, char *text, UINT8 type)
{
    WCHAR       	uri[256];
    UINT32      	w, fSize;
	MSG_T			msgdb;
	FILE_HANDLE_T	file = FILE_INVALID;
	
	dbg("MsgDb_MsgAdd: enter");

	DL_ClkGetDate( &msgdb.date );
	DL_ClkGetTime( &msgdb.time );
	msgdb.type = type;
	msgdb.len = strlen(text);
	msgdb.text = text;
	
	if ( !setting.save_history )
		return ContactListMsgAdd( ContactListFindContact(jid), &msgdb );
		
    // имя файла базы
    u_strcpy(uri, pathMsgDb);
    u_atou(jid, uri+u_strlen(uri));
	u_strcat(uri, L".mjh");

	if ( !DL_FsFFileExist(uri) ) { // если файл не существует, его нужно создать
		dbg("MsgDb_MsgAdd::Create new history file");
		file = DL_FsOpenFile(uri, FILE_WRITE_MODE, 0);
		DL_FsCloseFile( file );
		file = FILE_INVALID;
	}

    file = DL_FsOpenFile(uri, FILE_READ_PLUS_MODE, 0); // пишем в конец файла
    if (file == FILE_INVALID) return RESULT_FAIL;
   
    fSize = DL_FsGetFileSize(file);
	dbgf("MsgDb_MsgAdd: fSize = %d", fSize);
	
    DL_FsFSeekFile(file, fSize, SEEK_WHENCE_SET); // переходим в конец файла

	// дата
    DL_FsWriteFile(&msgdb.date, 1, 4, file, &w);
    // время
    DL_FsWriteFile(&msgdb.time, 1, 3, file, &w);
    // тип сообщения
    DL_FsWriteFile(&msgdb.type, 1, 1, file, &w);
    // длина текста сообщения
	DL_FsWriteFile(&msgdb.len, 1, 4, file, &w);
	// текст сообщения
    DL_FsWriteFile(msgdb.text, 1, msgdb.len, file, &w);

	dbgf("MsgDb_MsgAdd: msg_size = %d", msgdb.len);
	
    DL_FsCloseFile(file);
	
	dbg("MsgDb_MsgAdd: done");
	
    return RESULT_OK;
}

UINT32 MsgDb_LoadDb(char *jid)
{
    UINT32  		all=0, r, fSize, i=0, n=0, msg_num;
    WCHAR			uri[256];
	MSG_T 			msgdb;
	FILE_HANDLE_T	file = FILE_INVALID;
	
	dbg("MsgDb_LoadDb: enter");
	
	msg_num = MsgDb_GetCount( jid );
	
	if ( msg_num > MSG_COUNT )
		n = msg_num - MSG_COUNT;
	
	dbgf("MsgDb_LoadDb: n = %d", n);
	
    // имя файла базы
    u_strcpy(uri, pathMsgDb);
    u_atou(jid, uri+u_strlen(uri));
	u_strcat(uri, L".mjh");
	
	
    file = DL_FsOpenFile(uri, FILE_READ_PLUS_MODE, 0);
    if (file == FILE_INVALID) return -1;
 
    fSize = DL_FsGetFileSize(file);

	dbgf("MsgDb_LoadDb: fSize = %d", fSize);
	
	if ( !fSize ) return -1;	
	
	while (all < fSize) {
	
		all += 8;
        DL_FsFSeekFile(file, all, SEEK_WHENCE_SET);
        DL_FsReadFile(&msgdb.len, 1, sizeof(UINT32), file, &r); // читаем длину текста сообщения
        all +=  sizeof(UINT32) + msgdb.len;

		DL_FsFSeekFile(file, -12, SEEK_WHENCE_CUR);
		
		// читаем дату
		DL_FsReadFile(&msgdb.date, 1, 4, file, &r);
		// читаем время
		DL_FsReadFile(&msgdb.time, 1, 3, file, &r);
		// флаг
		DL_FsReadFile(&msgdb.type, 1, 1, file, &r);
		// читаем сообщение
		DL_FsReadFile(&msgdb.len, 1, 4, file, &r);
		msgdb.text = malloc( msgdb.len + 1 );
		if (!msgdb.text) return -1;
		DL_FsReadFile(msgdb.text, 1, msgdb.len, file, &r);
		msgdb.text[msgdb.len] = 0; // строка должна заканчиватся нулём
		
		if( i >= n )
			ContactListMsgAdd( ContactListFindContact(jid), &msgdb );
	
		i++; // кол-во сообщений всего
	}
	
	DL_FsCloseFile(file);
	
	dbgf("MsgDb_LoadDb: done, count = %d", i);

    return i;
}

UINT32 MsgDb_GetCount(char *jid)
{
    UINT32  		len, all=0, fSize, r, i=0;
    WCHAR   		uri[256];
	FILE_HANDLE_T	file = FILE_INVALID;
	
    // имя файла базы
    u_strcpy(uri, pathMsgDb);
    u_atou(jid, uri+u_strlen(uri));
	u_strcat(uri, L".mjh");

	
    file = DL_FsOpenFile(uri, FILE_READ_PLUS_MODE, 0); // пишем в конец файла
    if (file == FILE_INVALID) return -1;

    fSize = DL_FsGetFileSize(file);
	
	if ( !fSize ) return -1;	
	
	
    while (all < fSize) {
        all += 8;
        DL_FsFSeekFile(file, all, SEEK_WHENCE_SET);
        DL_FsReadFile(&len, 1, sizeof(UINT32), file, &r);
        all += sizeof(UINT32) + len;
        i++; // кол-во сообщений
    }

	DL_FsCloseFile(file);
	
	dbgf("MsgDb_GetCount: count = %d", i);
	
    return i;
}

UINT32 LoadTheme(UINT8 theme_index)
{
	if(theme_index >= COLOR_THEME_COUNT) theme_index = 0;
	switch(theme_index)
	{
		case 0:
		// White on black
			color.text				= 0xFEFEFE;	// Текст
			color.text2				= 0xBFC0C0;	// Текст меню
			color.cursor			= 0x4A004A;	// Курсор
			color.cursor2			= 0xA0A000;	// Рамка курсора
			color.clock				= 0xFFE400;	// Часы
			color.chat				= 0xFFFFFF;	// Цвет контакта с чатом
			color.background		= 0x000000;	// Фон
			color.bg_element		= 0x202020;	// Цвет загаловка и софтбара
			color.border			= 0x515151;	// Рамка загаловка и софтбара
		break;
	
		case 1:
		// Green
			color.text				= 0x000000;	// Текст
			color.text2				= 0x000000;	// Текст меню
			color.cursor			= 0xEFD77B;	// Курсор
			color.cursor2			= 0x9C7908;	// Рамка курсора
			color.clock				= 0x000000;	// Часы
			color.chat				= 0x9C7908;	// Цвет контакта с чатом
			color.background		= 0xDEFBDE;	// Фон
			color.bg_element		= 0xBDF7BD;	// Цвет загаловка и софтбара
			color.border			= 0x397939;	// Рамка загаловка и софтбара		
		break;
		
		case 2:
		// MRIM
			color.text				= 0x000000;	// Текст
			color.text2				= 0x000000;	// Текст меню
			color.cursor			= 0x5282B5;	// Курсор
			color.cursor2			= 0x426D94;	// Рамка курсора
			color.clock				= 0x000000;	// Часы
			color.chat				= 0x9C7908;	// Цвет контакта с чатом
			color.background		= 0xFFF3EF;	// Фон
			color.bg_element		= 0xDE9663;	// Цвет загаловка и софтбара
			color.border			= 0x632000;	// Рамка загаловка и софтбара		
		break;
		
		case 3:
		// Black on white
			color.text				= 0x000000;	// Текст
			color.text2				= 0x000000;	// Текст меню
			color.cursor			= 0xBDEFBD;	// Курсор
			color.cursor2			= 0xA55152;	// Рамка курсора
			color.clock				= 0x000000;	// Часы
			color.chat				= 0xA55152;	// Цвет контакта с чатом
			color.background		= 0xFFFFFF;	// Фон
			color.bg_element		= 0xDEDBDE;	// Цвет загаловка и софтбара
			color.border			= 0x737173;	// Рамка загаловка и софтбара		
		break;
		
		case 4:
		// Red
			color.text				= 0xFFFFFF;	// Текст
			color.text2				= 0xFFFFFF;	// Текст меню
			color.cursor			= 0x101410;	// Курсор
			color.cursor2			= 0xC65131;	// Рамка курсора
			color.clock				= 0xFFFFFF;	// Часы
			color.chat				= 0x9CA2A5;	// Цвет контакта с чатом
			color.background		= 0x212021;	// Фон
			color.bg_element		= 0xB53C21;	// Цвет загаловка и софтбара
			color.border			= 0x942000;	// Рамка загаловка и софтбара		
		break;
	}
	UIX_CS_SetColor( COLOR_BG, ATI_565RGB((color.background>>16), (color.background>>8), color.background) );
	UIX_CS_SetColor( COLOR_BG_ELEMENT, ATI_565RGB((color.bg_element>>16), (color.bg_element>>8), color.bg_element) );
	UIX_CS_SetColor( COLOR_BORDER, ATI_565RGB((color.border>>16), (color.border>>8), color.border) );
	UIX_CS_SetColor( COLOR_STR_NORMAL, ATI_565RGB((color.text>>16), (color.text>>8), color.text) );
	UIX_CS_SetColor( COLOR_STR_SELECTED, ATI_565RGB((color.chat>>16), (color.chat>>8), color.chat) );
	UIX_CS_SetColor( COLOR_CURSOR, ATI_565RGB((color.cursor>>16), (color.cursor>>8), color.cursor) );
	UIX_CS_SetColor( COLOR_CARET, ATI_565RGB((color.cursor2>>16), (color.cursor2>>8), color.cursor2) );
	
    return RESULT_OK; 
}

UINT32 InitResouces()
{
	WCHAR	 		file[256];
	DLHANDLE		libary;
	UINT32			status;
	
	dbg("InitResouces: enter");
	
	u_mkpath(file, elf.dir, L"resources.so", 0);
	
	libary = dlopen( file, RTLD_LOCAL );
	
		image_icons = dlsym( libary, "bmp_icons" );
	
		image_icq = dlsym( libary, "bmp_icq" );
		
		image_mrim = dlsym( libary, "bmp_mrim" );
	
		image_vkontakte = dlsym( libary, "bmp_vkontakte" );
		
		image_logo = dlsym( libary, "bmp_logo" );
		
		//image_smiles = dlsym( libary, "bmp_smiles" );
		
		image_clients = dlsym( libary, "bmp_clients" );
		
		image_xstatus = dlsym( libary, "bmp_xstatus" );
		
	
	if ( dlerror() ) cprint("InitResouces:\x84 error\n" );
	
	dlclose( libary );
	
	dbg("InitResouces: done");
	
	return status;
}

UINT32 Create(WCHAR *name)
{       
    WCHAR 		 uri[256]; 
	IFACE_DATA_T if_data;
	
	if_data.port = elf.app->port;

	
    u_strcpy(uri, elf.dir);
	u_strcat(uri, L"sounds/");
	u_strcat(uri, name);
	
    if (mme_media_file == 0 && DL_FsFFileExist(uri))
    {
        mme_media_file = MME_GC_playback_create(&if_data, uri, 0, 0, 0, 0, 0, 0); // открываем файл
    } 

    return RESULT_OK;
}

UINT32 SetVol(BOOL vol) // синхронизация громкости
{
   
   UINT8           volume_id=4;

    if (!strcmp(ldrGetPlatformName(), "LTE")) volume_id=2;

	
	if(vol)
		DL_AudSetVolumeSetting(volume_id, setting.volume);
	else
		DL_AudSetVolumeSetting(volume_id, NULL); // Безвучный режим
	
    return RESULT_OK;
}

UIX_ICON_T ElfGetIcon( AHIBITMAP_T *image, UINT8 i )
{
	UIX_ICON_T		icon;
	
		icon.bmp = image;
		icon.point.x = i * 16;
		icon.point.y = 0;
	
	return icon;
}

void XMPPProtocolNonify( UINT32 id, char * jid, void * data, UINT32 data_sz )
{
	APP_ELF_T *		papp = ( APP_ELF_T * )(elf.app);
	char			msg_buf[512];
	
	dbgf("XMPPProtocolNonify: id = 0x%p", id);
	if ( id < XMPP_NTF__BEGIN ) {
		// errors
		switch ( id ) {
			case XMPP_NTF__SET_HOST_ERROR:
				cprint("\x84 Error: Set host error\n");
				break;
			case XMPP_NTF__SOCKET_DELETE:
				cprint("\x84 Error: Socket delete\n");
				break;
			case XMPP_NTF__SOCKET_ERROR:
				cprint("\x84 Error: Socket error\n");
				break;
			case XMPP_NTF__JID_PW_ERROR:
				cprint("\x84 Error: JID/pw error\n");
				break;
			case XMPP_NTF__DISCONNECT:
				cprint("Disconnected\n");
				break;
			default:
				cprint("\x84 Error: Undefined\n");
		}
		im_connect = false;
		AppChangeState(elf.app, APP_STATE_MAIN, TRUE);
		
	} else if ( id < XMPP_NTF__EVENTS ) {
		if ( elf.app->state == APP_STATE_CONNECT ) {
			switch ( id ) {
				case XMPP_NTF__BEGIN:
					DrawLoadingScreen("", 1);
					break;
				case XMPP_NTF__CONNECTING:
					DrawLoadingScreen("Connecting...", 2);
					break;
				case XMPP_NTF__SEND_WELCOME:
					DrawLoadingScreen("Send Welcome...", 7);
					break;
				case XMPP_NTF__ZLIB_INIT_ACK:
					DrawLoadingScreen("Send zlib ask...", 15);
					break;
				case XMPP_NTF__LOGIN:
					DrawLoadingScreen("Login...", 25);
					break;
				case XMPP_NTF__LOGGED:
					DrawLoadingScreen("Logged...", 40);
					break;
				case XMPP_NTF__BIND:
					DrawLoadingScreen("Resouce binding...", 50);
					break;
				case XMPP_NTF__SESSION:
					DrawLoadingScreen("Init new session...", 60);
					break;
				case XMPP_NTF__ROSTER:
					DrawLoadingScreen("Roster request...", 70);
					break;
				case XMPP_NTF__BOOKMARKS:
					DrawLoadingScreen("Bookmarks request...", 80);
					break;
				case XMPP_NTF__PRESENSE:
					InitResouces();
					DrawLoadingScreen("Send Presense...", 95);
					break;	
				case XMPP_NTF__READY:
					DrawLoadingScreen("Ready...", 100);
					if( elf.app->state == APP_STATE_BG ) {
						cprint(ELF_NAME ":\x82 Connected\n");
					}
					AppChangeState(elf.app, APP_STATE_MAIN, FALSE);
					break;
			}
		}
	} else if ( id == XMPP_NTF__USER_STATUS ) {
			// data = data_sz = status id
			CONTACT_T *		contact = ContactListFindContact( jid );
			dbgf("handleXmppNonify::XMPP_NTF__USER_STATUS: contact = 0x%p", contact);
			if ( !contact ) goto done;
			
			if(data_sz != XMPPS_OFFLINE && contact->status > XMPPS_INVISIBLE ) {
				Create(L"online.mp3"); // подаём тон
			} else if(data_sz == XMPPS_OFFLINE && contact->status < XMPPS_INVISIBLE ) {
				Create(L"offline.mp3"); // подаём тон
			}
			if ( elf.app->state == APP_STATE_MAIN ) {
				papp->entries_num = ContactListUpdate(setting.show_off_contacts, item.group);
				DrawList(elf.app);
			}
			
			if( setting.console <= 1 ) goto done;
			strcpy(msg_buf, "\x87");
			strcat(msg_buf, contact->nick);
			strcat(msg_buf, ": \x8F");
			strcat(msg_buf, lang( LG_UPDATE_NICK + data_sz ));
			strcat(msg_buf, "\n");
			cprint(msg_buf);
			
	} else if ( id == XMPP_NTF__USER_TYPING ) {
		dbgf("handleXmppNonify::XMPP_NTF__USER_TYPING: composing = %d", data_sz);
		//  data_sz = composing
		if ( !data_sz ) goto done;
		
		Create(L"typing.mp3"); // подаём тон
		if (elf.app->state == APP_STATE_MAIN) 
			DrawList(elf.app);
		 else
			UIX_Render(elf.app->dialog);
			
	} else if ( id == XMPP_NTF__USER_INFO ) {
			
			state = CONTACT_INFO;
			strncpy(viewer_content, (char*)data, 2048);
			AppChangeState(elf.app, APP_STATE_VIEWER, FALSE);
	
	} else if ( id == XMPP_NTF__CLIENT_INFO ) {
			
			state = CLIENT_INFO;
			strncpy(viewer_content, (char*)data, 2048);
			AppChangeState(elf.app, APP_STATE_VIEWER, FALSE);

	} else if ( id == XMPP_NTF__INCOMING_MESSAGE  ) {
		CONTACT_T *		contact = ContactListFindContact( jid );
		dbgf("handleXmppNonify::XMPP_NTF__INCOMING_MESSAGE: contact = 0x%p", contact);
		Create(L"message.mp3"); // подаём тон
	
		MsgDb_MsgAdd( jid, data, MSG_TYPE_IN ); 
		
		papp->entries_num = ContactListUpdate(setting.show_off_contacts, item.group);
		
		if( elf.app->state == APP_STATE_CHAT ) {
			// Обновим чат
			if ( contact ) contact->new_msg = false;
			AppChangeState(elf.app, APP_STATE_CHAT, 0);
			
		} else if(elf.app->state == APP_STATE_BG  && setting.show_app_under_new_msg) {
			appShow( elf.app );
		} else {
			if ( !contact ) goto done;
			char	cons_msg[256];
			if(setting.console == 0 || setting.console == 2) goto done;
			strcpy(cons_msg, "\x89");
			strcat(cons_msg, contact->nick);
			strcat(cons_msg, ":\n\x8F");
			strncat(cons_msg, data, 128);
			strcat(cons_msg, "\n");
			cprint(cons_msg);
		}
	} else if ( id == XMPP_NTF__INCOMING_MESSAGE_SYSTEM ) {
		CONTACT_T *		contact = ContactListFindContact( jid );
		Create(L"srvmsg.mp3"); // подаём тон
		
		MsgDb_MsgAdd( jid, data, MSG_TYPE_SYSTEM ); 
		
		if ( contact ) contact->new_msg = true;
		
		papp->entries_num = ContactListUpdate(setting.show_off_contacts, item.group);
		
		if(elf.app->state == APP_STATE_CHAT) {
			AppChangeState(elf.app, APP_STATE_CHAT, FALSE);
		} else if(elf.app->state == APP_STATE_BG && setting.show_app_under_new_msg) {
			appShow( elf.app );
		}
		
	} else if ( id == XMPP_NTF__REGISTRATION_INSTRUCTIONS ) {
			
			state = REGISTRATION;
			strncpy( viewer_content, (char*)data, data_sz );
			viewer_content[data_sz] = 0;

			AppChangeState(elf.app, APP_STATE_VIEWER, FALSE);
		
	} else if ( id == XMPP_NTF__REGISTRATION_DATA ) {
			
			memcpy( &reg_info, data, data_sz );
			
	} else if ( id == XMPP_NTF__REGISTRATION_SUCCESSFUL ) {	// Регистраия в транспорте прошла успешно
			
			state = REGISTRATION;
			
			UIX_MessageBox( elf.app, 
							lang(LG_REGISTRATION_SUCCESSFUL), 
							lang(LG_REGISTRATION), 
							ElfGetIcon(image_icons, ICON_EDIT) 
						   );
	}
	
done:	dbg("XMPPProtocolNonify: done");
}
#ifdef	DEBUG
void ReportPhoneInfo()
{
	dbg("");
	
	dbgf("PhoneInfo: PhoneName = %s", ldrGetPhoneName());
	dbgf("PhoneInfo: PlatformName = %s", ldrGetPlatformName());
	dbgf("PhoneInfo: FirmwareVersion = %s", ldrGetFirmwareVersion());
	
	dbg("");
	const AHIDRVINFO_T	*ahi = ldrGetAhiDrvInfo();
	dbgf("PhoneInfo: ahi.drvName = %s", ahi->drvName);
	dbgf("PhoneInfo: ahi.drvVer = %s", ahi->drvVer);
	dbgf("PhoneInfo: ahi.totalMemory = %d b", ahi->totalMemory);
	dbgf("PhoneInfo: ahi.internalMemSize = %d b", ahi->internalMemSize);
	dbgf("PhoneInfo: ahi.externalMemSize = %d b", ahi->externalMemSize);
	dbg("");
}
#endif
