#include "accounts.h"

extern ldrElf		elf;
LIST				accounts;


int	AccountInit( void )
{
	FILE_HANDLE_T    a_file = FILE_INVALID;
	WCHAR   		 a_uri[256];
	
	u_mkpath(a_uri, elf.dir, L"accounts.list", 0);
	a_file = DL_FsOpenFile( a_uri, FILE_READ_MODE, 0);

	List_Init(&accounts, ACCOUNT_T);
	
	List_ReadFile( &accounts, a_file );
	
	DL_FsCloseFile( a_file );
}

int AccountUninit( void )
{ 
	FILE_HANDLE_T    	a_file = FILE_INVALID;
	WCHAR   		 	a_uri[256];

	u_mkpath(a_uri, elf.dir, L"accounts.list", 0);
	a_file = DL_FsOpenFile( a_uri, FILE_WRITE_MODE, 0);

	List_WriteFile( &accounts, a_file );
	DL_FsCloseFile( a_file );
	
	List_Clear( &accounts );
}

int AccountGetCount(void)
{
	return List_GetNum( &accounts );
}

ACCOUNT_T * AccountGet( int index )
{

	return (ACCOUNT_T *)List_GetItem(&accounts, index);
}

int AccountAddNew(void)
{
	ACCOUNT_T 		account;
	
	memclr(&account, sizeof(ACCOUNT_T));
	
	strcpy( account.login, "new" );
	strcpy( account.server, "jabber.ru" );
	strcpy( account.resource, "mJabber" );
	
	account.priority = 5;
	account.port = 5222;
	
	return List_AppendItem( &accounts, &account );
}

int AccountDelete( int index )
{
	return List_DeleteItem( &accounts, index );
}

