#ifndef __GDI__H__
#define __GDI__H__

#include <loader.h>
#include <apps.h>
#include <ATI.h>
#include <DAL.h>

#ifndef _bit
	#define _bit(ptr, bit) (((*(char*)((ptr) + ((bit) / 8))) >> (7 - ((bit) % 8))) & 1)
#endif

#define ATI_BITSTRIDE(width, bpp) (((bpp) && !(bpp & 7)) ? (width * (bpp / 8) + 3) & ~3 : width)

#ifdef	GDI_LIBRARY_BUILD
	#define EXPORT __attribute__ ((visibility("default")))
#else
	#define EXPORT
#endif

enum {
	GDI_INACTIVE = 0,
	GDI_SYSTEMDC,
	GDI_PRIVATEDC
};

enum {
	GDI_FLAG_NONE = 0x0,
	GDI_FLAG_NOSURF = 0x0,
	GDI_FLAG_SURFACE = 0x1
};

enum {
	GDI_ANI_NONE = 0x0,
	GDI_ANI_DONTFREE = 0x0,
	GDI_ANI_FREE = 0x1,
	GDI_ANI_FSW_FRAMES = 0x2,
	GDI_ANI_FSW_TIME = 0x4
};

enum {
	GDI_BMP_NONE = 0x0,
	GDI_BMP_DONTFREE = 0x0,
	GDI_BMP_FREE = 0x1
};

typedef struct uGDIPoint_tag {
	INT32		x, y;
} uGDIPoint;

typedef struct uGDIRect_tag {
	INT32		x1, y1, x2, y2;
} uGDIRect;

typedef struct uGDIDevice_tag {	//   GDI
	UINT32		context;		//	  (dCtx)
	UINT32		state;			//	 
} uGDIDevice;

typedef struct uGDIAhiROP_tag {
	UINT32		idle;			//	 AHIROP   
	UINT32		draw;			//   AHIROP   
} uGDIAhiROP;

typedef struct uGDISurface_tag {
	UINT32		surf;
	uGDIPoint	size;
} uGDISurface;

typedef struct uGDISurfaces_tag {
	uGDISurface	draw;
	uGDISurface	disp;
	uGDISurface	cache;
} uGDISurfaces;

typedef struct uGDIDeviceInfo_tag {
	BOOL		extsurf;			//     
} uGDIDeviceInfo;

typedef struct uGDIFont_tag {
	UINT8		width;				//  
	UINT8		height;				//  

	UINT32		count;				//  

	AHIROTATE_T	rot;				//        

	char		*data;				//        

	char		*chars;				//       

	AHIRECT_T	*rect;				//      
	AHIPOINT_T	*size;				//      
} uGDIFont;

typedef struct uGDIAnimation_tag {
	AHIBITMAP_T			bitmap;			//   
	AHISURFACE_T		surf;			//   

	INT32				width;			//  .  .       
	INT32				height;			//  
	INT32				frames;			//   .      

	UINT32				timeout;		//  
	UINT32				timestamp;		//      

	INT32				frameskip;		//    ,       
	INT32				skipped;		//    

	INT32				frame;			//   
	BOOL				active;			// ""  .  true -   .  false -     frame

	BOOL				transparent;	//  

	UINT32				flags;			//  

	struct	uGDIAnimation_tag	*next;	//  
} uGDIAnimation;

typedef struct uGDIBitmap_tag {
	AHIBITMAP_T			bitmap;			//   
	AHISURFACE_T		surf;			//   

	INT32				width;			//  
	INT32				height;			//  

	BOOL				transparent;	//  

	UINT32				flags;			//  

	struct	uGDIBitmap_tag	*next;		//  
} uGDIBitmap;

typedef struct uGDIObj_Animation_tag {
	uGDIAnimation	*first, *last;
} uGDIObj_Animation;

typedef struct uGDIObj_Bitmap_tag {
	uGDIBitmap		*first, *last;
} uGDIObj_Bitmap;




typedef struct uGDIContext_tag {
	uGDIDevice		device;			//   GDI
	uGDISurfaces	surfaces;		// : , , 
	uGDIDeviceInfo	info;			//   

	AHIRECT_T		region;			//    
	AHIROTATE_T		rotate;

	uGDIAhiROP		rop;			//  

	BOOL			dbuffer;		//   
	BOOL			surfswap;		//    

	BOOL			painting;		//   
	BOOL			rendering;		//   

	UINT32			flags;			//   
	AHICOLOROP_T	transop;		//  ,     0xFF00FF

	uGDIPoint		size;			//   (    )
	uGDIPoint		anisize;		//   ,     

	uGDIObj_Animation	animation;	//      
	uGDIObj_Bitmap		bitmap;		//      

	uGDIFont		font;			// 

	void			*app;			//   
} uGDIContext;




#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#ifdef	GDI_LIBRARY_BUILD
/// //////////////////////////////	  
EXPORT	UINT32	_init(void);	//    
EXPORT	UINT32	_fini(void);	//    
#endif

/// //////////////////////////////////////////////////////////////////////////////////	  GDI
EXPORT	UINT32	GDI_Init(uGDIContext *uCtx, const char *szIdent, void *app, UINT8 dMode, UINT32 dDefPatMode, UINT32 dDrawPatMode, BOOL dBufEnabled);
EXPORT	UINT32	GDI_UnInit(uGDIContext *uCtx);					//        (   !)

EXPORT	UINT32	GDI_BeginPaint(uGDIContext *uCtx);				//   
EXPORT	UINT32	GDI_EndPaint(uGDIContext *uCtx);				//    (      )

EXPORT	UINT32	GDI_SetDisplayRotation(uGDIContext *uCtx, AHIROTATE_T rot, BOOL resupd, BOOL fontupd);	//    

EXPORT	void	GDI_LockRendererByApp(uGDIContext *uCtx, void *app);	//       
EXPORT	void	GDI_UnlockRenderer(uGDIContext *uCtx);					//     


/// //////////////////////////////////////////////////////////////////////////////////////////////	    
EXPORT	UINT32	GDI_FillRect(uGDIContext *uCtx, INT32 X, INT32 Y, INT32 W, INT32 H, UINT32 brFg);		//  
EXPORT	UINT32	GDI_DrawRect(uGDIContext *uCtx, INT32 X, INT32 Y, INT32 W, INT32 H, UINT32 brFg);		//  
EXPORT	UINT32	GDI_DrawLine(uGDIContext *uCtx, INT32 X1, INT32 Y1, INT32 X2, INT32 Y2, UINT32 brFg);	//  


/// //////////////////////////////////////////////////////////////////////////////////////////////////	    
EXPORT	UINT32  GDI_CreateAniBitmapFromAhiBitmap(uGDIContext *uCtx, uGDIAnimation *uAni, AHIBITMAP_T *hBit);	//    AHI 
EXPORT	UINT32  GDI_CreateAniBitmapFromBinary(uGDIContext *uCtx, uGDIAnimation *uAni, void *bin,
												UINT32 width, UINT32 height, UINT32 pixfmt);			//     
EXPORT	UINT32	GDI_LoadAniBitmap(uGDIContext *uCtx, uGDIAnimation *uAni, const WCHAR *szPath);					//    
EXPORT	UINT32	GDI_UnLoadAniBitmap(uGDIContext *uCtx, uGDIAnimation *uAni);									//     

EXPORT	UINT32	GDI_RotateAniBitmapFrame(uGDIContext *uCtx, uGDIAnimation *uAni, AHIROTATE_T rot);				//    
EXPORT	UINT32	GDI_RotateAniBitmap(uGDIContext *uCtx, uGDIAnimation *uAni, AHIROTATE_T rot);					//    
EXPORT	UINT32	GDI_RotateAllAniBitmaps(uGDIContext *uCtx, AHIROTATE_T rot);									//   

EXPORT	void	GDI_NextAniFrame(uGDIAnimation *uAni);															//     


/// //////////////////////////////////////////////////////////////////////////////////////////////	   
EXPORT	UINT32	GDI_RenderAniBitmap(uGDIContext *uCtx, uGDIAnimation *uAni, INT32 X, INT32 Y);			//   
EXPORT	UINT32	GDI_RenderAniBitmapMulti(uGDIContext *uCtx, uGDIAnimation *uAni, AHIRECT_T *dstRectArr, AHIPOINT_T *srcPtArr, UINT32 count);
EXPORT	UINT32	GDI_RenderAniBitmapTrans(uGDIContext *uCtx, uGDIAnimation *uAni, INT32 X, INT32 Y);		//     
EXPORT	UINT32	GDI_RenderAniBitmapTransMulti(uGDIContext *uCtx, uGDIAnimation *uAni, AHIRECT_T *dstRectArr, AHIPOINT_T *srcPtArr, UINT32 count);


/// //////////////////////////////////////////////////////////////////////////////////////////////	    
EXPORT	UINT32  GDI_CreateBitmapFromAhiBitmap(uGDIContext *uCtx, uGDIBitmap *uBit, AHIBITMAP_T *hBit);	//  GDI   AHI 
EXPORT	UINT32  GDI_CreateBitmapFromBinary(uGDIContext *uCtx, uGDIBitmap *uBit, void *bin,
												UINT32 width, UINT32 height, UINT32 pixfmt);	//  GDI    
EXPORT	UINT32	GDI_LoadBitmap(uGDIContext *uCtx, uGDIBitmap *uBit, const WCHAR *szPath);				//  BMP   
EXPORT	UINT32	GDI_UnLoadBitmap(uGDIContext *uCtx, uGDIBitmap *uBit);									//     

EXPORT	UINT32	GDI_RotateBitmap(uGDIContext *uCtx, uGDIBitmap *uBit, AHIROTATE_T rot);					//   
EXPORT	UINT32	GDI_RotateAllBitmaps(uGDIContext *uCtx, AHIROTATE_T rot);								//   

EXPORT	UINT32	GDI_RenderRegionToBitmap(uGDIContext *uCtx, uGDIBitmap *uBit, BOOL disp);				//      
EXPORT	UINT32	GDI_RenderBitmap(uGDIContext *uCtx, uGDIBitmap *uBit, INT32 X, INT32 Y);				//  
EXPORT	UINT32	GDI_RenderBitmapToRegion(uGDIContext *uCtx, uGDIBitmap *uBit, INT32 srcX, INT32 srcY,
													INT32 dstX, INT32 dstY, INT32 dstW, INT32 dstH);	//    


/// //////////////////////////////////////////////////////////////////////////	      (120x64)
EXPORT	UINT32	GDI_AllocTempSurf(uGDIContext *uCtx, INT32 width, INT32 height);	//   
EXPORT	UINT32  GDI_CopyAniToTempSurf(uGDIContext *uCtx, uGDIAnimation *uAni);		//       
EXPORT	UINT32	GDI_FreeTempSurf(uGDIContext *uCtx);								//   


/// //////////////////////////////////////////////////////////////////////////////////////////////////////////	   
EXPORT	UINT32	GDI_InitFont(uGDIContext *uCtx, uGDIFont *uFont);													//  
EXPORT	UINT32	GDI_PrepareFont(uGDIContext *uCtx);																	//   
EXPORT	UINT32	GDI_UnInitFont(uGDIContext *uCtx);																	//     
EXPORT	UINT32	GDI_RenderString(uGDIContext *uCtx, char *string, INT32 X, INT32 Y, UINT32 brFg, UINT32 distance);	//    
EXPORT	UINT32	GDI_GetStringWidth(uGDIContext *uCtx, char *string, UINT32 distance);								//    ( )
EXPORT	UINT32	GDI_GetStringHeight(uGDIContext *uCtx, char *string);												//    ( )


/// //////////////////////////////////////////////////////	  GDI
inline	void	GDI_SwapSurfaces(uGDIContext *uCtx);	//      


/// //////////////////////////////////////////////////////////////////////////////////////	   
inline	void	GDI_UpdatePtPos(uGDIContext *uCtx, AHIPOINT_T *pt);						//   
inline	void	GDI_UpdatePtPosMulti(uGDIContext *uCtx, AHIPOINT_T *pt, INT32 count);	//   
inline	void	GDI_UpdateRcPos(uGDIContext *uCtx, AHIRECT_T *rc);						//   
inline	void	GDI_UpdateRcPosMulti(uGDIContext *uCtx, AHIRECT_T *rc, INT32 count);	//   


/// //////////////////////////////////////////////////////////////////////////////////////////////	,       
inline	void	AhiGetBitmapPixel(AHIBITMAP_T *bitmap, INT32 X, INT32 Y, UINT32 *pixel);		//   
inline	void	AhiSetBitmapPixel(AHIBITMAP_T *bitmap, INT32 X, INT32 Y, UINT32 pixel);			//   
inline	void	AhiUnpackBitmap(AHIBITMAP_T *bitmap, void *data, INT32 width, INT32 height, AHIROTATE_T rot);	//     


#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __GDI__H__
