
#include "helloworld.h"
UINT32              evcode_base;

/*  ?. ?   ? ?*/
const char app_name[APP_NAME_LEN] = "HelloWorld"; 


// ?? ?state-?

/* ?? HW_STATE_ANY (? ??state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    { EV_KEY_PRESS,             HandleKeypress },

    //    ? ??
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,           NULL           },
};

/* ? , ?????  ?.
   ?????, ??enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //  ??state
      NULL,                       //    state
      any_state_handlers          //   ?
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};

/* ?entry   ,   ?? ?*/
/* file_uri -  ??( argv[0]) */
/* param - ??( ?argv) */
/* reserve - ?  eventcode- (?64 ?)*/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32 status = RESULT_OK;
    evcode_base = reserve;    //  reserve
    

/*   */
    status = APP_Register( &evcode_base,            //  ??  
                           1,                       // ? ?  ?  
                           state_handling_table,    // ???
                           HW_STATE_MAX,            //  ??
                           (void*)HelloWorldStart );   // , ? ??
                   
    UtilLogStringData(" *** ELF *** HelloWorld: Register status %d", status);
    
    LdrStartApp(reserve);   // ?
    
    return 1;   //   ??, ?
}


/*  ? ? ? */
UINT32 HelloWorldStart( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
    APP_HELLOWORLD_T     *app = NULL;
    UINT32 status = RESULT_OK;
    
    UtilLogStringData(" *** ELF *** HelloWorld: HelloWorldStart");

    /* , ???? */
    if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    {
        return RESULT_FAIL; // ? ? ??
    }
    else
    {
        //   ?
        app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)APP_HandleEventPrepost, //   ?
                                                  sizeof(APP_HELLOWORLD_T), //  ??
                                                  reg_id,
                                                  0, 1,
                                                  1,
                                                  2, 0, 0 );
                                                  
        UtilLogStringData(" *** ELF *** HelloWorld: APP_InitAppData 0x%X", app);
        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, // ???
                            state_handling_table,
                            HelloWorldExit,
                            app_name,
                            0 );

        UtilLogStringData(" *** ELF *** HelloWorld: APP_Start 0x%X", status);

    }

    return RESULT_OK;
}


/*    ? */
UINT32 HelloWorldExit( EVENT_STACK_T *ev_st,  void *app )
{
    UINT32  status;

    /* ? ? */
    status = APP_Exit( ev_st, app, NULL );

    /* ? */
    LdrUnloadELF(&Lib); // &Lib ?  ?

    return status;
}

/*  ??state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    UtilLogStringData(" *** ELF *** HelloWorld: MainStateEnter");
    return RESULT_OK;
}

/*  , EV_KEY_PRESS ?  */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
    int mm;
    UtilLogStringData(" *** ELF *** HelloWorld: key pressed 0x%X", event->data.key_pressed);

   switch(event->data.key_pressed)
  {
     case 0:
         HAPI_LP393X_set_tri_color_led(0, 0x0ce);
         break; 
      case 1:
         HAPI_LP393X_set_tri_color_led(0, 0x1b7);
         break; 
      case 2:
         HAPI_LP393X_set_tri_color_led(0, 0x2a5);
         break; 
       case 3:
         HAPI_LP393X_set_tri_color_led(0, 0x394);
         break; 
    case 4:
         HAPI_LP393X_set_tri_color_led(0, 0x483);
         break; 
    case 5:
         HAPI_LP393X_set_tri_color_led(0, 0x572);
         break; 
    case 6:
         HAPI_LP393X_set_tri_color_led(0, 0x661);
         break; 
    case 7:
         HAPI_LP393X_set_tri_color_led(0, 0x750);
         break; 
    case 8:
         HAPI_LP393X_set_tri_color_led(0, 0x84f);
         break; 
    case 9:
         HAPI_LP393X_set_tri_color_led(0, 0x93e);
         break; 
    case 10:
         HAPI_LP393X_set_tri_color_led(0, 0xa21);
         break; 
    case 11:
         HAPI_LP393X_set_tri_color_led(0, 0xb03);
         break; 
    case 17:
         HAPI_LP393X_set_tri_color_led(0, 0xe00); 
         break; 
    case 18:
         HAPI_LP393X_set_tri_color_led(0, 0x0e0);
         break; 
   
    case 63:
    	   HAPI_LP393X_set_tri_color_led(0, 0x0);
         HelloWorldExit(ev_st, app);
         
   
   
   
   }
    
    for(mm=0;mm<=10000;mm++)
    {
    	 
    }
    
    HAPI_LP393X_set_tri_color_led(0, 0x0);
    return RESULT_OK;
}


  