#include "sysutil.h"

UINT8 GetCurrentDialogType(void)
{
    UINT8 type;
#ifdef DBGV
        PFprintf("*** %s *** Function: GetCurrentDialogType", app_name);
#endif
    UIS_GetActiveDialogType(&type);
    return type;
}

BOOL IsKeypadLock(void)
{
	UINT8 keypad_statate;
	DL_DbFeatureGetCurrentState( *KEYPAD_STATE, &keypad_statate );
	return keypad_statate;
}

BOOL IsWorkableDialog(void)
{
    if(GetCurrentDialogType()==DialogType_Homescreen && !IsKeypadLock())return TRUE;
    return FALSE;
}

UINT32 GetLinesInFile(FILE_HANDLE_T f)
{
    UINT32 start=DL_FsFGetPosition(f);
    BYTE * buf;
    UINT32 read;
    size_t size=DL_FsGetFileSize(f);
    UINT32 result=0;
    UINT32 i;
    
    DL_FsFSeekFile(f, 0, SEEK_WHENCE_SET);
    buf=malloc(size);
    DL_FsReadFile(buf, 1, size, f, &read);
    for(i=0;i<read;i++)
        if((buf[i]==13) && (buf[i+2]!=13) && (i!=read-2))result++;
    if(buf[i]!=10)result++;
    free(buf);
    DL_FsFSeekFile(f, start, SEEK_WHENCE_SET);
    
    return result;
}

UINT32 GetValidLinesInFile(FILE_HANDLE_T f)
{
    UINT32 start=DL_FsFGetPosition(f);
    BYTE * buf;
    UINT32 read;
    size_t size=DL_FsGetFileSize(f);
    UINT32 result=0;
    UINT32 i;
    UINT32 LastN=0;
    
    DL_FsFSeekFile(f, 0, SEEK_WHENCE_SET);
    buf=malloc(size);
    DL_FsReadFile(buf, 1, size, f, &read);
    for(i=0;i<read;i++)
    {
        if(buf[i]==13)
	{
            if((buf[i+2]!=13) && (buf[LastN]!=';') && (i!=read-2))result++;
            LastN=i+2;
	}
    }
    if(buf[i]!=10 && buf[LastN]!=';')result++;
    free(buf);
    DL_FsFSeekFile(f, start, SEEK_WHENCE_SET);

    return result;
}

UINT32 LoadFileToMem(WCHAR * fn, MEM_FILE_T * dest)
{
    FILE_HANDLE_T f;
    size_t size;
    UINT32 read;

    if(!DL_FsFFileExist(fn))
    {
	dest->size=NULL;
	dest->file=NULL;
        return RESULT_FAIL;
    }
    f=DL_FsOpenFile(fn, FILE_READ_MODE, NULL);
    size=DL_FsGetFileSize(f);
    dest->file=malloc(size);
    DL_FsReadFile(dest->file, 1, size, f, &read);
    dest->size=read;
    DL_FsCloseFile(f);
 #ifdef DBGV
        PFprintf("*** %s *** Function: LoadFileToMem malloc=%d read=%d", app_name, size, read);
#endif
    return RESULT_OK;
}