#include "ELF.h"

//     
BOOL exitN1;
BOOL exitN2;
BOOL exitN3;
UINT8 keyexitN1;
UINT8 keyexitN2;
UINT8 keyexitN3;

WCHAR ElfFolder[256];

SU_PORT_T port;
DRAWING_BUFFER_T    bufd;
UIS_DIALOG_T dialog;

EVENT_STACK_T * global_ev_st;
APPLICATION_T * global_papp;

IFACE_DATA_T LongKeyPressTimer;
IFACE_DATA_T ScroolSpeedTimer;

UINT32 Timers_Handles[TIMERS_COUNT];
UINT8 global_keypress = 0xFF;

DESKAPP_DATA_T DesktopApps[10];
UINT8 DesktopAppsCount;
UINT8 ActiveApp;


/*  .        */
const char app_name[APP_NAME_LEN] = "HomeScreen";


//     state-

/*    HW_STATE_ANY (   state) */
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{  
    //      
    //{ EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
    //{ EV_KEY_PRESS,           		  HandleKeypress },
    { STATE_HANDLERS_END,           NULL           },
};

const EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { STATE_HANDLERS_END,       	  NULL           },
};

/*   ,    -  .
      ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
    { HW_STATE_ANY,               // State
      NULL,                       //    state
      NULL,                       //    state
      any_state_handlers          //   
    },

    { HW_STATE_MAIN,
      MainStateEnter,
      NULL,
      main_state_handlers
    }

};

/******************************************************************************************
	 entry   ,     
	file_uri -    ( argv[0])
	param -   (  argv)
	reserve -   eventcode- ( 64 )
******************************************************************************************/
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve )
{
    UINT32              evcode_base;
    UINT32 		status = RESULT_OK;
    UINT8 i;
    
    evcode_base = reserve;    //  reserve
#ifdef DBGV
        PFprintf("*** %s *** RUN. Built: %d", app_name, BUILT_NUM);
        PFprintf("*** %s *** Function: Register", app_name);
#endif

    	/*   */
    status = APP_Register( &evcode_base,            //      
	       	 	       1,                       // - ,     
			       state_handling_table,    //  
			       HW_STATE_MAX,            //  
			       (void*)startApp );   // ,   

    keyexitN1=0xA;     //*
    keyexitN2=0xB;     //#
    keyexitN3=0xA;     //*
    ActiveApp=0;
    for(i=0;i<TIMERS_COUNT;i++)
        Timers_Handles[i]=NULL;
    
    u_atou(file_uri, ElfFolder);
    for (i=u_strlen(ElfFolder)-1; i > 0 ; i--)
    {
        if (ElfFolder[i] == '/') break;
        ElfFolder[i] = 0;
    }

    LdrStartApp(reserve);   //  
	
    return 1;   //    ,  
}


/*      */
UINT32 startApp( EVENT_STACK_T *ev_st,  REG_ID_T reg_id,  UINT32 param2 )//void *reg_hdl )
{
        APP_HELLOWORLD_T     *app = NULL;
    	UINT32 status = RESULT_OK;
#ifdef DBGV
        PFprintf("*** %s *** Function: StartApp", app_name);
#endif

    	/* ,    ? */
    	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK )
    	{
            return RESULT_FAIL; //     
    	}
    	else
        {
            //    
            app = (APP_HELLOWORLD_T*)APP_InitAppData( (void *)EventsMonitor, //  
                                                  	   sizeof(APP_HELLOWORLD_T), //   
                                                  	   reg_id,
                                                  	   0, 1,
                                                  	   1,
                                                  	   2, 0, 0 );
                                                  
        status = APP_Start( ev_st,
                            &app->apt,
                            HW_STATE_MAIN, //  
                            state_handling_table,
                            destroyApp,
                            app_name,
                            0 );
    	}

    	return RESULT_OK;
}


/*     */
UINT32 destroyApp( EVENT_STACK_T *ev_st,  void *app )
{
        UINT32  status;

    	/*    */
    	status = APP_Exit(ev_st, app, NULL);

    	//FreeItemsSettings();
        //DeleteDialog(ev_st, app);
    	/*   */
    	LdrUnloadELF(&Lib); // &Lib    

    	return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
#ifdef DBGV
        PFprintf("*** %s *** Function: MainStateEnter", app_name);
#endif
    global_papp=(APPLICATION_T*)app;
    global_ev_st=ev_st;
    return RESULT_OK;
}

/*  , EV_KEY_PRESS    */
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
    UINT8       keypress;
#ifdef DBGV
        PFprintf("*** %s *** Function: HandleKeypress", app_name);
#endif

    StartTimer(LONGKEYPRESS_TIMER, LONGKEYPRESS_TIMER_ID, ONESHOT_TIMER_TYPE, app);

    keypress = event->data.key_pressed;
    global_keypress = keypress;

    CheckCloseKeys(ev_st, app); //     
	
    HomeScreenToolsOnClick((UINT8)keypress, ev_st, app);

    return RESULT_OK;
}

UINT32 HandleKeyrelease( EVENT_STACK_T *ev_st,  void *app )
{

#ifdef DBGV
        PFprintf("*** %s *** Function: HandleKeyrelease", app_name);
#endif
    StopTimer(LONGKEYPRESS_TIMER_ID, app );
    StopTimer(SCROLLING_SPEED_TIMER_ID, app );
    global_keypress = 0xFF;

    return RESULT_OK;
}

UINT32 LongKeypress( EVENT_STACK_T *ev_st,  void *app )
{
    //EVENT_T     *event = AFW_GetEv(ev_st);
#ifdef DBGV
        PFprintf("*** %s *** Function: LongKeypress KEY: %d", app_name, global_keypress);
#endif

    HomeScreenToolsOnClick((UINT8)global_keypress, ev_st, app);
    StartTimer(SCROLLING_SPEED_TIMER, SCROLLING_SPEED_TIMER_ID, ONESHOT_TIMER_TYPE, app);
    
    return RESULT_OK;
}

UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
    UINT32 id = ((DL_TIMER_DATA_T*)(event->attachment))->ID;
    switch(id)
    {
	case(LONGKEYPRESS_TIMER_ID):
	    LongKeypress(ev_st, app);
	    break;
	case(SCROLLING_SPEED_TIMER_ID):
	    LongKeypress(ev_st, app);
	    break;
    }
    return RESULT_OK;
}

UINT32 StartTimer( UINT32 period, TIMERS_NUMBERS_T id, TIMER_TYPES_T type, void *app )
{
    UINT32 status;
    //APP_SHELL_T *papp = (APP_SHELL_T*)app;
    IFACE_DATA_T  iface;
#ifdef DBGV
        PFprintf("*** %s *** Function: StartTimer", app_name);
#endif
    if (Timers_Handles[id] != NULL) StopTimer( id, app );

    iface.port = ((APPLICATION_T*)app)->port;
    if (type==ONESHOT_TIMER_TYPE)
    {
        status = DL_ClkStartTimer( &iface, period, id );
    }
    else
    {
        status = DL_ClkStartCyclicalTimer( &iface, period, id );
    }
    Timers_Handles[id] = iface.handle;

    return status;
}

UINT32 StopTimer( TIMERS_NUMBERS_T id, void *app )
{
    UINT32 status;
    //APP_SHELL_T *papp = (APP_SHELL_T*)app;
    IFACE_DATA_T  iface;
#ifdef DBGV
        PFprintf("*** %s *** Function: StopTimer Timer_ID: %d", app_name, id);
#endif
    if(Timers_Handles[id]==NULL)
    {
#ifdef DBGV
        PFprintf("*** %s *** Function: StopTimer over(TimerHandle=NULL)", app_name);
#endif
        return RESULT_FAIL;
    }
    
    iface.port = ((APPLICATION_T*)app)->port;
    iface.handle = Timers_Handles[id];

    status = DL_ClkStopTimer( &iface );
    Timers_Handles[id] = NULL;

    return status;
}

UINT32 CheckCloseKeys( EVENT_STACK_T *ev_st, void *app )
{
    EVENT_T     *event = AFW_GetEv(ev_st);
    UINT8       keypress;
#ifdef DBGV
        PFprintf("*** %s *** Function: CheckCloseKeys", app_name);
#endif
    keypress = event->data.key_pressed;

    if (keyexitN1 != 0 && keyexitN2 != 0 && keyexitN3 != 0)
    {
        if (exitN1)
	{
	    if (exitN2)
	    {
	        if (!exitN3) if (keypress == keyexitN3) exitN3 = TRUE;
	    }
	    else
            {
	        if (keypress == keyexitN2) exitN2 = TRUE;
	    }
	}
	else
	{
	    if (keypress == keyexitN1) exitN1 = TRUE;
	}

	if (keypress != keyexitN1 && keypress != keyexitN2 && keypress != keyexitN3 )
	{
	    exitN1 = FALSE;
	    exitN2 = FALSE;
            exitN3 = FALSE;
        }
    }

    if(exitN1 & exitN2 & exitN3) return destroyApp(ev_st, app);

    return RESULT_OK;
}

UINT32 EventsMonitor( EVENT_STACK_T *ev_st, APPLICATION_T *app, APP_ID_T app_id, REG_ID_T reg_id )
{
    EVENT_T     *event;

    event = AFW_GetEv(ev_st);
    APP_HandleEventPrepost( ev_st, app, app_id, reg_id );
    
    if(event->code == NEW_DESKTOP_APP_EV)
    {
        NewDesktopAppRegister(ev_st, app);
        APP_ConsumeEv(ev_st, app);
	return RESULT_OK;
    }
    if(event->code == DEL_DESKTOP_APP_EV)
    {
        DesktopAppUnReg(ev_st, app);
        APP_ConsumeEv(ev_st, app);
	return RESULT_OK;
    }
    if(event->code == EV_KEY_PRESS)
    {
        HandleKeypress(ev_st, app);
        return RESULT_OK;
    }
    if(event->code == EV_KEY_RELEASE)
    {
        HandleKeyrelease(ev_st, app);
        return RESULT_OK;
    }
    if(event->code == EV_TIMER_EXPIRED)
    {
        Timer(ev_st, app);
        return RESULT_OK;
    }
    
    
    return RESULT_OK;
}

void HomeScreenToolsOnClick(UINT8 Key, EVENT_STACK_T *ev_st,  void *app)
{
    if(IsWorkableDialog())
    {
	if(Key==KEY_UP)
	{
	    ChangeActiveApp(ev_st, app, UP_DIRECT);
	    APP_ConsumeEv(ev_st, app);
	}
	if(Key==KEY_DOWN)
	{
	    ChangeActiveApp(ev_st, app, DOWN_DIRECT);
	    APP_ConsumeEv(ev_st, app);
	}
    }
}

UINT32 NewDesktopAppRegister( EVENT_STACK_T *ev_st, APPLICATION_T *app)
{
    EVENT_T     *event;
    DESKAPP_DATA_T TmpApp;
    UINT16 i, j;
#ifdef DBGV
        PFprintf("*** %s *** Function: NewDesktopAppRegister", app_name);
#endif
    event = AFW_GetEv(ev_st);
    
    if(event->attachment == NULL)return RESULT_FAIL;
#ifdef DBGV
        PFprintf("*** %s *** Function: NewDesktopAppRegister Add to stack", app_name);
#endif
    strcpy(DesktopApps[DesktopAppsCount].app_name, ((DESKAPP_DATA_T*)(event->attachment))->app_name);              //   
    DesktopApps[DesktopAppsCount].y = ((DESKAPP_DATA_T*)(event->attachment))->y;
    DesktopAppsCount++;                                                              //     
#ifdef DBGV
        PFprintf("*** %s *** Function: NewDesktopAppRegister sort begin", app_name);
#endif
    for(i=0;i<DesktopAppsCount-1;i++)              //    y
    {
	for(j=i+1;j<DesktopAppsCount;j++)
	{
	    if(DesktopApps[i].y > DesktopApps[j].y)
	    {
	        TmpApp.y = DesktopApps[i].y;
	        strcpy(TmpApp.app_name, DesktopApps[i].app_name);

		DesktopApps[i].y = DesktopApps[j].y;
                strcpy(DesktopApps[i].app_name, DesktopApps[j].app_name);

		DesktopApps[j].y = TmpApp.y;
                strcpy(DesktopApps[i].app_name, TmpApp.app_name);
	    }
	}
    }
    ChangeActiveApp(ev_st, app, NONE_DIRECT);
#ifdef DBGV
        PFprintf("*** %s *** Function: NewDesktopAppRegister sort end", app_name);
#endif
    return RESULT_OK;
}

UINT32 DesktopAppUnReg( EVENT_STACK_T *ev_st, APPLICATION_T *app)
{
    EVENT_T     *event;
    DESKAPP_DATA_T TmpApp;
    UINT16 i, j;
#ifdef DBGV
        PFprintf("*** %s *** Function: DesktopAppUnReg", app_name);
#endif
    event = AFW_GetEv(ev_st);

    if(event->attachment == NULL)return RESULT_FAIL;
    
    for(i=0;i<DesktopAppsCount;i++)
    {
        if(namecmp((char*)(event->attachment), DesktopApps[i].app_name))
	{
            DesktopApps[i].y=0xFFF;                        //   

            for(i=0;i<DesktopAppsCount-1;i++)              //    y
            {
	        for(j=i+1;j<DesktopAppsCount;j++)
	        {
	            if(DesktopApps[i].y > DesktopApps[j].y)
	            {
	                TmpApp.y = DesktopApps[i].y;
	                strcpy(TmpApp.app_name, DesktopApps[i].app_name);

		        DesktopApps[i].y = DesktopApps[j].y;
                        strcpy(DesktopApps[i].app_name, DesktopApps[j].app_name);

		        DesktopApps[j].y = TmpApp.y;
                        strcpy(DesktopApps[i].app_name, TmpApp.app_name);
	            }
	        }
            }
            DesktopAppsCount--;
	}
    }
    ChangeActiveApp(ev_st, app, NONE_DIRECT);

    return RESULT_OK;
}

UINT32 ChangeActiveApp( EVENT_STACK_T *ev_st, APPLICATION_T *app, DIRECTION_VERTICAL_T direct)
{
#ifdef DBGV
        PFprintf("*** %s *** Function: ChangeActiveApp", app_name);
#endif
    if(DesktopAppsCount == 0)return RESULT_FAIL;
    ActiveApp=(ActiveApp+direct-1)%DesktopAppsCount;
    AFW_CreateInternalQueuedEvAux(DESKAPP_GET_FOCUS_EV, FBF_LEAVE, sizeof(DesktopApps[ActiveApp]), DesktopApps[ActiveApp].app_name);       //   ,  
#ifdef DBGV
        PFprintf("*** %s *** Function: ChangeActiveApp Send get event", app_name);
#endif

    return RESULT_OK;
}