// UTF-8 w/o BOM

#ifndef SDK_TYPEDEFS_H
#define SDK_TYPEDEFS_H

#ifdef EMUELF
	#include <basetsd.h>
	#include <windows.h>
	#include <memory.h>

	// system types conflict workaround

	#define INT32					ELFINT32
	#define UINT32					ELFUINT32
	#define INT64					ELFINT64
	#define BOOL					ELFBOOL
#endif

typedef signed char				INT8;
typedef unsigned char			UINT8;
typedef signed short			INT16;
typedef unsigned short			UINT16;
typedef signed long				INT32;
typedef unsigned long			UINT32;

#ifdef WIN32
	typedef signed __int64			INT64;
	typedef unsigned __int64		UINT64;
#else
	typedef signed long long		INT64;
	typedef unsigned long long		UINT64;
#endif

typedef UINT8					BOOL;
typedef UINT8					BOOLEAN;

#ifdef __cplusplus
typedef wchar_t					WCHAR;
#else
typedef UINT16					WCHAR;
#endif

typedef UINT16					W_CHAR;
typedef UINT8					BYTE;
typedef UINT16					UIS_STRING_T;   
typedef char					UIS_ASCII_CHAR;


#endif // SDK_TYPEDEFS_H
