// extract_font.cpp:      .
//

#include "stdafx.h"

#define SWAP32(U) (U)<<24 | ((U)&0xFF00)<<8 | ((U)&0xFF0000)>>8 | (U)>>24

#define HDR_OFFSET 16


#define DEF_CG4_ORG 0x10F40000
#define DEF_IPATH "cg4.smg"
#define DEF_OPATH "font.bin"


#define ERROR(r) { ret = (r); break; }

void print_usage()
{
	printf( "Usage: extract_font [-c CG4_OFFSET] [-o OUT_PATH] [IN_PATH]\n" );
	printf( "by default:\n" );
	printf( "\tCG4_OFFSET = 0x%x\n", DEF_CG4_ORG );
	printf( "\tOUT_PATH   = %s\n", DEF_OPATH );
	printf( "\tIN_PATH    = %s\n", DEF_IPATH );
}


int main( int argc, char* argv[] )
{
	int		ret = 0;
	FILE	*fi = NULL, *fo = NULL;
	int		rd, wr, i;
	char	*data = NULL;
	int		cg4_org;
	DRM_LNG_HEADER_STRUCT_T drm;
	char	ipath[256], opath[256];



	printf( "(c) tim apple, motofan.ru, 2010-06-12\n" );


	// default values
	strncpy( ipath, DEF_IPATH, 256 );
	strncpy( opath, DEF_OPATH, 256 );
	cg4_org = DEF_CG4_ORG;

	i = 1;
	while ( i < argc )
	{
		// [-c CG4_OFFSET]
		if ( !_stricmp( argv[i], "-c" ) )
		{
			rd = 0;
			if ( ( i+1 < argc ) && ( rd = strtol( argv[i+1], 0,0 ) ) )
			{
				cg4_org = rd;
				i += 2;
				continue;
			}
		}

		// [-o OUT_PATH]
		if ( !_stricmp( argv[i], "-o" ) )
		{
			if ( i+1 < argc )
			{
				strncpy( opath, argv[i+1], 256 );
				i += 2;
				continue;
			}
		}

		// [IPATH]
		if ( argv[i][0] != '-' )
		{
			strncpy( ipath, argv[i], 256 );
			i++;
			continue;
		}


		print_usage();
		return 1;
	}

#ifdef _DEBUG
	printf( "ipath = %s\n", ipath );
	printf( "opath = %s\n", opath );
	printf( "cg4_org = 0x%x\n", cg4_org );
#endif

#ifdef _DEBUG
	printf( "sz = 0x%x \n", sizeof(DRM_LNG_HEADER_STRUCT_T) );
	//printf( "offset: 0x%x \n", (char*)&drm.lng_pkg_array[10] - (char*)&drm );
	printf( "offset: 0x%x \n", (char*)&drm.max_hplmn_lng_entries - (char*)&drm );
	printf( "offset: 0x%x \n", (char*)&drm.font_pkg - (char*)&drm );
#endif

	do
	{

		fi = fopen( ipath, "rb" );
		if ( !fi ) ERROR(-1);
		
		fseek( fi, HDR_OFFSET, SEEK_SET );
		rd = fread( &drm, sizeof(DRM_LNG_HEADER_STRUCT_T), 1, fi );
		if ( rd < 1 ) ERROR(-2);
		
		drm.font_pkg.lookuptableptr = SWAP32((UINT32)drm.font_pkg.lookuptableptr);
		drm.font_pkg.maintableptr   = SWAP32((UINT32)drm.font_pkg.maintableptr);
		
#ifdef _DEBUG
		printf( "font_pkg: %p, %p \n", drm.font_pkg.lookuptableptr, drm.font_pkg.maintableptr );
		//printf( "font_pkg: %x, %x \n",	SWAP32((UINT32)drm.font_pkg.lookuptableptr), 
		//								SWAP32((UINT32)drm.font_pkg.maintableptr) );
#endif

		/*  ,  lookuptable  maintable
		**       maintable  16 
		*/
		int off1 = (int)drm.font_pkg.lookuptableptr - cg4_org;
		int off2 = (int)drm.font_pkg.maintableptr - cg4_org;
		int	off3 = off2 + 16 * sizeof(UIS_FONTS_MAIN_TABLE_T);

		int sz = off3 - off1;
#ifdef _DEBUG
		printf( "%X, %X, %X, (%d)", off1, off2, off3, sz );
#endif

		data = (char*)malloc( sz + 16 );
		if ( !data ) ERROR(-3);

		fseek( fi, off1, SEEK_SET );
		rd = fread( data, sz, 1, fi );
		if ( rd < 1 ) ERROR(-4);

		fo = fopen( opath, "wb" );
		if ( !fo ) ERROR(-5);

		UINT32 lto = SWAP32( 16 );
		UINT32 mto = SWAP32( 16 + off2 - off1 );

		// write header
		wr = fwrite( &lto, 4, 1, fo );
		if ( wr < 1 ) ERROR(-6);
		wr = fwrite( &mto, 4, 1, fo );
		if ( wr < 1 ) ERROR(-7);
		
		fseek( fo, 16, SEEK_SET );
		wr = fwrite( data, sz, 1, fo );
		if ( wr < 1 ) ERROR(-8);

	} while (0);

	if ( data )
		free( data );
	if ( fi )
		fclose( fi );
	if ( fo )
		fclose( fo );

	printf( "done, ret = %d \n", ret );

#ifdef _DEBUG
	//if ( ret != 0 )
	//	getchar();
#endif

	return ret;
}


