#include "typedefs.h"

typedef struct
{
	UINT32 data;
	UINT16 font_height;
	UINT16 chars_index;
	UINT16 ranges_index;
	UINT16 blk_char_width;
	UINT16 rcount;
	UINT16 common_range_min;
	UINT16 common_range_max;
	UINT16 common_range_index;
	UINT16 common_range_offset;
	UINT16 ascend_value;
	UINT16 descend_value;
}  UIS_FONTS_MAIN_TABLE_T;

typedef struct
{
	UINT32					lookuptableptr;		// UINT8*
	UINT32					maintableptr;		// UIS_FONTS_MAIN_TABLE_T*
} DRM_FONT_INFO_STRUCT_T;


#define DRM_TYPEFACE_NAME_LENGTH 50

typedef struct
{
	UINT8 typefaceID;
	WCHAR typefaceName[DRM_TYPEFACE_NAME_LENGTH];
	UINT32 offset; // UINT8*
	UINT32 size;
	UINT8 minHeight;
	UINT8 maxHeight;
	UINT32 pxPerPoint; // float. 4 bytes ???
} DRM_TYPEFACE_ATTRIB_T;


typedef struct
{
	UINT32					typefaces_count;	// UINT8*
	UINT32					maintableptr;		// DRM_TYPEFACE_ATTRIB_T*
} DRM_TTF_FONT_INFO_STRUCT_T;


typedef struct
{
	UINT32		DRM_gResContent;
	UINT32		DRM_gResContentValue;
	UINT32		DRM_gResContentFormatString;
	UINT32		DRM_gResTransContentResId;
} DRM_RES_CONTENT_STRUCT_T;


typedef struct
{
	UINT32						prompt_data;             /* uint8 */
	UINT32						prompt_offset_tbl;
	UINT32						decode_table;
	UINT32						lexicus_type[2];
	DRM_RES_CONTENT_STRUCT_T    DRM_gResContentTable;    
	UINT32						drm_last_prompt;
	UINT32						drm_last_content;
} DRM_LNG_RES_STRUCT_T;


typedef struct
{
	UINT8				 lng_id;
	DRM_LNG_RES_STRUCT_T  lng_data;
} DRM_LNG_ARRAY_STRUCT_T;


typedef struct
{
	UINT8                             package_type; 
	UINT16                            bundle_id;               /* id for Bundle */
	UINT8                             num_available_lng;
	DRM_LNG_ARRAY_STRUCT_T            lng_pkg_array[10];
	UINT32                            max_hplmn_lng_entries; 	// UINT8*
	UINT32								mcc_lng_map_table;		// void*
	UINT32							 asian_data[10+3]; // DRM_ASIAN_DATA_STRUCT_T
	DRM_FONT_INFO_STRUCT_T            font_pkg;
	UINT32                            lng_pkg_last_address;		// void*
} DRM_LNG_HEADER_STRUCT_T;


typedef struct
{
   char						hdr[16];
   DRM_LNG_HEADER_STRUCT_T  lng_header_ptr; 
} DRM_ROM_STRUCT_T;

