#ifndef ZALIL_H
#define ZALIL_H


#include <apps.h>
#include <synsock_api.h>
#include "Graphics.h"



typedef struct
{ 
	APPLICATION_T	apt; /*   ,   */
    UINT32          item;
    UINT32          prev_item;

} APP_ELF;

/*   */
typedef enum
{
	HW_STATE_ANY, /* ANY-state   */
    HW_STATE_INIT,
	HW_STATE_MAIN,
    HW_STATE_CANVAS,
    HW_STATE_VIEWER,

	HW_STATE_MAX /*   */
} HW_STATES_T;

#define DRMRES_FOLDER		0x120000CE

typedef enum
{
	RES_LIST_CAPTION=0,
   	
	RES_MAX
} ELF_RESOURCE;

/*     */
RESOURCE_ID Resources[RES_MAX];

typedef struct
{
	WCHAR		name[FILENAME_MAX_LEN+1]; //  
	UINT16		attrib;   // 
} FILEINFO;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 


UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 ELF_Start( EVENT_STACK_T *ev_st, REG_ID_T reg_id, void * reg_hdl );
UINT32 ELF_Exit( EVENT_STACK_T *ev_st,  void *app );

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 MainStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );
UINT32 Navigate (EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app );
UINT32 SelectItem( EVENT_STACK_T *ev_st,  void *app );
UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num);
UINT32 UpdateList( EVENT_STACK_T *ev_st,  void *app, UINT32 sItem );

UINT32 CanvasStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 ViewerStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );
UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type );

UINT32 Back ( EVENT_STACK_T *ev_st,  void *app );
UINT32 HandleKeypress( EVENT_STACK_T *ev_st,  void *app );
UINT32 Timer( EVENT_STACK_T *ev_st,  void *app );



UINT32 HandleAPIAnsw( EVENT_STACK_T *ev_st, void *app );
UINT32 HandleSockAnsw( EVENT_STACK_T *ev_st, void *app );

UINT32 OpenFile(WCHAR *uri);
UINT32 CloseFile(void);
UINT32 UploadFile(void);
UINT32 socket_wr(char *request, UINT32 len);

void paint(void);

// Util
UINT32 UCS2toCP1251(WCHAR *src, char *trg);
UINT32 FindFile( WCHAR *folder, WCHAR *filtr ); //  
WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ) ;
UINT32 InitResources(void);
UINT32 RemoveResources(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */ 


#endif