#define DEBUG_APP_NAME				"Zalil"
#include "zalil.h"
#include <dbg.h>


#define HTTP_HOST			"zalil.ru"
#define HTTP_USER_AGENT		"Zalil/1.0"

//    
socket_f *				socket = NULL;
socket_connect_f *		socket_connect = NULL;
socket_write_f *		socket_write = NULL;
socket_read_f *			socket_read = NULL;
socket_bind_f *			socket_bind = NULL;
socket_close_f *		socket_close = NULL;
socket_delete_f *		socket_delete = NULL;

FILE_HANDLE_T   f;
HSOCK			g_socket;

UINT8   upload_mode=0;
UINT32  upload=0; //  
UINT8   prg;


#define TIME_PAINT  512 //    
#define BUF_SIZE    512 //     

#define boundary  "7d20345dc" // ,   
char        request[BUF_SIZE];
char        data1[128];
char        data2[] = "\r\n"
                      "--"  boundary  "--" "\r\n";


char FileName[64];
char link[32]; // id  

FILEINFO  *file_list=NULL; // 
WCHAR  cur_folder[256]; //  
UINT32 ENTRIES_NUM=4;		// - 

 UIS_DIALOG_T           dialog;
 DRAWING_BUFFER_T		bufd; //   

/*  .        */
const char app_name[APP_NAME_LEN] = DEBUG_APP_NAME;

//   http  2   ,     ,
//     GET  ,    
//  POST       "Content-Length",    
//char sock_write_data[128];


//     state-

/*    HW_STATE_ANY (   state) */
static EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
    /* GUI-     */
    { EV_REVOKE_TOKEN,              APP_HandleUITokenRevoked },
	
    { STATE_HANDLERS_RESERVED,	HandleAPIAnsw		},	//      socket api
	{ STATE_HANDLERS_RESERVED,	HandleSockAnsw		},	//     
    { EV_TIMER_EXPIRED,       	Timer               },

	//      
	{ STATE_HANDLERS_END,		NULL				},
};

static EVENT_HANDLER_ENTRY_T init_state_handlers[] =
{
    /*   ,      UI */
    { EV_GRANT_TOKEN,               HandleUITokenGranted },
    { STATE_HANDLERS_END,           NULL           },
};

static EVENT_HANDLER_ENTRY_T main_state_handlers[] =
{
    { EV_REQUEST_LIST_ITEMS,       	 HandleListReq  },
	{ EV_SELECT, 		             SelectItem },
	{ EV_LIST_NAVIGATE,				 Navigate },
    { EV_DONE,                     	 Back },
    { STATE_HANDLERS_END,            NULL },
};

static EVENT_HANDLER_ENTRY_T canvas_state_handlers[] =
{

    { EV_INK_KEY_PRESS,			         HandleKeypress },
    { STATE_HANDLERS_END,		NULL				},
};

static EVENT_HANDLER_ENTRY_T viewer_state_handlers[] =
{
    { EV_DONE,                 	Back                },
    { STATE_HANDLERS_END,		NULL				},
};

/*   ,    -  .
	   ,   enum-e */
const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
	{ HW_STATE_ANY,			// State
	  NULL,					//    state
	  NULL,					//    state
	  any_state_handlers	//   
	},

    { HW_STATE_INIT,
      NULL,
      NULL,
      init_state_handlers
    },

	{ HW_STATE_MAIN,
	  MainStateEnter,
	  MainStateExit,
	  main_state_handlers
	},

    { HW_STATE_CANVAS,
	  CanvasStateEnter,
	  StateExit,
	  canvas_state_handlers
	},

    { HW_STATE_VIEWER,
	  ViewerStateEnter,
	  StateExit,
	  viewer_state_handlers
	}
};

UINT32 LdrFindEventHandlerTbl( EVENT_HANDLER_ENTRY_T *tbl,  EVENT_HANDLER_T *hfn )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].hfunc==hfn)	
			return tbl[i].code;

		i++;
	}

	return 0;
}

UINT32 LdrInitEventHandlersTbl( EVENT_HANDLER_ENTRY_T *tbl,  UINT32 *base )
{
	UINT32			i=0;
	while( tbl[i].code!=STATE_HANDLERS_END )
	{
		if(tbl[i].code==STATE_HANDLERS_RESERVED)	
			tbl[i].code = (*base)++;

		i++;
	}
	return *base;
}

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char * file_uri, char * param, UINT32 reserve )
{
	UINT32          status = RESULT_OK;
    UINT32			evcode_base= reserve;


    //  
	LdrInitEventHandlersTbl((EVENT_HANDLER_ENTRY_T *)any_state_handlers, &evcode_base);

    /*   */
	status = APP_Register( &evcode_base,			//      
						   1,						// - ,     
						   state_handling_table,	//  
						   HW_STATE_MAX,			//  
						   (void*)ELF_Start );		// ,   


	LdrStartApp(evcode_base);	//  

	
	return 1;				//    ,  
}


UINT32 ELF_Start( EVENT_STACK_T *ev_st, REG_ID_T reg_id, void * reg_hdl )
{
	APP_ELF	*	app = NULL;
	UINT32		status = RESULT_OK;
	
	dbg("ELF_Start: Enter", NULL);
	
	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK ) {
		return RESULT_FAIL; //     
	} else {


        app = (APP_ELF*)APP_InitAppData( (void *)APP_HandleEvent, //     GUI
                                              sizeof(APP_ELF), //   
                                              reg_id,
                                              0, 1,
                                              1,
                                              1, 1, 0 );

        InitResources();

		dbg("ELF_Start: APP_InitAppData DONE, app = 0x%p", app);
		status = APP_Start( ev_st,
							&app->apt,
							HW_STATE_INIT, //  
							state_handling_table,
							ELF_Exit,
							app_name,
							0 );
		dbg("ELF_Start: APP_Start DONE, status = %d", status);

		
		g_socket = HSOCK_INVALID;
        u_strcpy(cur_folder, L"/"); //    
	}

	dbg("ELF_Start: END", NULL);
	
	return RESULT_OK;
}


/*     */
UINT32 ELF_Exit( EVENT_STACK_T *ev_st, void *app )
{
	UINT32 status;

	dbg("ELF_Exit: Enter", NULL);

    APP_UtilStopTimer(app);
    CloseFile();
    if ( g_socket != HSOCK_INVALID ) {
            //  
            status = socket_close( g_socket );
			dbg("socket_close DONE, status = %d", status);
			status = socket_delete( g_socket );
			dbg("socket_delete DONE, status = %d", status);
            g_socket = HSOCK_INVALID;
	}
    free(file_list);
    RemoveResources();

	
	/*    */
	status = APP_Exit( ev_st,(APPLICATION_T*) app, NULL );
	dbg("ELF_Exit: APP_Exit DONE, status = %d", status);
	
	dbg("ELF_Exit: call LdrUnloadELF... END", NULL);
	/*   */
	LdrUnloadELF(&Lib); // &Lib    
	
	return status;
}

UINT32 HandleUITokenGranted( EVENT_STACK_T *ev_st,  void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;
    UINT32                  status;

    //    
    status = APP_HandleUITokenGranted( ev_st, app );

    //   ,   state
    if( (status == RESULT_OK) && (papp->token_status == 2) )
        status = APP_UtilChangeState( HW_STATE_MAIN, ev_st, app );

    return status;
}


UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APP_ELF                 *papp = (APP_ELF*)app;
    SU_PORT_T               port = papp->apt.port;
	UINT32					starting_num;

	if(type!=ENTER_STATE_ENTER) return RESULT_OK;
            
       
		FindFile( cur_folder , L"*" );

        DRM_SetResource( Resources[RES_LIST_CAPTION],  cur_folder , (u_strlen(cur_folder)+1)*sizeof(WCHAR) );

        papp->prev_item = 1;
        papp->item = 1;

    	dialog = UIS_CreateList( &port,
    							 0,
    							 ENTRIES_NUM,
    							 0,
    							 &starting_num,
    							 0,
    							 2,
    							 NULL,
    							 Resources[RES_LIST_CAPTION] );
      
    
        if(dialog == NULL) return RESULT_FAIL;
    
        papp->apt.dialog = dialog;

    	//   ,     starting_num 
    	SendListItems(ev_st, app, 1, starting_num);

    return RESULT_OK;
}

UINT32 MainStateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
        return RESULT_OK;

    dbg("StateExit", NULL);
    free(file_list);
	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}

UINT32 Navigate (EVENT_STACK_T *ev_st,  void *app )
{
    APP_ELF           *papp = (APP_ELF*)app;
    EVENT_T               *event = AFW_GetEv(ev_st);

	papp->item = event->data.index;
	return RESULT_OK;
}


/* -  EV_REQUEST_LIST_ITEMS -   List    
          */
UINT32 HandleListReq( EVENT_STACK_T *ev_st,  void *app )
{
	APP_ELF			        *papp = (APP_ELF*) app;
	EVENT_T					*event;
	UINT32					start, num;

	//      "",      
	if( !papp->apt.focused ) return RESULT_OK;

	//      
	event = AFW_GetEv( ev_st );

	start = event->data.list_items_req.begin_idx;
	num = event->data.list_items_req.count;

	//   ,     - ,      
	APP_ConsumeEv( ev_st, app );
    return SendListItems( ev_st, app, start, num );
}

UINT32 SelectItem( EVENT_STACK_T *ev_st,  void *app ) 
{
    APP_ELF         *papp = (APP_ELF*) app;
    UINT32          i;
    WCHAR           uri[256];


	//APP_ConsumeEv( ev_st, app );

    dbg("Select item in FB", NULL);
    

    	    if (papp->item == 1 && u_strcmp(cur_folder, L"/"))
			{
                 dbg("Level Up", NULL);
				// 
				if (cur_folder[u_strlen(cur_folder)-1] == '/') cur_folder[u_strlen(cur_folder)-1] = 0;
					for (i=u_strlen(cur_folder)-1; i > 0 ; i--)
					{
						if (cur_folder[i] == '/'){
							break;
						} else {
							cur_folder[i] = 0;
						}
					}

					FindFile( cur_folder, L"*" );
	

                    DRM_SetResource( Resources[RES_LIST_CAPTION],  cur_folder , (u_strlen(cur_folder)+1)*sizeof(WCHAR) );
					UpdateList(ev_st, app, papp->prev_item);
                    papp->prev_item = 1;
                    UIS_Refresh();
			}
			else
				{
					if (file_list[papp->item-1].attrib & FS_ATTR_DIRECTORY)
					{
                        dbg("Open folder", NULL);
                        //   
                        papp->prev_item = papp->item;
						u_strcat(cur_folder, file_list[papp->item-1].name);
						u_strcat(cur_folder, L"/");
                        
						FindFile( cur_folder, L"*" );

                        DRM_SetResource( Resources[RES_LIST_CAPTION],  cur_folder , (u_strlen(cur_folder)+1)*sizeof(WCHAR) );
                        UpdateList(ev_st, app, 1);
                        UIS_Refresh();
					}
					else
					{
                        u_strcpy(uri, cur_folder);
                        u_strcat(uri, file_list[papp->item-1].name);
                        OpenFile(uri);
                        APP_UtilChangeState( HW_STATE_CANVAS,  ev_st,  app );
					}
				}

	
	return RESULT_OK;
}

UINT32 SendListItems( EVENT_STACK_T *ev_st,  void *app, UINT32 start, UINT32 num)
{
    APPLICATION_T			*papp = (APPLICATION_T*) app;
	LIST_ENTRY_T			*plist=NULL; //    
	UINT32					i, index, status=RESULT_OK;
	UINT32					img_res=NULL;
    
    if( num==0 ) return RESULT_FAIL; //  ,   
	
	plist = malloc( sizeof(LIST_ENTRY_T)*num ); // malloc
	if( plist==NULL ) return RESULT_FAIL;

    for( index=0, i=start; (i<start+num) && (i<=ENTRIES_NUM+1); i++, index++)
	{
				plist[index].editable = FALSE;			//  
				plist[index].content.static_entry.unk6 = 1;

                img_res=NULL;
                

                    if (file_list[i-1].attrib & FS_ATTR_DIRECTORY) 
                    {
                        img_res = DRMRES_FOLDER;
                    } else {
                        img_res = NULL;
                    }

                    UIS_MakeContentFromString( "p1q0", &(plist[index].content.static_entry.text), file_list[i-1].name, img_res);

	}


    //       ,    
	status = APP_UtilAddEvUISListData( ev_st, app, 0,
									   start, num,
									   FBF_LEAVE,
									   sizeof(LIST_ENTRY_T)*num,
									   plist );
	if( status != RESULT_FAIL )
	{
		//        
		status = UIS_HandleEvent(papp->dialog, ev_st);
	}

	free(plist);

	return status;
}


UINT32 UpdateList( EVENT_STACK_T *ev_st,  void *app, UINT32 sItem )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;

	if (sItem > 0) {
        dbg("Update List", NULL);
            APP_UtilAddEvUISListChange( ev_st,
                                    app,
                                    0, // = 0
                                    sItem,
                                    ENTRIES_NUM,
                                    TRUE,
                                    2,          // = 2
                                    FBF_FREE,
                                    NULL,
                                    NULL );	

            UIS_HandleEvent( papp->dialog,  ev_st );
    }
			
	
	return RESULT_OK;
}

/*    state */
UINT32 CanvasStateEnter( EVENT_STACK_T * ev_st, void * app, ENTER_STATE_TYPE_T type )
{
    APPLICATION_T       *papp = (APPLICATION_T*) app;
    SU_PORT_T           port = papp->port;
	ADD_EVENT_DATA_T    add_data;

    if(type!=ENTER_STATE_ENTER) return RESULT_OK;

	dbg("MainStateEnter: type = %d, app = 0x%p", type, app);

    bufd.w = 176;
    bufd.h = 220;
    bufd.buf = NULL;

	dialog = UIS_CreateColorCanvas ( &port, &bufd, false ); //  

    if(dialog == 0) return RESULT_FAIL;

    papp->dialog = dialog;

	paint();
	
	//  API  SynSock
	add_data.data_tag = 0;
	add_data.data.params[0] = LdrFindEventHandlerTbl(any_state_handlers, HandleAPIAnsw );		//      
	SockReqAPI(add_data);
	
	return RESULT_OK;
}


UINT32 ViewerStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type )
{
    APPLICATION_T         *papp = (APPLICATION_T*)app;
    SU_PORT_T             port = papp->port;
    CONTENT_T             content;
    WCHAR                 u_link[64];
    

	if(type!=ENTER_STATE_ENTER) 
		return RESULT_OK;

    dbg("ViewerStateEnter", NULL);

    u_strcpy(u_link, L"slil.ru/");
    u_atou(link, u_link+u_strlen(u_link));
    UIS_MakeContentFromString( "q0Nq1", &content, L"", u_link);

    dialog = UIS_CreateViewer( &port, 
                               &content,
                               NULL );

    if(dialog == NULL) return RESULT_FAIL;
    
    papp->dialog = dialog;
        
    return RESULT_OK;
}


UINT32 StateExit( EVENT_STACK_T *ev_st,  void *app,  EXIT_STATE_TYPE_T type )
{
	APPLICATION_T           *papp = (APPLICATION_T*) app;

    if ( type == EXIT_STATE_SUSPEND )
        return RESULT_OK;

    dbg("StateExit", NULL);

	APP_UtilUISDialogDelete( &papp->dialog );

	return RESULT_OK;
}



UINT32 Back( EVENT_STACK_T *ev_st, void *app )
{
    APPLICATION_T           *papp = (APPLICATION_T*) app;

    if (papp->state == HW_STATE_VIEWER ) {
        return APP_UtilChangeState( HW_STATE_MAIN,  ev_st,  app );
    } else if (papp->state == HW_STATE_MAIN) {
        return ELF_Exit(ev_st,app);
    }

	return RESULT_OK;
}


UINT32 Timer( EVENT_STACK_T *ev_st,  void *app )                
{

	if (((DL_TIMER_DATA_T*)(AFW_GetEv(ev_st)->attachment))->ID == 0)
	{
        paint();
        if (upload_mode < 3) UploadFile();
        APP_UtilStartTimer( TIME_PAINT, 0, app );
    }

    return RESULT_OK;
}


UINT32 HandleKeypress( EVENT_STACK_T *ev_st, void *app )
{
	UINT8               keypress = (AFW_GetEv(ev_st))->data.key_pressed;
    UINT32              status;


    if(keypress == KEY_RED) {
        return ELF_Exit(ev_st,app);
    } else if(keypress == KEY_LSOFT) {
        APP_UtilStopTimer(app);
        CloseFile();
        
        if ( g_socket != HSOCK_INVALID ) {
            //  
            status = socket_close( g_socket );
			dbg("socket_close DONE, status = %d", status);
        }
        return APP_UtilChangeState( HW_STATE_MAIN,  ev_st,  app );
    }

	
	return RESULT_OK;
}

UINT32 HandleAPIAnsw( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *	event = AFW_GetEv(ev_st);
    //UINT32      status;
	int			i;
	
	dbg("APIAnsw: Enter", NULL);
	
	APP_ConsumeEv( ev_st, app );
	
	socket = (socket_f *)(event->data.params[0]);
	socket_connect = (socket_connect_f *)(event->data.params[1]);
	socket_write = (socket_write_f *)(event->data.params[2]);
	socket_read = (socket_read_f *)(event->data.params[3]);
	socket_bind = (socket_bind_f *)(event->data.params[4]);
	socket_close = (socket_close_f *)(event->data.params[5]);
	socket_delete = (socket_delete_f *)(event->data.params[6]);
	
	// ,    .  ,    
	for ( i=0; i<7; i++ ) {
		if ( event->data.params[i] == NULL ) {
			return ELF_Exit(ev_st,app);
		}
	}

    if ( g_socket != HSOCK_INVALID ) {
                 //  

				if ( socket_connect(g_socket, HTTP_HOST, 80) != -1 ) {
					dbg("socket_connect OK...", NULL);
				} else {
					dbg("socket_connect ERROR", NULL);
				}

        return RESULT_OK; //   
    }

     dbg("create socket...", NULL);
    
                //  ,  ,     
                //        ,         
        g_socket = socket(SOCK_TCP, LdrFindEventHandlerTbl( any_state_handlers, HandleSockAnsw ));

        //      ,        
        //  -     8
        if ( g_socket == HSOCK_INVALID ) {
            dbg("can't create socket", NULL);
            return RESULT_FAIL;
        }

	return RESULT_OK;
}

UINT32 HandleSockAnsw( EVENT_STACK_T *ev_st, void *app )
{
    UINT32      status;
	EVENT_T *	event = AFW_GetEv(ev_st);
	UINT32		answ = event->data.params[0];

    UINT32		i=0; 
    INT32       len;
    char    buffer[1024];
    char    *data=NULL;

	
	if ( answ == SOCK_ANSW_CREATE ) {
		//  
		dbg("SockAnsw: CREATE, status = %d", event->data.params[1]);

        //  
        if ( g_socket != HSOCK_INVALID ) {
				if ( socket_connect(g_socket, HTTP_HOST, 80) != -1 ) {
					dbg("socket_connect OK...", NULL);
				} else {
					dbg("socket_connect ERROR", NULL);
				}
		}
		
	} else if ( answ == SOCK_ANSW_READY ) {
		//    
		dbg("SockAnsw: READY", NULL);

        //    
        status = UploadFile();
        if (status == RESULT_OK) APP_UtilStartTimer( TIME_PAINT, 0, app );
       
	} else if ( answ == SOCK_ANSW_DATA ) {
		//  
		dbg("SockAnsw: DATA", NULL);
		
		if ( g_socket != HSOCK_INVALID ) {
			len = BUF_SIZE;
            memset(buffer, 0, 1024);
				len = socket_read( g_socket, buffer, BUF_SIZE );
                dbg("READ = %s", buffer);

                data = strstr(buffer, "/upload/");
                if (data != buffer && data != NULL) {
                    data += strlen("/upload/");
                    while(*(data+i) != 0x0D && *(data+i) != 0x0) {
                        i++;
                    }
                    data[i] = 0;
                    strcpy(link, data);
                    dbg("slil.ru/%s", link);

                    socket_close( g_socket );
                    CloseFile();
                    APP_UtilStopTimer( app );
                    return APP_UtilChangeState( HW_STATE_VIEWER,  ev_st,  app );
                }
        }
		
	} else if ( answ == SOCK_ANSW_DELETE ) {
		//   - 
		dbg("SockAnsw: DELETE", NULL);
		g_socket = HSOCK_INVALID;
        CloseFile();
        
		
	} else if ( answ == SOCK_ANSW_ERROR ) {
		// 
		dbg("SockAnsw: ERROR", NULL);
	}
	
	return RESULT_OK;
}


UINT32 OpenFile(WCHAR *uri) 
{
    upload=0;
    upload_mode=0;
    prg=0;
    link[0]=0;

    if (f != FILE_INVALID) CloseFile();

    UCS2toCP1251(u_strrchr(uri, (WCHAR)'/')+1, FileName);
    dbg("Open %s", FileName);

    f = DL_FsOpenFile( uri,  FILE_READ_MODE,  0 );
    if (f == FILE_INVALID ) return RESULT_FAIL;

    return RESULT_OK;
}

UINT32 CloseFile() 
{
    DL_FsCloseFile(f);
    f = FILE_INVALID;
    return RESULT_OK;
}

UINT32 UploadFile() 
{
    
    UINT32		rd=BUF_SIZE;
   
    if ( g_socket == HSOCK_INVALID || f == FILE_INVALID) return RESULT_FAIL;


    switch (upload_mode) {
    case 0:
        //  

        strcpy(data1,  "--"  boundary  "\r\n" \
                       "Content-Disposition: form-data; name=\"file\"; filename=\"");
        strcat(data1,  FileName);
        strcat(data1,  "\"" "\r\n" \
                        "Content-Type: application/octet-stream" "\r\n" \
                        "\r\n");

        strcpy(request, "POST /upload/ HTTP/1.0\r\n" \
                        "User-Agent: " HTTP_USER_AGENT "\r\n" \
                        "Host: " HTTP_HOST "\r\n" \
                        "Accept: text/html\r\n" \
                        "Accept-Language: en, ru\r\n" \
                        "Referer: http://" HTTP_HOST "/\r\n" \
                        "Proxy-Connection: Keep-Alive\r\n" \
                        "Content-Length: ");
        itoa(DL_FsGetFileSize(f) + strlen(data1) + strlen(data2), request+strlen(request), 10);
        strcat(request,  "\r\n" \
                        "Content-Type: multipart/form-data; boundary=" boundary "\r\n" \
                        "\r\n");
        //strcat(request, data1);

        socket_wr(request, strlen(request));
        socket_wr(data1, strlen(data1));
        upload_mode = 1;
        break;

    case 1:

            DL_FsReadFile( request, 1, BUF_SIZE, f, &rd );
            if (rd != BUF_SIZE) upload_mode = 2;
            if (socket_wr(request, rd) == RESULT_FAIL) { //   :(
                DL_FsFSeekFile( f,  (-1)*rd, SEEK_WHENCE_CUR ); //   
            } else {
                upload += rd;
                prg = (upload*100)/DL_FsGetFileSize(f);
            }
      
        break;

    case 2: 
        socket_wr(data2, strlen(data2));
        upload_mode = 3;
        break;
    }

    return RESULT_OK;

}

UINT32 socket_wr(char *request, UINT32 len)
{
    char 		*data;
    UINT32		wr;

    //dbg("WRITE = %s", request);
    data = (char*)request;
       
                while ( len > 0 ) {
                    wr = socket_write(g_socket, data, len);
                    dbg("socket_write DONE, %d", wr);
                    if ( wr == -1 ) {
                        //   
                        dbg("socket is not ready %d", g_socket);
                        return RESULT_FAIL;
                    } else if ( wr == 0 && len > 0 ) {
                        //  ...
                        dbg("can't write to socket", NULL);
                        return RESULT_FAIL;
                    }
                    len -= wr;
                    data+= wr;
                }

     return RESULT_OK;

}


void paint()
{
    WCHAR   str[64];
    UINT16  x;


    // 
	SetFillColor(0xFFFFFF00);
    FillRect(0, 17, bufd.w, bufd.h);
    
    //  
    SetForegroundColor(0x00000000);
    DrawRect(9, 179, 176-19, 30);

    //  
    x = ((bufd.w-21) * prg)/100;
    SetFillColor(0x00FF0000);
    FillRect(10, 180, x, 28);

    SetBackgroundColor(0xFFFFFFFF);

    //     
    SetForegroundColor(0x00000000);
    u_atou(FileName, str);
    DrawText(str, 10, 125, ANCHOR_LEFT | ANCHOR_TOP);
    //  
    u_ltou(DL_FsGetFileSize(f), str);
    u_strcat(str, L" b");
    DrawText(str , 10, 150, ANCHOR_LEFT | ANCHOR_TOP);
    // 
    u_ltou(prg, str);
    u_strcat(str, L" %");
    DrawText(str, bufd.w/2-5, 180+8, ANCHOR_LEFT | ANCHOR_TOP);

}

/**** Util ****/

// unicode 2 ansii
UINT32 UCS2toCP1251(WCHAR *src, char *trg)
{
    UINT16  i;

    for(i=0; i <= u_strlen(src); i++) {
        if (src[i] < 0xA0) { //  128
            trg[i] = src[i];
        } else if (src[i] == 0x451){ // 
            trg[i] = 0xB8;
        } else if (src[i] == 0x401){ // 
            trg[i] = 0xA8;
        } else if (src[i] > 0x40F) { // 
            trg[i] = src[i] - 0x350;
        } else {
            trg[i] = 0x3F; // ? -  
        }
    }

    return RESULT_OK;
}


UINT32 FindFile( WCHAR *folder, WCHAR *filtr ) //  
{
     //INT32                   err=RESULT_OK;
     FS_SEARCH_PARAMS_T		sp;
     FS_SEARCH_RESULT_T		hResult;
     FS_SEARCH_HANDLE_T		hSearch;
    
    
     UINT16		count_files=0, count_res=1;
     UINT32		status = RESULT_OK;
     INT32		i=0, j=0;
     UINT8       mode=0;
     WCHAR       volumes[12];
    
     WCHAR       search_string[256];


     if ( folder==NULL || !u_strcmp(folder, L"/")) {
             u_strcpy(search_string, L"/");
     } else {
         //    file://
         if(u_strncmp(folder, L"file:/", 6))
         {
             u_strcpy(search_string, L"file:/");
             u_strcat(search_string, folder);
         } else {
             u_strcpy(search_string, folder);
         }
    
         //    
         if ( folder[u_strlen(folder)-1] != '/' ) 
             u_strcat(search_string, L"/");
    
         u_strcat(search_string, L"\xFFFE");
         u_strcat(search_string, filtr);
     }

 /////  /////
 // 1)    `a`  hResult.name  !
 // 2)       .      .   "    "
 //////////////////////

    dbg("Find files...", NULL);


    if (!u_strcmp(search_string, L"/")) { // 

        DL_FsVolumeEnum(volumes);

        free(file_list);
        file_list = malloc(sizeof(FILEINFO)*4);
        if (file_list == NULL) return RESULT_FAIL;

        cur_folder[0] = '/';

        ENTRIES_NUM = 0;

        for (i=0; i < 4; i++) {
            file_list[i].name[0] = volumes[i*3+1];//'a' + i;
            file_list[i].name[1] = 0;
            file_list[i].attrib = FS_ATTR_DIRECTORY;

            ENTRIES_NUM++;

            if (volumes[i*3+2] == NULL)  break;
        }

        return RESULT_OK;
    }

	
	sp.flags = 0x1C; 
	sp.attrib = 0;
	sp.mask = 0;
	
	status = DL_FsSSearch( sp, search_string, &hSearch, &count_files, 0 );
    dbg("Search status = %d", status);
	if ( status != RESULT_OK ) {
        DL_FsSearchClose( hSearch );
        return RESULT_FAIL;
    }

    dbg("count_files = %d", count_files);
	
	ENTRIES_NUM = count_files+1;

	dbg("Memory Fbrowser !", NULL);
	free(file_list);
    dbg("Free file_list !", NULL);
    file_list = malloc(sizeof(FILEINFO)*(count_files+1));
    if (file_list == NULL) return RESULT_FAIL;
	

	u_strcpy(file_list[0].name, L"..");
	file_list[0].attrib = FS_ATTR_DIRECTORY;


    for ( i=0, j=1; j<=count_files; i++ ) {

            if (i >= count_files){
                if (mode > 0) {
                    break;
                } else {
                    i=-1;
                    mode=1;
                    continue;
                }
            }

		status = DL_FsSearchResults( hSearch, i, &count_res, &hResult );
		if ( status == RESULT_OK ) 
		{
            if ((mode==0) && !(hResult.attrib&FS_ATTR_DIRECTORY)) continue;
            if ((mode==1) && (hResult.attrib&FS_ATTR_DIRECTORY)) continue;

            //     "    "
            if(!u_strcmp(hResult.name+u_strlen(hResult.name)-1, L"/")) continue;
            	
			u_strcpy(file_list[j].name, SplitPath(hResult.name, L"/"));
			file_list[j].attrib = hResult.attrib;
		} 
        j++;
	}

	DL_FsSearchClose( hSearch ); 


    dbg("Find files end", NULL);

	
	return RESULT_OK;
}


//     spliter  
WCHAR* SplitPath( WCHAR* path, WCHAR* spliter ) 
{
	int j = u_strlen(path)-2;
	while( j > 0 ) 
	{
		if ( !u_strncmp(path+j, spliter, 1) ) 
		{
			return path+j+1;
		}
		j--;
	}
	return path;
}



/*           */
UINT32 InitResources( )
{
    UINT32						status;

	const WCHAR list_caption[] = L"Zalil by om2804";

	/*     */
    status = DRM_CreateResource( &Resources[RES_LIST_CAPTION], RES_TYPE_STRING, (void*)list_caption, (u_strlen((WCHAR*)list_caption)+1)*sizeof(WCHAR) );

	return status;
}



/*        */
UINT32 RemoveResources( )
{
	UINT32				status = RESULT_OK;
	UINT32				i;

	for(i=0;i<RES_MAX;i++)
		status |= DRM_ClearResource( Resources[i] );

	return status;
}

