#ifndef ELFAPP_H
#define ELFAPP_H


#include <apps.h>
#include <trace.h>

#include <dsma.h>
#include <synsock_api.h> //      



//      
/*typedef struct
{ 
	APPLICATION_T	apt; //   ,   

} APP_ELF;*/


enum {
	SOCK_STATE_NULL = 0,
	SOCK_STATE_CREATE,
	SOCK_STATE_SET_ATTR,
	SOCK_STATE_ACTIVATE,
	SOCK_STATE_READY,
	SOCK_STATE_ERROR
};

typedef struct {
	HSOCK		hsock;
	UINT32		ev_callback;
	int			state;
	
	CMD_NUM		cmd;
	UINT32		proxy_id;
	char		host[MAX_HOST_LEN+1];
	UINT32		tra_prot;
	int			loc_port;
	int			rem_port;
	
	UINT32		last_activity;
} SOCKET_T;

typedef struct {
	UINT32 				timeout; //   
	char 				apn[64];
    char 				login[32];
    char 				password[16];
} web_session_t;

/*   */
typedef enum
{
	HW_STATE_ANY, /* ANY-state   */

	HW_STATE_MAX /*   */
} HW_STATES_T;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 
UINT32 Register( char* file_uri,  char* param,  UINT32 reserve );

UINT32 ELF_Start( EVENT_STACK_T * ev_st, REG_ID_T reg_id, void * reg_hdl );
UINT32 ELF_Init( void );
UINT32 ELF_Exit( EVENT_STACK_T *ev_st,  void *app );

UINT32 MainStateEnter( EVENT_STACK_T *ev_st,  void *app,  ENTER_STATE_TYPE_T type );

UINT32 NET_HandleProxyEvent( EVENT_STACK_T * ev_st, void * app );
UINT32 HandleIfaceReq( EVENT_STACK_T * ev_st, void * app );
UINT32 HandleTimerExpiried( EVENT_STACK_T * ev_st, void * app );

UINT32 WSFree( EVENT_STACK_T *ev_st, void *app);
UINT32 WSRead(void);

// SOCKET API
HSOCK socket( int type, UINT32 ev_callback );

int socket_connect( HSOCK hs, const char * host, int port );
UINT32 socket_write( HSOCK hs, const void * buf, UINT32 size );
UINT32 socket_read( HSOCK hs, void * buf, UINT32 size );
int socket_bind( HSOCK hs, int loc_port );
int socket_close(HSOCK hs);
int socket_delete( HSOCK hs );

// -----------------
// Util
int util_find_sock( HSOCK hsock );
int util_find_sock_by_proxy( UINT32 proxy_id );
int util_find_sock_by_cmd( UINT32 cmd );
int util_delete_sock( int idx );
int util_find_free_sock( void );
int util_init_attr( int idx );





#ifdef __cplusplus
}
#endif /* __cplusplus */ 


#endif