// : G-XaD, mod: om2804

#define DEBUG_APP_NAME				"SynSock"


#include "synsock.h"
#include <dbg.h>

#define SocketAnswer(ev_code,add_data) \
			AFW_CreateInternalQueuedEvAuxD(ev_code,&add_data,FBF_LEAVE,0,NULL)
#define getTime() \
			suPalTicksToMsec(suPalReadTime())


#define SOCKETS_ACTIVITY_TIMER_ID		0

#define SOCKETS_ACTIVITY_TIMER_DELAY	10*1000

//       
//#define LOCAL_PORT_START				100

//     
UINT32				evcode_base;
//     
UINT32	app_reg_tbl[1] = {SOCKET_MGR_MAIN_REGISTER};

//   
SOCKET_T			g_socket_tbl[MAX_SOCKETS];

//  .   . USE_GPRS
UINT32				g_phy_protocol;
//  .   . PROTOCOL_IP
UINT32				g_net_protocol;
// 0
UINT32				g_link_protocol;

web_session_t       *web_session=NULL;
WS_RECORD_T         *ws_record=NULL;


//   
HSOCK				g_next_hsock;

//  
SU_PORT_T			g_port;

//   DSMA
DSMA_ATTRIBUTE_T	g_attrs[MAX_SOCKETS][16];

//  .       
const char		app_name[APP_NAME_LEN] = DEBUG_APP_NAME;





//       ...
//       
const EVENT_HANDLER_ENTRY_T any_state_handlers[] =
{
	{ SOCKET_MGR_MAIN_REGISTER,	HandleIfaceReq		},
	{ EV_TIMER_EXPIRED,			HandleTimerExpiried	},
	
	{ EV_DSMA_PROXY_CREATE,		NET_HandleProxyEvent },
	{ EV_DSMA_PROXY_STATE,		NET_HandleProxyEvent },
	{ EV_DSMA_BUFF_STATE,		NET_HandleProxyEvent },
	{ EV_DSMA_PROXY_ATTR,		NET_HandleProxyEvent },
    { WS_EVENT,                 WSFree },

	

	//      
	{ STATE_HANDLERS_END,		NULL				},
};




/*   ,    -  .
	   ,   enum-e */
static const STATE_HANDLERS_ENTRY_T state_handling_table[] =
{
	{ HW_STATE_ANY,			// State
	  NULL,					//    state
	  NULL,					//    state
	  any_state_handlers	//   
	}
};

/*  entry   ,      */
/* file_uri -    ( argv[0]) */
/* param -   (  argv) */
/* reserve -   eventcode- ( 64 )*/
UINT32 Register( char* file_uri, char* param, UINT32 reserve )
{
	UINT32	status = RESULT_OK;
	
	evcode_base = reserve;	//  reserve
	
	g_next_hsock = 1;
	
	dbg("Register: Enter", NULL);
	

		
	/*   */
		status = APP_Register( &app_reg_tbl[0],			//      
							   1,						// - ,     
							   state_handling_table,	//  
							   HW_STATE_MAX,			//  
							   (void*)ELF_Start );	// ,   
		dbg("Register: APP_Register DONE, status = %d", status);
		

		LdrStartApp(SOCKET_MGR_MAIN_REGISTER);	//  
		

	
	dbg("Register: END", NULL);
	
	return 1;				//    ,  
}

/*      */
UINT32 ELF_Start( EVENT_STACK_T * ev_st, REG_ID_T reg_id, void * reg_hdl )
{
	APPLICATION_T *		app = NULL;
	UINT32				status = RESULT_OK;
	
	dbg("ELF_Start: Enter", NULL);
	
	if( AFW_InquireRoutingStackByRegId( reg_id ) == RESULT_OK ) {
		return RESULT_FAIL; //     
	} else {
		app = (APPLICATION_T *)APP_InitAppData( (void *)APP_HandleEventPrepost,	//    
												sizeof(APPLICATION_T),			//   
												reg_id,
												0, 1,
												0,
												2, 0, 0 );

		status = APP_Start( ev_st,
							app,
							HW_STATE_ANY, //  
							state_handling_table,
							ELF_Exit,
							app_name,
							0 );
		if ( status == RESULT_OK ) {
			//     ,        DL_DSMA
			g_port = app->port;
			ELF_Init();

            
			
			//  ,     
			APP_UtilStartCyclicalTimer( SOCKETS_ACTIVITY_TIMER_DELAY, SOCKETS_ACTIVITY_TIMER_ID, app );
		}
	}

	dbg("ELF_Start: END", NULL);
	
	return RESULT_OK;
}

UINT32 ELF_Init( void )
{
    INT32   err;
	int i;
	//  
	memclr(g_attrs, sizeof(g_attrs));
	//   
	for ( i=0; i<MAX_SOCKETS; i++ ) {
		util_delete_sock(i);
	}
	g_phy_protocol = USE_GPRS;
	g_net_protocol = PROTOCOL_IP;
	g_link_protocol = 0;

    //   
    if (web_session == NULL) {
        web_session = suAllocMem(sizeof(web_session_t), &err);
        if (err != 0) return RESULT_FAIL;
    }      
    memclr(web_session, sizeof(web_session_t));
    web_session->timeout = 60000;

	return RESULT_OK;
}



/*     */
UINT32 ELF_Exit( EVENT_STACK_T *ev_st, void *app )
{
	UINT32	status;
	int		i;

	dbg("ELF_Exit: Enter", NULL);
	
	/*    */
	status = APP_Exit( ev_st,(APPLICATION_T*) app, NULL );
	
	dbg("ELF_Exit: APP_Exit DONE, status = %d", status);
	
	/*    ,  ... */
	for ( i=0; i<MAX_SOCKETS; i++ ) {
		util_delete_sock(i);
	}

	/*    */
//	LdrUnloadELF(&Lib); // &Lib    
	
	dbg("ELF_Exit: END", NULL);
	return status;
}

/*    state */
UINT32 MainStateEnter( EVENT_STACK_T *ev_st, void *app, ENTER_STATE_TYPE_T type )
{
	dbg("MainStateEnter: type = %d", type);
	return RESULT_OK;
}



int util_find_sock( HSOCK hsock )
{
	int i;
	if ( hsock == HSOCK_INVALID )
		return -1;
	for ( i=0; i<MAX_SOCKETS; i++ ) {
		if ( hsock == g_socket_tbl[i].hsock )
			return i;
	}
	return -1;
}

int util_find_sock_by_proxy( UINT32 proxy_id )
{
	int i;
	if ( proxy_id == PROXY_NULL )
		return -1;
	for ( i=0; i<MAX_SOCKETS; i++ ) {
		if ( proxy_id == g_socket_tbl[i].proxy_id )
			return i;
	}
	return -1;
}

int util_find_sock_by_cmd( UINT32 cmd )
{
	int i;
	for ( i=0; i<MAX_SOCKETS; i++ ) {
		if ( cmd == g_socket_tbl[i].cmd )
			return i;
	}
	return -1;
}

int util_delete_sock( int idx )
{
	if ( idx < 0 || idx >= MAX_SOCKETS )
		return -1;
	if ( g_socket_tbl[idx].proxy_id != PROXY_NULL )
		DL_DSMA_ProxyDestroy(g_socket_tbl[idx].proxy_id);
	g_socket_tbl[idx].proxy_id = PROXY_NULL;
	g_socket_tbl[idx].hsock = HSOCK_INVALID;
	g_socket_tbl[idx].state = 0;
	return 0;
}
int util_find_free_sock( void )
{
	int i;
	for ( i=0; i<MAX_SOCKETS; i++ ) {
		if ( g_socket_tbl[i].hsock == HSOCK_INVALID )
			return i;
	}
	return -1;
}
int util_init_attr( int idx )
{
	int		i;
	i = 0;
	memclr(&g_attrs[idx], sizeof(DSMA_ATTRIBUTE_T)*16);
	// TCP / UDP
	g_attrs[idx][i].attr = DSMA_ATTR_TRANS_PROT;
	g_attrs[idx][i].value = &g_socket_tbl[idx].tra_prot;
	g_attrs[idx][i++].size = sizeof(UINT32);
	// IP
	g_attrs[idx][i].attr = DSMA_ATTR_NET_PROT;
	g_attrs[idx][i].value = &g_net_protocol;
	g_attrs[idx][i++].size = sizeof(UINT32);
	// ?
	g_attrs[idx][i].attr = DSMA_ATTR_LINK_PROT;
	g_attrs[idx][i].value = &g_link_protocol;
	g_attrs[idx][i++].size = sizeof(UINT32);
	// GPRS,   
	g_attrs[idx][i].attr = DSMA_ATTR_PHYS_PROT;
	g_attrs[idx][i].value = &g_phy_protocol;
	g_attrs[idx][i++].size = sizeof(UINT32);
	//  
	g_attrs[idx][i].attr = DSMA_ATTR_APN;
	g_attrs[idx][i].value = web_session->apn;
	g_attrs[idx][i++].size = strlen(web_session->apn);
	// login
	g_attrs[idx][i].attr = DSMA_ATTR_USER_NAME;
	g_attrs[idx][i].value = web_session->login;
	g_attrs[idx][i++].size = strlen(web_session->login);
	// password
	g_attrs[idx][i].attr = DSMA_ATTR_PW;
	g_attrs[idx][i].value = web_session->password;
	g_attrs[idx][i++].size = strlen(web_session->password);
	//   
	g_attrs[idx][i].attr = DSMA_ATTR_REMOTE_IP;
	g_attrs[idx][i].value = g_socket_tbl[idx].host;
	g_attrs[idx][i++].size = strlen(g_socket_tbl[idx].host);
	//    
	g_attrs[idx][i].attr = DSMA_ATTR_REMOTE_PORT;
	g_attrs[idx][i].value = &g_socket_tbl[idx].rem_port;
	g_attrs[idx][i++].size = sizeof(UINT32);
	//     
	if ( g_socket_tbl[idx].loc_port != 0 ) {
		g_attrs[idx][i].attr = DSMA_ATTR_LOCAL_PORT;
		g_attrs[idx][i].value = &g_socket_tbl[idx].loc_port;
		g_attrs[idx][i++].size = sizeof(UINT32);
	}
	
	return i;
}

UINT32 WSFree( EVENT_STACK_T *ev_st, void *app)
{
    EVENT_T     *ev = AFW_GetEv(ev_st);
    WS_EVENT_T  *ws_att = (WS_EVENT_T*)(ev->attachment);
    UINT8       index;

    if (ev->att_size == 0) return RESULT_OK;

    dbg("WS index = %d", ws_att->index);

    DL_DbWebSessionsGetDefaultSessionIndex(&index);

    if (ws_att->index == index ) {
        if (ws_att->result < 2) {
    
                switch (ws_record->timeout) {
                    case WS_TIMEOUT_NULL:
                        web_session->timeout=0;
                    break;
    
                    case WS_TIMEOUT_1_MIN:
                        web_session->timeout=1*60000;
                    break;
    
                    case WS_TIMEOUT_2_MIN:
                        web_session->timeout=2*60000;
                    break;
    
                    case WS_TIMEOUT_5_MIN:
                        web_session->timeout=5*60000;
                    break;
    
                    case WS_TIMEOUT_10_MIN:
                        web_session->timeout=10*60000;
                    break;
    
                    case WS_TIMEOUT_15_MIN:
                        web_session->timeout=15*60000;
                    break;
                }
    
    
                u_utoa(ws_record->gprs_record->apn, web_session->apn); // apn
                dbg("apn: %s", web_session->apn);
                u_utoa(ws_record->gprs_record->login, web_session->login); // login
                dbg("login: %s", web_session->login);
                u_utoa(ws_record->gprs_record->password, web_session->password); // pass
                dbg("password: %s", web_session->password);
        }

        free(ws_record->gprs_record);
        free(ws_record);
    }

    return RESULT_OK;
}

UINT32 WSRead(void) 
{
	UINT8 		 index;
	IFACE_DATA_T iface_data;
	
	INT32		 err;
	UINT32		 status;
	
	iface_data.port = g_port;


    if (ws_record == NULL) {
        ws_record = suAllocMem(sizeof(WS_RECORD_T), &err);
        memset(ws_record, 0, sizeof(WS_RECORD_T));
        if (err != 0) return RESULT_FAIL;
    }

    if (ws_record->gprs_record == NULL) {
        ws_record->gprs_record = suAllocMem(sizeof(WS_GPRS_RECORD_T), &err);
        if (err != 0) return RESULT_FAIL;
    }
	
	
	//    Web-
	DL_DbWebSessionsGetDefaultSessionIndex(&index);
	dbg("DefaultSessionIndex = %d", index);
	
	//   Web-   
	//  .     EV_WS_GET_BY_INDEX,     WS_GET_BY_INDEX_T
	status = DL_DbWebSessionsGetSessionByIndex(&iface_data, index, ws_record);
	dbg("status GetSessionByIndex = %d", status);
	if (status > 1) return RESULT_FAIL;
	return RESULT_OK;
}


// MY Socket API ----------------------------------------------

HSOCK socket( int type, UINT32 ev_callback )
{
	int		idx;
	HSOCK	hsock;
	dbg("create socket, type = %d, ev_cb = 0x%x", type, ev_callback);
	
	if ( type != SOCK_TCP && type != SOCK_UDP )
		return HSOCK_INVALID;
	if ( ev_callback == 0 || ev_callback == STATE_HANDLERS_END )
		return HSOCK_INVALID;
		
	if (WSRead() == RESULT_FAIL) return HSOCK_INVALID;	//    web-
	
	idx = util_find_free_sock();
	if ( idx == -1 )
		return HSOCK_INVALID;
	hsock = g_next_hsock++;
	//   
	memclr(&g_socket_tbl[idx], sizeof(SOCKET_T));
	g_socket_tbl[idx].hsock = hsock;
	g_socket_tbl[idx].ev_callback = ev_callback;
	g_socket_tbl[idx].tra_prot = (type == SOCK_UDP ? PROTOCOL_UDP : PROTOCOL_TCP);
	g_socket_tbl[idx].loc_port = 0;
	g_socket_tbl[idx].cmd = DL_DSMA_ProxyCreate( g_port );
	//     
	g_socket_tbl[idx].state = SOCK_STATE_CREATE;
	g_socket_tbl[idx].last_activity = getTime();
	return hsock;
}

int socket_connect( HSOCK hsock, const char * host, int port )
{
	int		idx;
	UINT32	len;
	CMD_NUM	cmd;
	idx = util_find_sock(hsock);
	dbg("connect socket %d, idx:%d to %s:%d", hsock, idx, host, port);
	if ( idx == -1 || g_socket_tbl[idx].proxy_id == PROXY_NULL )
		return -1;
	len = strlen((char*)host);
	if ( len > MAX_HOST_LEN )
		return -1;
	strcpy(g_socket_tbl[idx].host, (char*)host);
	g_socket_tbl[idx].rem_port = port;
	len = util_init_attr(idx);
	cmd = DL_DSMA_ProxyAttributeSet( g_socket_tbl[idx].proxy_id, len, &g_attrs[idx][0] );
	g_socket_tbl[idx].cmd = cmd;
	//     
	g_socket_tbl[idx].state = SOCK_STATE_SET_ATTR;
	g_socket_tbl[idx].last_activity = getTime();
	return 0;
}

int socket_bind( HSOCK hsock, int loc_port )
{
	int idx = util_find_sock(hsock);
	dbg("bind socket %d, idx:%d to port %d", hsock, idx, loc_port);
	if ( idx == -1 )
		return -1;
	//   ,      
	g_socket_tbl[idx].loc_port = loc_port;
	g_socket_tbl[idx].last_activity = getTime();
	return 0;
}
int socket_close( HSOCK hsock )
{
	int idx = util_find_sock(hsock);
	dbg("close socket %d, idx:%d", hsock, idx);
	if ( idx == -1 || g_socket_tbl[idx].proxy_id == PROXY_NULL )
		return -1;
	//   gprs ,      
	g_socket_tbl[idx].cmd = DL_DSMA_ProxyDeactivateSocket( g_socket_tbl[idx].proxy_id );
	g_socket_tbl[idx].last_activity = getTime();
	return 0;
}
int socket_delete( HSOCK hsock )
{
	int idx = util_find_sock(hsock);
	dbg("delete socket %d, idx:%d", hsock, idx);
	if ( idx == -1 )
		return idx;
	util_delete_sock(idx);
	return 0;
}

UINT32 socket_write( HSOCK hsock, const void * buf, UINT32 size )
{
	int			idx = util_find_sock(hsock);
	UINT32		wr;
	dbg("write to socket %d, idx:%d", hsock, idx);
	if ( idx == -1 || g_socket_tbl[idx].proxy_id == PROXY_NULL )
		return -1;
	if ( g_socket_tbl[idx].state == SOCK_STATE_READY )
		wr = DL_DSMA_ProxyWrite( g_socket_tbl[idx].proxy_id, (BYTE *)buf, size );
	else
		wr = -1;
	g_socket_tbl[idx].last_activity = getTime();
	return wr;
}

UINT32 socket_read( HSOCK hsock, void * buf, UINT32 size )
{
	int			idx = util_find_sock(hsock);
	UINT32		rd;
	dbg("read from socket %d, idx:%d", hsock, idx);
	if ( idx == -1 || g_socket_tbl[idx].proxy_id == PROXY_NULL )
		return -1;
	if ( g_socket_tbl[idx].state == SOCK_STATE_READY )
		rd = DL_DSMA_ProxyRead( g_socket_tbl[idx].proxy_id, buf, size );
	else
		rd = -1;
	g_socket_tbl[idx].last_activity = getTime();
	return rd;
}


UINT32 NET_HandleProxyEvent( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *		event = AFW_GetEv(ev_st);
	UINT32			code = event->code;
	DSMA_DATA_T *	dsma = (DSMA_DATA_T *)event->attachment;
	int				idx;
	ADD_EVENT_DATA_T	add_data;
	
	dbg("ProxyEvent: code:0x%x, proxy_id:%d, status:%d", code, dsma->proxy_id, dsma->status);
	dbg("ProxyEvent: ev_code = 0x%x, att_size = %d, att = 0x%p", code, event->att_size, event->attachment);
	if ( /*event->att_size != sizeof(DSMA_DATA_T) || */dsma == NULL ) {
		dbg("ProxyEvent: ev_code = 0x%x, att_size = %d, att = 0x%p", code, event->att_size, event->attachment);
		return RESULT_OK;
	}
	
	//    "" 
	
	//    ,  proxy_id   ,  ""   
	//       
	idx = util_find_sock_by_cmd(dsma->cmd);
	if ( idx == -1 ) {
		//      ,    
		idx = util_find_sock_by_proxy(dsma->proxy_id);
	}
	
	if ( idx == -1 ) {
		//     
		dbg("ProxyEvent: socket not found. proxy_id:%d", dsma->proxy_id);
		return RESULT_OK;
	}
	
	//   ,  
	APP_ConsumeEv(ev_st, app);
	
	memclr(&add_data, sizeof(ADD_EVENT_DATA_T));
	
	switch (code) {
		case EV_DSMA_PROXY_CREATE :
			//  
			dbg("ProxyEvent: EV_DSMA_PROXY_CREATE, status = %d", dsma->status);
			if ( g_socket_tbl[idx].state != SOCK_STATE_CREATE ) {
				// ...      _
				dbg("ProxyEvent: wrong state %d", g_socket_tbl[idx].state);
			} else if ( g_socket_tbl[idx].cmd == dsma->cmd ) {
				//  ,   
				// ,     DSMA
				g_socket_tbl[idx].proxy_id = dsma->proxy_id;
				//     
				add_data.data.params[0] = SOCK_ANSW_CREATE;
				if ( dsma->status == RESULT_OK ) {
					//  
					add_data.data.params[1] = RESULT_OK;
					g_socket_tbl[idx].state = SOCK_STATE_NULL;
				} else {
					add_data.data.params[1] = RESULT_FAIL;
					dbg("ProxyEvent: status is fail", NULL);
					g_socket_tbl[idx].state = SOCK_STATE_NULL;
				}
				//  
				SocketAnswer(g_socket_tbl[idx].ev_callback, add_data);
			} else {
				dbg("ProxyEvent: wrong cmd %d", dsma->cmd);
			}
			break;
		
		case EV_DSMA_PROXY_ATTR :
			//  
			dbg("ProxyEvent: EV_DSMA_PROXY_ATTR, status = %d", dsma->status);
			if ( g_socket_tbl[idx].state != SOCK_STATE_SET_ATTR ) {
				// ...    
				dbg("ProxyEvent: wrong state %d", g_socket_tbl[idx].state);
			} else if ( g_socket_tbl[idx].cmd == dsma->cmd ) {
				dbg("ProxyEvent: status = %d", NULL);
				//   ,  
				if ( dsma->status == RESULT_OK ) {
					g_socket_tbl[idx].cmd = DL_DSMA_ProxyActivate( dsma->proxy_id );
					g_socket_tbl[idx].state = SOCK_STATE_ACTIVATE;
				} else {
					dbg("ProxyEvent: status is fail", NULL);
					add_data.data.params[0] = SOCK_ANSW_ERROR;
					SocketAnswer(g_socket_tbl[idx].ev_callback, add_data);
				}
			} else {
				dbg("ProxyEvent: wrong cmd %d", dsma->cmd);
			}
			break;
			
		case EV_DSMA_PROXY_STATE:
			// ,     
			dbg("ProxyEvent: EV_DSMA_PROXY_STATE, status = %d", dsma->status);
			g_socket_tbl[idx].last_activity = getTime();
			if ( g_socket_tbl[idx].state == SOCK_STATE_ACTIVATE ) {
				//     
				if ( dsma->proxy_state == PROXY_STATE_ACTIVE ) {
					// 
					g_socket_tbl[idx].state = SOCK_STATE_READY;
					// 
					add_data.data.params[0] = SOCK_ANSW_READY;
					SocketAnswer(g_socket_tbl[idx].ev_callback, add_data);
				} else {
					//  
					g_socket_tbl[idx].state = SOCK_STATE_ERROR;
					dbg("ProxyEvent: error proxy_state %d", dsma->proxy_state);
					add_data.data.params[0] = SOCK_ANSW_ERROR;
					SocketAnswer(g_socket_tbl[idx].ev_callback, add_data);
				}
			} else if ( g_socket_tbl[idx].state == SOCK_STATE_READY ) {
				//    
				if ( dsma->buf_state == BUFFER_STATE_DATA ) {
					//    ,  
					dbg("ProxyEvent: incoming data", NULL);
					add_data.data.params[0] = SOCK_ANSW_DATA;
					SocketAnswer(g_socket_tbl[idx].ev_callback, add_data);
				} else {
					//   ...
					dbg("ProxyEvent: buf_state = %d", dsma->buf_state);
				}
			} else {
				// _
				dbg("ProxyEvent: unexpected socket state %d", g_socket_tbl[idx].state);
			}
			break;
			
		case EV_DSMA_BUFF_STATE:
			//  
			dbg("ProxyEvent: EV_DSMA_BUFF_STATE, status = %d", dsma->status);
			if ( dsma->buf_state == BUFFER_STATE_DATA ) {
				//    ,  
				dbg("ProxyEvent: incoming data", NULL);
				add_data.data.params[0] = SOCK_ANSW_DATA;
				SocketAnswer(g_socket_tbl[idx].ev_callback, add_data);
			} else {
				//   ...
				dbg("ProxyEvent: buf_state = %d", dsma->buf_state);
			}
	}
	
	return RESULT_OK;
}

//     
UINT32 HandleIfaceReq( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *			event = AFW_GetEv(ev_st);
	ADD_EVENT_DATA_T	add_data;
	UINT32				ev_cb;
	
	ev_cb = event->data.params[0];
	if ( ev_cb != 0 ) {
		add_data.data_tag = 0;
		add_data.data.params[0] = (UINT32)socket;
		add_data.data.params[1] = (UINT32)socket_connect;
		add_data.data.params[2] = (UINT32)socket_write;
		add_data.data.params[3] = (UINT32)socket_read;
		add_data.data.params[4] = (UINT32)socket_bind;
		add_data.data.params[5] = (UINT32)socket_close;
		add_data.data.params[6] = (UINT32)socket_delete;
		SocketAnswer(ev_cb, add_data);
	}
	
	return RESULT_OK;
}

//     
UINT32 HandleTimerExpiried( EVENT_STACK_T * ev_st, void * app )
{
	EVENT_T *			event;
	UINT32				time;
	int					i;
	ADD_EVENT_DATA_T	add_data;
	
	if ( ((DL_TIMER_DATA_T *)(event->attachment))->ID != SOCKETS_ACTIVITY_TIMER_ID ) {
		//     _
		return RESULT_OK;
	}
	event = AFW_GetEv(ev_st);
	//      
	time = getTime();
	
	add_data.data_tag = 0;
	
	for ( i=0; i<MAX_SOCKETS; i++ ) {
		if ( g_socket_tbl[i].hsock != HSOCK_INVALID ) {
			if ( time - g_socket_tbl[i].last_activity > web_session->timeout ) {
				add_data.data.params[0] = SOCK_ANSW_DELETE;
				add_data.data.params[1] = g_socket_tbl[i].hsock;
				SocketAnswer(g_socket_tbl[i].ev_callback, add_data);
				util_delete_sock(i);
			}
		}
	}
	
	return RESULT_OK;
}











