#ifndef XML_H
#define XML_H


#include <typedefs.h>
#include <util.h>
#include <memory.h>
#include <trace.h>

typedef struct{
	char   name[32];
	char   string[32];
} ptag_t; //  2 

typedef struct{
	char	name[32];
	ptag_t  *ptag;
	UINT32	count_ptags;
}tag_t;

typedef enum {
	MODE_NAME,
	MODE_STRING
} PARSE_MODES_T;

void InitTag(char *name, tag_t *tag);
char* ReadTag(char *buffer, tag_t *tag);
char* GetPTagString(tag_t tag, char *name_ptag);
void CloseTag(tag_t *tag);

#endif
